/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.http.request.HttpRequestPersistentSubstitutor;
import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutionKey;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariables;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableExpr;
import com.intellij.httpClient.http.request.psi.HttpFileVariable;
import com.intellij.httpClient.http.request.psi.HttpFileVariableEscapedPart;
import com.intellij.httpClient.http.request.psi.HttpFileVariableValue;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.psi.HttpVariableBase;
import com.intellij.httpClient.http.request.run.HttpRequestGlobalContext;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.httpClient.http.request.substitutor.HttpRequestVariableSubstitutorFactory;
import com.intellij.httpClient.http.request.variables.HttpFileVariablesProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestVariableSubstitutorImpl
implements HttpRequestVariableSubstitutor {
    private static final Logger LOG = Logger.getInstance(HttpRequestVariableSubstitutorImpl.class);
    private static final HttpRequestVariableSubstitutorImpl EMPTY = new HttpRequestVariableSubstitutorImpl(HttpFileVariablesProvider.Empty.INSTANCE, HttpRequestEnvironment.empty(), new HttpRequestGlobalContext(), HttpRequestSessionVariables.EMPTY, HttpRequestPersistentSubstitutor.Empty.INSTANCE, false, false);
    private static final HttpRequestVariableSubstitutorImpl NO_SUBSTITUTIONS = new HttpRequestVariableSubstitutorImpl(HttpFileVariablesProvider.Empty.INSTANCE, HttpRequestEnvironment.empty(), new HttpRequestGlobalContext(), HttpRequestSessionVariables.EMPTY, HttpRequestPersistentSubstitutor.Empty.INSTANCE, true, false);
    private final HttpFileVariablesProvider myFileVariablesProvider;
    private final HttpRequestEnvironment myEnvironment;
    private final HttpRequestGlobalContext myGlobalContext;
    private final HttpRequestSessionVariables mySessionVariables;
    private final HttpRequestPersistentSubstitutor myPersistentSubstitutor;
    private final boolean myIgnoreDynamicVariables;
    private final boolean myInvalidVariableAware;

    private HttpRequestVariableSubstitutorImpl(@NotNull HttpFileVariablesProvider fileVariablesProvider, @NotNull HttpRequestEnvironment environment, @NotNull HttpRequestGlobalContext context, @NotNull HttpRequestSessionVariables variables2, @NotNull HttpRequestPersistentSubstitutor persistentSubstitutor, boolean ignoreDynamicVariables, boolean validateVariables) {
        if (fileVariablesProvider == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(1);
        }
        if (context == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(2);
        }
        if (variables2 == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(3);
        }
        if (persistentSubstitutor == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(4);
        }
        this.myFileVariablesProvider = fileVariablesProvider;
        this.myEnvironment = environment;
        this.myGlobalContext = context;
        this.mySessionVariables = variables2;
        this.myPersistentSubstitutor = persistentSubstitutor;
        this.myIgnoreDynamicVariables = ignoreDynamicVariables;
        this.myInvalidVariableAware = validateVariables;
    }

    @NotNull
    @ApiStatus.Internal
    public static HttpRequestVariableSubstitutorImpl create(@NotNull Project project, @NotNull HttpRequestEnvironment environment, @Nullable PsiFile file) {
        HttpFileVariablesProvider httpFileVariablesProvider;
        if (project == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(6);
        }
        HttpRequestGlobalContext context = HttpRequestGlobalContext.getInstance(project);
        if (file instanceof HttpRequestPsiFile) {
            HttpRequestPsiFile httpFile = (HttpRequestPsiFile)file;
            httpFileVariablesProvider = new HttpFileVariablesProvider.FileBased(httpFile);
        } else {
            httpFileVariablesProvider = HttpFileVariablesProvider.Empty.INSTANCE;
        }
        HttpFileVariablesProvider.Empty provider = httpFileVariablesProvider;
        return new HttpRequestVariableSubstitutorImpl(provider, environment, context, HttpRequestSessionVariables.EMPTY, HttpRequestPersistentSubstitutor.create(), false, false);
    }

    @Override
    @NotNull
    public String getValue(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(7);
        }
        String string = this.getValue(element, (Condition<? super PsiElement>)Conditions.alwaysTrue());
        if (string == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getValue(@NotNull PsiElement element, @NotNull Condition<? super PsiElement> filter2) {
        if (element == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(9);
        }
        if (filter2 == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(10);
        }
        if (element instanceof HttpVariableBase) {
            HttpVariableBase variable2 = (HttpVariableBase)element;
            return this.getVariableValue(variable2, HttpRequestVariableSubstitutionKey.fromPsiElement((PsiElement)variable2), null);
        }
        if (element instanceof HttpRequestCompositeElement) {
            StringBuilder builder2 = new StringBuilder();
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof HttpVariableBase) {
                    HttpVariableBase variable3 = (HttpVariableBase)child;
                    builder2.append(this.getVariableValue(variable3, HttpRequestVariableSubstitutionKey.fromPsiElement((PsiElement)variable3), null));
                    continue;
                }
                if (!filter2.value((Object)child)) continue;
                builder2.append(child.getText());
            }
            String string = builder2.toString();
            if (string == null) {
                HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private String getVariableValue(@NotNull HttpVariableBase variable2, @NotNull HttpRequestVariableSubstitutionKey key2, @Nullable String ignoredFileVariable) {
        if (variable2 == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(13);
        }
        if (key2 == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(14);
        }
        if (variable2 instanceof HttpDynamicVariable) {
            HttpDynamicVariable dynamicVariable = (HttpDynamicVariable)variable2;
            if ("auth.token".equals(dynamicVariable.getName())) {
                String string = this.getDynamicVariableValue(dynamicVariable, dynamicVariable.getText());
                if (string == null) {
                    HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(15);
                }
                return string;
            }
            String string = this.myPersistentSubstitutor.retrieve(key2, (Function0<String>)((Function0)() -> this.getDynamicVariableValue(dynamicVariable, dynamicVariable.getText())));
            if (string == null) {
                HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(16);
            }
            return string;
        }
        if (variable2 instanceof HttpVariable) {
            String string = this.getEnvironmentVariableValue(variable2.getName(), variable2.getText(), ignoredFileVariable);
            if (string == null) {
                HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(17);
            }
            return string;
        }
        throw new IllegalArgumentException("Unknown subclass of HttpVariableBase");
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private String getDynamicVariableValue(@NotNull HttpDynamicVariable variable2, @Nullable String defaultValue) {
        if (variable2 == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(18);
        }
        if (this.myIgnoreDynamicVariables) {
            return defaultValue;
        }
        HttpDynamicVariableExpr expr = variable2.getDynamicVariableExpr();
        if (expr == null) {
            return defaultValue;
        }
        String computed = HttpClientDynamicVariables.computeDynamicVariable(this.myEnvironment, this.myInvalidVariableAware, expr);
        if (computed != null) {
            return computed;
        }
        return defaultValue;
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public String getEnvironmentVariableValue(@Nullable String name, @Nullable String defaultValue) {
        return this.getEnvironmentVariableValue(name, defaultValue, null);
    }

    @Nullable
    @Contract(value="_, !null, _ -> !null")
    private String getEnvironmentVariableValue(@Nullable String name, @Nullable String defaultValue, @Nullable String ignoredFileVariable) {
        if (StringUtil.isNotEmpty((String)name)) {
            String fileVariable;
            String session = this.mySessionVariables.getValue(name);
            if (session != null) {
                return session;
            }
            String global = this.myGlobalContext.getValue(name);
            if (global != null) {
                return global;
            }
            if (!name.equals(ignoredFileVariable) && (fileVariable = this.getFileVariableValue(name, defaultValue)) != null) {
                return fileVariable;
            }
            String envVariable = this.myEnvironment.getVariableValue(StringUtil.notNullize((String)name));
            if (envVariable != null) {
                return envVariable;
            }
        }
        return defaultValue;
    }

    @Nullable
    private String getFileVariableValue(@NotNull @NlsSafe String name, @Nullable String defaultValue) {
        HttpFileVariablesProvider.Value computedValue;
        if (name == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(19);
        }
        if ((computedValue = this.myFileVariablesProvider.getFileVariableValue(name, this.myInvalidVariableAware, (Function1<? super HttpFileVariable, String>)((Function1)variable2 -> {
            HttpFileVariableValue value = variable2.getFileVariableValue();
            if (value == null) {
                return "";
            }
            StringBuilder text2 = new StringBuilder();
            for (PsiElement currentElement = value.getFirstChild(); currentElement != null; currentElement = currentElement.getNextSibling()) {
                if (currentElement instanceof HttpVariableBase) {
                    HttpVariableBase variableBase = (HttpVariableBase)currentElement;
                    HttpRequestVariableSubstitutionKey key2 = HttpRequestVariableSubstitutionKey.fromPsiElement(currentElement);
                    text2.append(this.getVariableValue(variableBase, key2, name));
                    continue;
                }
                if (currentElement instanceof HttpFileVariableEscapedPart) {
                    HttpFileVariableEscapedPart escapedPart = (HttpFileVariableEscapedPart)currentElement;
                    text2.append(escapedPart.unescape());
                    continue;
                }
                String elementText = currentElement.getText();
                if (currentElement == value.getFirstChild()) {
                    text2.append(elementText.stripLeading());
                    continue;
                }
                text2.append(elementText);
            }
            return text2.toString();
        }))) == HttpFileVariablesProvider.Value.Ambiguous.INSTANCE) {
            throw new HttpRequestVariableSubstitutor.InvalidVariableException(HttpClientExecutorBundle.message("rest.client.request.ambiguous.variable.error", name));
        }
        if (computedValue instanceof HttpFileVariablesProvider.Value.Computed) {
            HttpFileVariablesProvider.Value.Computed result2 = (HttpFileVariablesProvider.Value.Computed)computedValue;
            return result2.getValue();
        }
        if (computedValue == HttpFileVariablesProvider.Value.InProgress.INSTANCE) {
            return defaultValue;
        }
        return null;
    }

    @NotNull
    public HttpRequestUpdatedVariableSubstitutor updateAware() {
        HttpRequestVariableSubstitutorImpl newSubstitutor = new HttpRequestVariableSubstitutorImpl(this.myFileVariablesProvider, this.myEnvironment, this.myGlobalContext, new HttpRequestSessionVariables(), HttpRequestPersistentSubstitutor.create(), this.myIgnoreDynamicVariables, this.myInvalidVariableAware);
        HttpRequestVariableSubstitutorUpdater updater = new HttpRequestVariableSubstitutorUpdater(newSubstitutor);
        return new HttpRequestUpdatedVariableSubstitutor(newSubstitutor, updater);
    }

    @Override
    @NotNull
    public HttpRequestVariableSubstitutor invalidVariablesAware(boolean aware) {
        return new HttpRequestVariableSubstitutorImpl(this.myFileVariablesProvider.clone(), this.myEnvironment, this.myGlobalContext, this.mySessionVariables, this.myPersistentSubstitutor, this.myIgnoreDynamicVariables, aware);
    }

    @Override
    @Nullable
    @Contract(value="_,!null,_,_->!null")
    public String getVariableValue(@Nullable String name, @Nullable String defaultValue, @NotNull Project project, @Nullable HttpRequestVariableSubstitutionKey key2) {
        if (project == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(20);
        }
        if (StringUtil.isNotEmpty((String)name)) {
            if (name.startsWith(HttpRequestElementTypes.DYNAMIC_SIGN.toString())) {
                String variableExprText = name.substring(HttpRequestElementTypes.DYNAMIC_SIGN.toString().length()).trim();
                HttpDynamicVariable dynamicVariable = HttpRequestPsiFactory.createDynamicVariable(project, variableExprText);
                if (key2 == null || "auth.token".equals(dynamicVariable.getName())) {
                    return this.getDynamicVariableValue(dynamicVariable, defaultValue);
                }
                return this.myPersistentSubstitutor.retrieve(key2, (Function0<String>)((Function0)() -> this.getDynamicVariableValue(dynamicVariable, defaultValue)));
            }
            return this.getEnvironmentVariableValue(name, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public HttpRequestEnvironment getEnvironment() {
        HttpRequestEnvironment httpRequestEnvironment = this.myEnvironment;
        if (httpRequestEnvironment == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(21);
        }
        return httpRequestEnvironment;
    }

    @ApiStatus.Internal
    @NotNull
    public @NotNull Function<@NotNull String, @Nullable String> getSessionVariablesProvider() {
        Function<String, String> function = this.mySessionVariables::getValue;
        if (function == null) {
            HttpRequestVariableSubstitutorImpl.$$$reportNull$$$0(22);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 12, 15, 16, 17, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileVariablesProvider";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentSubstitutor";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/HttpRequestVariableSubstitutorImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestVariableSubstitutorImpl";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableValue";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionVariablesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                break;
            }
            case 13: 
            case 14: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getVariableValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicVariableValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFileVariableValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11, 12, 15, 16, 17, 21, 22 -> new IllegalStateException(string);
        };
    }

    private static class HttpRequestSessionVariables {
        private static final HttpRequestSessionVariables EMPTY = new HttpRequestSessionVariables();
        private final AtomicReference<Map<String, String>> myVariables = new AtomicReference(Map.of());

        private HttpRequestSessionVariables() {
        }

        @Nullable
        String getValue(@NotNull String name) {
            if (name == null) {
                HttpRequestSessionVariables.$$$reportNull$$$0(0);
            }
            return this.myVariables.get().get(name);
        }

        void setVariables(@NotNull Map<String, String> newVariables2) {
            if (newVariables2 == null) {
                HttpRequestSessionVariables.$$$reportNull$$$0(1);
            }
            this.myVariables.getAndSet(newVariables2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newVariables";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestVariableSubstitutorImpl$HttpRequestSessionVariables";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setVariables";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HttpRequestVariableSubstitutorUpdater {
        private final HttpRequestVariableSubstitutorImpl mySubstitutor;

        private HttpRequestVariableSubstitutorUpdater(HttpRequestVariableSubstitutorImpl substitutor2) {
            this.mySubstitutor = substitutor2;
        }

        public void setVariables(@NotNull Map<String, String> newVariables2) {
            if (newVariables2 == null) {
                HttpRequestVariableSubstitutorUpdater.$$$reportNull$$$0(0);
            }
            this.mySubstitutor.mySessionVariables.setVariables(newVariables2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVariables", "com/intellij/httpClient/http/request/HttpRequestVariableSubstitutorImpl$HttpRequestVariableSubstitutorUpdater", "setVariables"));
        }
    }

    public record HttpRequestUpdatedVariableSubstitutor(@NotNull HttpRequestVariableSubstitutorImpl substitutor, @NotNull HttpRequestVariableSubstitutorUpdater updater) {
        @NotNull
        private final HttpRequestVariableSubstitutorImpl substitutor;
        @NotNull
        private final HttpRequestVariableSubstitutorUpdater updater;

        public HttpRequestUpdatedVariableSubstitutor(@NotNull HttpRequestVariableSubstitutorImpl substitutor2, @NotNull HttpRequestVariableSubstitutorUpdater updater) {
            if (substitutor2 == null) {
                HttpRequestUpdatedVariableSubstitutor.$$$reportNull$$$0(0);
            }
            if (updater == null) {
                HttpRequestUpdatedVariableSubstitutor.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public HttpRequestVariableSubstitutorImpl substitutor() {
            HttpRequestVariableSubstitutorImpl httpRequestVariableSubstitutorImpl = this.substitutor;
            if (httpRequestVariableSubstitutorImpl == null) {
                HttpRequestUpdatedVariableSubstitutor.$$$reportNull$$$0(2);
            }
            return httpRequestVariableSubstitutorImpl;
        }

        @NotNull
        public HttpRequestVariableSubstitutorUpdater updater() {
            HttpRequestVariableSubstitutorUpdater httpRequestVariableSubstitutorUpdater = this.updater;
            if (httpRequestVariableSubstitutorUpdater == null) {
                HttpRequestUpdatedVariableSubstitutor.$$$reportNull$$$0(3);
            }
            return httpRequestVariableSubstitutorUpdater;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/HttpRequestVariableSubstitutorImpl$HttpRequestUpdatedVariableSubstitutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestVariableSubstitutorImpl$HttpRequestUpdatedVariableSubstitutor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substitutor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class FactoryImpl
    implements HttpRequestVariableSubstitutorFactory {
        @Override
        @NotNull
        public HttpRequestVariableSubstitutor getDefault(@NotNull Project project, @NotNull PsiFile contextFile) {
            block6: {
                HttpRequestVariableSubstitutorImpl httpRequestVariableSubstitutorImpl;
                if (project == null) {
                    FactoryImpl.$$$reportNull$$$0(0);
                }
                if (contextFile == null) {
                    FactoryImpl.$$$reportNull$$$0(1);
                }
                try {
                    HttpRequestEnvironment env = HttpRequestEnvironment.getDefault(project, contextFile);
                    if (env == null) break block6;
                    httpRequestVariableSubstitutorImpl = HttpRequestVariableSubstitutorImpl.create(project, env, contextFile);
                }
                catch (HttpRequestValidationException e) {
                    LOG.debug((Throwable)((Object)e));
                }
                if (httpRequestVariableSubstitutorImpl == null) {
                    FactoryImpl.$$$reportNull$$$0(2);
                }
                return httpRequestVariableSubstitutorImpl;
            }
            HttpRequestVariableSubstitutor httpRequestVariableSubstitutor = this.empty();
            if (httpRequestVariableSubstitutor == null) {
                FactoryImpl.$$$reportNull$$$0(3);
            }
            return httpRequestVariableSubstitutor;
        }

        @Override
        @NotNull
        public HttpRequestVariableSubstitutor empty() {
            HttpRequestVariableSubstitutorImpl httpRequestVariableSubstitutorImpl = EMPTY;
            if (httpRequestVariableSubstitutorImpl == null) {
                FactoryImpl.$$$reportNull$$$0(4);
            }
            return httpRequestVariableSubstitutorImpl;
        }

        @Override
        @NotNull
        public HttpRequestVariableSubstitutor withoutAnySubstitution() {
            HttpRequestVariableSubstitutorImpl httpRequestVariableSubstitutorImpl = NO_SUBSTITUTIONS;
            if (httpRequestVariableSubstitutorImpl == null) {
                FactoryImpl.$$$reportNull$$$0(5);
            }
            return httpRequestVariableSubstitutorImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextFile";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/HttpRequestVariableSubstitutorImpl$FactoryImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestVariableSubstitutorImpl$FactoryImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefault";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withoutAnySubstitution";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefault";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

