/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.HttpRequestRecognitionUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\nH\u0000\u001a\u0014\u0010\u0010\u001a\u00020\r*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"HOST_REGEXP", "", "METHOD_REGEXP", "PATH_REGEXP", "PORT_REGEXP", "SCHEME_REGEXP", "requestRegexp", "Lkotlin/text/Regex;", "findAllPossibleHttpRequests", "Lkotlin/sequences/Sequence;", "Lkotlin/text/MatchResult;", "text", "isMethodRequired", "", "emptySpacesCount", "", "isAtTheBeginningOfTheLine", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestRecognitionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestRecognitionUtils.kt\ncom/intellij/httpClient/http/request/HttpRequestRecognitionUtilsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,42:1\n643#2,5:43\n*S KotlinDebug\n*F\n+ 1 HttpRequestRecognitionUtils.kt\ncom/intellij/httpClient/http/request/HttpRequestRecognitionUtilsKt\n*L\n32#1:43,5\n*E\n"})
public final class HttpRequestRecognitionUtilsKt {
    @NotNull
    private static final String METHOD_REGEXP = "?<method>[A-Z]+";
    @NotNull
    private static final String SCHEME_REGEXP = "?<scheme>(https|http|[a-z]+)://";
    @NotNull
    private static final String HOST_REGEXP = "?<host>[A-Za-z0-9-\\.\\\\]+";
    @NotNull
    private static final String PORT_REGEXP = "?<port>:[0-9]+";
    @NotNull
    private static final String PATH_REGEXP = "?<path>/[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]*";
    @NotNull
    private static final Regex requestRegexp = new Regex("( )*(?<method>[A-Z]+)?( )*(?<scheme>(https|http|[a-z]+)://)?(?<host>[A-Za-z0-9-\\.\\\\]+)?(?<port>:[0-9]+)?(?<path>/[A-Za-z0-9-\\?=:&\\-;?_/\\.\\\\]*)?");

    @NotNull
    public static final Sequence<MatchResult> findAllPossibleHttpRequests(@NotNull String text2, boolean isMethodRequired) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)text2, (long)1000L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        return SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)Regex.findAll$default((Regex)requestRegexp, (CharSequence)charSequence, (int)0, (int)2, null), (Function1)findAllPossibleHttpRequests.1.INSTANCE), (Function1)((Function1)new Function1<MatchResult, Boolean>(text2, isMethodRequired){
            final /* synthetic */ String $text;
            final /* synthetic */ boolean $isMethodRequired;
            {
                this.$text = $text;
                this.$isMethodRequired = $isMethodRequired;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MatchResult result2) {
                String method;
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (!HttpRequestRecognitionUtilsKt.access$isAtTheBeginningOfTheLine(result2, this.$text)) {
                    return false;
                }
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result2.getGroups(), (String)"method");
                String string = method = matchGroup != null ? matchGroup.getValue() : null;
                if (method != null) {
                    return RequestExecutionSupport.All.allSupportedMethods().contains(method);
                }
                if (this.$isMethodRequired) {
                    return false;
                }
                return RegexExtensionsJDK8Kt.get((MatchGroupCollection)result2.getGroups(), (String)"scheme") != null ? true : RegexExtensionsJDK8Kt.get((MatchGroupCollection)result2.getGroups(), (String)"port") != null;
            }
        }));
    }

    public static /* synthetic */ Sequence findAllPossibleHttpRequests$default(String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return HttpRequestRecognitionUtilsKt.findAllPossibleHttpRequests(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static final int emptySpacesCount(@NotNull MatchResult $this$emptySpacesCount) {
        String string;
        block1: {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$emptySpacesCount, (String)"<this>");
            String $this$takeWhile$iv = $this$emptySpacesCount.getValue();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var1_1;
        }
        return string.length();
    }

    private static final boolean isAtTheBeginningOfTheLine(MatchResult $this$isAtTheBeginningOfTheLine, String text2) {
        int start = $this$isAtTheBeginningOfTheLine.getRange().getFirst();
        if (start == 0) {
            return true;
        }
        char characterBefore = text2.charAt(start - 1);
        return Intrinsics.areEqual((Object)String.valueOf(characterBefore), (Object)System.lineSeparator());
    }

    public static final /* synthetic */ boolean access$isAtTheBeginningOfTheLine(MatchResult $receiver, String text2) {
        return HttpRequestRecognitionUtilsKt.isAtTheBeginningOfTheLine($receiver, text2);
    }
}

