/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpFilePath;
import com.intellij.httpClient.http.request.psi.HttpHost;
import com.intellij.httpClient.http.request.psi.HttpInputFile;
import com.intellij.httpClient.http.request.psi.HttpQuery;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBody;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestMessage;
import com.intellij.httpClient.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestPsiFactory {
    private HttpRequestPsiFactory() {
    }

    @Nullable
    public static PsiElement createVariableIdentifier(@NotNull Project project, @NotNull String name) {
        HttpHost host;
        HttpRequestPsiFile file;
        HttpRequest newRequest;
        if (project == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(0);
        }
        if (name == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(1);
        }
        HttpRequestTarget target = (newRequest = HttpRequestPsiUtils.getFirstRequest((PsiFile)(file = HttpRequestPsiFactory.createDummyFile(project, "http://{{" + name + "}}")))) != null ? newRequest.getRequestTarget() : null;
        HttpHost httpHost = host = target != null ? target.getHost() : null;
        if (host != null) {
            PsiElement variable2 = HttpRequestPsiUtils.getNextSiblingByType(host.getFirstChild(), HttpRequestElementTypes.VARIABLE, false);
            return variable2 instanceof HttpVariable ? ((HttpVariable)variable2).getNameIdentifier() : null;
        }
        return null;
    }

    @NotNull
    public static HttpRequestTarget createHttpRequestTarget(@NotNull Project project, @NotNull String newHttpRequestTargetText) {
        if (project == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(2);
        }
        if (newHttpRequestTargetText == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(3);
        }
        HttpRequestPsiFile file = HttpRequestPsiFactory.createDummyFile(project, newHttpRequestTargetText);
        HttpRequest newRequest = HttpRequestPsiUtils.getFirstRequest((PsiFile)file);
        assert (newRequest != null);
        HttpRequestTarget target = newRequest.getRequestTarget();
        assert (target != null);
        HttpRequestTarget httpRequestTarget = target;
        if (httpRequestTarget == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(4);
        }
        return httpRequestTarget;
    }

    @NotNull
    public static HttpFilePath createFilePath(@NotNull Project project, @NotNull String newPath) {
        if (project == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(5);
        }
        if (newPath == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(6);
        }
        HttpRequestPsiFile file = HttpRequestPsiFactory.createDummyFile(project, "http://127.0.0.1\n\n< " + newPath);
        HttpRequest newRequest = HttpRequestPsiUtils.getFirstRequest((PsiFile)file);
        assert (newRequest != null);
        HttpRequestBody body2 = newRequest.getRequestBody();
        assert (body2 instanceof HttpRequestMessagesGroup);
        List<HttpRequestMessage> messages = ((HttpRequestMessagesGroup)body2).getRequestMessageList();
        assert (messages.get(0) instanceof HttpInputFile);
        HttpFilePath filePath2 = ((HttpInputFile)messages.get(0)).getFilePath();
        assert (filePath2 != null);
        HttpFilePath httpFilePath = filePath2;
        if (httpFilePath == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(7);
        }
        return httpFilePath;
    }

    @NotNull
    public static HttpDynamicVariable createDynamicVariable(@NotNull Project project, @NotNull String expr) {
        if (project == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(8);
        }
        if (expr == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(9);
        }
        HttpRequestPsiFile file = HttpRequestPsiFactory.createDummyFile(project, "GET {{$" + expr + "}}");
        HttpRequest newRequest = HttpRequestPsiUtils.getFirstRequest((PsiFile)file);
        assert (newRequest != null);
        HttpRequestTarget target = newRequest.getRequestTarget();
        assert (target != null);
        HttpHost host = target.getHost();
        assert (host != null);
        List<HttpDynamicVariable> variables2 = host.getDynamicVariableList();
        assert (variables2.size() == 1);
        HttpDynamicVariable httpDynamicVariable = variables2.get(0);
        if (httpDynamicVariable == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(10);
        }
        return httpDynamicVariable;
    }

    @NotNull
    public static HttpQuery createHttpQuery(@NotNull Project project, @NotNull String query) {
        if (project == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(11);
        }
        if (query == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(12);
        }
        HttpRequestPsiFile file = HttpRequestPsiFactory.createDummyFile(project, "GET localhost/path?" + query);
        HttpRequest newRequest = HttpRequestPsiUtils.getFirstRequest((PsiFile)file);
        assert (newRequest != null);
        HttpRequestTarget target = newRequest.getRequestTarget();
        assert (target != null);
        HttpQuery targetQuery = target.getQuery();
        assert (targetQuery != null);
        HttpQuery httpQuery = targetQuery;
        if (httpQuery == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(13);
        }
        return httpQuery;
    }

    @NotNull
    public static HttpRequestPsiFile createDummyFile(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(15);
        }
        HttpRequestFileType fileType = HttpRequestFileType.INSTANCE;
        String fileName = "DUMMY__." + fileType.getDefaultExtension();
        PsiFile dummyFile = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, (FileType)fileType, (CharSequence)text2, System.currentTimeMillis(), false);
        assert (dummyFile instanceof HttpRequestPsiFile);
        HttpRequestPsiFile httpRequestPsiFile = (HttpRequestPsiFile)dummyFile;
        if (httpRequestPsiFile == null) {
            HttpRequestPsiFactory.$$$reportNull$$$0(16);
        }
        return httpRequestPsiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 10, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newHttpRequestTargetText";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/HttpRequestPsiFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestPsiFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createHttpRequestTarget";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDynamicVariable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createHttpQuery";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVariableIdentifier";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHttpRequestTarget";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFilePath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDynamicVariable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createHttpQuery";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 10, 13, 16 -> new IllegalStateException(string);
        };
    }
}

