/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.NettyRuntime;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@IntellijInternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/httpClient/http/request/HttpClientEventLoopHolder;", "Lcom/intellij/openapi/Disposable;", "()V", "eventLoop", "Lio/netty/channel/nio/NioEventLoopGroup;", "getEventLoop", "()Lio/netty/channel/nio/NioEventLoopGroup;", "eventLoopGroup", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "maxThreads", "", "dispose", "", "intellij.httpClient.executor"})
@ApiStatus.Internal
public final class HttpClientEventLoopHolder
implements Disposable {
    private final int maxThreads = NettyRuntime.availableProcessors();
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final NioEventLoopGroup eventLoopGroup;
    @NotNull
    private final NioEventLoopGroup eventLoop;

    public HttpClientEventLoopHolder() {
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Intellij HttpClient Reactor Netty Pool", (int)this.maxThreads);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        this.eventLoop = this.eventLoopGroup = new NioEventLoopGroup(this.maxThreads, (Executor)this.executor);
    }

    @NotNull
    public final NioEventLoopGroup getEventLoop() {
        return this.eventLoop;
    }

    public void dispose() {
        this.eventLoop.shutdownGracefully().get(10L, TimeUnit.SECONDS);
    }
}

