/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.executor.websocket;

import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestConverter;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.httpClient.executor.websocket.WebSocketClientRequest;
import com.intellij.httpClient.executor.websocket.WebSocketClientRequestRequestHandler;
import com.intellij.httpClient.http.request.HttpRequestHeadersBuilder;
import com.intellij.httpClient.http.request.HttpRequestPsiConvertersKt;
import com.intellij.httpClient.http.request.HttpRequestUrlAccessor;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestBidiStreamingMessages;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/executor/websocket/WebSocketClientRequestExecutionSupport;", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "Lcom/intellij/httpClient/executor/websocket/WebSocketClientRequest;", "()V", "needsScheme", "", "getNeedsScheme", "()Z", "supportedSchemes", "", "", "getSupportedSchemes", "()Ljava/util/List;", "canProcess", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "getRequestConverter", "Lcom/intellij/httpClient/execution/common/RequestConverter;", "getRequestHandler", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "supportedMethods", "", "Companion", "intellij.httpClient.executor"})
@ApiStatus.Internal
public final class WebSocketClientRequestExecutionSupport
implements RequestExecutionSupport<WebSocketClientRequest> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> SCHEMES;

    @Override
    @NotNull
    public Collection<String> supportedMethods() {
        return CollectionsKt.listOf((Object)"WEBSOCKET");
    }

    @Override
    public boolean canProcess(@NotNull RequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        return !requestContext.getDebugMode() && Intrinsics.areEqual((Object)requestContext.getMethod(), (Object)"WEBSOCKET") && CollectionsKt.contains((Iterable)SCHEMES, (Object)requestContext.getScheme());
    }

    @Override
    @NotNull
    public RequestHandler<WebSocketClientRequest> getRequestHandler() {
        return new WebSocketClientRequestRequestHandler();
    }

    @Override
    @NotNull
    public RequestConverter<WebSocketClientRequest> getRequestConverter() {
        return new RequestConverter<WebSocketClientRequest>(){

            @NotNull
            protected Class<WebSocketClientRequest> getRequestType() {
                return WebSocketClientRequest.class;
            }

            @NotNull
            public WebSocketClientRequest psiToCommonRequest(@NotNull SmartPsiElementPointer<HttpRequest> requestPsiPointer, @NotNull HttpRequestVariableSubstitutor substitutor2) {
                Intrinsics.checkNotNullParameter(requestPsiPointer, (String)"requestPsiPointer");
                Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
                PsiElement psiElement = requestPsiPointer.getElement();
                Intrinsics.checkNotNull((Object)psiElement);
                HttpRequest element = (HttpRequest)psiElement;
                HttpRequestUrlAccessor httpRequestUrlAccessor = HttpRequestPsiConvertersKt.getFullUrl(element, substitutor2);
                Intrinsics.checkNotNull((Object)httpRequestUrlAccessor);
                String url = httpRequestUrlAccessor.toUrlString(true);
                HttpRequestBidiStreamingMessages messages = HttpRequestBidiStreamingMessages.Companion.createFromBody(element.getRequestBody(), substitutor2);
                HttpRequestHeadersBuilder headers2 = WebSocketClientRequestExecutionSupport.Companion.getHeaders(element, substitutor2);
                return new WebSocketClientRequest(url, messages, headers2);
            }

            @NotNull
            protected String toExternalFormInner(@NotNull WebSocketClientRequest request2, @Nullable String fileName) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                return "";
            }
        };
    }

    @Override
    public boolean getNeedsScheme() {
        return true;
    }

    @Override
    @NotNull
    public List<String> getSupportedSchemes() {
        return SCHEMES;
    }

    static {
        Object[] objectArray = new String[]{"ws", "wss"};
        SCHEMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/executor/websocket/WebSocketClientRequestExecutionSupport$Companion;", "", "()V", "SCHEMES", "", "", "getHeaders", "Lcom/intellij/httpClient/http/request/HttpRequestHeadersBuilder;", "element", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "substitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "intellij.httpClient.executor"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock(generateAssertion=false)
        @NotNull
        public final HttpRequestHeadersBuilder getHeaders(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor2) {
            HttpRequestHeadersBuilder httpRequestHeadersBuilder;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
            HttpRequestHeadersBuilder $this$getHeaders_u24lambda_u240 = httpRequestHeadersBuilder = new HttpRequestHeadersBuilder(null, 1, null);
            boolean bl = false;
            for (HttpHeaderField header2 : element.getHeaderFieldList()) {
                String string = header2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String string3 = "Content-Type".toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string2, (Object)string3)) continue;
                $this$getHeaders_u24lambda_u240.add((Pair<String, String>)TuplesKt.to((Object)header2.getName(), (Object)header2.getValue(substitutor2)));
            }
            HttpRequestHeadersBuilder headers2 = httpRequestHeadersBuilder;
            return headers2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

