/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.executor.graphql;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestConverter;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.httpClient.execution.common.RunContext;
import com.intellij.httpClient.execution.impl.HttpRequestConverter;
import com.intellij.httpClient.execution.impl.engineV2.HttpRequestHandlerV2;
import com.intellij.httpClient.executor.graphql.request.GraphQLClientRequest;
import com.intellij.httpClient.executor.graphql.request.GraphQLOverWsClientRequest;
import com.intellij.httpClient.executor.graphql.request.GraphQLRestClientRequest;
import com.intellij.httpClient.executor.websocket.WebSocketClientRequestRequestHandler;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/executor/graphql/GraphQLClientRequestExecutionSupport;", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "Lcom/intellij/httpClient/executor/graphql/request/GraphQLClientRequest;", "()V", "needsScheme", "", "getNeedsScheme", "()Z", "supportedSchemes", "", "", "getSupportedSchemes", "()Ljava/util/List;", "canProcess", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "getRequestConverter", "Lcom/intellij/httpClient/execution/common/RequestConverter;", "getRequestHandler", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "supportedMethods", "", "Companion", "intellij.httpClient.executor"})
public final class GraphQLClientRequestExecutionSupport
implements RequestExecutionSupport<GraphQLClientRequest> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String GRAPH_QL_METHOD = "GRAPHQL";
    @NotNull
    private static final List<String> HTTP_SCHEMES;
    @NotNull
    private static final List<String> WS_SCHEMES;
    @NotNull
    private static final List<String> SCHEMES;

    @Override
    @NotNull
    public Collection<String> supportedMethods() {
        return CollectionsKt.listOf((Object)GRAPH_QL_METHOD);
    }

    @Override
    public boolean canProcess(@NotNull RequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        return !requestContext.getDebugMode() && Intrinsics.areEqual((Object)requestContext.getMethod(), (Object)GRAPH_QL_METHOD) && CollectionsKt.contains((Iterable)SCHEMES, (Object)requestContext.getScheme());
    }

    @Override
    @NotNull
    public RequestHandler<GraphQLClientRequest> getRequestHandler() {
        return new RequestHandler<GraphQLClientRequest>(){

            public void prepareExecutionEnvironment(@NotNull GraphQLClientRequest request2, @NotNull RunContext runContext) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
            }

            @NotNull
            public CommonClientResponse execute(@NotNull GraphQLClientRequest request2, @NotNull RunContext runContext) {
                CommonClientResponse commonClientResponse;
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
                GraphQLClientRequest graphQLClientRequest = request2;
                if (graphQLClientRequest instanceof GraphQLRestClientRequest) {
                    commonClientResponse = (CommonClientResponse)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CommonClientResponse>, Object>(request2, runContext, null){
                        int label;
                        final /* synthetic */ GraphQLClientRequest $request;
                        final /* synthetic */ RunContext $runContext;
                        {
                            this.$request = $request;
                            this.$runContext = $runContext;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = new HttpRequestHandlerV2().executeSuspend(((GraphQLRestClientRequest)this.$request).getDelegate(), this.$runContext, (Continuation<? super CommonClientResponse>)((Continuation)this));
                                    if (object3 != object2) return object3;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return object3;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CommonClientResponse> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }));
                } else if (graphQLClientRequest instanceof GraphQLOverWsClientRequest) {
                    WebSocketClientRequestRequestHandler webSocketClientRequestRequestHandler = new WebSocketClientRequestRequestHandler();
                    CommonClientResponse response2 = webSocketClientRequestRequestHandler.execute(((GraphQLOverWsClientRequest)request2).getDelegate(), runContext);
                    commonClientResponse = GraphQLOverWsClientRequest.Companion.modifyResponse((GraphQLOverWsClientRequest)request2, response2, webSocketClientRequestRequestHandler, runContext);
                } else {
                    throw new IllegalStateException("Check all inheritors of GraphQLClientRequest and update `when` block");
                }
                return commonClientResponse;
            }
        };
    }

    @Override
    @NotNull
    public RequestConverter<GraphQLClientRequest> getRequestConverter() {
        return new RequestConverter<GraphQLClientRequest>(){

            @NotNull
            protected Class<GraphQLClientRequest> getRequestType() {
                return GraphQLClientRequest.class;
            }

            @NotNull
            public GraphQLClientRequest psiToCommonRequest(@NotNull SmartPsiElementPointer<HttpRequest> requestPsiPointer, @NotNull HttpRequestVariableSubstitutor substitutor2) throws HttpRequestValidationException {
                GraphQLClientRequest graphQLClientRequest;
                String it;
                boolean bl;
                boolean $i$f$any;
                Iterable $this$any$iv;
                String url;
                HttpRequest request2;
                block12: {
                    Intrinsics.checkNotNullParameter(requestPsiPointer, (String)"requestPsiPointer");
                    Intrinsics.checkNotNullParameter((Object)substitutor2, (String)"substitutor");
                    HttpRequest httpRequest = (HttpRequest)requestPsiPointer.getElement();
                    if (httpRequest == null) {
                        throw new HttpRequestValidationException("");
                    }
                    request2 = httpRequest;
                    url = request2.getHttpUrl(substitutor2);
                    $this$any$iv = GraphQLClientRequestExecutionSupport.Companion.getHTTP_SCHEMES$intellij_httpClient_executor();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl2 = false;
                            String string = url;
                            boolean bl3 = string != null ? StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null) : false;
                            if (!bl3) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    CommonClientRequest restRequest = new HttpRequestConverter().psiToCommonRequest((SmartPsiElementPointer)requestPsiPointer, substitutor2);
                    graphQLClientRequest = new GraphQLRestClientRequest((RestClientRequest)restRequest);
                } else {
                    boolean bl4;
                    block13: {
                        $this$any$iv = GraphQLClientRequestExecutionSupport.Companion.getWS_SCHEMES$intellij_httpClient_executor();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl5 = false;
                                String string = url;
                                boolean bl6 = string != null ? StringsKt.startsWith$default((String)string, (String)it, (boolean)false, (int)2, null) : false;
                                if (!bl6) continue;
                                bl4 = true;
                                break block13;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        graphQLClientRequest = GraphQLOverWsClientRequest.Companion.create(request2, substitutor2);
                    } else {
                        String string;
                        HttpRequestCompositeElement httpRequestCompositeElement = request2.getRequestTarget();
                        if ((httpRequestCompositeElement != null && (httpRequestCompositeElement = httpRequestCompositeElement.getScheme()) != null ? httpRequestCompositeElement.getText() : (string = null)) == null) {
                            string = "";
                        }
                        throw new HttpRequestValidationException(string);
                    }
                }
                return graphQLClientRequest;
            }

            @NotNull
            protected String toExternalFormInner(@NotNull GraphQLClientRequest request2, @Nullable String fileName) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                return "";
            }
        };
    }

    @Override
    public boolean getNeedsScheme() {
        return true;
    }

    @Override
    @NotNull
    public List<String> getSupportedSchemes() {
        return SCHEMES;
    }

    static {
        Object[] objectArray = new String[]{"http://", "https://"};
        HTTP_SCHEMES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"ws://", "wss://"};
        WS_SCHEMES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"http", "https", "ws", "wss"};
        SCHEMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/executor/graphql/GraphQLClientRequestExecutionSupport$Companion;", "", "()V", "GRAPH_QL_METHOD", "", "HTTP_SCHEMES", "", "getHTTP_SCHEMES$intellij_httpClient_executor", "()Ljava/util/List;", "SCHEMES", "WS_SCHEMES", "getWS_SCHEMES$intellij_httpClient_executor", "intellij.httpClient.executor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getHTTP_SCHEMES$intellij_httpClient_executor() {
            return HTTP_SCHEMES;
        }

        @NotNull
        public final List<String> getWS_SCHEMES$intellij_httpClient_executor() {
            return WS_SCHEMES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

