/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.adapters.HttpClientContentType;
import com.intellij.httpClient.execution.adapters.HttpClientMessagesAdaptersKt;
import com.intellij.httpClient.execution.impl.engineV2.NettyCookie;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.netty.http.client.HttpClientResponse;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\f*\u00020\u0004H\u0000\u001a\u0012\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\nH\u0000\u00a8\u0006\u0010"}, d2={"biscuitsToHeader", "", "biscuits", "", "Lcom/intellij/httpClient/execution/RestClientRequest$Biscuit;", "encodeCookieValue", "value", "extractContentType", "Lcom/intellij/httpClient/execution/adapters/HttpClientContentType;", "resp", "Lreactor/netty/http/client/HttpClientResponse;", "asBiscuit", "Lio/netty/handler/codec/http/cookie/Cookie;", "receivedFrom", "Ljava/net/URL;", "asNettyCookie", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nnettyAdapters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 nettyAdapters.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyAdaptersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1549#2:194\n1620#2,3:195\n1549#2:198\n1620#2,3:199\n*S KotlinDebug\n*F\n+ 1 nettyAdapters.kt\ncom/intellij/httpClient/execution/impl/engineV2/NettyAdaptersKt\n*L\n153#1:194\n153#1:195,3\n156#1:198\n156#1:199,3\n*E\n"})
public final class NettyAdaptersKt {
    private static final HttpClientContentType extractContentType(HttpClientResponse resp) {
        String contentTypeHeader = resp.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeHeader == null) {
            return HttpClientContentType.TEXT_PLAIN;
        }
        return HttpClientMessagesAdaptersKt.parseContentType(contentTypeHeader);
    }

    @NotNull
    public static final Cookie asNettyCookie(@NotNull RestClientRequest.Biscuit $this$asNettyCookie) {
        Intrinsics.checkNotNullParameter((Object)$this$asNettyCookie, (String)"<this>");
        String string = $this$asNettyCookie.getName();
        if (string == null) {
            string = "";
        }
        String string2 = URLEncoder.encode(string, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(...)");
        String string3 = $this$asNettyCookie.getValue();
        if (string3 == null) {
            string3 = "";
        }
        return new NettyCookie(string2, NettyAdaptersKt.encodeCookieValue(string3), $this$asNettyCookie.getPath());
    }

    private static final RestClientRequest.Biscuit asBiscuit(Cookie $this$asBiscuit, URL receivedFrom) {
        String string;
        String string2 = $this$asBiscuit.name();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = URLDecoder.decode(string2, Charsets.UTF_8);
        String string4 = $this$asBiscuit.value();
        if (string4 == null) {
            string4 = "";
        }
        String string5 = URLDecoder.decode(StringsKt.removeSurrounding((String)string4, (CharSequence)"\""), Charsets.UTF_8);
        String string6 = $this$asBiscuit.domain();
        if (string6 == null) {
            string6 = receivedFrom.getHost();
        }
        if ((string = $this$asBiscuit.path()) == null) {
            string = receivedFrom.getPath();
        }
        return new RestClientRequest.Biscuit(string3, string5, string6, string, $this$asBiscuit.maxAge() != Long.MIN_VALUE ? Instant.now().toEpochMilli() + $this$asBiscuit.maxAge() : -1L);
    }

    /*
     * Unable to fully structure code
     */
    private static final String encodeCookieValue(String value) {
        v0 = StringsKt.firstOrNull((CharSequence)value);
        if (v0 != null ? CharsKt.isWhitespace((char)v0.charValue()) : false) ** GOTO lbl-1000
        v1 = StringsKt.lastOrNull((CharSequence)value);
        v2 = v1 != null ? CharsKt.isWhitespace((char)v1.charValue()) : false;
        if (v2) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        needQuotes = v3;
        encoded = URLEncoder.encode(value, Charsets.UTF_8);
        if (needQuotes) {
            v4 = "\"" + encoded + "\"";
        } else {
            var3_3 = encoded;
            Intrinsics.checkNotNull((Object)var3_3);
            v4 = var3_3;
        }
        return v4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RestClientRequest.Biscuit> biscuits(@NotNull HttpClientResponse $this$biscuits) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$biscuits, (String)"<this>");
        Iterable $this$map$iv = CollectionsKt.flatten((Iterable)$this$biscuits.cookies().values());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Cookie cookie = (Cookie)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(NettyAdaptersKt.asBiscuit((Cookie)it, new URL($this$biscuits.resourceUrl())));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String biscuitsToHeader(@NotNull List<? extends RestClientRequest.Biscuit> biscuits) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(biscuits, (String)"biscuits");
        Iterable iterable = biscuits;
        ClientCookieEncoder clientCookieEncoder = ClientCookieEncoder.STRICT;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RestClientRequest.Biscuit biscuit = (RestClientRequest.Biscuit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NettyAdaptersKt.asNettyCookie((RestClientRequest.Biscuit)it));
        }
        return clientCookieEncoder.encode((Collection)((List)destination$iv$iv));
    }

    public static final /* synthetic */ HttpClientContentType access$extractContentType(HttpClientResponse resp) {
        return NettyAdaptersKt.extractContentType(resp);
    }
}

