/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.httpClient.execution.impl.HttpRequestConverter;
import com.intellij.httpClient.execution.impl.HttpRequestExecutionSupportKt;
import com.intellij.httpClient.execution.impl.HttpRequestFallbackHandlerProvider;
import com.intellij.httpClient.execution.impl.engineV2.HttpRequestHandlerV2;
import com.intellij.httpClient.http.request.lexer.HttpClientExtensionLexemesDefaultManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/execution/impl/HttpRequestRunSupport;", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "Lcom/intellij/httpClient/execution/RestClientRequest;", "()V", "needsScheme", "", "getNeedsScheme", "()Z", "supportedSchemes", "", "", "getSupportedSchemes", "()Ljava/util/List;", "canProcess", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "getRequestConverter", "Lcom/intellij/httpClient/execution/impl/HttpRequestConverter;", "getRequestHandler", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "supportedMethods", "", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpRequestExecutionSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestExecutionSupport.kt\ncom/intellij/httpClient/execution/impl/HttpRequestRunSupport\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,37:1\n50#2:38\n*S KotlinDebug\n*F\n+ 1 HttpRequestExecutionSupport.kt\ncom/intellij/httpClient/execution/impl/HttpRequestRunSupport\n*L\n22#1:38\n*E\n"})
public class HttpRequestRunSupport
implements RequestExecutionSupport<RestClientRequest> {
    @Override
    public boolean canProcess(@NotNull RequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        return !requestContext.getDebugMode() && HttpClientExtensionLexemesDefaultManager.getMethods().contains(requestContext.getMethod()) && CollectionsKt.contains((Iterable)HttpRequestExecutionSupportKt.getHTTP_SCHEMES(), (Object)requestContext.getScheme());
    }

    @Override
    @NotNull
    public RequestHandler<RestClientRequest> getRequestHandler() {
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        Object object = (HttpRequestFallbackHandlerProvider)(application != null ? application.getService(HttpRequestFallbackHandlerProvider.class) : null);
        if (object == null || (object = object.getRequestHandler()) == null) {
            object = new HttpRequestHandlerV2();
        }
        return object;
    }

    @NotNull
    public HttpRequestConverter getRequestConverter() {
        return new HttpRequestConverter();
    }

    @Override
    @NotNull
    public Collection<String> supportedMethods() {
        return HttpClientExtensionLexemesDefaultManager.getMethods();
    }

    @Override
    public boolean getNeedsScheme() {
        return true;
    }

    @Override
    @NotNull
    public List<String> getSupportedSchemes() {
        return HttpRequestExecutionSupportKt.getHTTP_SCHEMES();
    }
}

