/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.common.RunContext;
import com.intellij.httpClient.execution.impl.engineV2.HttpRequestHandlerV2;
import com.intellij.httpClient.http.request.debug.HttpRequestDebugger;
import com.intellij.httpClient.http.request.debug.HttpRequestDebuggerUtils;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/httpClient/execution/impl/HttpDebugRequestHandler;", "Lcom/intellij/httpClient/execution/impl/engineV2/HttpRequestHandlerV2;", "()V", "findDebuggerExtension", "Lcom/intellij/httpClient/http/request/debug/HttpRequestDebugger;", "settings", "Lcom/intellij/httpClient/http/request/run/config/HttpRequestExecutionSettings;", "getHost", "", "request", "Lcom/intellij/httpClient/execution/common/CommonClientRequest;", "prepareDebugSession", "", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/httpClient/execution/RestClientRequest;", "processHandler", "Lcom/intellij/httpClient/http/request/run/HttpClientRequestProcessHandler;", "prepareExecutionEnvironment", "runContext", "Lcom/intellij/httpClient/execution/common/RunContext;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpDebugRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpDebugRequestHandler.kt\ncom/intellij/httpClient/execution/impl/HttpDebugRequestHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n11#2:76\n288#3,2:77\n*S KotlinDebug\n*F\n+ 1 HttpDebugRequestHandler.kt\ncom/intellij/httpClient/execution/impl/HttpDebugRequestHandler\n*L\n32#1:76\n62#1:77,2\n*E\n"})
public final class HttpDebugRequestHandler
extends HttpRequestHandlerV2 {
    @Override
    public void prepareExecutionEnvironment(@NotNull RestClientRequest request2, @NotNull RunContext runContext) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        this.prepareDebugSession(runContext.getSettings(), runContext.getProject(), request2, runContext.getProcessHandler());
    }

    private final void prepareDebugSession(HttpRequestExecutionSettings settings, Project project, RestClientRequest request2, HttpClientRequestProcessHandler processHandler) throws ExecutionException {
        if (processHandler == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(HttpDebugRequestHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to prepare debug session because null value is passed for process handler. Abort.");
            throw new ExecutionException(RestClientBundle.message("rest.client.request.debug.null.process.handler", new Object[0]));
        }
        String host = this.getHost(request2);
        this.findDebuggerExtension(settings).startDebugSession(project, request2, host, processHandler);
    }

    private final String getHost(CommonClientRequest request2) throws ExecutionException {
        URI uRI;
        try {
            String string = request2.getURL();
            if (string == null) {
                string = "";
            }
            uRI = new URI(string);
        }
        catch (URISyntaxException ex) {
            Object[] objectArray = new Object[1];
            String string = request2.getURL();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            throw new ExecutionException(RestClientBundle.message("debug.http.client.can.not.parse.url", objectArray), (Throwable)ex);
        }
        URI uri = uRI;
        String string = uri.getHost();
        if (string == null) {
            Object[] objectArray = new Object[1];
            String string2 = request2.getURL();
            if (string2 == null) {
                string2 = "";
            }
            objectArray[0] = string2;
            throw new ExecutionException(RestClientBundle.message("debug.http.client.can.not.resolve.host.name", objectArray));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final HttpRequestDebugger findDebuggerExtension(HttpRequestExecutionSettings settings) throws ExecutionException {
        HttpRequestDebugger httpRequestDebugger;
        List<HttpRequestDebugger> list2 = HttpRequestDebuggerUtils.getAvailableDebuggerExtension();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAvailableDebuggerExtension(...)");
        List<HttpRequestDebugger> debuggerExtensions = list2;
        if (debuggerExtensions.isEmpty()) {
            throw new ExecutionException(RestClientBundle.message("debug.http.client.no.debugger.extensions", new Object[0]));
        }
        HttpRequestExecutionSettings httpRequestExecutionSettings = settings;
        String debuggerName = httpRequestExecutionSettings != null ? httpRequestExecutionSettings.getDebugger() : null;
        CharSequence charSequence = debuggerName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            Object v2;
            Object[] objectArray;
            block5: {
                void $this$firstOrNull$iv;
                objectArray = (Object[])debuggerExtensions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HttpRequestDebugger it = (HttpRequestDebugger)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPresentableName(), (Object)debuggerName)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            if ((httpRequestDebugger = (HttpRequestDebugger)v2) == null) {
                objectArray = new Object[]{debuggerName};
                throw new ExecutionException(RestClientBundle.message("debug.http.client.no.debugger.extension.by.name", objectArray));
            }
        } else {
            Object object = CollectionsKt.first(debuggerExtensions);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            httpRequestDebugger = (HttpRequestDebugger)object;
        }
        return httpRequestDebugger;
    }
}

