/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.common;

import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestConverter;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntellijInternalApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\bf\u0018\u0000 \u0016*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH&J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H&J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H&J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H&R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0003"}, d2={"Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "RequestType", "Lcom/intellij/httpClient/execution/common/CommonClientRequest;", "", "needsScheme", "", "getNeedsScheme", "()Z", "supportedSchemes", "", "", "getSupportedSchemes", "()Ljava/util/List;", "canProcess", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "getRequestConverter", "Lcom/intellij/httpClient/execution/common/RequestConverter;", "getRequestHandler", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "supportedMethods", "", "All", "intellij.httpClient.executor"})
public interface RequestExecutionSupport<RequestType extends CommonClientRequest> {
    @NotNull
    public static final All All = com.intellij.httpClient.execution.common.RequestExecutionSupport$All.$$INSTANCE;

    @NotNull
    public Collection<String> supportedMethods();

    public boolean canProcess(@NotNull RequestContext var1);

    @NotNull
    public RequestHandler<RequestType> getRequestHandler();

    @NotNull
    public RequestConverter<RequestType> getRequestConverter();

    default public boolean getNeedsScheme() {
        return false;
    }

    @NotNull
    default public List<String> getSupportedSchemes() {
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0018\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00142\u0006\u0010\u0018\u001a\u00020\u000fJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u000fJ\u0010\u0010\u000b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007R&\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/httpClient/execution/common/RequestExecutionSupport$All;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "getEP_NAME$annotations", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ignoreAssertions", "", "allSupportedMethods", "", "", "forContext", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "forMethod", "", "method", "", "forSchema", "schema", "getDefaultMethod", "scheme", "getDefaultScheme", "", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nRequestExecutionSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestExecutionSupport.kt\ncom/intellij/httpClient/execution/common/RequestExecutionSupport$All\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,171:1\n766#2:172\n857#2,2:173\n1549#2:175\n1620#2,3:176\n766#2:179\n857#2,2:180\n766#2:182\n857#2,2:183\n1#3:185\n11#4:186\n*S KotlinDebug\n*F\n+ 1 RequestExecutionSupport.kt\ncom/intellij/httpClient/execution/common/RequestExecutionSupport$All\n*L\n50#1:172\n50#1:173,2\n58#1:175\n58#1:176,3\n75#1:179\n75#1:180,2\n80#1:182\n80#1:183,2\n37#1:186\n*E\n"})
    public static final class All {
        static final /* synthetic */ All $$INSTANCE;
        private static volatile boolean ignoreAssertions;
        @ApiStatus.Internal
        @NotNull
        private static final ExtensionPointName<RequestExecutionSupport<?>> EP_NAME;
        @NotNull
        private static final Logger LOG;

        private All() {
        }

        @NotNull
        public final ExtensionPointName<RequestExecutionSupport<?>> getEP_NAME() {
            return EP_NAME;
        }

        @IntellijInternalApi
        public static /* synthetic */ void getEP_NAME$annotations() {
        }

        @IntellijInternalApi
        @TestOnly
        public final void ignoreAssertions(@NotNull Disposable disposable2) {
            Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
            ignoreAssertions = true;
            Disposer.register((Disposable)disposable2, All::ignoreAssertions$lambda$0);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final RequestExecutionSupport<?> forContext(@NotNull RequestContext requestContext) {
            RequestExecutionSupport it;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
            Iterable $this$filter$iv = EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (RequestExecutionSupport)element$iv$iv;
                boolean bl = false;
                if (!it.canProcess(requestContext)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List executionSupports = (List)destination$iv$iv;
            if (executionSupports.isEmpty()) {
                LOG.info("No suitable execution support is available for given context: " + requestContext);
            }
            if (!ignoreAssertions) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$filter$iv = executionSupports;
                RequestContext requestContext2 = requestContext;
                boolean bl = executionSupports.size() <= 1;
                Logger logger = LOG;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (RequestExecutionSupport)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getClass().getName());
                }
                collection = (List)destination$iv$iv;
                logger.assertTrue(bl, (Object)("Ambiguous context " + requestContext2 + ", too many suitable execution supports: " + (List)collection));
            }
            return (RequestExecutionSupport)CollectionsKt.firstOrNull((List)executionSupports);
        }

        @NotNull
        public final Collection<String> allSupportedMethods() {
            return SequencesKt.toList((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)EP_NAME.getExtensionList()), (Function1)allSupportedMethods.1.INSTANCE)));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<RequestExecutionSupport<?>> forMethod(@Nullable CharSequence method) {
            void $this$filterTo$iv$iv;
            if (method == null) {
                return CollectionsKt.emptyList();
            }
            String strMethod = ((Object)method).toString();
            Iterable $this$filter$iv = EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RequestExecutionSupport it = (RequestExecutionSupport)element$iv$iv;
                boolean bl = false;
                if (!it.supportedMethods().contains(strMethod)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<RequestExecutionSupport<?>> forSchema(@NotNull String schema) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Iterable $this$filter$iv = EP_NAME.getExtensionList();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RequestExecutionSupport executor = (RequestExecutionSupport)element$iv$iv;
                boolean bl = false;
                if (!executor.getSupportedSchemes().contains(schema)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final String getDefaultScheme(@NotNull String method) {
            Object v2;
            Object v0;
            Object it;
            block5: {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Iterable iterable = EP_NAME.getExtensionList();
                for (Object object : iterable) {
                    it = (RequestExecutionSupport)object;
                    boolean bl = false;
                    if (!it.supportedMethods().contains(method)) continue;
                    v0 = object;
                    break block5;
                }
                v0 = null;
            }
            RequestExecutionSupport requestExecutionSupport = v0;
            if (requestExecutionSupport != null) {
                RequestExecutionSupport support = requestExecutionSupport;
                boolean bl = false;
                String string = (String)CollectionsKt.firstOrNull(support.getSupportedSchemes());
                if (string != null) {
                    Object object;
                    object = string;
                    it = object;
                    boolean bl2 = false;
                    v2 = support.getNeedsScheme() ? object : null;
                } else {
                    v2 = null;
                }
            } else {
                v2 = null;
            }
            return v2;
        }

        @Nullable
        public final String getDefaultMethod(@NotNull String scheme) {
            String string;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                Iterable iterable = EP_NAME.getExtensionList();
                for (Object t : iterable) {
                    RequestExecutionSupport it = (RequestExecutionSupport)t;
                    boolean bl = false;
                    if (!it.getSupportedSchemes().contains(scheme)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            RequestExecutionSupport requestExecutionSupport = v0;
            if (requestExecutionSupport != null) {
                RequestExecutionSupport support = requestExecutionSupport;
                boolean bl = false;
                string = (String)CollectionsKt.firstOrNull((Iterable)support.supportedMethods());
            } else {
                string = null;
            }
            return string;
        }

        private static final void ignoreAssertions$lambda$0() {
            ignoreAssertions = true;
        }

        static {
            $$INSTANCE = new All();
            EP_NAME = ExtensionPointName.Companion.create("com.intellij.httpClient.requestExecutionSupport");
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RequestExecutionSupport.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        public static <RequestType extends CommonClientRequest> boolean getNeedsScheme(@NotNull RequestExecutionSupport<RequestType> $this) {
            return ((RequestExecutionSupport)$this).getNeedsScheme();
        }

        @Deprecated
        @NotNull
        public static <RequestType extends CommonClientRequest> List<String> getSupportedSchemes(@NotNull RequestExecutionSupport<RequestType> $this) {
            return ((RequestExecutionSupport)$this).getSupportedSchemes();
        }
    }
}

