/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.intellij.httpClient.execution.RestClientResponse;
import com.intellij.httpClient.execution.adapters.HttpClientBasicHeader;
import com.intellij.httpClient.execution.adapters.HttpClientContentType;
import com.intellij.httpClient.execution.adapters.HttpClientResponse;
import com.intellij.httpClient.execution.adapters.HttpClientResponseHeader;
import com.intellij.httpClient.execution.adapters.HttpClientResponseStatusLine;
import com.intellij.httpClient.execution.common.CommonClientResponseBody;
import com.intellij.httpClient.execution.common.CommonClientResponseProperty;
import com.intellij.httpClient.execution.common.CommonClientResponsePropertyHolder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RestClientResponseImpl
implements RestClientResponse {
    private final CommonClientResponsePropertyHolder.MapBasedHolder myHolderDelegate;
    private final HttpClientResponse myResponse;
    private final CommonClientResponseBody myBody;
    private volatile Long myExecutionTime;
    @Nullable
    private List<HttpClientBasicHeader> myHeaders;

    private RestClientResponseImpl(@NotNull HttpClientResponse response2, @NotNull CommonClientResponseBody body2) {
        if (response2 == null) {
            RestClientResponseImpl.$$$reportNull$$$0(0);
        }
        if (body2 == null) {
            RestClientResponseImpl.$$$reportNull$$$0(1);
        }
        this.myHolderDelegate = new CommonClientResponsePropertyHolder.MapBasedHolder();
        this.myResponse = response2;
        this.myBody = body2;
    }

    @Override
    public Long getExecutionTime() {
        return this.myExecutionTime;
    }

    @Override
    public void setExecutionTime(@Nullable Long executionTime) {
        this.myExecutionTime = executionTime;
    }

    @NotNull
    public static RestClientResponse createEmptyResponse(@NotNull HttpClientResponse response2) {
        if (response2 == null) {
            RestClientResponseImpl.$$$reportNull$$$0(2);
        }
        return new RestClientResponseImpl(response2, new CommonClientResponseBody.Empty());
    }

    @NotNull
    public static RestClientResponse createEmptyResponse(@NotNull String statusText) {
        if (statusText == null) {
            RestClientResponseImpl.$$$reportNull$$$0(3);
        }
        return RestClientResponseImpl.createEmptyResponse(new EmptyResponseWithErrorText(statusText));
    }

    @NotNull
    public static RestClientResponse createFromBody(@NotNull HttpClientResponse response2, @NotNull CommonClientResponseBody body2) {
        if (response2 == null) {
            RestClientResponseImpl.$$$reportNull$$$0(4);
        }
        if (body2 == null) {
            RestClientResponseImpl.$$$reportNull$$$0(5);
        }
        return new RestClientResponseImpl(response2, body2);
    }

    @Override
    @NotNull
    public HttpClientContentType getContentType() {
        HttpClientContentType httpClientContentType = this.myResponse.getContentType();
        if (httpClientContentType == null) {
            RestClientResponseImpl.$$$reportNull$$$0(6);
        }
        return httpClientContentType;
    }

    @Override
    @NotNull
    public HttpClientResponseStatusLine getStatusLine() {
        HttpClientResponseStatusLine httpClientResponseStatusLine = this.myResponse.getStatusLine();
        if (httpClientResponseStatusLine == null) {
            RestClientResponseImpl.$$$reportNull$$$0(7);
        }
        return httpClientResponseStatusLine;
    }

    @Override
    @NotNull
    public List<? extends HttpClientBasicHeader> getAllHeaders() {
        if (this.myHeaders != null) {
            List<HttpClientBasicHeader> list2 = this.myHeaders;
            if (list2 == null) {
                RestClientResponseImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List<HttpClientResponseHeader> list3 = this.myResponse.getHeaders();
        if (list3 == null) {
            RestClientResponseImpl.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @Override
    @NotNull
    public CommonClientResponseBody getBody() {
        CommonClientResponseBody commonClientResponseBody = this.myBody;
        if (commonClientResponseBody == null) {
            RestClientResponseImpl.$$$reportNull$$$0(10);
        }
        return commonClientResponseBody;
    }

    @Override
    @Nullable
    public <T> T get(@NotNull CommonClientResponseProperty<T> property) {
        if (property == null) {
            RestClientResponseImpl.$$$reportNull$$$0(11);
        }
        return this.myHolderDelegate.get(property);
    }

    @Override
    public <T> void set(@NotNull CommonClientResponseProperty<T> property, T value) {
        if (property == null) {
            RestClientResponseImpl.$$$reportNull$$$0(12);
        }
        this.myHolderDelegate.set(property, value);
    }

    @Override
    public RestClientResponse withHeaders(@NotNull List<HttpClientBasicHeader> headers2) {
        if (headers2 == null) {
            RestClientResponseImpl.$$$reportNull$$$0(13);
        }
        this.myHeaders = new ArrayList<HttpClientBasicHeader>(headers2);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusText";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/execution/RestClientResponseImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/execution/RestClientResponseImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHeaders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyResponse";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFromBody";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withHeaders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    private static class EmptyResponseWithErrorText
    implements HttpClientResponse {
        private final String myStatusText;

        EmptyResponseWithErrorText(String statusText) {
            this.myStatusText = statusText;
        }

        @Override
        @NotNull
        public List<HttpClientResponseHeader> getHeaders() {
            List<HttpClientResponseHeader> list2 = List.of();
            if (list2 == null) {
                EmptyResponseWithErrorText.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        @Nullable
        public HttpClientResponseHeader getHeader(@NotNull String name) {
            if (name == null) {
                EmptyResponseWithErrorText.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        @NotNull
        public HttpClientContentType getContentType() {
            HttpClientContentType httpClientContentType = HttpClientContentType.TEXT_PLAIN;
            if (httpClientContentType == null) {
                EmptyResponseWithErrorText.$$$reportNull$$$0(2);
            }
            return httpClientContentType;
        }

        @Override
        @NotNull
        public HttpClientResponseStatusLine getStatusLine() {
            return new HttpClientResponseStatusLine("HTTP/1.1", Integer.MAX_VALUE, this.myStatusText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/execution/RestClientResponseImpl$EmptyResponseWithErrorText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaders";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/execution/RestClientResponseImpl$EmptyResponseWithErrorText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentType";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getHeader";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

