/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientFormBodyPart;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestClientRequestBuilder
implements RequestBuilder<RestClientRequest, RestClientFormBodyPart> {
    private final RestClientRequest myRequest = new RestClientRequest();

    public RestClientRequestBuilder() {
        this.myRequest.urlPath = "";
        this.myRequest.textToSend = "";
        this.myRequest.filesToSend = "";
    }

    @Override
    public void withUrl(@NotNull String url) {
        if (url == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(0);
        }
        this.myRequest.urlBase = url;
    }

    @Override
    public void withMethod(@NotNull String method) {
        if (method == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(1);
        }
        this.myRequest.httpMethod = method;
    }

    @Override
    public void withProtocol(@NotNull RequestBuilder.HttpProtocol protocol) {
        if (protocol == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(2);
        }
        this.myRequest.protocol = protocol;
    }

    @Override
    public <E extends Throwable> void withQueryParameters(@NotNull ThrowableConsumer<RequestBuilder.QueryBuilder, E> queryInitializer) throws E {
        if (queryInitializer == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(3);
        }
        queryInitializer.consume((key2, value) -> this.myRequest.parameters.add(new RestClientRequest.KeyValuePair(key2, value)));
        this.myRequest.parametersEnabled = !this.myRequest.parameters.isEmpty();
    }

    @Override
    public void withAuthData(@NotNull HttpClientAuthData data) {
        if (data == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(4);
        }
        this.myRequest.authData = data;
    }

    public void withHeader(@NotNull String name, @NotNull String value) {
        if (name == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(5);
        }
        if (value == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(6);
        }
        this.withHeader(name, value, __ -> null);
    }

    @Override
    public void withHeader(@NotNull String name, @NotNull String value, @NotNull Function<String, @Nullable String> optionProvider) {
        if (name == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(7);
        }
        if (value == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(8);
        }
        if (optionProvider == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(9);
        }
        this.myRequest.headers.add(new RestClientRequest.KeyValuePair(name, value));
    }

    @Override
    public void withFileToSend(@NotNull File file) {
        if (file == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(10);
        }
        this.myRequest.filesToSend = PathUtil.toSystemIndependentName((String)file.getPath());
        this.myRequest.haveFileToSend = StringUtil.isNotEmpty((String)this.myRequest.filesToSend);
    }

    @Override
    public void withTextToSend(@NotNull String text2) {
        if (text2 == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(11);
        }
        this.myRequest.textToSend = text2;
        this.myRequest.haveTextToSend = StringUtil.isNotEmpty((String)this.myRequest.textToSend);
    }

    @Override
    public <E extends Throwable> void withMultipartBody(@Nullable String multipartBoundary, @NotNull ThrowableConsumer<? super RequestBuilder.MultipartBodyBuilder<RestClientFormBodyPart>, E> multipartInitializer) throws E {
        if (multipartInitializer == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(12);
        }
        this.myRequest.isFileUpload = true;
        this.myRequest.multipartBoundary = multipartBoundary;
        this.myRequest.formBodyPart = new ArrayList<RestClientFormBodyPart>();
        multipartInitializer.consume((Object)new RequestBuilder.MultipartBodyBuilder<RestClientFormBodyPart>(){

            @Override
            public RestClientFormBodyPart createPartForFile(@NotNull String fieldName, @NotNull String fileName, @NotNull File file, @NotNull RequestBuilder.ContentTypeInfo contentType2) {
                if (fieldName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fileName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (contentType2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return RestClientFormBodyPart.create(fieldName, fileName, file, contentType2);
            }

            @Override
            public RestClientFormBodyPart createPartForString(@NotNull String fieldName, @NotNull String content2, @NotNull RequestBuilder.ContentTypeInfo contentType2) {
                if (fieldName == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (content2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (contentType2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                return RestClientFormBodyPart.create(fieldName, content2, contentType2);
            }

            @Override
            public void addFormBodyPart(@NotNull RestClientFormBodyPart bodyPart) {
                if (bodyPart == null) {
                    1.$$$reportNull$$$0(7);
                }
                RestClientRequestBuilder.this.myRequest.formBodyPart.add(bodyPart);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fieldName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contentType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "content";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "bodyPart";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/httpClient/execution/RestClientRequestBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createPartForFile";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createPartForString";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addFormBodyPart";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void withConfig(@NotNull HttpRequestConfig config) {
        if (config == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(13);
        }
        this.myRequest.config = config;
    }

    @Override
    public void withEmptyCredentials() {
        this.myRequest.setEmptyCredentials();
    }

    @Override
    public void withSslConfiguration(@Nullable SslConfiguration sslConfiguration) {
        this.myRequest.sslConfiguration = sslConfiguration;
    }

    @Override
    public void withUserDefinedOutputFilePath(@NotNull String filePath2, boolean isForce) {
        Path path2;
        if (filePath2 == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(14);
        }
        if ((path2 = Path.of(filePath2, new String[0]).toAbsolutePath()).getParent() != null) {
            this.myRequest.outputFilePath = new CommonClientRequest.OutputFilePath(path2, isForce, filePath2.endsWith(File.separator));
        }
    }

    @Override
    public RestClientRequest build() {
        return this.myRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryInitializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multipartInitializer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/execution/RestClientRequestBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withUrl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withProtocol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withQueryParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withAuthData";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "withHeader";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "withFileToSend";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "withTextToSend";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "withMultipartBody";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "withConfig";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "withUserDefinedOutputFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

