/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientFormBodyPart;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.common.CommonClientRequest;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestClientRequest
implements CommonClientRequest {
    public List<Biscuit> biscuits = new ArrayList<Biscuit>();
    public String httpMethod;
    public String urlBase;
    public String urlPath;
    public List<KeyValuePair> headers = new ArrayList<KeyValuePair>();
    public List<KeyValuePair> parameters = new ArrayList<KeyValuePair>();
    public boolean parametersEnabled;
    public boolean haveTextToSend;
    public boolean haveFileToSend;
    public boolean isFileUpload;
    public String textToSend;
    public String filesToSend;
    @Transient
    public List<RestClientFormBodyPart> formBodyPart = new ArrayList<RestClientFormBodyPart>();
    @Transient
    public String multipartBoundary = null;
    @Transient
    public HttpClientAuthData authData = null;
    @Transient
    @NotNull
    public HttpRequestConfig config = new HttpRequestConfig(true, true, true);
    @Transient
    @Nullable
    public SslConfiguration sslConfiguration = null;
    @Transient
    @Nullable
    public RequestBuilder.HttpProtocol protocol = null;
    @Nullable
    public CommonClientRequest.OutputFilePath outputFilePath;
    private List<KeyValuePair> myActualHeaders = List.of();

    @Override
    @Transient
    @Nullable
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    @Transient
    @Nullable
    public String getTextToSend() {
        return this.textToSend;
    }

    @Override
    @Transient
    @Nullable
    public CommonClientRequest.OutputFilePath getOutputFilePath() {
        return this.outputFilePath;
    }

    @Override
    @Transient
    public boolean isLogResponse() {
        return this.config.isLogResponse();
    }

    public String getHeaderValue(String name, String defaultValue) {
        for (KeyValuePair header2 : this.headers) {
            if (!name.equals(header2.getKey())) continue;
            return header2.getValue();
        }
        return defaultValue;
    }

    @Nullable
    public List<String> getHeadersValue(@NotNull String name) {
        if (name == null) {
            RestClientRequest.$$$reportNull$$$0(0);
        }
        ArrayList<String> list2 = new ArrayList<String>();
        for (KeyValuePair header2 : this.headers) {
            if (!name.equals(header2.getKey())) continue;
            list2.add(header2.getValue());
        }
        return list2.isEmpty() ? null : list2;
    }

    public void deleteHeader(@NotNull String name) {
        if (name == null) {
            RestClientRequest.$$$reportNull$$$0(1);
        }
        this.headers.removeIf(header2 -> name.equals(header2.getKey()));
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (String path2 : StringUtil.split((String)this.filesToSend, (String)File.pathSeparator)) {
            files.add(new File(path2));
        }
        return files;
    }

    @Override
    @NotNull
    public String getURL() {
        Object base = this.urlBase;
        if (!((String)base).endsWith("/") && !this.urlPath.isEmpty()) {
            base = (String)base + "/";
        }
        base = this.urlPath.startsWith("/") ? (String)base + this.urlPath.substring(1) : (String)base + this.urlPath;
        String string = ((String)base).replace(" ", "%20");
        if (string == null) {
            RestClientRequest.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String createQueryString() {
        return StringUtil.join(this.parameters, pair -> {
            String key2 = URLEncoder.encode(pair.getKey(), StandardCharsets.UTF_8);
            String value = URLEncoder.encode(pair.getValue(), StandardCharsets.UTF_8);
            if (StringUtil.isNotEmpty((String)value)) {
                return key2 + "=" + value;
            }
            return key2;
        }, (String)"&");
    }

    public void addBiscuit(@NotNull Biscuit biscuit) {
        if (biscuit == null) {
            RestClientRequest.$$$reportNull$$$0(3);
        }
        this.biscuits.add(biscuit);
    }

    public boolean isEmptyCredentials() {
        return this.authData == HttpClientAuthData.EMPTY_CREDENTIALS;
    }

    public void setEmptyCredentials() {
        this.authData = HttpClientAuthData.EMPTY_CREDENTIALS;
    }

    @Transient
    @ApiStatus.Internal
    @NotNull
    public List<KeyValuePair> getActualSentHeaders() {
        List<KeyValuePair> list2 = this.myActualHeaders;
        if (list2 == null) {
            RestClientRequest.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void setActualSentHeaders(@NotNull List<KeyValuePair> actualHeaders) {
        if (actualHeaders == null) {
            RestClientRequest.$$$reportNull$$$0(5);
        }
        this.myActualHeaders = List.copyOf(actualHeaders);
    }

    public String toString() {
        String url = this.getURL();
        String queryString = this.createQueryString();
        if (!queryString.isEmpty()) {
            return url + (url.contains("?") ? "&" : "?") + queryString;
        }
        return url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestClientRequest request2 = (RestClientRequest)o;
        if (this.haveFileToSend != request2.haveFileToSend) {
            return false;
        }
        if (this.haveTextToSend != request2.haveTextToSend) {
            return false;
        }
        if (this.isFileUpload != request2.isFileUpload) {
            return false;
        }
        if (this.parametersEnabled != request2.parametersEnabled) {
            return false;
        }
        if (!this.config.equals(request2.config)) {
            return false;
        }
        if (!Objects.equals(this.filesToSend, request2.filesToSend)) {
            return false;
        }
        if (!Objects.equals(this.headers, request2.headers)) {
            return false;
        }
        if (!Objects.equals(this.httpMethod, request2.httpMethod)) {
            return false;
        }
        if (!Objects.equals(this.parameters, request2.parameters)) {
            return false;
        }
        if (!Objects.equals(this.textToSend, request2.textToSend)) {
            return false;
        }
        if (!Objects.equals(this.urlBase, request2.urlBase)) {
            return false;
        }
        if (!Objects.equals(this.urlPath, request2.urlPath)) {
            return false;
        }
        if (!Objects.equals(this.biscuits, request2.biscuits)) {
            return false;
        }
        if (!Objects.equals(this.formBodyPart, request2.formBodyPart)) {
            return false;
        }
        if (!Objects.equals(this.multipartBoundary, request2.multipartBoundary)) {
            return false;
        }
        return Objects.equals(this.authData, request2.authData);
    }

    public int hashCode() {
        int result2 = Objects.hashCode(this.httpMethod);
        result2 = 31 * result2 + Objects.hashCode(this.urlBase);
        result2 = 31 * result2 + Objects.hashCode(this.urlPath);
        result2 = 31 * result2 + Objects.hashCode(this.headers);
        result2 = 31 * result2 + Objects.hashCode(this.parameters);
        result2 = 31 * result2 + Objects.hashCode(this.config);
        result2 = 31 * result2 + (this.parametersEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.haveTextToSend ? 1 : 0);
        result2 = 31 * result2 + (this.haveFileToSend ? 1 : 0);
        result2 = 31 * result2 + (this.isFileUpload ? 1 : 0);
        result2 = 31 * result2 + Objects.hashCode(this.textToSend);
        result2 = 31 * result2 + Objects.hashCode(this.filesToSend);
        result2 = 31 * result2 + Objects.hashCode(this.formBodyPart);
        result2 = 31 * result2 + Objects.hashCode(this.multipartBoundary);
        result2 = 31 * result2 + Objects.hashCode(this.authData);
        result2 = 31 * result2 + Objects.hashCode(this.biscuits);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/execution/RestClientRequest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "biscuit";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/execution/RestClientRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getURL";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualSentHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHeadersValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteHeader";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addBiscuit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setActualSentHeaders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    public static class KeyValuePair {
        private String myKey;
        private String myValue;

        public KeyValuePair() {
        }

        public KeyValuePair(String key2, String value) {
            this.myKey = key2;
            this.myValue = value;
        }

        public String getKey() {
            return this.myKey;
        }

        public void setKey(String key2) {
            this.myKey = key2;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyValuePair pair = (KeyValuePair)o;
            if (!this.myKey.equals(pair.myKey)) {
                return false;
            }
            return this.myValue.equals(pair.myValue);
        }

        public int hashCode() {
            int result2 = this.myKey.hashCode();
            result2 = 31 * result2 + this.myValue.hashCode();
            return result2;
        }
    }

    public static class Biscuit {
        private String myName;
        private String myValue;
        private String myDomain;
        private String myPath;
        private long myDate;

        public Biscuit() {
        }

        public Biscuit(String name, String value, String domain, String path2, long date) {
            this.myName = name;
            this.myValue = value;
            this.myDomain = domain;
            this.myPath = path2;
            this.myDate = date;
        }

        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        public String getDomain() {
            return this.myDomain;
        }

        public void setDomain(String domain) {
            this.myDomain = domain;
        }

        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path2) {
            this.myPath = path2;
        }

        public long getDate() {
            return this.myDate;
        }

        public void setDate(long date) {
            this.myDate = date;
        }

        public boolean isExpired(@NotNull Date currentTime) {
            if (currentTime == null) {
                Biscuit.$$$reportNull$$$0(0);
            }
            if (this.myDate == -1L) {
                return false;
            }
            Date expirationDate = new Date(this.myDate);
            return expirationDate.before(currentTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Biscuit biscuit = (Biscuit)o;
            if (this.myDate != biscuit.myDate) {
                return false;
            }
            if (!Objects.equals(this.myDomain, biscuit.myDomain)) {
                return false;
            }
            if (!this.myName.equals(biscuit.myName)) {
                return false;
            }
            if (!Objects.equals(this.myPath, biscuit.myPath)) {
                return false;
            }
            return this.myValue.equals(biscuit.myValue);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + this.myValue.hashCode();
            result2 = 31 * result2 + (this.myDomain != null ? this.myDomain.hashCode() : 0);
            result2 = 31 * result2 + (this.myPath != null ? this.myPath.hashCode() : 0);
            result2 = 31 * result2 + Long.hashCode(this.myDate);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTime", "com/intellij/httpClient/execution/RestClientRequest$Biscuit", "isExpired"));
        }
    }
}

