/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.adapters.HttpClientContentType;
import com.intellij.httpClient.execution.adapters.HttpClientMessagesAdaptersKt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class RestClientFormBodyPart
implements RequestBuilder.RequestFormBodyPart {
    protected String myFieldName;
    protected HttpClientContentType myContentType;
    protected List<RestClientRequest.KeyValuePair> myHeaders;

    protected RestClientFormBodyPart(@NotNull String fieldName, @NotNull HttpClientContentType contentType2) {
        if (fieldName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(0);
        }
        if (contentType2 == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(1);
        }
        this.myFieldName = fieldName;
        this.myContentType = contentType2;
        this.myHeaders = new ArrayList<RestClientRequest.KeyValuePair>();
    }

    @NotNull
    public static RestClientFormBodyPart create(@NotNull String fieldName, @NotNull File file) {
        if (fieldName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(2);
        }
        if (file == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(3);
        }
        return new RestClientFileBodyPart(fieldName, file.getName(), file, HttpClientContentType.APPLICATION_OCTET_STREAM);
    }

    @NotNull
    public static RestClientFormBodyPart create(@NotNull String fieldName, @NotNull String fileName, @NotNull File file, @NotNull RequestBuilder.ContentTypeInfo contentType2) {
        if (fieldName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(4);
        }
        if (fileName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(5);
        }
        if (file == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(6);
        }
        if (contentType2 == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(7);
        }
        return new RestClientFileBodyPart(fieldName, fileName, file, RestClientFormBodyPart.parseContentType(contentType2));
    }

    @NotNull
    public static RestClientFormBodyPart create(@NotNull String fieldName, @NotNull String content2, @NotNull RequestBuilder.ContentTypeInfo contentType2) {
        if (fieldName == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(8);
        }
        if (content2 == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(9);
        }
        if (contentType2 == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(10);
        }
        return new RestClientStringBodyPart(fieldName, content2, RestClientFormBodyPart.parseContentType(contentType2));
    }

    @NotNull
    private static HttpClientContentType parseContentType(@NotNull RequestBuilder.ContentTypeInfo contentTypeInfo) {
        HttpClientContentType contentType2;
        if (contentTypeInfo == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(11);
        }
        try {
            contentType2 = HttpClientMessagesAdaptersKt.parseContentType(contentTypeInfo.contentTypeHeaderNotNull());
        }
        catch (Exception e) {
            contentType2 = contentTypeInfo.fallbackMimeType() != null ? new HttpClientContentType(contentTypeInfo.fallbackMimeType(), null) : new HttpClientContentType("*/*", null);
        }
        if (contentType2.getCharset() == null) {
            contentType2 = contentType2.withCharset(contentTypeInfo.acceptCharsetHeaderNotNull());
        }
        HttpClientContentType httpClientContentType = contentType2;
        if (httpClientContentType == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(12);
        }
        return httpClientContentType;
    }

    @Override
    @NotNull
    public RestClientFormBodyPart addHeader(@NotNull String name, @Nullable String value) {
        if (name == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(13);
        }
        this.myHeaders.add(new RestClientRequest.KeyValuePair(name, value));
        RestClientFormBodyPart restClientFormBodyPart = this;
        if (restClientFormBodyPart == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(14);
        }
        return restClientFormBodyPart;
    }

    @NotNull
    public String getFieldName() {
        String string = this.myFieldName;
        if (string == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getContentType() {
        String string = this.myContentType.toString();
        if (string == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public List<RestClientRequest.KeyValuePair> getHeaders() {
        List<RestClientRequest.KeyValuePair> list2 = Collections.unmodifiableList(this.myHeaders);
        if (list2 == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @NotNull
    public String toPsiRepresentation() {
        String string = this.myHeaders.stream().map(field -> field.getKey() + ": " + field.getValue()).collect(Collectors.joining("\n"));
        if (string == null) {
            RestClientFormBodyPart.$$$reportNull$$$0(18);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestClientFormBodyPart part = (RestClientFormBodyPart)o;
        return Objects.equals(this.myFieldName, part.myFieldName) && Objects.equals(this.myContentType.getMimeType(), part.myContentType.getMimeType()) && Objects.equals(this.myContentType.getCharset(), part.myContentType.getCharset()) && Objects.equals(this.myHeaders, part.myHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.myFieldName, this.myContentType.getMimeType(), this.myContentType.getCharset(), this.myHeaders);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 1: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTypeInfo";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/execution/RestClientFormBodyPart";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/execution/RestClientFormBodyPart";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseContentType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addHeader";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaders";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiRepresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseContentType";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addHeader";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }

    public static final class RestClientFileBodyPart
    extends RestClientFormBodyPart {
        private final File myFile;
        private final String myFileName;

        private RestClientFileBodyPart(@NotNull String name, @NotNull String fileName, @NotNull File file, @NotNull HttpClientContentType contentType2) {
            if (name == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(0);
            }
            if (fileName == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(1);
            }
            if (file == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(2);
            }
            if (contentType2 == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(3);
            }
            super(name, contentType2);
            this.myFile = file;
            this.myFileName = fileName;
        }

        @NotNull
        public File getFile() {
            File file = this.myFile;
            if (file == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(4);
            }
            return file;
        }

        @NotNull
        public String getFileName() {
            String string = this.myFileName;
            if (string == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        public Charset getCharset() {
            return this.myContentType.getCharset();
        }

        @Override
        @NotNull
        public String toPsiRepresentation() {
            String string = super.toPsiRepresentation() + "\n\n< " + this.myFile.getPath();
            if (string == null) {
                RestClientFileBodyPart.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RestClientFileBodyPart part = (RestClientFileBodyPart)o;
            return Objects.equals(this.myFile.getName(), part.myFile.getName()) && Objects.equals(this.myFileName, part.myFileName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myFile.getName(), this.myFileName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/execution/RestClientFormBodyPart$RestClientFileBodyPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/execution/RestClientFormBodyPart$RestClientFileBodyPart";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPsiRepresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static final class RestClientStringBodyPart
    extends RestClientFormBodyPart {
        private final String myContent;

        private RestClientStringBodyPart(@NotNull String fieldName, @NotNull String content2, @NotNull HttpClientContentType contentType2) {
            if (fieldName == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(1);
            }
            if (contentType2 == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(2);
            }
            super(fieldName, contentType2);
            this.myContent = content2;
        }

        @NotNull
        public String getContent() {
            String string = this.myContent;
            if (string == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String toPsiRepresentation() {
            String string = super.toPsiRepresentation() + "\n\n" + StringUtil.convertLineSeparators((String)this.myContent);
            if (string == null) {
                RestClientStringBodyPart.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RestClientStringBodyPart part = (RestClientStringBodyPart)o;
            return Objects.equals(this.myContent, part.myContent);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/execution/RestClientFormBodyPart$RestClientStringBodyPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/execution/RestClientFormBodyPart$RestClientStringBodyPart";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPsiRepresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

