/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.generation;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.httpClient.actions.generation.ChoosingResult;
import com.intellij.httpClient.actions.generation.HttpHostChooser;
import com.intellij.httpClient.actions.generation.HttpMethodChooserKt;
import com.intellij.httpClient.actions.generation.LookupItemsTracker;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Result;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J*\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0002J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0000\u00a2\u0006\u0002\b\u001bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/httpClient/actions/generation/HttpMethodChooser;", "", "requestTargets", "", "Lcom/intellij/httpClient/http/request/psi/HttpRequestTarget;", "methods", "", "(Ljava/util/Collection;Ljava/util/Collection;)V", "file", "Lcom/intellij/httpClient/http/request/HttpRequestPsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "chooseMethod", "Lcom/intellij/httpClient/actions/generation/ChoosingResult;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "cont", "Lkotlinx/coroutines/CancellableContinuation;", "afterTemplateRunnable", "Ljava/util/function/Consumer;", "lookupElements", "", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "lookupElements$intellij_restClient", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpMethodChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpMethodChooser.kt\ncom/intellij/httpClient/actions/generation/HttpMethodChooser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,84:1\n1#2:85\n1549#3:86\n1620#3,3:87\n314#4,11:90\n*S KotlinDebug\n*F\n+ 1 HttpMethodChooser.kt\ncom/intellij/httpClient/actions/generation/HttpMethodChooser\n*L\n74#1:86\n74#1:87,3\n76#1:90,11\n*E\n"})
public final class HttpMethodChooser {
    @NotNull
    private final HttpRequest request;
    @NotNull
    private final Project project;
    @NotNull
    private final HttpRequestPsiFile file;
    @NotNull
    private final Collection<String> methods;

    /*
     * WARNING - void declaration
     */
    public HttpMethodChooser(@NotNull Collection<? extends HttpRequestTarget> requestTargets2, @NotNull Collection<String> methods) {
        void it;
        boolean bl;
        Intrinsics.checkNotNullParameter(requestTargets2, (String)"requestTargets");
        Intrinsics.checkNotNullParameter(methods, (String)"methods");
        boolean bl2 = bl = !requestTargets2.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-HttpMethodChooser$32 = false;
            Collection<? extends HttpRequestTarget> $i$a$-assert-HttpMethodChooser$32 = requestTargets2;
            throw new AssertionError($i$a$-assert-HttpMethodChooser$32);
        }
        boolean bl3 = bl = !methods.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            Collection<String> collection = methods;
            throw new AssertionError(collection);
        }
        HttpRequestTarget httpRequestTarget = (HttpRequestTarget)CollectionsKt.first((Iterable)requestTargets2);
        HttpMethodChooser httpMethodChooser = this;
        boolean bl5 = false;
        HttpRequest httpRequest = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)it), HttpRequest.class);
        if (httpRequest == null) {
            throw new IllegalStateException("wrong HttpRequestTarget".toString());
        }
        httpMethodChooser.request = httpRequest;
        Project project = this.request.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        PsiFile psiFile = this.request.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.HttpRequestPsiFile");
        this.file = (HttpRequestPsiFile)psiFile;
        this.methods = CollectionsKt.toList((Iterable)methods);
    }

    private final void chooseMethod(Editor editor2, CancellableContinuation<?> cont, Consumer<ChoosingResult> afterTemplateRunnable) {
        if (cont.isCancelled()) {
            return;
        }
        VirtualFile virtualFile = this.file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        HttpHostChooser.Companion.navigateToElement$intellij_restClient(this.project, editor2, virtualFile, this.request.getTextOffset());
        boolean shouldStop = this.methods.size() > 1;
        TemplateBuilderImpl templateBuilder2 = new TemplateBuilderImpl((PsiElement)this.request);
        LookupItemsTracker completionTracker = new LookupItemsTracker();
        List<LookupElementBuilder> lookupElements = this.lookupElements$intellij_restClient();
        if (shouldStop) {
            for (LookupElementBuilder item : lookupElements) {
                completionTracker.addTo((LookupElement)item);
            }
        }
        TextRange textRange = HttpMethodChooserKt.access$getMethodTextRange(this.request);
        templateBuilder2.replaceElement((PsiElement)this.request, textRange, "VARIABLE", (Expression)new ConstantNode(CollectionsKt.first((Iterable)this.methods) + " ").withLookupItems((Collection)lookupElements), shouldStop);
        WriteCommandAction.runWriteCommandAction((Project)this.project, (String)"Choose.Method", (String)"Generate.Http.Request", () -> HttpMethodChooser.chooseMethod$lambda$3(cont, templateBuilder2, editor2, this, afterTemplateRunnable, completionTracker), (PsiFile[])new PsiFile[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LookupElementBuilder> lookupElements$intellij_restClient() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.methods;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LookupElementBuilder.create((String)((String)it + " ")));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final Object chooseMethod(@NotNull Editor editor2, @NotNull Continuation<? super ChoosingResult> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super ChoosingResult> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.chooseMethod(editor2, cont, new Consumer((CancellableContinuation<? super ChoosingResult>)cont){
            final /* synthetic */ CancellableContinuation<ChoosingResult> $cont;
            {
                this.$cont = $cont;
            }

            public final void accept(@NotNull ChoosingResult result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                ((Continuation)this.$cont).resumeWith(Result.constructor-impl((Object)result2));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private static final void chooseMethod$lambda$3(CancellableContinuation $cont, TemplateBuilderImpl $templateBuilder, Editor $editor, HttpMethodChooser this$0, Consumer $afterTemplateRunnable, LookupItemsTracker $completionTracker) {
        Intrinsics.checkNotNullParameter((Object)$cont, (String)"$cont");
        Intrinsics.checkNotNullParameter((Object)$templateBuilder, (String)"$templateBuilder");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$afterTemplateRunnable, (String)"$afterTemplateRunnable");
        Intrinsics.checkNotNullParameter((Object)$completionTracker, (String)"$completionTracker");
        if ($cont.isCancelled()) {
            return;
        }
        Template template = $templateBuilder.buildInlineTemplate();
        $editor.getCaretModel().moveToOffset(UtilsKt.getStartOffset((PsiElement)((PsiElement)this$0.request)));
        TemplateManager.getInstance((Project)this$0.project).startTemplate($editor, template, false, null, (TemplateEditingListener)new TemplateEditingAdapter($afterTemplateRunnable, $completionTracker){
            final /* synthetic */ Consumer<ChoosingResult> $afterTemplateRunnable;
            final /* synthetic */ LookupItemsTracker $completionTracker;
            {
                this.$afterTemplateRunnable = $afterTemplateRunnable;
                this.$completionTracker = $completionTracker;
            }

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                Intrinsics.checkNotNullParameter((Object)template, (String)"template");
                this.$afterTemplateRunnable.accept(new ChoosingResult(!brokenOff, this.$completionTracker.getCanceled()));
            }
        });
    }
}

