/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.environment;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironmentFileNames;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.internal.statistic.collectors.fus.ui.GotItUsageCollector;
import com.intellij.internal.statistic.collectors.fus.ui.GotItUsageCollectorGroup;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class HttpRequestNewEnvironmentFileAction
extends AnAction
implements DumbAware {
    private static final String DEFAULT_ENVIRONMENT_NAME = "dev";
    private static final String PUBLIC_ENVIRONMENT_FILE_TEMPLATE = "HTTP Public Environment File";
    private static final String PRIVATE_ENVIRONMENT_FILE_TEMPLATE = "HTTP Private Environment File";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    protected abstract EnvironmentType getEnvironmentType();

    public final void actionPerformed(@NotNull AnActionEvent e) {
        PsiDirectory directory;
        if (e == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(1);
        }
        if ((directory = HttpRequestNewEnvironmentFileAction.getPsiDirectory(e)) == null) {
            return;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        String variableName = (String)e.getData(HttpClientDataKeys.ENV_VARIABLE_DEFAULT_NAME);
        Consumer listener2 = (Consumer)e.getData(HttpClientDataKeys.ENV_NAME_CHOSEN_LISTENER);
        HttpRequestNewEnvironmentFileAction.createHttpClientEnv(directory, this.getEnvironmentType(), variableName, null, editor2, listener2);
    }

    @ApiStatus.Internal
    @RequiresEdt
    public static void createHttpClientEnv(@NotNull PsiDirectory psiDirectory2, @NotNull EnvironmentType environmentType, @Nullable String defaultVariableName, @Nullable String defaultEnvName, @Nullable Editor editor2, @Nullable Consumer<String> envNameChosenListener) {
        if (psiDirectory2 == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(2);
        }
        if (environmentType == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        String filename = HttpRequestNewEnvironmentFileAction.getEnvFilename(environmentType);
        if (HttpRequestNewEnvironmentFileAction.failedToMakeExistingFileWritable(editor2, filename, psiDirectory2)) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)psiDirectory2.getProject()).withName(RestClientBundle.message("http.request.create.new.environment.file.command.name", new Object[0])).run(() -> {
            HttpRequestNewEnvironmentFileAction.scheduleTooltipShow(psiDirectory2.getProject());
            PsiFile file = psiDirectory2.findFile(filename);
            if (file != null) {
                HttpRequestNewEnvironmentFileAction.createEnvInFile(file, defaultVariableName, defaultEnvName, envNameChosenListener);
            } else {
                String templateName = HttpRequestNewEnvironmentFileAction.getTemplateName(environmentType);
                HttpRequestNewEnvironmentFileAction.createFile(filename, templateName, psiDirectory2, defaultVariableName, defaultEnvName, envNameChosenListener);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private static boolean failedToMakeExistingFileWritable(@Nullable Editor editor2, @Nullable String string, @Nullable PsiDirectory psiDirectory2) {
        void psiDirectory3;
        ThreadingAssertions.assertEventDispatchThread();
        if (psiDirectory3 != null) {
            ReadonlyStatusHandler.OperationStatus status;
            void filename;
            PsiFile file;
            PsiFile psiFile = file = filename != null ? psiDirectory3.findFile((String)filename) : null;
            if (file != null && (status = ReadonlyStatusHandler.getInstance((Project)file.getProject()).ensureFilesWritable(List.of(file.getVirtualFile()))).hasReadonlyFiles()) {
                Editor currentEditor;
                if (currentEditor != null) {
                    HintManager.getInstance().showErrorHint(currentEditor, status.getReadonlyFilesMessage());
                }
                return true;
            }
        }
        return false;
    }

    private static void createFile(@Nullable String filename, @NotNull String templateName, @NotNull PsiDirectory psiDirectory2, @Nullable String defaultVariableName, @Nullable String defaultEnvName, final @Nullable Consumer<String> envNameChosenListener) {
        VirtualFile virtualFile;
        PsiFile file;
        if (templateName == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(4);
        }
        if (psiDirectory2 == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(5);
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)psiDirectory2.getProject()).getInternalTemplate(templateName);
        HashMap<String, String> variables2 = new HashMap<String, String>();
        if (defaultVariableName != null) {
            variables2.put("name", defaultVariableName);
        }
        if (defaultEnvName != null) {
            variables2.put(DEFAULT_ENVIRONMENT_NAME, defaultEnvName);
        }
        if (envNameChosenListener != null) {
            MessageBusConnection connection = psiDirectory2.getProject().getMessageBus().connect();
            connection.subscribe(TemplateManager.TEMPLATE_STARTED_TOPIC, state -> {
                connection.disconnect();
                state.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

                    public void currentVariableChanged(@NotNull TemplateState templateState, Template template, int oldIndex, int newIndex) {
                        if (templateState == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        HttpRequestNewEnvironmentFileAction.onEnvNameChosen(template, oldIndex, HttpRequestNewEnvironmentFileAction.DEFAULT_ENVIRONMENT_NAME, templateState, envNameChosenListener);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateState", "com/intellij/httpClient/actions/environment/HttpRequestNewEnvironmentFileAction$1", "currentVariableChanged"));
                    }
                });
            });
        }
        if ((file = CreateFileFromTemplateAction.createFileFromTemplate((String)filename, (FileTemplate)template, (PsiDirectory)psiDirectory2, null, (boolean)true, variables2)) != null && (virtualFile = file.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)file.getProject()).openFile(virtualFile, true);
        }
    }

    private static void onEnvNameChosen(Template template, int oldIndex, String dev, @NotNull TemplateState templateState, @NotNull Consumer<String> envNameChosenListener) {
        if (templateState == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(6);
        }
        if (envNameChosenListener == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(7);
        }
        List templateVariables = template.getVariables();
        if (oldIndex < 0 || oldIndex >= templateVariables.size()) {
            return;
        }
        String name = ((Variable)templateVariables.get(oldIndex)).getName();
        if (!dev.equals(name)) {
            return;
        }
        TextResult envValue = templateState.getVariableValue(name);
        if (envValue != null) {
            envNameChosenListener.accept(envValue.getText());
        }
    }

    @RequiresWriteLock
    @RequiresEdt
    private static void createEnvInFile(final @NotNull PsiFile file, @Nullable String defaultVariableName, String defaultEnvName, final Consumer<String> envNameChosenListener) {
        if (file == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertEventDispatchThread();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !(file instanceof JsonFile)) {
            return;
        }
        JsonFile jsonFile = (JsonFile)file;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)file.getProject()).openFile(virtualFile, true)[0];
        Editor editor2 = ((TextEditor)fileEditor).getEditor();
        TemplateImpl template = TemplateSettings.getInstance().getTemplate("env", "HTTP Request");
        if (template == null) {
            return;
        }
        JsonValue value = HttpRequestNewEnvironmentFileAction.getJsonFileContent(jsonFile);
        if (!(value instanceof JsonObject)) {
            return;
        }
        JsonObject valueObject = (JsonObject)value;
        editor2.getCaretModel().moveToOffset(value.getTextRange().getEndOffset() - 1);
        TemplateImpl newTemplate = HttpRequestNewEnvironmentFileAction.prepareTemplate(defaultVariableName, defaultEnvName, template, valueObject);
        TemplateManager.getInstance((Project)file.getProject()).startTemplate(editor2, (Template)newTemplate, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void currentVariableChanged(@NotNull TemplateState templateState, Template template, int oldIndex, int newIndex) {
                if (templateState == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (envNameChosenListener != null) {
                    HttpRequestNewEnvironmentFileAction.onEnvNameChosen(template, oldIndex, "ENV_NAME", templateState, envNameChosenListener);
                }
            }

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    2.$$$reportNull$$$0(1);
                }
                new ReformatCodeProcessor(file, true).run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "templateState";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "template";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/httpClient/actions/environment/HttpRequestNewEnvironmentFileAction$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "currentVariableChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "templateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static TemplateImpl prepareTemplate(@Nullable String defaultVariableName, @Nullable String defaultEnvName, @NotNull TemplateImpl template, @NotNull JsonObject value) {
        if (template == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(9);
        }
        if (value == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(10);
        }
        TemplateImpl newTemplate = template.copy();
        String preferableEnvName = defaultEnvName != null ? defaultEnvName : DEFAULT_ENVIRONMENT_NAME;
        int lastEnvIndex = value.getPropertyList().stream().filter(property -> property.getName().startsWith(preferableEnvName)).map(property -> StringUtil.trimStart((String)property.getName(), (String)preferableEnvName)).mapToInt(propertySuffix -> StringUtil.parseInt((String)propertySuffix, (int)0)).max().orElse(-1);
        ArrayList templateVariables = newTemplate.getVariables();
        Variable envNameVariable = (Variable)ContainerUtil.find((Iterable)templateVariables, variable2 -> variable2.getName().equals("ENV_NAME"));
        if (envNameVariable != null) {
            if (lastEnvIndex == -1) {
                envNameVariable.setExpressionString("\"" + preferableEnvName + "\"");
                if (defaultEnvName != null) {
                    envNameVariable.setAlwaysStopAt(false);
                }
            } else {
                envNameVariable.setExpressionString("\"" + preferableEnvName + (lastEnvIndex + 1) + "\"");
            }
        }
        Variable varNameVariable = (Variable)ContainerUtil.find((Iterable)templateVariables, variable2 -> variable2.getName().equals("VAR_NAME"));
        if (defaultVariableName != null && varNameVariable != null) {
            varNameVariable.setExpressionString("\"" + defaultVariableName + "\"");
            varNameVariable.setAlwaysStopAt(false);
        }
        TemplateImpl templateImpl = newTemplate;
        if (templateImpl == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(11);
        }
        return templateImpl;
    }

    private static JsonValue getJsonFileContent(@NotNull JsonFile file) {
        JsonValue value;
        if (file == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(12);
        }
        if ((value = file.getTopLevelValue()) == null) {
            JsonObject object = new JsonElementGenerator(file.getProject()).createObject("");
            file.add((PsiElement)object);
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
            if (document != null) {
                PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(document);
            }
        }
        value = file.getTopLevelValue();
        return value;
    }

    private static void scheduleTooltipShow(final @NotNull Project project) {
        if (project == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(13);
        }
        Disposable disposable2 = Disposer.newDisposable();
        project.getMessageBus().connect(disposable2).subscribe(TemplateManager.TEMPLATE_STARTED_TOPIC, s -> {
            s.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (brokenOff) {
                        return;
                    }
                    HttpRequestNewEnvironmentFileAction.showTooltip(s.getEditor(), project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/httpClient/actions/environment/HttpRequestNewEnvironmentFileAction$3", "templateFinished"));
                }
            });
            Disposer.dispose((Disposable)disposable2);
        });
    }

    @RequiresEdt
    private static void showTooltip(@NotNull Editor editor2, @NotNull Project project) {
        if (editor2 == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(14);
        }
        if (project == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(15);
        }
        ThreadingAssertions.assertEventDispatchThread();
        int offset = editor2.getCaretModel().getOffset();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        if (!(file instanceof JsonFile)) {
            return;
        }
        Pair<@NlsSafe String, @NlsSafe String> names = HttpRequestNewEnvironmentFileAction.getEnvAndVarNames((JsonFile)file);
        if (names == null) {
            return;
        }
        GotItTooltip tooltip = new GotItTooltip("http.request.new.env.file.action", RestClientBundle.message("http.request.create.new.environment.tooltip.text", names.second, names.first), (Disposable)HttpRequestHistoryManager.getInstance(project));
        tooltip.withHeader(RestClientBundle.message("group.HTTPClientNewEnvironmentFile.text", new Object[0]));
        tooltip.withShowCount(1);
        tooltip.withMaxWidth(JBUI.scale((int)250));
        tooltip.withPosition(Balloon.Position.above);
        if (!HttpRequestNewEnvironmentFileAction.isOffsetVisible(editor2, offset)) {
            return;
        }
        tooltip.setOnBalloonCreated(balloon -> {
            editor2.getScrollingModel().addVisibleAreaListener(area -> {
                if (HttpRequestNewEnvironmentFileAction.isOffsetVisible(editor2, offset)) {
                    balloon.revalidate();
                } else {
                    balloon.hide(true);
                    GotItUsageCollector.getInstance().logClose(tooltip.getId(), GotItUsageCollectorGroup.CloseType.AncestorRemoved);
                }
            }, (Disposable)balloon);
            return Unit.INSTANCE;
        });
        tooltip.show(editor2.getContentComponent(), (c, b) -> editor2.offsetToXY(offset));
    }

    private static boolean isOffsetVisible(@NotNull Editor editor2, int offset) {
        if (editor2 == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(16);
        }
        return editor2.getScrollingModel().getVisibleArea().contains(editor2.offsetToXY(offset));
    }

    private static @Nullable Pair<@NlsSafe String, @NlsSafe String> getEnvAndVarNames(@NotNull JsonFile file) {
        JsonValue object;
        if (file == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(17);
        }
        if (!((object = file.getTopLevelValue()) instanceof JsonObject)) {
            return null;
        }
        JsonObject rootObject = (JsonObject)object;
        List properties = rootObject.getPropertyList();
        if (properties.isEmpty()) {
            return null;
        }
        JsonProperty envProperty = (JsonProperty)properties.get(0);
        String envName = envProperty.getName();
        JsonValue jsonValue = envProperty.getValue();
        if (!(jsonValue instanceof JsonObject)) {
            return null;
        }
        JsonObject envObject = (JsonObject)jsonValue;
        List envProperties = envObject.getPropertyList();
        if (envProperties.isEmpty()) {
            return null;
        }
        String variableName = ((JsonProperty)envProperties.get(0)).getName();
        return Pair.create((Object)envName, (Object)variableName);
    }

    @Nullable
    protected static PsiDirectory getPsiDirectory(@NotNull AnActionEvent e) {
        PsiFile currentPsiFile;
        PsiDirectory[] directories;
        DataContext dataContext;
        IdeView view;
        if (e == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(18);
        }
        if ((view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext = e.getDataContext())) != null && (directories = view.getDirectories()).length == 1) {
            return directories[0];
        }
        VirtualFile currentFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (currentFile != null && e.getProject() != null && (currentPsiFile = PsiManager.getInstance((Project)e.getProject()).findFile(currentFile)) != null) {
            if (HttpRequestNewEnvironmentFileAction.isInsideProjectIdeaDir(currentPsiFile)) {
                VirtualFile directory = (VirtualFile)PlatformCoreDataKeys.PROJECT_FILE_DIRECTORY.getData(dataContext);
                return directory != null ? PsiManager.getInstance((Project)e.getProject()).findDirectory(directory) : null;
            }
            if (currentPsiFile.getContainingDirectory() != null) {
                return currentPsiFile.getContainingDirectory();
            }
        }
        return null;
    }

    private static boolean isInsideProjectIdeaDir(@NotNull PsiFile file) {
        if (file == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(19);
        }
        if (!ProjectKt.isDirectoryBased((Project)file.getProject()) || file.getProject().isDefault()) {
            return false;
        }
        String path2 = file.getProject().getBasePath() + "/.idea";
        VirtualFile ideaDir = LocalFileFinder.findFile((String)path2);
        if (ideaDir == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)ideaDir, (VirtualFile)file.getVirtualFile(), (boolean)false);
    }

    @NotNull
    public static String getEnvFilename(@NotNull EnvironmentType environmentType) {
        if (environmentType == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(20);
        }
        String string = switch (environmentType) {
            default -> throw new IncompatibleClassChangeError();
            case EnvironmentType.PRIVATE -> HttpRequestEnvironmentFileNames.ENV_PRIVATE_FILE_NAMES[0];
            case EnvironmentType.PUBLIC -> HttpRequestEnvironmentFileNames.ENV_FILE_NAMES[0];
        };
        if (string == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static String getTemplateName(@NotNull EnvironmentType environmentType) {
        if (environmentType == null) {
            HttpRequestNewEnvironmentFileAction.$$$reportNull$$$0(22);
        }
        return switch (environmentType) {
            default -> throw new IncompatibleClassChangeError();
            case EnvironmentType.PUBLIC -> PUBLIC_ENVIRONMENT_FILE_TEMPLATE;
            case EnvironmentType.PRIVATE -> PRIVATE_ENVIRONMENT_FILE_TEMPLATE;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/environment/HttpRequestNewEnvironmentFileAction";
                break;
            }
            case 1: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 3: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envNameChosenListener";
                break;
            }
            case 8: 
            case 12: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/environment/HttpRequestNewEnvironmentFileAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTemplate";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvFilename";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHttpClientEnv";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onEnvNameChosen";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEnvInFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getJsonFileContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scheduleTooltipShow";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetVisible";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEnvAndVarNames";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInsideProjectIdeaDir";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEnvFilename";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22 -> new IllegalArgumentException(string);
        };
    }

    public static enum EnvironmentType {
        PUBLIC,
        PRIVATE;

    }
}

