/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.StringTrieBuilder;
import java.nio.ByteBuffer;

public final class BytesTrieBuilder
extends StringTrieBuilder {
    private final byte[] intBytes = new byte[5];
    private byte[] bytes;
    private int bytesLength;

    public BytesTrieBuilder add(byte[] sequence, int length2, int value) {
        this.addImpl(new BytesAsCharSequence(sequence, length2), value);
        return this;
    }

    public BytesTrie build(StringTrieBuilder.Option buildOption) {
        this.buildBytes(buildOption);
        return new BytesTrie(this.bytes, this.bytes.length - this.bytesLength);
    }

    public ByteBuffer buildByteBuffer(StringTrieBuilder.Option buildOption) {
        this.buildBytes(buildOption);
        return ByteBuffer.wrap(this.bytes, this.bytes.length - this.bytesLength, this.bytesLength);
    }

    private void buildBytes(StringTrieBuilder.Option buildOption) {
        if (this.bytes == null) {
            this.bytes = new byte[1024];
        }
        this.buildImpl(buildOption);
    }

    public BytesTrieBuilder clear() {
        this.clearImpl();
        this.bytes = null;
        this.bytesLength = 0;
        return this;
    }

    @Override
    @Deprecated
    protected boolean matchNodesCanHaveValues() {
        return false;
    }

    @Override
    @Deprecated
    protected int getMaxBranchLinearSubNodeLength() {
        return 5;
    }

    @Override
    @Deprecated
    protected int getMinLinearMatch() {
        return 16;
    }

    @Override
    @Deprecated
    protected int getMaxLinearMatchLength() {
        return 16;
    }

    private void ensureCapacity(int length2) {
        if (length2 > this.bytes.length) {
            int newCapacity = this.bytes.length;
            while ((newCapacity *= 2) <= length2) {
            }
            byte[] newBytes = new byte[newCapacity];
            System.arraycopy(this.bytes, this.bytes.length - this.bytesLength, newBytes, newBytes.length - this.bytesLength, this.bytesLength);
            this.bytes = newBytes;
        }
    }

    @Override
    @Deprecated
    protected int write(int b) {
        int newLength = this.bytesLength + 1;
        this.ensureCapacity(newLength);
        this.bytesLength = newLength;
        this.bytes[this.bytes.length - this.bytesLength] = (byte)b;
        return this.bytesLength;
    }

    @Override
    @Deprecated
    protected int write(int offset, int length2) {
        int newLength = this.bytesLength + length2;
        this.ensureCapacity(newLength);
        this.bytesLength = newLength;
        int bytesOffset = this.bytes.length - this.bytesLength;
        while (length2 > 0) {
            this.bytes[bytesOffset++] = (byte)this.strings.charAt(offset++);
            --length2;
        }
        return this.bytesLength;
    }

    private int write(byte[] b, int length2) {
        int newLength = this.bytesLength + length2;
        this.ensureCapacity(newLength);
        this.bytesLength = newLength;
        System.arraycopy(b, 0, this.bytes, this.bytes.length - this.bytesLength, length2);
        return this.bytesLength;
    }

    @Override
    @Deprecated
    protected int writeValueAndFinal(int i, boolean isFinal) {
        if (0 <= i && i <= 64) {
            return this.write(16 + i << 1 | (isFinal ? 1 : 0));
        }
        int length2 = 1;
        if (i < 0 || i > 0xFFFFFF) {
            this.intBytes[0] = 127;
            this.intBytes[1] = (byte)(i >> 24);
            this.intBytes[2] = (byte)(i >> 16);
            this.intBytes[3] = (byte)(i >> 8);
            this.intBytes[4] = (byte)i;
            length2 = 5;
        } else {
            if (i <= 6911) {
                this.intBytes[0] = (byte)(81 + (i >> 8));
            } else {
                if (i <= 0x11FFFF) {
                    this.intBytes[0] = (byte)(108 + (i >> 16));
                } else {
                    this.intBytes[0] = 126;
                    this.intBytes[1] = (byte)(i >> 16);
                    length2 = 2;
                }
                this.intBytes[length2++] = (byte)(i >> 8);
            }
            this.intBytes[length2++] = (byte)i;
        }
        this.intBytes[0] = (byte)(this.intBytes[0] << 1 | (isFinal ? 1 : 0));
        return this.write(this.intBytes, length2);
    }

    @Override
    @Deprecated
    protected int writeValueAndType(boolean hasValue, int value, int node) {
        int offset = this.write(node);
        if (hasValue) {
            offset = this.writeValueAndFinal(value, false);
        }
        return offset;
    }

    @Override
    @Deprecated
    protected int writeDeltaTo(int jumpTarget) {
        int i = this.bytesLength - jumpTarget;
        assert (i >= 0);
        if (i <= 191) {
            return this.write(i);
        }
        return this.write(this.intBytes, BytesTrieBuilder.internalEncodeDelta(i, this.intBytes));
    }

    @Deprecated
    public static final int internalEncodeDelta(int i, byte[] intBytes) {
        assert (i >= 0);
        if (i <= 191) {
            intBytes[0] = (byte)i;
            return 1;
        }
        int length2 = 1;
        if (i <= 12287) {
            intBytes[0] = (byte)(192 + (i >> 8));
        } else {
            if (i <= 917503) {
                intBytes[0] = (byte)(240 + (i >> 16));
            } else {
                if (i <= 0xFFFFFF) {
                    intBytes[0] = -2;
                } else {
                    intBytes[0] = -1;
                    intBytes[1] = (byte)(i >> 24);
                    length2 = 2;
                }
                intBytes[length2++] = (byte)(i >> 16);
            }
            intBytes[length2++] = (byte)(i >> 8);
        }
        intBytes[length2++] = (byte)i;
        return length2;
    }

    private static final class BytesAsCharSequence
    implements CharSequence {
        private byte[] s;
        private int len;

        public BytesAsCharSequence(byte[] sequence, int length2) {
            this.s = sequence;
            this.len = length2;
        }

        @Override
        public char charAt(int i) {
            return (char)(this.s[i] & 0xFF);
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return null;
        }
    }
}

