/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LocaleObjectCache<K, V> {
    private ConcurrentHashMap<K, CacheEntry<K, V>> _map;
    private ReferenceQueue<V> _queue = new ReferenceQueue();

    public LocaleObjectCache() {
        this(16, 0.75f, 16);
    }

    public LocaleObjectCache(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this._map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    public V get(K key2) {
        V value = null;
        this.cleanStaleEntries();
        CacheEntry<K, V> entry = this._map.get(key2);
        if (entry != null) {
            value = (V)entry.get();
        }
        if (value == null) {
            key2 = this.normalizeKey(key2);
            V newVal = this.createObject(key2);
            if (key2 == null || newVal == null) {
                return null;
            }
            CacheEntry<K, V> newEntry = new CacheEntry<K, V>(key2, newVal, this._queue);
            while (value == null) {
                this.cleanStaleEntries();
                entry = this._map.putIfAbsent(key2, newEntry);
                if (entry == null) {
                    value = newVal;
                    break;
                }
                value = (V)entry.get();
            }
        }
        return value;
    }

    private void cleanStaleEntries() {
        CacheEntry entry;
        while ((entry = (CacheEntry)this._queue.poll()) != null) {
            this._map.remove(entry.getKey());
        }
    }

    protected abstract V createObject(K var1);

    protected K normalizeKey(K key2) {
        return key2;
    }

    private static class CacheEntry<K, V>
    extends SoftReference<V> {
        private K _key;

        CacheEntry(K key2, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this._key = key2;
        }

        K getKey() {
            return this._key;
        }
    }
}

