/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core.features;

import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.RecentFilesSEContributor;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsagesCollector;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.searchEverywhereMl.ranking.core.features.FeaturesProviderCache;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereElementFeaturesProviderKt;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereFileFeaturesProvider;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywhereFileFeaturesProviderKt;
import com.intellij.searchEverywhereMl.ranking.core.features.SearchEverywherePsiElementFeaturesProviderUtils;
import com.intellij.textMatching.PrefixMatchingUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0004H\u0016J\"\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereFileFeaturesProvider;", "Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereElementFeaturesProvider;", "()V", "getElementFeatures", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "element", "", "currentTime", "", "searchQuery", "", "elementPriority", "", "cache", "Lcom/intellij/searchEverywhereMl/ranking/core/features/FeaturesProviderCache;", "getFeaturesDeclarations", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getRelativePathNameMatchingFeatures", "", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "isBookmark", "", "isExactMatch", "isExactRelativePath", "isTopLevel", "(Lcom/intellij/psi/PsiFileSystemItem;)Ljava/lang/Boolean;", "matchesFileTypeInQuery", "(Lcom/intellij/psi/PsiFileSystemItem;Ljava/lang/String;)Ljava/lang/Boolean;", "Fields", "intellij.searchEverywhereMl.ranking.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSearchEverywhereFileFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchEverywhereFileFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereFileFeaturesProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n215#2,2:203\n1#3:205\n*S KotlinDebug\n*F\n+ 1 SearchEverywhereFileFeaturesProvider.kt\ncom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereFileFeaturesProvider\n*L\n163#1:203,2\n*E\n"})
public final class SearchEverywhereFileFeaturesProvider
extends SearchEverywhereElementFeaturesProvider {
    public SearchEverywhereFileFeaturesProvider() {
        Class[] classArray = new Class[]{FileSearchEverywhereContributor.class, RecentFilesSEContributor.class};
        super(classArray);
    }

    @Override
    @NotNull
    public List<EventField<?>> getFeaturesDeclarations() {
        Object[] objectArray = new EventField[]{Fields.INSTANCE.getIS_DIRECTORY_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), Fields.INSTANCE.getFILETYPE_DATA_KEY(), Fields.INSTANCE.getIS_BOOKMARK_DATA_KEY(), Fields.INSTANCE.getIS_EXACT_MATCH_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), Fields.INSTANCE.getFILETYPE_MATCHES_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), Fields.INSTANCE.getIS_TOP_LEVEL_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), Fields.INSTANCE.getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking_core()};
        Collection collection = CollectionsKt.arrayListOf((Object[])objectArray);
        Collection<EventField<?>> collection2 = Fields.INSTANCE.getREL_PATH_NAME_FEATURE_TO_FIELD$intellij_searchEverywhereMl_ranking_core().values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)collection2);
    }

    @Override
    @NotNull
    public List<EventPair<?>> getElementFeatures(@NotNull Object element, long currentTime, @NotNull String searchQuery, int elementPriority, @Nullable FeaturesProviderCache cache) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchQuery, (String)"searchQuery");
        Object[] objectArray = SearchEverywherePsiElementFeaturesProviderUtils.INSTANCE.getPsiElement(element);
        PsiFileSystemItem psiFileSystemItem = objectArray instanceof PsiFileSystemItem ? (PsiFileSystemItem)objectArray : null;
        if (psiFileSystemItem == null) {
            return CollectionsKt.emptyList();
        }
        PsiFileSystemItem item = psiFileSystemItem;
        objectArray = new EventPair[]{Fields.INSTANCE.getIS_BOOKMARK_DATA_KEY().with((Object)this.isBookmark(item)), Fields.INSTANCE.getIS_DIRECTORY_DATA_KEY$intellij_searchEverywhereMl_ranking_core().with((Object)item.isDirectory()), Fields.INSTANCE.getIS_EXACT_MATCH_DATA_KEY$intellij_searchEverywhereMl_ranking_core().with((Object)this.isExactMatch(item, searchQuery, elementPriority)), Fields.INSTANCE.getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking_core().with((Object)this.isExactRelativePath(item, searchQuery))};
        ArrayList data = CollectionsKt.arrayListOf((Object[])objectArray);
        data.addAll(this.getRelativePathNameMatchingFeatures(item, searchQuery));
        SearchEverywhereElementFeaturesProviderKt.putIfValueNotNull(data, (EventField)Fields.INSTANCE.getIS_TOP_LEVEL_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.isTopLevel(item));
        if (item.isDirectory()) {
            return data;
        }
        data.add(Fields.INSTANCE.getFILETYPE_DATA_KEY().with((Object)item.getVirtualFile().getFileType().getName()));
        SearchEverywhereElementFeaturesProviderKt.putIfValueNotNull(data, (EventField)Fields.INSTANCE.getFILETYPE_MATCHES_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking_core(), this.matchesFileTypeInQuery(item, searchQuery));
        return data;
    }

    private final boolean isBookmark(PsiFileSystemItem item) {
        BookmarksManager bookmarksManager = BookmarksManager.getInstance((Project)item.getProject());
        Boolean bkm = (Boolean)ReadAction.compute(() -> SearchEverywhereFileFeaturesProvider.isBookmark$lambda$2(item, bookmarksManager));
        Intrinsics.checkNotNull((Object)bkm);
        return bkm;
    }

    private final boolean isExactMatch(PsiFileSystemItem item, String searchQuery, int elementPriority) {
        if (elementPriority == 5000) {
            return true;
        }
        String string = item.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        String string2 = item.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String fileName = string2;
        return SequencesKt.none((Sequence)SequencesKt.filterIndexed((Sequence)SequencesKt.map((Sequence)StringsKt.asSequence((CharSequence)searchQuery), (Function1)isExactMatch.1.INSTANCE), (Function2)((Function2)new Function2<Integer, Character, Boolean>(searchQuery, fileName, filePath){
            final /* synthetic */ String $searchQuery;
            final /* synthetic */ String $fileName;
            final /* synthetic */ String $filePath;
            {
                this.$searchQuery = $searchQuery;
                this.$fileName = $fileName;
                this.$filePath = $filePath;
                super(2);
            }

            @NotNull
            public final Boolean invoke(int searchQueryCharIndex, char c) {
                if (searchQueryCharIndex == 0 && c == '/' && this.$searchQuery.length() - 1 == this.$fileName.length()) {
                    return true;
                }
                Integer n = this.$filePath.length() - this.$searchQuery.length() + searchQueryCharIndex;
                int it = ((Number)n).intValue();
                boolean bl = false;
                Integer n2 = it >= 0 ? n : null;
                if (n2 == null) {
                    return true;
                }
                int index = n2;
                return this.$filePath.charAt(index) != c;
            }
        })));
    }

    private final boolean isExactRelativePath(PsiFileSystemItem item, String searchQuery) {
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Path path = SearchEverywhereFileFeaturesProviderKt.access$toNioPathOrNull(virtualFile);
        if (path == null) {
            return false;
        }
        Path filePath = path;
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = SearchEverywhereFileFeaturesProviderKt.access$toNioPathOrNull((VirtualFile)object)) == null) {
            return false;
        }
        Object basePath = object;
        Path path2 = NioPathUtil.toNioPathOrNull((String)searchQuery);
        if (path2 == null) {
            return false;
        }
        Path queryPath = path2;
        try {
            Path relativePath = basePath.relativize(filePath);
            return Intrinsics.areEqual((Object)queryPath, (Object)relativePath);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private final Collection<EventPair<?>> getRelativePathNameMatchingFeatures(PsiFileSystemItem item, String searchQuery) {
        Path path;
        VirtualFile virtualFile = item.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Path path2 = SearchEverywhereFileFeaturesProviderKt.access$toNioPathOrNull(virtualFile);
        if (path2 == null) {
            return CollectionsKt.emptyList();
        }
        Path filePath = path2;
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = SearchEverywhereFileFeaturesProviderKt.access$toNioPathOrNull((VirtualFile)object)) == null) {
            return CollectionsKt.emptyList();
        }
        Object basePath = object;
        try {
            path = basePath.relativize(filePath);
        }
        catch (IllegalArgumentException e) {
            return CollectionsKt.emptyList();
        }
        Path relativePath = path;
        Map features2 = new LinkedHashMap();
        PrefixMatchingUtil.INSTANCE.calculateFeatures(((Object)relativePath).toString(), searchQuery, features2);
        ArrayList result = new ArrayList();
        Map $this$forEach$iv = Fields.INSTANCE.getREL_PATH_NAME_FEATURE_TO_FIELD$intellij_searchEverywhereMl_ranking_core();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            EventPair<?> it;
            Object matchValue;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            EventField field = (EventField)entry.getValue();
            if (features2.get(key) == null) continue;
            if (this.setMatchValueToField$intellij_searchEverywhereMl_ranking_core(matchValue, field) == null) continue;
            boolean bl2 = false;
            result.add(it);
        }
        return result;
    }

    private final Boolean isTopLevel(PsiFileSystemItem item) {
        Project project = item.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = ProjectUtil.guessProjectDir((Project)project);
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object basePath = object;
        Object object2 = item.getVirtualFile().getParent();
        if (object2 == null || (object2 = object2.getPath()) == null) {
            return null;
        }
        Object fileDirectoryPath = object2;
        return Intrinsics.areEqual((Object)fileDirectoryPath, (Object)basePath);
    }

    private final Boolean matchesFileTypeInQuery(PsiFileSystemItem item, String searchQuery) {
        String fileExtension = item.getVirtualFile().getExtension();
        String extensionInQuery = StringsKt.substringAfterLast((String)searchQuery, (char)'.', (String)"");
        if (((CharSequence)extensionInQuery).length() == 0 || fileExtension == null) {
            return null;
        }
        return Intrinsics.areEqual((Object)extensionInQuery, (Object)fileExtension);
    }

    private static final Boolean isBookmark$lambda$2(PsiFileSystemItem $item, BookmarksManager $bookmarksManager) {
        Bookmark bookmark;
        Intrinsics.checkNotNullParameter((Object)$item, (String)"$item");
        VirtualFile virtualFile = $item.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile vFile = virtualFile;
            boolean bl = false;
            Object object = $bookmarksManager;
            if (object != null && (object = object.getBookmarks()) != null) {
                Object v2;
                block5: {
                    Iterable iterable = (Iterable)object;
                    for (Object t : iterable) {
                        Bookmark it = (Bookmark)t;
                        boolean bl2 = false;
                        if (!(it instanceof FileBookmark && Intrinsics.areEqual((Object)((FileBookmark)it).getFile(), (Object)vFile))) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                bookmark = v2;
            } else {
                bookmark = null;
            }
        } else {
            bookmark = null;
        }
        return bookmark != null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR8\u0010\u0015\u001a&\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0016j\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018`\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/features/SearchEverywhereFileFeaturesProvider$Fields;", "", "()V", "FILETYPE_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getFILETYPE_DATA_KEY", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "FILETYPE_MATCHES_QUERY_DATA_KEY", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getFILETYPE_MATCHES_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_BOOKMARK_DATA_KEY", "getIS_BOOKMARK_DATA_KEY", "IS_DIRECTORY_DATA_KEY", "getIS_DIRECTORY_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "IS_EXACT_MATCH_DATA_KEY", "getIS_EXACT_MATCH_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY", "getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "IS_TOP_LEVEL_DATA_KEY", "getIS_TOP_LEVEL_DATA_KEY$intellij_searchEverywhereMl_ranking_core", "REL_PATH_NAME_FEATURE_TO_FIELD", "Ljava/util/HashMap;", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "Lkotlin/collections/HashMap;", "getREL_PATH_NAME_FEATURE_TO_FIELD$intellij_searchEverywhereMl_ranking_core", "()Ljava/util/HashMap;", "intellij.searchEverywhereMl.ranking.core"})
    public static final class Fields {
        @NotNull
        public static final Fields INSTANCE = new Fields();
        @NotNull
        private static final StringEventField FILETYPE_DATA_KEY = EventFields.StringValidatedByCustomRule((String)"fileType", FileTypeUsagesCollector.ValidationRule.class);
        @NotNull
        private static final BooleanEventField IS_BOOKMARK_DATA_KEY = EventFields.Boolean((String)"isBookmark");
        @NotNull
        private static final BooleanEventField IS_DIRECTORY_DATA_KEY = EventFields.Boolean((String)"isDirectory");
        @NotNull
        private static final BooleanEventField IS_EXACT_MATCH_DATA_KEY = EventFields.Boolean((String)"isExactMatch");
        @NotNull
        private static final BooleanEventField FILETYPE_MATCHES_QUERY_DATA_KEY = EventFields.Boolean((String)"fileTypeMatchesQuery");
        @NotNull
        private static final BooleanEventField IS_TOP_LEVEL_DATA_KEY = EventFields.Boolean((String)"isTopLevel");
        @NotNull
        private static final BooleanEventField IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY = EventFields.Boolean((String)"isExactRelativePath");
        @NotNull
        private static final HashMap<String, EventField<?>> REL_PATH_NAME_FEATURE_TO_FIELD;

        private Fields() {
        }

        @NotNull
        public final StringEventField getFILETYPE_DATA_KEY() {
            return FILETYPE_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_BOOKMARK_DATA_KEY() {
            return IS_BOOKMARK_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_DIRECTORY_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return IS_DIRECTORY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EXACT_MATCH_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return IS_EXACT_MATCH_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getFILETYPE_MATCHES_QUERY_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return FILETYPE_MATCHES_QUERY_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_TOP_LEVEL_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return IS_TOP_LEVEL_DATA_KEY;
        }

        @NotNull
        public final BooleanEventField getIS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY$intellij_searchEverywhereMl_ranking_core() {
            return IS_EXACT_MATCH_WITH_REL_PATH_DATA_KEY;
        }

        @NotNull
        public final HashMap<String, EventField<?>> getREL_PATH_NAME_FEATURE_TO_FIELD$intellij_searchEverywhereMl_ranking_core() {
            return REL_PATH_NAME_FEATURE_TO_FIELD;
        }

        static {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"prefix_same_start_count", (Object)EventFields.Int((String)"relPathPrefixSameStartCount")), TuplesKt.to((Object)"prefix_greedy_score", (Object)EventFields.Double((String)"relPathPrefixGreedyScore")), TuplesKt.to((Object)"prefix_matched_words_score", (Object)EventFields.Double((String)"relPathPrefixMatchedWordsScore")), TuplesKt.to((Object)"prefix_matched_words_relative", (Object)EventFields.Double((String)"relPathPrefixMatchedWordsRelative"))};
            REL_PATH_NAME_FEATURE_TO_FIELD = MapsKt.hashMapOf((Pair[])pairArray);
        }
    }
}

