/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.makefile.MakefileFile;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.psi.MakefileElementFactory;
import com.jetbrains.lang.makefile.psi.MakefileRule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/lang/makefile/inspections/CreateRuleFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "startInWriteAction", "", "intellij.makefile"})
public final class CreateRuleFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = MakefileLangBundle.message("intention.name.create.rule", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = MakefileLangBundle.message("intention.family.name.create.rule", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement prerequisite = descriptor.getPsiElement();
        PsiFile psiFile = prerequisite.getContainingFile();
        MakefileFile makefileFile = psiFile instanceof MakefileFile ? (MakefileFile)psiFile : null;
        if (makefileFile == null) {
            return;
        }
        MakefileFile file = makefileFile;
        String string = prerequisite.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        MakefileRule rule = MakefileElementFactory.INSTANCE.createRule(project, string);
        PsiElement psiElement = prerequisite.getParent().getParent().getParent().getParent().getNextSibling();
        ASTNode anchor = psiElement != null ? psiElement.getNode() : null;
        file.getNode().addChild(MakefileElementFactory.INSTANCE.createEOL(project, "\n").getNode(), anchor);
        file.getNode().addChild(rule.getNode(), anchor);
        file.getNode().addChild(MakefileElementFactory.INSTANCE.createEOL(project, "\n").getNode(), anchor);
    }
}

