/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.makefile.MakefileTargetIndex;
import com.jetbrains.lang.makefile.psi.MakefilePrerequisite;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import com.jetbrains.lang.makefile.psi.MakefileTargetLine;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006\u001a\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\f0\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0014"}, d2={"MakefileTargetIcon", "Ljavax/swing/Icon;", "getMakefileTargetIcon", "()Ljavax/swing/Icon;", "findAllTargets", "", "", "kotlin.jvm.PlatformType", "", "project", "Lcom/intellij/openapi/project/Project;", "findTargets", "Lcom/jetbrains/lang/makefile/psi/MakefileTarget;", "name", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "findTargetLine", "Lcom/jetbrains/lang/makefile/psi/MakefileTargetLine;", "Lcom/jetbrains/lang/makefile/psi/MakefilePrerequisite;", "intellij.makefile"})
public final class UtilsKt {
    @NotNull
    private static final Icon MakefileTargetIcon;

    @NotNull
    public static final Icon getMakefileTargetIcon() {
        return MakefileTargetIcon;
    }

    public static final Collection<String> findAllTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MakefileTargetIndex.Companion.getInstance().getAllKeys(project);
    }

    @NotNull
    public static final Collection<MakefileTarget> findTargets(@NotNull Project project, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        MakefileTargetIndex makefileTargetIndex = MakefileTargetIndex.Companion.getInstance();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return makefileTargetIndex.getTargets(name, project, globalSearchScope);
    }

    @NotNull
    public static final Iterable<MakefileTarget> findTargets(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)psiFile), MakefileTarget.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        return collection;
    }

    @Nullable
    public static final MakefileTargetLine findTargetLine(@NotNull MakefilePrerequisite $this$findTargetLine) {
        Intrinsics.checkNotNullParameter((Object)$this$findTargetLine, (String)"<this>");
        PsiElement psiElement = $this$findTargetLine.getParent().getParent().getParent();
        return psiElement instanceof MakefileTargetLine ? (MakefileTargetLine)psiElement : null;
    }

    static {
        Icon icon = AllIcons.RunConfigurations.TestState.Run;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Run");
        MakefileTargetIcon = icon;
    }
}

