/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.text;

import java.awt.Component;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;

public abstract class TextReader<T extends Component> {
    @Nonnull
    public abstract Class<T> supportedComponent();

    @RunsInCurrentThread
    public final boolean containsText(@Nonnull Component c, @Nonnull String text2) {
        this.checkCorrectType(c);
        Component casted = (Component)this.supportedComponent().cast(c);
        return this.checkContainsText(casted, text2);
    }

    private void checkCorrectType(Component c) {
        Class<T> type2 = this.supportedComponent();
        if (!type2.isAssignableFrom(c.getClass())) {
            String msg = String.format("Expecting component of type %s but got %s", type2.getName(), c.getClass().getName());
            throw new IllegalArgumentException(msg);
        }
    }

    @RunsInCurrentThread
    protected abstract boolean checkContainsText(@Nonnull T var1, @Nonnull String var2);
}

