/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Robot;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.awt.AWT;
import org.assertj.swing.core.InputEventGenerator;
import org.assertj.swing.core.Settings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.exception.UnexpectedException;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.Platform;
import org.assertj.swing.util.RobotFactory;

class RobotEventGenerator
implements InputEventGenerator {
    private static final int KEY_INPUT_DELAY = 200;
    private final Robot robot;
    private final Settings settings;

    RobotEventGenerator() {
        this(new Settings());
    }

    RobotEventGenerator(@Nonnull Settings settings) {
        this(new RobotFactory(), settings);
    }

    RobotEventGenerator(@Nonnull RobotFactory robotFactory, @Nonnull Settings settings) {
        try {
            this.robot = robotFactory.newRobotInLeftScreen();
            if (Platform.isWindows() || Platform.isOSX()) {
                Pause.pause(500L);
            }
        }
        catch (AWTException e) {
            throw UnexpectedException.unexpected(e);
        }
        this.settings = settings;
        settings.attachTo(this.robot);
    }

    @Nonnull
    Robot robot() {
        return this.robot;
    }

    @Override
    @RunsInEDT
    public void pressMouse(@Nonnull Component c, @Nonnull Point where, int buttons) {
        Point p = Preconditions.checkNotNull(GuiActionRunner.execute(() -> AWT.translate(c, where.x, where.y)));
        if (!AWT.isPointInScreenBoundaries(p)) {
            throw ActionFailedException.actionFailure("The component to click is out of the boundaries of the screen");
        }
        this.pressMouse(p, buttons);
    }

    @Override
    public void pressMouse(@Nonnull Point where, int buttons) {
        this.moveMouse(where.x, where.y);
        this.pressMouse(buttons);
    }

    @Override
    public void pressMouse(int buttons) {
        this.robot.mousePress(buttons);
    }

    @Override
    public void releaseMouse(int buttons) {
        this.robot.mouseRelease(buttons);
    }

    @Override
    public void rotateMouseWheel(int amount) {
        this.robot.mouseWheel(amount);
    }

    @Override
    @RunsInEDT
    public void moveMouse(@Nonnull Component c, int x, int y2) {
        Point p = Preconditions.checkNotNull(GuiActionRunner.execute(() -> AWT.translate(c, x, y2)));
        this.moveMouse(p.x, p.y);
    }

    @Override
    public void moveMouse(int x, int y2) {
        this.robot.mouseMove(x, y2);
    }

    @Override
    public void pressKey(int keyCode, char keyChar) {
        try {
            this.robot.keyPress(keyCode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid key code '%d'", keyCode));
        }
    }

    @Override
    public void releaseKey(int keyCode) {
        this.robot.keyRelease(keyCode);
        if (!Platform.isOSX()) {
            return;
        }
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        if (200 > delayBetweenEvents) {
            Pause.pause(200 - delayBetweenEvents);
        }
    }
}

