/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.starter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.LateinitValKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.language.CodeFormatter;
import org.jetbrains.completion.full.line.language.DialectDetector;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.starter.FullLineFormatter;
import org.jetbrains.completion.full.line.starter.FullLineFormatterKt;
import org.jetbrains.completion.full.line.utils.ConcurrentFlowKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 >2\u00020\u0001:\u0004=>?@B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020$H\u0082@\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010)\u001a\u00020\bH\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010)\u001a\u00020\bH\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010)\u001a\u00020\bH\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010)\u001a\u00020\bH\u0002J\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u0002002\u0006\u0010)\u001a\u00020\bH\u0002J\u0010\u00101\u001a\u0002022\u0006\u0010)\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010)\u001a\u00020\bH\u0002J(\u00105\u001a\u00020.*\u00020\u00002\f\u00106\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u00107\u001a\u000208H\u0082@\u00a2\u0006\u0002\u00109J\u0012\u0010:\u001a\b\u0012\u0004\u0012\u00020\f0(*\u00020;H\u0002J\u000e\u0010<\u001a\u0004\u0018\u00010$*\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R+\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u001c8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u001b\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006A"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter;", "", "args", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Args;", "(Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Args;)V", "getArgs", "()Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Args;", "failedFile", "Ljava/io/File;", "fileToParse", "languagesToFilter", "", "", "nThreads", "", "outputFile", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats;", "stats", "getStats", "()Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats;", "setStats", "(Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats;)V", "stats$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "total", "getTotal", "()J", "setTotal", "(J)V", "total$delegate", "formatDataFile", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "dataFile", "(Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readDirectory", "Lkotlin/sequences/Sequence;", "file", "readFile", "readGZFile", "readJsonlFile", "run", "", "writeToFile", "Ljava/io/OutputStream;", "writeToGZFile", "Ljava/util/zip/GZIPOutputStream;", "writeToJsonlFile", "Ljava/io/FileOutputStream;", "processData", "data", "writer", "Ljava/io/BufferedWriter;", "(Lorg/jetbrains/completion/full/line/starter/FullLineFormatter;Lkotlin/sequences/Sequence;Ljava/io/BufferedWriter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readDataFiles", "Ljava/io/InputStream;", "toDataFile", "Args", "Companion", "DataFile", "Stats", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineFormatter.kt\norg/jetbrains/completion/full/line/starter/FullLineFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,333:1\n1#2:334\n1313#3,2:335\n*S KotlinDebug\n*F\n+ 1 FullLineFormatter.kt\norg/jetbrains/completion/full/line/starter/FullLineFormatter\n*L\n51#1:335,2\n*E\n"})
public final class FullLineFormatter {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Args args;
    @NotNull
    private final File fileToParse;
    @NotNull
    private final File outputFile;
    @NotNull
    private final File failedFile;
    private final int nThreads;
    @NotNull
    private final List<String> languagesToFilter;
    @NotNull
    private final Project project;
    @NotNull
    private final ReadWriteProperty total$delegate;
    @NotNull
    private final ReadWriteProperty stats$delegate;
    @NotNull
    private static final Gson gson;
    private static final long PARSING_TIME_LIMIT = 300L;

    public FullLineFormatter(@NotNull Args args) {
        File it;
        File file2;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.args = args;
        this.fileToParse = this.args.getFileToParse();
        File file3 = file2 = this.args.getOutputFile();
        FullLineFormatter fullLineFormatter = this;
        boolean bl = false;
        if (it.exists()) {
            it.delete();
        }
        fullLineFormatter.outputFile = file2;
        it = file2 = this.args.getFailedFile();
        fullLineFormatter = this;
        boolean bl2 = false;
        if (it.exists()) {
            it.delete();
        }
        fullLineFormatter.failedFile = file2;
        this.nThreads = this.args.getThreads();
        this.languagesToFilter = this.args.getLanguagesToFilter();
        Project project = ProjectManager.getInstance().getDefaultProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getDefaultProject(...)");
        this.project = project;
        this.total$delegate = LateinitValKt.lateinitVal();
        this.stats$delegate = LateinitValKt.lateinitVal();
    }

    @NotNull
    public final Args getArgs() {
        return this.args;
    }

    private final long getTotal() {
        return ((Number)this.total$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
    }

    private final void setTotal(long l) {
        this.total$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)l);
    }

    private final Stats getStats() {
        return (Stats)this.stats$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setStats(Stats stats) {
        this.stats$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)stats);
    }

    public final void run() {
        this.setTotal(FullLineFormatterKt.access$countToLong(this.readFile(this.fileToParse)));
        this.setStats(new Stats(this.getTotal(), this.failedFile));
        System.out.println((Object)(this.getTotal() + " lines in total."));
        CoroutineDispatcher dispatcher = Dispatchers.getDefault().limitedParallelism(this.nThreads);
        Sequence $this$forEach$iv = SequencesKt.chunked(this.readFile(this.fileToParse), (int)100);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(dispatcher, this, (List<String>)it, null){
                int label;
                final /* synthetic */ CoroutineDispatcher $dispatcher;
                final /* synthetic */ FullLineFormatter this$0;
                final /* synthetic */ List<String> $it;
                {
                    this.$dispatcher = $dispatcher;
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.$dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$it, null){
                                Object L$0;
                                int label;
                                final /* synthetic */ FullLineFormatter this$0;
                                final /* synthetic */ List<String> $it;
                                {
                                    this.this$0 = $receiver;
                                    this.$it = $it;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            var2_3 = FullLineFormatter.access$writeToFile(this.this$0, FullLineFormatter.access$getOutputFile$p(this.this$0));
                                            var3_4 = Charsets.UTF_8;
                                            var4_5 = new OutputStreamWriter((OutputStream)var2_3, (Charset)var3_4);
                                            var5_6 = 8192;
                                            var2_3 = var4_5 instanceof BufferedWriter != false ? (BufferedWriter)var4_5 : new BufferedWriter((Writer)var4_5, var5_6);
                                            var3_4 = this.this$0;
                                            var4_5 = this.$it;
                                            var5_7 = null;
                                            writer = (BufferedWriter)var2_3;
                                            $i$a$-use-FullLineFormatter$run$1$1$1$1 = false;
                                            this.L$0 = var2_3;
                                            this.label = 1;
                                            v0 = FullLineFormatter.access$processData((FullLineFormatter)var3_4, (FullLineFormatter)var3_4, CollectionsKt.asSequence((Iterable)((Iterable)var4_5)), writer, (Continuation)this);
                                            ** if (v0 != var8_2) goto lbl22
lbl21:
                                            // 1 sources

                                            return var8_2;
lbl22:
                                            // 1 sources

                                            ** GOTO lbl31
                                        }
                                        case 1: {
                                            $i$a$-use-FullLineFormatter$run$1$1$1$1 = false;
                                            var5_7 = null;
                                            var2_3 = (Closeable)this.L$0;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl31:
                                                // 2 sources

                                                var6_8 = Unit.INSTANCE;
                                                ** GOTO lbl41
                                            }
                                            catch (Throwable var6_9) {
                                                var5_7 = var6_9;
                                                throw var6_9;
                                            }
                                        }
                                        catch (Throwable var6_10) {
                                            throw var6_10;
                                        }
                                        {
                                            finally {
                                                CloseableKt.closeFinally((Closeable)var2_3, (Throwable)var5_7);
                                            }
lbl41:
                                            // 1 sources

                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            PsiManager $this$run_u24lambda_u243_u24lambda_u242 = PsiManager.getInstance((Project)this.project);
            boolean bl2 = false;
            $this$run_u24lambda_u243_u24lambda_u242.dropPsiCaches();
            $this$run_u24lambda_u243_u24lambda_u242.dropResolveCaches();
        }
        this.getStats().logTotal(this.outputFile);
    }

    private final Object processData(FullLineFormatter $this$processData, Sequence<String> data, BufferedWriter writer, Continuation<? super Unit> $completion) {
        Object object = ConcurrentFlowKt.merge(ConcurrentFlowKt.map(ConcurrentFlowKt.concurrent(FlowKt.asFlow(data), $this$processData.nThreads), (Function2)new Function2<String, Continuation<? super DataFile>, Object>($this$processData, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ FullLineFormatter $this_processData;
            {
                this.$this_processData = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String line2 = (String)this.L$0;
                        DataFile dataFile = FullLineFormatter.access$toDataFile(this.$this_processData, line2);
                        if (dataFile == null) {
                            FullLineFormatter $this$invokeSuspend_u24lambda_u240 = this.$this_processData;
                            boolean bl = false;
                            FullLineFormatter.access$getStats($this$invokeSuspend_u24lambda_u240).fail(new Stats.Reason.Json(line2));
                            return null;
                        }
                        DataFile dataFile2 = dataFile;
                        this.label = 1;
                        Object object3 = FullLineFormatter.access$formatDataFile(this.$this_processData, dataFile2, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull String p1, @Nullable Continuation<? super DataFile> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $this$processData.args.getPreserveOrder()).collect(new FlowCollector(writer){
            final /* synthetic */ BufferedWriter $writer;
            {
                this.$writer = $writer;
            }

            @Nullable
            public final Object emit(@Nullable DataFile it, @NotNull Continuation<? super Unit> $completion) {
                if (it != null) {
                    Appendable appendable = ((Appendable)this.$writer).append(FullLineFormatter.Companion.getGson().toJson(it.getInitObject()));
                    Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
                }
                return Unit.INSTANCE;
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object formatDataFile(DataFile var1_1, Continuation<? super DataFile> var2_2) {
        if (!(var2_2 instanceof formatDataFile.1)) ** GOTO lbl-1000
        var15_3 = var2_2;
        if ((var15_3.label & -2147483648) != 0) {
            var15_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ FullLineFormatter this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FullLineFormatter.access$formatDataFile(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                path = dataFile.getPath();
                text = dataFile.getContext();
                v0 = FileTypeManager.getInstance().getFileTypeByFileName(dataFile.getPath());
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getFileTypeByFileName(...)");
                fileType = v0;
                v1 = language = LanguageUtil.getFileTypeLanguage((FileType)fileType);
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-FullLineFormatter$formatDataFile$supporter$1 = false;
                    v2 = FullLineLanguageSupporter.Companion.getInstance(it);
                } else {
                    v2 = supporter = null;
                }
                if (language == null || supporter == null) {
                    this.getStats().fail(new Stats.Reason.Unsupported(dataFile, language));
                    return null;
                }
                formatter = ((FullLineLanguageSupporter)KClasses.createInstance((KClass)Reflection.getOrCreateKotlinClass(supporter.getClass()))).getFormatter();
                dialectDetector = ((FullLineLanguageSupporter)KClasses.createInstance((KClass)Reflection.getOrCreateKotlinClass(supporter.getClass()))).getDialectDetector();
                $continuation.L$0 = this;
                $continuation.L$1 = dataFile;
                $continuation.L$2 = fileType;
                $continuation.L$3 = language;
                $continuation.L$4 = supporter;
                $continuation.L$5 = formatter;
                $continuation.L$6 = dialectDetector;
                $continuation.label = 1;
                v3 = TimeoutKt.withTimeout((long)300L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PsiFile>, Object>(supporter, path, fileType, text, this, null){
                    int label;
                    final /* synthetic */ FullLineLanguageSupporter $supporter;
                    final /* synthetic */ String $path;
                    final /* synthetic */ FileType $fileType;
                    final /* synthetic */ String $text;
                    final /* synthetic */ FullLineFormatter this$0;
                    {
                        this.$supporter = $supporter;
                        this.$path = $path;
                        this.$fileType = $fileType;
                        this.$text = $text;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)((Function0)new Function0<PsiFile>(this.$supporter, this.$path, this.$fileType, this.$text, this.this$0){
                                    final /* synthetic */ FullLineLanguageSupporter $supporter;
                                    final /* synthetic */ String $path;
                                    final /* synthetic */ FileType $fileType;
                                    final /* synthetic */ String $text;
                                    final /* synthetic */ FullLineFormatter this$0;
                                    {
                                        this.$supporter = $supporter;
                                        this.$path = $path;
                                        this.$fileType = $fileType;
                                        this.$text = $text;
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final PsiFile invoke() {
                                        String string = new File(this.$path).getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                                        return this.$supporter.createFileFromText(string, this.$fileType, this.$text, FullLineFormatter.access$getProject$p(this.this$0));
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super PsiFile> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v3 != var16_5) goto lbl43
lbl42:
                // 1 sources

                return var16_5;
lbl43:
                // 1 sources

                ** GOTO lbl56
            }
            case 1: {
                dialectDetector = (DialectDetector)$continuation.L$6;
                formatter = (CodeFormatter)$continuation.L$5;
                supporter = (FullLineLanguageSupporter)$continuation.L$4;
                language = (Language)$continuation.L$3;
                fileType = (FileType)$continuation.L$2;
                dataFile = (DataFile)$continuation.L$1;
                this = (FullLineFormatter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl56:
                // 2 sources

                psiFile = (PsiFile)v3;
                $continuation.L$0 = this;
                $continuation.L$1 = dataFile;
                $continuation.L$2 = fileType;
                $continuation.L$3 = language;
                $continuation.L$4 = supporter;
                $continuation.L$5 = formatter;
                $continuation.L$6 = psiFile;
                $continuation.label = 2;
                v4 = TimeoutKt.withTimeout((long)300L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(formatter, psiFile, dialectDetector, null){
                    int label;
                    final /* synthetic */ CodeFormatter $formatter;
                    final /* synthetic */ PsiFile $psiFile;
                    final /* synthetic */ DialectDetector $dialectDetector;
                    {
                        this.$formatter = $formatter;
                        this.$psiFile = $psiFile;
                        this.$dialectDetector = $dialectDetector;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)((Function0)new Function0<String>(this.$formatter, this.$psiFile, this.$dialectDetector){
                                    final /* synthetic */ CodeFormatter $formatter;
                                    final /* synthetic */ PsiFile $psiFile;
                                    final /* synthetic */ DialectDetector $dialectDetector;
                                    {
                                        this.$formatter = $formatter;
                                        this.$psiFile = $psiFile;
                                        this.$dialectDetector = $dialectDetector;
                                        super(0);
                                    }

                                    @NotNull
                                    public final String invoke() {
                                        return (String)CoroutinesKt.blockingContextToIndicator((Function0)((Function0)new Function0<String>(this.$formatter, this.$psiFile, this.$dialectDetector){
                                            final /* synthetic */ CodeFormatter $formatter;
                                            final /* synthetic */ PsiFile $psiFile;
                                            final /* synthetic */ DialectDetector $dialectDetector;
                                            {
                                                this.$formatter = $formatter;
                                                this.$psiFile = $psiFile;
                                                this.$dialectDetector = $dialectDetector;
                                                super(0);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            @NotNull
                                            public final String invoke() {
                                                void $this$mapTo$iv$iv;
                                                void $this$map$iv;
                                                List<CodeFormatter.ImportElement> list2 = this.$formatter.importElements(this.$psiFile);
                                                Iterable iterable = list2;
                                                DialectDetector dialectDetector2 = this.$dialectDetector;
                                                boolean $i$f$map = false;
                                                void var4_5 = $this$map$iv;
                                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                boolean $i$f$mapTo = false;
                                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                    void it;
                                                    CodeFormatter.ImportElement importElement = (CodeFormatter.ImportElement)item$iv$iv;
                                                    Collection collection = destination$iv$iv;
                                                    boolean bl = false;
                                                    collection.add(it.getElement());
                                                }
                                                String string = dialectDetector2.fromListOfImports((List)destination$iv$iv);
                                                if (string == null) {
                                                    string = this.$dialectDetector.fromFile(this.$psiFile);
                                                }
                                                return string;
                                            }
                                        }));
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v4 != var16_5) goto lbl68
lbl67:
                // 1 sources

                return var16_5;
lbl68:
                // 1 sources

                ** GOTO lbl81
            }
            case 2: {
                psiFile = (PsiFile)$continuation.L$6;
                formatter = (CodeFormatter)$continuation.L$5;
                supporter = (FullLineLanguageSupporter)$continuation.L$4;
                language = (Language)$continuation.L$3;
                fileType = (FileType)$continuation.L$2;
                dataFile = (DataFile)$continuation.L$1;
                this = (FullLineFormatter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl81:
                // 2 sources

                if (this.languagesToFilter.contains(languageTag = (String)v4)) {
                    this.getStats().fail(new Stats.Reason.Filtered(dataFile, language));
                    return null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = dataFile;
                $continuation.L$2 = fileType;
                $continuation.L$3 = supporter;
                $continuation.L$4 = formatter;
                $continuation.L$5 = languageTag;
                $continuation.L$6 = null;
                $continuation.label = 3;
                v5 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)((Function0)new Function0<String>(formatter, psiFile){
                    final /* synthetic */ CodeFormatter $formatter;
                    final /* synthetic */ PsiFile $psiFile;
                    {
                        this.$formatter = $formatter;
                        this.$psiFile = $psiFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        PsiFile psiFile2 = this.$psiFile.getContainingFile();
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                        PsiElement psiElement = (PsiElement)psiFile2;
                        TextRange textRange = this.$psiFile.getContainingFile().getTextRange();
                        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                        return this.$formatter.format(psiElement, textRange);
                    }
                }), (Continuation)$continuation);
                ** if (v5 != var16_5) goto lbl95
lbl94:
                // 1 sources

                return var16_5;
lbl95:
                // 1 sources

                ** GOTO lbl107
            }
            case 3: {
                languageTag = (String)$continuation.L$5;
                formatter = (CodeFormatter)$continuation.L$4;
                supporter = (FullLineLanguageSupporter)$continuation.L$3;
                fileType = (FileType)$continuation.L$2;
                dataFile = (DataFile)$continuation.L$1;
                this = (FullLineFormatter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl107:
                // 2 sources

                finalContext = (String)v5;
                $continuation.L$0 = this;
                $continuation.L$1 = dataFile;
                $continuation.L$2 = languageTag;
                $continuation.L$3 = finalContext;
                $continuation.L$4 = null;
                $continuation.L$5 = null;
                $continuation.label = 4;
                v6 = TimeoutKt.withTimeout((long)300L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends IntRange>>, Object>(supporter, fileType, finalContext, this, formatter, null){
                    int label;
                    final /* synthetic */ FullLineLanguageSupporter $supporter;
                    final /* synthetic */ FileType $fileType;
                    final /* synthetic */ String $finalContext;
                    final /* synthetic */ FullLineFormatter this$0;
                    final /* synthetic */ CodeFormatter $formatter;
                    {
                        this.$supporter = $supporter;
                        this.$fileType = $fileType;
                        this.$finalContext = $finalContext;
                        this.this$0 = $receiver;
                        this.$formatter = $formatter;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)((Function0)new Function0<List<? extends IntRange>>(this.$supporter, this.$fileType, this.$finalContext, this.this$0, this.$formatter){
                                    final /* synthetic */ FullLineLanguageSupporter $supporter;
                                    final /* synthetic */ FileType $fileType;
                                    final /* synthetic */ String $finalContext;
                                    final /* synthetic */ FullLineFormatter this$0;
                                    final /* synthetic */ CodeFormatter $formatter;
                                    {
                                        this.$supporter = $supporter;
                                        this.$fileType = $fileType;
                                        this.$finalContext = $finalContext;
                                        this.this$0 = $receiver;
                                        this.$formatter = $formatter;
                                        super(0);
                                    }

                                    @NotNull
                                    public final List<IntRange> invoke() {
                                        return (List)CoroutinesKt.blockingContextToIndicator((Function0)((Function0)new Function0<List<? extends IntRange>>(this.$supporter, this.$fileType, this.$finalContext, this.this$0, this.$formatter){
                                            final /* synthetic */ FullLineLanguageSupporter $supporter;
                                            final /* synthetic */ FileType $fileType;
                                            final /* synthetic */ String $finalContext;
                                            final /* synthetic */ FullLineFormatter this$0;
                                            final /* synthetic */ CodeFormatter $formatter;
                                            {
                                                this.$supporter = $supporter;
                                                this.$fileType = $fileType;
                                                this.$finalContext = $finalContext;
                                                this.this$0 = $receiver;
                                                this.$formatter = $formatter;
                                                super(0);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            @NotNull
                                            public final List<IntRange> invoke() {
                                                void $this$mapTo$iv$iv;
                                                PsiFile psiFile2 = this.$supporter.createFileFromText("formatted" + this.$fileType.getDefaultExtension(), this.$fileType, this.$finalContext, FullLineFormatter.access$getProject$p(this.this$0));
                                                CodeFormatter codeFormatter = this.$formatter;
                                                Object p0 = psiFile2;
                                                boolean bl = false;
                                                Iterable $this$map$iv = codeFormatter.importElements((PsiFile)p0);
                                                boolean $i$f$map = false;
                                                p0 = $this$map$iv;
                                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                boolean $i$f$mapTo = false;
                                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                    void it;
                                                    CodeFormatter.ImportElement importElement = (CodeFormatter.ImportElement)item$iv$iv;
                                                    Collection collection = destination$iv$iv;
                                                    boolean bl2 = false;
                                                    int start = it.getFullRange().getStartOffset();
                                                    int endInclusive = it.getFullRange().getEndOffset();
                                                    int newLineOffset = 0;
                                                    collection.add(new IntRange(start, endInclusive + newLineOffset));
                                                }
                                                return (List)destination$iv$iv;
                                            }
                                        }));
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<IntRange>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v6 != var16_5) goto lbl118
lbl117:
                // 1 sources

                return var16_5;
lbl118:
                // 1 sources

                ** GOTO lbl128
            }
            case 4: {
                finalContext = (String)$continuation.L$3;
                languageTag = (String)$continuation.L$2;
                dataFile = (DataFile)$continuation.L$1;
                this = (FullLineFormatter)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl128:
                    // 2 sources

                    importRanges = (List)v6;
                    ((Map)dataFile.getInitObject()).put("final_context", finalContext);
                    ((Map)dataFile.getInitObject()).put("import_ranges", importRanges);
                    ((Map)dataFile.getInitObject()).put("language_tag", languageTag);
                    this.getStats().succeed();
                    return dataFile;
                }
                catch (Throwable e) {
                    if (e instanceof TimeoutCancellationException) {
                        v7 = new Stats.Reason.Timeout(dataFile, (TimeoutCancellationException)e);
                    } else {
                        e.printStackTrace();
                        v7 = new Stats.Reason.Exception(dataFile, e);
                    }
                    reason = v7;
                    this.getStats().fail(reason);
                    return null;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Sequence<String> readFile(File file2) {
        Sequence<String> sequence2;
        if (file2.isDirectory()) {
            System.out.println((Object)("Reading from directory " + file2.getAbsolutePath()));
            sequence2 = this.readDirectory(file2);
        } else if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"gz")) {
            System.out.println((Object)("Reading from gz file " + file2.getAbsolutePath()));
            sequence2 = this.readGZFile(file2);
        } else if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"jsonl")) {
            System.out.println((Object)("Reading from jsonl file " + file2.getAbsolutePath()));
            sequence2 = this.readJsonlFile(file2);
        } else {
            throw new IllegalArgumentException("Can't parse " + file2.getAbsolutePath() + ". Currently only directory and jsonl file are supported.");
        }
        return sequence2;
    }

    private final Sequence<String> readDirectory(File file2) {
        return SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file2)), (Function1)((Function1)new Function1<File, Boolean>(file2){
            final /* synthetic */ File $file;
            {
                this.$file = $file;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)it, (Object)this.$file);
            }
        })), (Function1)((Function1)new Function1<File, Sequence<? extends String>>((Object)this){

            @NotNull
            public final Sequence<String> invoke(@NotNull File p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return FullLineFormatter.access$readFile((FullLineFormatter)this.receiver, p0);
            }
        }));
    }

    private final Sequence<String> readGZFile(File file2) {
        return this.readDataFiles(new GZIPInputStream(new FileInputStream(file2)));
    }

    private final Sequence<String> readJsonlFile(File file2) {
        return this.readDataFiles(new FileInputStream(file2));
    }

    private final Sequence<String> readDataFiles(InputStream $this$readDataFiles) {
        InputStream inputStream2 = $this$readDataFiles;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        return TextStreamsKt.lineSequence((BufferedReader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
    }

    private final DataFile toDataFile(String $this$toDataFile) {
        DataFile dataFile;
        try {
            Object object = gson.fromJson($this$toDataFile, LinkedHashMap.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<kotlin.String, kotlin.Any>{ kotlin.collections.TypeAliasesKt.LinkedHashMap<kotlin.String, kotlin.Any> }");
            LinkedHashMap obj = (LinkedHashMap)object;
            dataFile = new DataFile(obj);
        }
        catch (JsonSyntaxException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            System.out.println((Object)"Failed to parse line due to corrupt json.");
            dataFile = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            dataFile = null;
        }
        return dataFile;
    }

    private final OutputStream writeToFile(File file2) {
        OutputStream outputStream2;
        String string = FilesKt.getExtension((File)file2);
        if (Intrinsics.areEqual((Object)string, (Object)"jsonl")) {
            outputStream2 = this.writeToJsonlFile(file2);
        } else if (Intrinsics.areEqual((Object)string, (Object)"gz")) {
            outputStream2 = this.writeToGZFile(file2);
        } else {
            throw new IllegalArgumentException("Can't parse " + file2.getAbsolutePath() + ". Currently only `jsonl.gz` and `jsonl` file are supported.");
        }
        return outputStream2;
    }

    private final FileOutputStream writeToJsonlFile(File file2) {
        return new FileOutputStream(file2, true);
    }

    private final GZIPOutputStream writeToGZFile(File file2) {
        return new GZIPOutputStream(new FileOutputStream(file2, true));
    }

    public static final /* synthetic */ Object access$processData(FullLineFormatter $this, FullLineFormatter $receiver, Sequence data, BufferedWriter writer, Continuation $completion) {
        return $this.processData($receiver, (Sequence<String>)data, writer, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ DataFile access$toDataFile(FullLineFormatter $this, String $receiver) {
        return $this.toDataFile($receiver);
    }

    public static final /* synthetic */ Object access$formatDataFile(FullLineFormatter $this, DataFile dataFile, Continuation $completion) {
        return $this.formatDataFile(dataFile, (Continuation<? super DataFile>)$completion);
    }

    public static final /* synthetic */ Stats access$getStats(FullLineFormatter $this) {
        return $this.getStats();
    }

    public static final /* synthetic */ Project access$getProject$p(FullLineFormatter $this) {
        return $this.project;
    }

    public static final /* synthetic */ Sequence access$readFile(FullLineFormatter $this, File file2) {
        return $this.readFile(file2);
    }

    public static final /* synthetic */ OutputStream access$writeToFile(FullLineFormatter $this, File file2) {
        return $this.writeToFile(file2);
    }

    public static final /* synthetic */ File access$getOutputFile$p(FullLineFormatter $this) {
        return $this.outputFile;
    }

    static {
        GsonBuilder gsonBuilder;
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FullLineFormatter.class, "total", "getTotal()J", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FullLineFormatter.class, "stats", "getStats()Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        GsonBuilder $this$gson_u24lambda_u245 = gsonBuilder = new GsonBuilder();
        boolean bl = false;
        $this$gson_u24lambda_u245.setLenient();
        Gson gson = gsonBuilder.create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        FullLineFormatter.gson = gson;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\fH\u00c6\u0003JK\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\"\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Args;", "", "fileToParse", "Ljava/io/File;", "outputFile", "failedFile", "threads", "", "languagesToFilter", "", "", "preserveOrder", "", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;ILjava/util/List;Z)V", "getFailedFile", "()Ljava/io/File;", "getFileToParse", "getLanguagesToFilter", "()Ljava/util/List;", "getOutputFile", "getPreserveOrder", "()Z", "getThreads", "()I", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "toString", "intellij.fullLine"})
    public static final class Args {
        @NotNull
        private final File fileToParse;
        @NotNull
        private final File outputFile;
        @NotNull
        private final File failedFile;
        private final int threads;
        @NotNull
        private final List<String> languagesToFilter;
        private final boolean preserveOrder;

        public Args(@NotNull File fileToParse, @NotNull File outputFile, @NotNull File failedFile, int threads, @NotNull List<String> languagesToFilter, boolean preserveOrder) {
            Intrinsics.checkNotNullParameter((Object)fileToParse, (String)"fileToParse");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            Intrinsics.checkNotNullParameter((Object)failedFile, (String)"failedFile");
            Intrinsics.checkNotNullParameter(languagesToFilter, (String)"languagesToFilter");
            this.fileToParse = fileToParse;
            this.outputFile = outputFile;
            this.failedFile = failedFile;
            this.threads = threads;
            this.languagesToFilter = languagesToFilter;
            this.preserveOrder = preserveOrder;
        }

        @NotNull
        public final File getFileToParse() {
            return this.fileToParse;
        }

        @NotNull
        public final File getOutputFile() {
            return this.outputFile;
        }

        @NotNull
        public final File getFailedFile() {
            return this.failedFile;
        }

        public final int getThreads() {
            return this.threads;
        }

        @NotNull
        public final List<String> getLanguagesToFilter() {
            return this.languagesToFilter;
        }

        public final boolean getPreserveOrder() {
            return this.preserveOrder;
        }

        @NotNull
        public final File component1() {
            return this.fileToParse;
        }

        @NotNull
        public final File component2() {
            return this.outputFile;
        }

        @NotNull
        public final File component3() {
            return this.failedFile;
        }

        public final int component4() {
            return this.threads;
        }

        @NotNull
        public final List<String> component5() {
            return this.languagesToFilter;
        }

        public final boolean component6() {
            return this.preserveOrder;
        }

        @NotNull
        public final Args copy(@NotNull File fileToParse, @NotNull File outputFile, @NotNull File failedFile, int threads, @NotNull List<String> languagesToFilter, boolean preserveOrder) {
            Intrinsics.checkNotNullParameter((Object)fileToParse, (String)"fileToParse");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            Intrinsics.checkNotNullParameter((Object)failedFile, (String)"failedFile");
            Intrinsics.checkNotNullParameter(languagesToFilter, (String)"languagesToFilter");
            return new Args(fileToParse, outputFile, failedFile, threads, languagesToFilter, preserveOrder);
        }

        public static /* synthetic */ Args copy$default(Args args, File file2, File file3, File file4, int n, List list2, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                file2 = args.fileToParse;
            }
            if ((n2 & 2) != 0) {
                file3 = args.outputFile;
            }
            if ((n2 & 4) != 0) {
                file4 = args.failedFile;
            }
            if ((n2 & 8) != 0) {
                n = args.threads;
            }
            if ((n2 & 0x10) != 0) {
                list2 = args.languagesToFilter;
            }
            if ((n2 & 0x20) != 0) {
                bl = args.preserveOrder;
            }
            return args.copy(file2, file3, file4, n, list2, bl);
        }

        @NotNull
        public String toString() {
            return "Args(fileToParse=" + this.fileToParse + ", outputFile=" + this.outputFile + ", failedFile=" + this.failedFile + ", threads=" + this.threads + ", languagesToFilter=" + this.languagesToFilter + ", preserveOrder=" + this.preserveOrder + ")";
        }

        public int hashCode() {
            int result = this.fileToParse.hashCode();
            result = result * 31 + this.outputFile.hashCode();
            result = result * 31 + this.failedFile.hashCode();
            result = result * 31 + Integer.hashCode(this.threads);
            result = result * 31 + ((Object)this.languagesToFilter).hashCode();
            result = result * 31 + Boolean.hashCode(this.preserveOrder);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.fileToParse, (Object)args.fileToParse)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputFile, (Object)args.outputFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.failedFile, (Object)args.failedFile)) {
                return false;
            }
            if (this.threads != args.threads) {
                return false;
            }
            if (!Intrinsics.areEqual(this.languagesToFilter, args.languagesToFilter)) {
                return false;
            }
            return this.preserveOrder == args.preserveOrder;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Companion;", "", "()V", "PARSING_TIME_LIMIT", "", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGson() {
            return gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\b\u0016\u0012\"\u0010\u0002\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u0005\u00a2\u0006\u0002\u0010\u0006B9\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\"\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003J%\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u0005H\u00c6\u0003JC\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042$\b\u0002\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001R\u0016\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR2\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "", "obj", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "(Ljava/util/LinkedHashMap;)V", "path", "context", "initObject", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/LinkedHashMap;)V", "getContext", "()Ljava/lang/String;", "getInitObject", "()Ljava/util/LinkedHashMap;", "getPath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.fullLine"})
    public static final class DataFile {
        @SerializedName(value="filepath")
        @NotNull
        private final String path;
        @SerializedName(value="original_context")
        @NotNull
        private final String context;
        @SerializedName(value="init_object")
        @NotNull
        private final LinkedHashMap<String, Object> initObject;

        public DataFile(@NotNull String path2, @NotNull String context2, @NotNull LinkedHashMap<String, Object> initObject) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter(initObject, (String)"initObject");
            this.path = path2;
            this.context = context2;
            this.initObject = initObject;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getContext() {
            return this.context;
        }

        @NotNull
        public final LinkedHashMap<String, Object> getInitObject() {
            return this.initObject;
        }

        public DataFile(@NotNull LinkedHashMap<String, Object> obj) {
            Intrinsics.checkNotNullParameter(obj, (String)"obj");
            this("" + obj.get("filepath") + obj.get("extension"), String.valueOf(obj.get("content")), obj);
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.context;
        }

        @NotNull
        public final LinkedHashMap<String, Object> component3() {
            return this.initObject;
        }

        @NotNull
        public final DataFile copy(@NotNull String path2, @NotNull String context2, @NotNull LinkedHashMap<String, Object> initObject) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter(initObject, (String)"initObject");
            return new DataFile(path2, context2, initObject);
        }

        public static /* synthetic */ DataFile copy$default(DataFile dataFile, String string, String string2, LinkedHashMap linkedHashMap, int n, Object object) {
            if ((n & 1) != 0) {
                string = dataFile.path;
            }
            if ((n & 2) != 0) {
                string2 = dataFile.context;
            }
            if ((n & 4) != 0) {
                linkedHashMap = dataFile.initObject;
            }
            return dataFile.copy(string, string2, linkedHashMap);
        }

        @NotNull
        public String toString() {
            return "DataFile(path=" + this.path + ", context=" + this.context + ", initObject=" + this.initObject + ")";
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = result * 31 + this.context.hashCode();
            result = result * 31 + this.initObject.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataFile)) {
                return false;
            }
            DataFile dataFile = (DataFile)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)dataFile.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.context, (Object)dataFile.context)) {
                return false;
            }
            return Intrinsics.areEqual(this.initObject, dataFile.initObject);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\u0013R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats;", "", "total", "", "failedFile", "Ljava/io/File;", "(JLjava/io/File;)V", "failed", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/atomic/AtomicInteger;", "index", "lastTimestamp", "Ljava/util/concurrent/atomic/AtomicLong;", "startTimestamp", "success", "countFailed", "", "fail", "", "reason", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason;", "logIteration", "logTotal", "outputFile", "succeed", "Reason", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nFullLineFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineFormatter.kt\norg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,333:1\n1#2:334\n*E\n"})
    private static final class Stats {
        private final long total;
        @NotNull
        private final File failedFile;
        @NotNull
        private final AtomicInteger index;
        @NotNull
        private final AtomicInteger success;
        private final long startTimestamp;
        @NotNull
        private final AtomicLong lastTimestamp;
        @NotNull
        private final ConcurrentHashMap<String, AtomicInteger> failed;

        public Stats(long total, @NotNull File failedFile) {
            Intrinsics.checkNotNullParameter((Object)failedFile, (String)"failedFile");
            this.total = total;
            this.failedFile = failedFile;
            this.index = new AtomicInteger(0);
            this.success = new AtomicInteger(0);
            this.startTimestamp = System.currentTimeMillis();
            this.lastTimestamp = new AtomicLong(System.currentTimeMillis());
            this.failed = new ConcurrentHashMap();
        }

        public final void fail(@NotNull Reason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.logIteration();
            String key = reason.description();
            this.failed.putIfAbsent(key, new AtomicInteger(0));
            AtomicInteger atomicInteger = this.failed.get(key);
            Intrinsics.checkNotNull((Object)atomicInteger);
            atomicInteger.incrementAndGet();
            OutputStream outputStream2 = new GZIPOutputStream(new FileOutputStream(this.failedFile, true));
            Charset charset = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter(outputStream2, charset);
            int n = 8192;
            BufferedWriter stream = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            Appendable appendable = ((Appendable)stream).append(reason.toJson());
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
            stream.close();
        }

        public final void succeed() {
            this.logIteration();
            this.success.getAndIncrement();
        }

        public final void logIteration() {
            int i = this.index.getAndIncrement();
            if (i % 1000 == 0) {
                java.time.Duration duration = java.time.Duration.ofMillis(System.currentTimeMillis() - this.lastTimestamp.get());
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
                java.time.Duration duration2 = duration;
                long duration3 = Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration2.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration2.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
                this.lastTimestamp.set(System.currentTimeMillis());
                System.out.println((Object)("Processed " + i + "/" + this.total + ", failed " + this.countFailed() + " [" + Duration.toString-impl((long)duration3) + "]."));
            }
        }

        public final void logTotal(@NotNull File outputFile) {
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            java.time.Duration duration = java.time.Duration.ofMillis(System.currentTimeMillis() - this.startTimestamp);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            Object object = duration;
            long duration2 = Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)((java.time.Duration)object).getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)((java.time.Duration)object).getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
            object = new StringBuilder();
            Comparable<java.time.Duration> $this$logTotal_u24lambda_u240 = object;
            boolean bl = false;
            StringBuilder stringBuilder = ((StringBuilder)$this$logTotal_u24lambda_u240).append("Processed " + this.index + "/" + this.total + ".");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder2 = ((StringBuilder)$this$logTotal_u24lambda_u240).append("Formatted for " + Duration.toString-impl((long)duration2) + ".");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = ((StringBuilder)$this$logTotal_u24lambda_u240).append("Saved to " + outputFile.getAbsolutePath());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder4 = ((StringBuilder)$this$logTotal_u24lambda_u240).append("======================================");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder5 = ((StringBuilder)$this$logTotal_u24lambda_u240).append("Successfully formatted " + this.success + " files.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder6 = ((StringBuilder)$this$logTotal_u24lambda_u240).append("Failed for " + this.countFailed() + " files.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            if (!((Map)this.failed).isEmpty()) {
                StringBuilder stringBuilder7 = ((StringBuilder)$this$logTotal_u24lambda_u240).append("\tReasons: " + this.failed);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            }
            String string = ((StringBuilder)object).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Object it = object = string;
            boolean bl2 = false;
            System.out.println(it);
        }

        /*
         * WARNING - void declaration
         */
        public final int countFailed() {
            Collection<AtomicInteger> collection = this.failed.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            int n = 0;
            for (Object t : iterable) {
                void it;
                AtomicInteger atomicInteger = (AtomicInteger)t;
                int n2 = n;
                boolean bl = false;
                int n3 = it.get();
                n = n2 + n3;
            }
            return n;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rJ\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016\u0082\u0001\u0005\u000e\u000f\u0010\u0011\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason;", "", "description", "", "toJson", "withFailed", "dataFile", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "fail", "Exception", "Filtered", "Json", "Timeout", "Unsupported", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Exception;", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Filtered;", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Json;", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Timeout;", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Unsupported;", "intellij.fullLine"})
        public static interface Reason {
            @NotNull
            public String toJson();

            @NotNull
            public String description();

            @NotNull
            default public String withFailed(@NotNull DataFile dataFile, @NotNull String fail) {
                Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
                Intrinsics.checkNotNullParameter((Object)fail, (String)"fail");
                ((Map)dataFile.getInitObject()).put("fail", fail);
                String string = Companion.getGson().toJson((Object)dataFile);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                return string;
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Exception;", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason;", "dataFile", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "exception", "", "(Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;Ljava/lang/Throwable;)V", "getDataFile", "()Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "getException", "()Ljava/lang/Throwable;", "description", "", "toJson", "intellij.fullLine"})
            public static final class Exception
            implements Reason {
                @NotNull
                private final DataFile dataFile;
                @NotNull
                private final Throwable exception;

                public Exception(@NotNull DataFile dataFile, @NotNull Throwable exception) {
                    Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    this.dataFile = dataFile;
                    this.exception = exception;
                }

                @NotNull
                public final DataFile getDataFile() {
                    return this.dataFile;
                }

                @NotNull
                public final Throwable getException() {
                    return this.exception;
                }

                @Override
                @NotNull
                public String toJson() {
                    return this.withFailed(this.dataFile, "exception: " + this.exception.getLocalizedMessage());
                }

                @Override
                @NotNull
                public String description() {
                    return String.valueOf(Reflection.getOrCreateKotlinClass(this.exception.getClass()).getSimpleName());
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Filtered;", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason;", "dataFile", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "language", "Lcom/intellij/lang/Language;", "(Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;Lcom/intellij/lang/Language;)V", "getDataFile", "()Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "getLanguage", "()Lcom/intellij/lang/Language;", "description", "", "toJson", "intellij.fullLine"})
            public static final class Filtered
            implements Reason {
                @NotNull
                private final DataFile dataFile;
                @Nullable
                private final Language language;

                public Filtered(@NotNull DataFile dataFile, @Nullable Language language2) {
                    Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
                    this.dataFile = dataFile;
                    this.language = language2;
                }

                @NotNull
                public final DataFile getDataFile() {
                    return this.dataFile;
                }

                @Nullable
                public final Language getLanguage() {
                    return this.language;
                }

                @Override
                @NotNull
                public String toJson() {
                    Language language2 = this.language;
                    return this.withFailed(this.dataFile, "filtered: " + (language2 != null ? language2.getID() : null));
                }

                @Override
                @NotNull
                public String description() {
                    Object object = this.language;
                    if (object == null || (object = object.getID()) == null) {
                        object = "null";
                    }
                    return "Filtered " + (String)object;
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Json;", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason;", "raw", "", "(Ljava/lang/String;)V", "getRaw", "()Ljava/lang/String;", "description", "toJson", "intellij.fullLine"})
            public static final class Json
            implements Reason {
                @NotNull
                private final String raw;

                public Json(@NotNull String raw) {
                    Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
                    this.raw = raw;
                }

                @NotNull
                public final String getRaw() {
                    return this.raw;
                }

                @Override
                @NotNull
                public String toJson() {
                    return StringsKt.removeSuffix((String)((Object)StringsKt.trimEnd((CharSequence)StringsKt.removeSuffix((String)this.raw, (CharSequence)"}"))).toString(), (CharSequence)",") + ", \"fail\": \"json\"}";
                }

                @Override
                @NotNull
                public String description() {
                    return "bad json";
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Timeout;", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason;", "dataFile", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "exception", "Lkotlinx/coroutines/TimeoutCancellationException;", "(Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;Lkotlinx/coroutines/TimeoutCancellationException;)V", "getDataFile", "()Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "getException", "()Lkotlinx/coroutines/TimeoutCancellationException;", "description", "", "toJson", "intellij.fullLine"})
            public static final class Timeout
            implements Reason {
                @NotNull
                private final DataFile dataFile;
                @NotNull
                private final TimeoutCancellationException exception;

                public Timeout(@NotNull DataFile dataFile, @NotNull TimeoutCancellationException exception) {
                    Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    this.dataFile = dataFile;
                    this.exception = exception;
                }

                @NotNull
                public final DataFile getDataFile() {
                    return this.dataFile;
                }

                @NotNull
                public final TimeoutCancellationException getException() {
                    return this.exception;
                }

                @Override
                @NotNull
                public String toJson() {
                    return this.withFailed(this.dataFile, "timeout: " + this.exception.getLocalizedMessage());
                }

                @Override
                @NotNull
                public String description() {
                    return "Timeout " + Reflection.getOrCreateKotlinClass(this.exception.getClass()).getSimpleName();
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason$Unsupported;", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$Stats$Reason;", "dataFile", "Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "language", "Lcom/intellij/lang/Language;", "(Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;Lcom/intellij/lang/Language;)V", "getDataFile", "()Lorg/jetbrains/completion/full/line/starter/FullLineFormatter$DataFile;", "getLanguage", "()Lcom/intellij/lang/Language;", "description", "", "toJson", "intellij.fullLine"})
            public static final class Unsupported
            implements Reason {
                @NotNull
                private final DataFile dataFile;
                @Nullable
                private final Language language;

                public Unsupported(@NotNull DataFile dataFile, @Nullable Language language2) {
                    Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
                    this.dataFile = dataFile;
                    this.language = language2;
                }

                @NotNull
                public final DataFile getDataFile() {
                    return this.dataFile;
                }

                @Nullable
                public final Language getLanguage() {
                    return this.language;
                }

                @Override
                @NotNull
                public String toJson() {
                    Language language2 = this.language;
                    return this.withFailed(this.dataFile, "unsupported: " + (language2 != null ? language2.getID() : null));
                }

                @Override
                @NotNull
                public String description() {
                    Object object = this.language;
                    if (object == null || (object = object.getID()) == null) {
                        object = "null";
                    }
                    return "Unsupported " + (String)object;
                }
            }
        }
    }
}

