/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.settings;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.FullLineCompletionType;
import org.jetbrains.completion.full.line.language.LangState;
import org.jetbrains.completion.full.line.language.ModelSettings;
import org.jetbrains.completion.full.line.language.RedCodePolicy;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSettings;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.models.FullLineUXMode;
import org.jetbrains.completion.full.line.models.ModelType;
import org.jetbrains.completion.full.line.settings.GeneralState;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@State(name="MLServerCompletionSettings", storages={@Storage(value="MLServerCompletionSettings.xml", deprecated=true, roamingType=RoamingType.DISABLED), @Storage(value="full.line.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.CODE, exportable=true)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u0000 82\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000278B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0002H\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010#\u001a\u00020\u0011J\u000e\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010&\u001a\u00020\u0011J\u000e\u0010'\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010)\u001a\u00020!H\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020\u0002H\u0016J\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u0018H\u0002J\u0006\u00102\u001a\u00020\u0011J\u0013\u00103\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b4\u0010\rJ\u0015\u00105\u001a\u0004\u0018\u00010-2\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u00106R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00069"}, d2={"Lorg/jetbrains/completion/full/line/settings/FullLineSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "settingsState", "Lorg/jetbrains/completion/full/line/settings/GeneralState;", "getSettingsState", "()Lorg/jetbrains/completion/full/line/settings/GeneralState;", "setSettingsState", "(Lorg/jetbrains/completion/full/line/settings/GeneralState;)V", "abortComputationAfter", "Lkotlin/time/Duration;", "abortComputationAfter-UwyO8pc", "()J", "cacheSettings", "Lorg/jetbrains/completion/full/line/settings/FullLineSettings$CacheSettings;", "checkIncorrectCode", "", "language", "Lcom/intellij/lang/Language;", "completionType", "Lorg/jetbrains/completion/full/line/FullLineCompletionType;", "enableStringsWalking", "getLangState", "Lorg/jetbrains/completion/full/line/language/LangState;", "languageId", "", "getState", "getUXMode", "Lorg/jetbrains/completion/full/line/models/FullLineUXMode;", "incorrectCodePolicy", "Lorg/jetbrains/completion/full/line/language/RedCodePolicy;", "initializeComponent", "", "interruptContextInitialization", "isEnabled", "isFilterModelEnabled", "isFimModel", "isGreyTextMode", "isLanguageSupported", "isTriggerModelEnabled", "loadEvaluationConfig", "loadState", "state", "maxSimultaneouslyPipelines", "", "maxSuggestionsForAnalysis", "patchForEval", "langId", "langState", "showScore", "silentComputationAfter", "silentComputationAfter-UwyO8pc", "topN", "(Lcom/intellij/lang/Language;)Ljava/lang/Integer;", "CacheSettings", "Companion", "intellij.fullLine.core"})
@SourceDebugExtension(value={"SMAP\nFullLineSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineSettings.kt\norg/jetbrains/completion/full/line/settings/FullLineSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1#2:243\n1855#3,2:244\n288#3,2:246\n*S KotlinDebug\n*F\n+ 1 FullLineSettings.kt\norg/jetbrains/completion/full/line/settings/FullLineSettings\n*L\n142#1:244,2\n151#1:246,2\n*E\n"})
public final class FullLineSettings
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private GeneralState settingsState = new GeneralState(false, false, 0, null, false, 0, 0, 0, 0.0f, 0, 0, 0, false, false, false, false, 0, null, 262143, null);

    @NotNull
    public final GeneralState getSettingsState() {
        return this.settingsState;
    }

    public final void setSettingsState(@NotNull GeneralState generalState) {
        Intrinsics.checkNotNullParameter((Object)generalState, (String)"<set-?>");
        this.settingsState = generalState;
    }

    public void initializeComponent() {
        this.loadEvaluationConfig();
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.settingsState = this.settingsState.deserialize(state);
    }

    @NotNull
    public Element getState() {
        return this.settingsState.serialize();
    }

    @NotNull
    public final LangState getLangState(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        String string = language2.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        return this.getLangState(string);
    }

    @NotNull
    public final LangState getLangState(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        LangState langState = this.settingsState.getLangStates().get(languageId);
        if (langState == null) {
            throw new IllegalArgumentException("Language id:" + languageId + " is not supported");
        }
        return langState;
    }

    public final boolean isEnabled() {
        return this.settingsState.getEnable();
    }

    public final boolean isGreyTextMode() {
        return FullLineUXMode.Companion.getInlineModes().contains((Object)this.settingsState.getCompletionMode());
    }

    @NotNull
    public final FullLineCompletionType completionType() {
        return this.isGreyTextMode() ? FullLineCompletionType.INLINE : FullLineCompletionType.LOOKUP;
    }

    public final boolean enableStringsWalking() {
        return this.settingsState.getStringsWalking();
    }

    public final boolean showScore() {
        return this.settingsState.getShowScore();
    }

    public final int maxSimultaneouslyPipelines() {
        return this.settingsState.getMaxSimultaneouslyPipelines();
    }

    @Nullable
    public final Integer topN(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return this.getLangState(language2).getCustomTopN() != null ? this.getLangState(language2).getCustomTopN() : (this.settingsState.getCompletionMode() == FullLineUXMode.ShowInLookupWithOneSuggestion ? Integer.valueOf(1) : (this.settingsState.getUseTopN() ? Integer.valueOf(this.settingsState.getTopN()) : null));
    }

    public final boolean checkIncorrectCode(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return this.getLangState(language2).getCheckIncorrectCode();
    }

    public final boolean isFimModel(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Object object = FullLineLanguageSupporter.Companion.getInstance(language2);
        return object != null && (object = object.getModelSettings()) != null ? ((ModelSettings)object).getFimModel() : false;
    }

    @NotNull
    public final RedCodePolicy incorrectCodePolicy(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return this.getLangState(language2).getIncorrectCodePolicy();
    }

    public final boolean isTriggerModelEnabled(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return this.getLangState(language2).isTriggerModelEnabled();
    }

    public final boolean isFilterModelEnabled(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return this.getLangState(language2).isFilterModelEnabled();
    }

    @NotNull
    public final FullLineUXMode getUXMode() {
        return this.settingsState.getCompletionMode();
    }

    public final boolean isLanguageSupported(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Map map = this.settingsState.getLangStates();
        String string = language2.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        return map.containsKey(string);
    }

    public final boolean isEnabled(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return this.isEnabled() && this.isLanguageSupported(language2) && this.getLangState(language2).getEnabled();
    }

    @NotNull
    public final CacheSettings cacheSettings() {
        return CacheSettings.Companion.fromSettings(this.settingsState);
    }

    public final long abortComputationAfter-UwyO8pc() {
        return DurationKt.toDuration((int)this.settingsState.getAbortComputationAfterMs(), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    public final long silentComputationAfter-UwyO8pc() {
        return DurationKt.toDuration((int)this.settingsState.getSilentComputationAfterMs(), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    public final boolean interruptContextInitialization(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return this.getLangState(language2).getInterruptContextInitialization();
    }

    public final int maxSuggestionsForAnalysis(@NotNull Language language2) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        return this.getLangState(language2).getMaxSuggestionForAnalysis();
    }

    private final void loadEvaluationConfig() {
        Object v18;
        block21: {
            String it;
            Object object;
            Object object2;
            String string;
            Object object3;
            Object object4;
            Object object5;
            String string2 = System.getenv("flcc_evaluating");
            if (string2 == null) {
                return;
            }
            String isTesting = string2;
            if (!Boolean.parseBoolean(isTesting)) {
                return;
            }
            Object object6 = System.getenv("flcc_enable");
            if (object6 != null && (object6 = StringsKt.toBooleanStrictOrNull((String)object6)) != null) {
                boolean bl = (Boolean)object6;
                boolean bl2 = false;
                this.settingsState.setEnable(bl);
            }
            String string3 = System.getenv("flcc_completion_mode");
            if (string3 != null) {
                Object v3;
                block20: {
                    String value = string3;
                    boolean bl = false;
                    Iterable bl2 = (Iterable)FullLineUXMode.getEntries();
                    for (Object object7 : bl2) {
                        FullLineUXMode mode = (FullLineUXMode)((Object)object7);
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)mode.name(), (String)value, (boolean)true)) continue;
                        v3 = object7;
                        break block20;
                    }
                    v3 = null;
                }
                FullLineUXMode fullLineUXMode = v3;
                if (fullLineUXMode != null) {
                    FullLineUXMode it3 = fullLineUXMode;
                    boolean bl = false;
                    this.settingsState.setCompletionMode(it3);
                }
            }
            if ((object5 = System.getenv("flcc_topN")) != null && (object5 = StringsKt.toIntOrNull((String)object5)) != null) {
                int n = ((Number)object5).intValue();
                boolean bl = false;
                this.settingsState.setUseTopN(true);
                this.settingsState.setTopN(n);
            }
            if ((object4 = System.getenv("flcc_stringsWalking")) != null && (object4 = StringsKt.toBooleanStrictOrNull((String)object4)) != null) {
                boolean bl = (Boolean)object4;
                boolean bl2 = false;
                this.settingsState.setStringsWalking(bl);
            }
            if ((object3 = System.getenv("flcc_showScore")) != null && (object3 = StringsKt.toBooleanStrictOrNull((String)object3)) != null) {
                boolean bl = (Boolean)object3;
                boolean bl3 = false;
                this.settingsState.setShowScore(bl);
            }
            if ((string = System.getenv("flcc_completionMode")) != null && (string = string.toString()) != null) {
                String string4 = string;
                boolean bl = false;
                this.settingsState.setCompletionMode(FullLineUXMode.valueOf(string4));
            }
            if ((object2 = System.getenv("flcc_abort_computation_after_ms")) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null) {
                int n = ((Number)object2).intValue();
                boolean bl = false;
                this.settingsState.setAbortComputationAfterMs(n);
            }
            if ((object = System.getenv("flcc_silent_computation_after_ms")) != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
                int n = ((Number)object).intValue();
                boolean bl = false;
                this.settingsState.setSilentComputationAfterMs(n);
            }
            String string5 = System.getenv("flcc_only_proposals");
            if (string5 != null) {
                it = string5;
                boolean bl = false;
                Registry.get((String)"full.line.only.proposals").setValue(Boolean.parseBoolean(it));
            }
            String string6 = System.getenv("flcc_caching");
            if (string6 != null) {
                it = string6;
                boolean bl = false;
                Registry.get((String)"full.line.enable.caching").setValue(Boolean.parseBoolean(it));
            }
            String string7 = System.getenv("flcc_all_language_eval");
            if (string7 != null) {
                String string8;
                String string9 = it = string7;
                boolean bl = false;
                String string10 = string8 = Intrinsics.areEqual((Object)StringsKt.toBooleanStrictOrNull((String)string9), (Object)true) ? it : null;
                if (string8 != null) {
                    String string11 = string8;
                    boolean bl4 = false;
                    Set<Map.Entry<String, LangState>> set = this.settingsState.getLangStates().entrySet();
                    Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
                    Iterable $this$forEach$iv = set;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Map.Entry entry = (Map.Entry)element$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)entry);
                        String langId = (String)entry.getKey();
                        LangState langState = (LangState)entry.getValue();
                        Intrinsics.checkNotNull((Object)langId);
                        Intrinsics.checkNotNull((Object)langState);
                        this.patchForEval(langId, langState);
                    }
                    return;
                }
            }
            String string12 = System.getenv("flcc_language");
            if (string12 == null) {
                return;
            }
            String evalLanguage = string12;
            Set<String> set = this.settingsState.getLangStates().keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Iterable $this$firstOrNull$iv = set;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it8 = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it8);
                String string13 = it8.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string13, (Object)evalLanguage)) continue;
                v18 = element$iv;
                break block21;
            }
            v18 = null;
        }
        String string = v18;
        if (string == null) {
            return;
        }
        String langId = string;
        LangState langState = (LangState)MapsKt.getValue((Map)this.settingsState.getLangStates(), (Object)langId);
        this.patchForEval(langId, langState);
    }

    private final void patchForEval(String langId, LangState langState) {
        block48: {
            Object object;
            int it;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            Object object13;
            Object object14;
            Object object15;
            Object object16;
            Object object17;
            Object object18;
            Object object19;
            Object object20;
            Object object21;
            Object object22;
            Object object23;
            Object object24;
            Object object25;
            Object object26;
            Object object27;
            Object object28;
            Object object29;
            Object object30;
            String string;
            String string2;
            String string3;
            String it2;
            Object object31;
            Object object32;
            String string4;
            Object object33;
            Object object34;
            boolean it3;
            Object object35 = System.getenv("flcc_enabled");
            if (object35 != null && (object35 = StringsKt.toBooleanStrictOrNull((String)object35)) != null) {
                it3 = (Boolean)object35;
                boolean bl = false;
                langState.setEnabled(it3);
            }
            if ((object34 = System.getenv("flcc_onlyFullLines")) != null && (object34 = StringsKt.toBooleanStrictOrNull((String)object34)) != null) {
                it3 = (Boolean)object34;
                boolean bl = false;
                langState.setOnlyFullLines(it3);
            }
            if ((object33 = System.getenv("flcc_checkIncorrectCode")) != null && (object33 = StringsKt.toBooleanStrictOrNull((String)object33)) != null) {
                it3 = (Boolean)object33;
                boolean bl = false;
                langState.setCheckIncorrectCode(it3);
            }
            if ((string4 = System.getenv("flcc_incorrectCodePolicy")) != null) {
                String string5;
                String it4 = string5 = string4;
                boolean bl = false;
                string4 = !StringsKt.isBlank((CharSequence)it4) ? string5 : null;
                if (string4 != null) {
                    it4 = string4;
                    boolean bl2 = false;
                    langState.setIncorrectCodePolicy(RedCodePolicy.valueOf(it4));
                }
            }
            if ((object32 = System.getenv("flcc_checkTriggerModel")) != null && (object32 = StringsKt.toBooleanStrictOrNull((String)object32)) != null) {
                boolean it5 = (Boolean)object32;
                boolean bl = false;
                langState.setTriggerModelEnabled(it5);
            }
            if ((object31 = System.getenv("flcc_checkFilterModel")) != null && (object31 = StringsKt.toBooleanStrictOrNull((String)object31)) != null) {
                boolean it6 = (Boolean)object31;
                boolean bl = false;
                langState.setFilterModelEnabled(it6);
            }
            String string6 = System.getenv("flcc_host");
            if (string6 != null) {
                String it7 = string6;
                boolean bl = false;
                String string7 = langId.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                Registry.get((String)("full.line.server.host." + string7)).setValue(it7);
            }
            Language language2 = Language.findLanguageByID((String)langId);
            if (language2 == null) {
                return;
            }
            Language language3 = language2;
            Object object36 = FullLineLanguageSupporter.Companion.getInstance(language3);
            if (object36 == null || (object36 = object36.getModelSettings()) == null) {
                return;
            }
            Object modelSettings = object36;
            String string8 = System.getenv("flcc_jvmModelVersion");
            if (string8 != null) {
                String string9;
                it2 = string9 = string8;
                boolean bl = false;
                string8 = !StringsKt.isBlank((CharSequence)it2) ? string9 : null;
                if (string8 != null) {
                    it2 = string8;
                    boolean bl3 = false;
                    ((ModelSettings)modelSettings).setJvmModelVersion(it2);
                }
            }
            if ((string3 = System.getenv("flcc_nativeModelVersion")) != null) {
                String string10;
                it2 = string10 = string3;
                boolean bl = false;
                string3 = !StringsKt.isBlank((CharSequence)it2) ? string10 : null;
                if (string3 != null) {
                    it2 = string3;
                    boolean bl4 = false;
                    ((ModelSettings)modelSettings).setNativeModelVersion(it2);
                }
            }
            if ((string2 = System.getenv("flcc_nativeLLaMAVersion")) != null) {
                String string11;
                it2 = string11 = string2;
                boolean bl = false;
                string2 = !StringsKt.isBlank((CharSequence)it2) ? string11 : null;
                if (string2 != null) {
                    it2 = string2;
                    boolean bl5 = false;
                    ((ModelSettings)modelSettings).setNativeLLaMAVersion(it2);
                }
            }
            if ((string = System.getenv("flcc_modelType")) != null) {
                String string12;
                it2 = string12 = string;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it2) ? string12 : null;
                if (string != null) {
                    it2 = string;
                    boolean bl6 = false;
                    ((ModelSettings)modelSettings).setModelType(ModelType.valueOf(it2));
                }
            }
            if ((object30 = System.getenv("flcc_numIterations")) != null && (object30 = StringsKt.toIntOrNull((String)object30)) != null) {
                int it8 = ((Number)object30).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).setNumIterations(it8);
            }
            if ((object29 = System.getenv("flcc_beamSize")) != null && (object29 = StringsKt.toIntOrNull((String)object29)) != null) {
                int it9 = ((Number)object29).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).setBeamSize(it9);
            }
            if ((object28 = System.getenv("flcc_lenPow")) != null && (object28 = StringsKt.toDoubleOrNull((String)object28)) != null) {
                double it10 = ((Number)object28).doubleValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).setLenPow(it10);
            }
            if ((object27 = System.getenv("flcc_lenBase")) != null && (object27 = StringsKt.toDoubleOrNull((String)object27)) != null) {
                double it11 = ((Number)object27).doubleValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).setLenBase(it11);
            }
            if ((object26 = System.getenv("flcc_useDynamicIterations")) != null && (object26 = StringsKt.toBooleanStrictOrNull((String)object26)) != null) {
                boolean it12 = (Boolean)object26;
                boolean bl = false;
                ((ModelSettings)modelSettings).setUseDynamicIterations(it12);
            }
            if ((object25 = System.getenv("flcc_ragEnabled")) != null && (object25 = StringsKt.toBooleanStrictOrNull((String)object25)) != null) {
                boolean it13 = (Boolean)object25;
                boolean bl = false;
                ((ModelSettings)modelSettings).setRagEnabled(it13);
            }
            if ((object24 = System.getenv("flcc_rag_minContextSize")) != null && (object24 = StringsKt.toIntOrNull((String)object24)) != null) {
                int it14 = ((Number)object24).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setMinContextSize(it14);
            }
            if ((object23 = System.getenv("flcc_rag_chunkByTokens")) != null && (object23 = StringsKt.toBooleanStrictOrNull((String)object23)) != null) {
                boolean it15 = (Boolean)object23;
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setChunkByTokens(it15);
            }
            if ((object22 = System.getenv("flcc_rag_maxChunksNumber")) != null && (object22 = StringsKt.toIntOrNull((String)object22)) != null) {
                int it16 = ((Number)object22).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setMaxChunksNumber(it16);
            }
            if ((object21 = System.getenv("flcc_rag_maxRagContextSize")) != null && (object21 = StringsKt.toIntOrNull((String)object21)) != null) {
                int it17 = ((Number)object21).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setMaxRagContextSize(it17);
            }
            if ((object20 = System.getenv("flcc_rag_chunkSize")) != null && (object20 = StringsKt.toIntOrNull((String)object20)) != null) {
                int it18 = ((Number)object20).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setChunkSize(it18);
            }
            if ((object19 = System.getenv("flcc_rag_chunkStride")) != null && (object19 = StringsKt.toIntOrNull((String)object19)) != null) {
                int it19 = ((Number)object19).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setChunkStride(it19);
            }
            if ((object18 = System.getenv("flcc_rag_dropLastChunk")) != null && (object18 = StringsKt.toBooleanStrictOrNull((String)object18)) != null) {
                boolean it20 = (Boolean)object18;
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setDropLastChunk(it20);
            }
            if ((object17 = System.getenv("flcc_rag_chunkContinuationSize")) != null && (object17 = StringsKt.toIntOrNull((String)object17)) != null) {
                int it21 = ((Number)object17).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setChunkContinuationSize(it21);
            }
            if ((object16 = System.getenv("flcc_rag_maxChunksToRetrieve")) != null && (object16 = StringsKt.toIntOrNull((String)object16)) != null) {
                int it22 = ((Number)object16).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setMaxChunksToRetrieve(it22);
            }
            if ((object15 = System.getenv("flcc_rag_dirTraversingLevel")) != null && (object15 = StringsKt.toIntOrNull((String)object15)) != null) {
                int it23 = ((Number)object15).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setDirTraversingLevel(it23);
            }
            if ((object14 = System.getenv("flcc_rag_filesTraversingLimit")) != null && (object14 = StringsKt.toIntOrNull((String)object14)) != null) {
                int it24 = ((Number)object14).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setFilesTraversingLimit(it24);
            }
            if ((object13 = System.getenv("flcc_rag_cacheSimilarityThreshold")) != null && (object13 = StringsKt.toDoubleOrNull((String)object13)) != null) {
                double it25 = ((Number)object13).doubleValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setCacheSimilarityThreshold(it25);
            }
            if ((object12 = System.getenv("flcc_rag_fromTheSameFile")) != null && (object12 = StringsKt.toBooleanStrictOrNull((String)object12)) != null) {
                boolean it26 = (Boolean)object12;
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setFromTheSameFile(it26);
            }
            if ((object11 = System.getenv("flcc_rag_chunksFilterThreshold")) != null && (object11 = StringsKt.toDoubleOrNull((String)object11)) != null) {
                double it27 = ((Number)object11).doubleValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setChunksFilterThreshold(it27);
            }
            if ((object10 = System.getenv("flcc_rag_addFilePaths")) != null && (object10 = StringsKt.toBooleanStrictOrNull((String)object10)) != null) {
                boolean it28 = (Boolean)object10;
                boolean bl = false;
                ((ModelSettings)modelSettings).getRagSettings().setAddFilePaths(it28);
            }
            if ((object9 = System.getenv("flcc_fimModel")) != null && (object9 = StringsKt.toBooleanStrictOrNull((String)object9)) != null) {
                boolean it29 = (Boolean)object9;
                boolean bl = false;
                ((ModelSettings)modelSettings).setFimModel(it29);
            }
            if ((object8 = System.getenv("flcc_fim_minSuffixLength")) != null && (object8 = StringsKt.toIntOrNull((String)object8)) != null) {
                int it30 = ((Number)object8).intValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getFimSettings().setMinSuffixLength(it30);
            }
            if ((object7 = System.getenv("flcc_fim_maxSuffixFraction")) != null && (object7 = StringsKt.toDoubleOrNull((String)object7)) != null) {
                double it31 = ((Number)object7).doubleValue();
                boolean bl = false;
                ((ModelSettings)modelSettings).getFimSettings().setMaxSuffixFraction(it31);
            }
            if ((object6 = System.getenv("flcc_cacheRatio")) != null && (object6 = StringsKt.toDoubleOrNull((String)object6)) != null) {
                double it32 = ((Number)object6).doubleValue();
                boolean bl = false;
                this.settingsState.setCacheRatio((float)it32);
            }
            if ((object5 = System.getenv("flcc_minCached")) != null && (object5 = StringsKt.toIntOrNull((String)object5)) != null) {
                int it33 = ((Number)object5).intValue();
                boolean bl = false;
                this.settingsState.setMinCached(it33);
            }
            if ((object4 = System.getenv("flcc_maxMissing")) != null && (object4 = StringsKt.toIntOrNull((String)object4)) != null) {
                int it34 = ((Number)object4).intValue();
                boolean bl = false;
                this.settingsState.setMaxMissing(it34);
            }
            if ((object3 = System.getenv("flcc_maxModelCtx")) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null) {
                int it35 = ((Number)object3).intValue();
                boolean bl = false;
                this.settingsState.setMaxModelCtx(it35);
            }
            if ((object2 = FullLineLanguageSupporter.Companion.getInstance(language3)) == null || (object2 = object2.getLanguageSettings()) == null) {
                return;
            }
            Object languageSettings = object2;
            FullLineLanguageSettings.InlineDebouncePolicy inlineDebouncePolicy = ((FullLineLanguageSettings)languageSettings).getInlineDebouncePolicy();
            Object object37 = System.getenv("flcc_debounce_delayBeforeInvocation");
            if (object37 != null && (object37 = StringsKt.toIntOrNull((String)object37)) != null) {
                it = ((Number)object37).intValue();
                boolean bl = false;
                inlineDebouncePolicy.setDelayBeforeInvocationMs(it);
            }
            if ((object = System.getenv("flcc_debounce_minTimeToShow")) == null || (object = StringsKt.toIntOrNull((String)object)) == null) break block48;
            it = ((Number)object).intValue();
            boolean bl = false;
            inlineDebouncePolicy.setMinTimeToShowMs(it);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/completion/full/line/settings/FullLineSettings$CacheSettings;", "", "cacheRatio", "", "minCached", "", "maxMissing", "maxModelCtx", "(FIII)V", "getCacheRatio", "()F", "getMaxMissing", "()I", "getMaxModelCtx", "getMinCached", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.fullLine.core"})
    public static final class CacheSettings {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final float cacheRatio;
        private final int minCached;
        private final int maxMissing;
        private final int maxModelCtx;
        @NotNull
        private static final CacheSettings DEFAULT = new CacheSettings(0.5f, 5, 30, 0);

        public CacheSettings(float cacheRatio, int minCached, int maxMissing, int maxModelCtx) {
            this.cacheRatio = cacheRatio;
            this.minCached = minCached;
            this.maxMissing = maxMissing;
            this.maxModelCtx = maxModelCtx;
        }

        public final float getCacheRatio() {
            return this.cacheRatio;
        }

        public final int getMinCached() {
            return this.minCached;
        }

        public final int getMaxMissing() {
            return this.maxMissing;
        }

        public final int getMaxModelCtx() {
            return this.maxModelCtx;
        }

        public final float component1() {
            return this.cacheRatio;
        }

        public final int component2() {
            return this.minCached;
        }

        public final int component3() {
            return this.maxMissing;
        }

        public final int component4() {
            return this.maxModelCtx;
        }

        @NotNull
        public final CacheSettings copy(float cacheRatio, int minCached, int maxMissing, int maxModelCtx) {
            return new CacheSettings(cacheRatio, minCached, maxMissing, maxModelCtx);
        }

        public static /* synthetic */ CacheSettings copy$default(CacheSettings cacheSettings, float f, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                f = cacheSettings.cacheRatio;
            }
            if ((n4 & 2) != 0) {
                n = cacheSettings.minCached;
            }
            if ((n4 & 4) != 0) {
                n2 = cacheSettings.maxMissing;
            }
            if ((n4 & 8) != 0) {
                n3 = cacheSettings.maxModelCtx;
            }
            return cacheSettings.copy(f, n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "CacheSettings(cacheRatio=" + this.cacheRatio + ", minCached=" + this.minCached + ", maxMissing=" + this.maxMissing + ", maxModelCtx=" + this.maxModelCtx + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.cacheRatio);
            result = result * 31 + Integer.hashCode(this.minCached);
            result = result * 31 + Integer.hashCode(this.maxMissing);
            result = result * 31 + Integer.hashCode(this.maxModelCtx);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheSettings)) {
                return false;
            }
            CacheSettings cacheSettings = (CacheSettings)other;
            if (Float.compare(this.cacheRatio, cacheSettings.cacheRatio) != 0) {
                return false;
            }
            if (this.minCached != cacheSettings.minCached) {
                return false;
            }
            if (this.maxMissing != cacheSettings.maxMissing) {
                return false;
            }
            return this.maxModelCtx == cacheSettings.maxModelCtx;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/completion/full/line/settings/FullLineSettings$CacheSettings$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/completion/full/line/settings/FullLineSettings$CacheSettings;", "getDEFAULT", "()Lorg/jetbrains/completion/full/line/settings/FullLineSettings$CacheSettings;", "fromSettings", "state", "Lorg/jetbrains/completion/full/line/settings/GeneralState;", "intellij.fullLine.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CacheSettings fromSettings(@NotNull GeneralState state) {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                return new CacheSettings(state.getCacheRatio(), state.getMinCached(), state.getMaxMissing(), state.getMaxModelCtx());
            }

            @NotNull
            public final CacheSettings getDEFAULT() {
                return DEFAULT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/completion/full/line/settings/FullLineSettings$Companion;", "", "()V", "availableLanguages", "", "Lcom/intellij/lang/Language;", "getAvailableLanguages", "()Ljava/util/List;", "availableLanguagesWithModel", "getAvailableLanguagesWithModel", "getInstance", "Lorg/jetbrains/completion/full/line/settings/FullLineSettings;", "intellij.fullLine.core"})
    @SourceDebugExtension(value={"SMAP\nFullLineSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineSettings.kt\norg/jetbrains/completion/full/line/settings/FullLineSettings$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n42#2,3:243\n1603#3,9:246\n1855#3:255\n1856#3:257\n1612#3:258\n1603#3,9:259\n1855#3:268\n1856#3:270\n1612#3:271\n1#4:256\n1#4:269\n*S KotlinDebug\n*F\n+ 1 FullLineSettings.kt\norg/jetbrains/completion/full/line/settings/FullLineSettings$Companion\n*L\n39#1:243,3\n43#1:246,9\n43#1:255\n43#1:257\n43#1:258\n46#1:259,9\n46#1:268\n46#1:270\n46#1:271\n43#1:256\n46#1:269\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FullLineSettings getInstance() {
            boolean $i$f$service = false;
            Class<FullLineSettings> serviceClass$iv = FullLineSettings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (FullLineSettings)object;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Language> getAvailableLanguagesWithModel() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = FullLineLanguageSupporter.Companion.supportedLanguagesWithModel();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Language it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (Language.findLanguageByID((String)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Language> getAvailableLanguages() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = FullLineLanguageSupporter.Companion.supportedLanguages();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Language it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (Language.findLanguageByID((String)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

