/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.relevance;

import com.intellij.internal.ml.DecisionFunction;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.CoreUtilsKt;
import org.jetbrains.completion.full.line.FullLineParams;
import org.jetbrains.completion.full.line.relevance.FullLineFeaturesProvider;
import org.jetbrains.completion.full.line.relevance.FullLineRelevanceModelProvider;
import org.jetbrains.completion.full.line.relevance.RelevanceModelResponse;
import org.jetbrains.completion.full.line.relevance.RelevanceModelService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0004H$J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\u0014H$\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/completion/full/line/relevance/RelevanceModelServiceImpl;", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelService;", "()V", "completionProbabilityRegistryKey", "", "getCompletionProbabilityRegistryKey", "()Ljava/lang/String;", "featuresProvider", "Lorg/jetbrains/completion/full/line/relevance/FullLineFeaturesProvider;", "getFeaturesProvider", "()Lorg/jetbrains/completion/full/line/relevance/FullLineFeaturesProvider;", "modelProvider", "Lorg/jetbrains/completion/full/line/relevance/FullLineRelevanceModelProvider;", "getModelProvider", "()Lorg/jetbrains/completion/full/line/relevance/FullLineRelevanceModelProvider;", "getModel", "Lcom/intellij/internal/ml/DecisionFunction;", "parameters", "Lorg/jetbrains/completion/full/line/FullLineParams;", "getScore", "", "(Lorg/jetbrains/completion/full/line/FullLineParams;)Ljava/lang/Double;", "getStagingModel", "languageId", "getStagingThreshold", "()Ljava/lang/Double;", "getThreshold", "requestModel", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "Companion", "intellij.fullLine.core"})
@SourceDebugExtension(value={"SMAP\nRelevanceModelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelevanceModelService.kt\norg/jetbrains/completion/full/line/relevance/RelevanceModelServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n9#2:68\n*S KotlinDebug\n*F\n+ 1 RelevanceModelService.kt\norg/jetbrains/completion/full/line/relevance/RelevanceModelServiceImpl\n*L\n65#1:68\n*E\n"})
public abstract class RelevanceModelServiceImpl
implements RelevanceModelService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;

    @Override
    @NotNull
    public RelevanceModelResponse requestModel(@NotNull FullLineParams parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Double d = this.getScore(parameters);
        if (d == null) {
            return RelevanceModelResponse.Companion.getUNAVAILABLE();
        }
        double score = d;
        return new RelevanceModelResponse(score, CoreUtilsKt.randomPass(this.getCompletionProbabilityRegistryKey()) ? RelevanceModelResponse.Decision.RANDOM_PASS : (score >= this.getThreshold() ? RelevanceModelResponse.Decision.PASS : RelevanceModelResponse.Decision.SKIP));
    }

    private final Double getScore(FullLineParams parameters) {
        DecisionFunction model = this.getModel(parameters);
        FullLineFeaturesProvider fullLineFeaturesProvider = this.getFeaturesProvider();
        FeatureMapper[] featureMapperArray = model.getFeaturesOrder();
        Intrinsics.checkNotNullExpressionValue((Object)featureMapperArray, (String)"getFeaturesOrder(...)");
        double[] features2 = fullLineFeaturesProvider.getFeatures(parameters, featureMapperArray);
        if (features2 == null) {
            LOG.debug("Could not initialize features");
            return null;
        }
        double score = model.predict(features2);
        LOG.debug("Model score is " + score);
        return score;
    }

    private final double getThreshold() {
        Double stagingThreshold = this.getStagingThreshold();
        if (stagingThreshold != null) {
            return stagingThreshold;
        }
        return this.getModelProvider().getThreshold();
    }

    private final DecisionFunction getModel(FullLineParams parameters) {
        String string = parameters.getOriginalFile().getLanguage().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        DecisionFunction stagingModel = this.getStagingModel(string);
        if (stagingModel != null) {
            return stagingModel;
        }
        return this.getModelProvider().getModel();
    }

    @Nullable
    protected abstract DecisionFunction getStagingModel(@NotNull String var1);

    @Nullable
    protected abstract Double getStagingThreshold();

    @NotNull
    protected abstract String getCompletionProbabilityRegistryKey();

    @NotNull
    protected abstract FullLineRelevanceModelProvider getModelProvider();

    @NotNull
    protected abstract FullLineFeaturesProvider getFeaturesProvider();

    @NotNull
    protected static final Logger getLOG() {
        return Companion.getLOG();
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/completion/full/line/relevance/RelevanceModelServiceImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.fullLine.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        protected static /* synthetic */ void getLOG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

