/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.python.supporters;

import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonLexer;
import com.jetbrains.python.lexer.PythonLexerKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.enclosure.FullLineEnclosures;
import org.jetbrains.completion.full.line.language.enclosure.FullLineEnclosuresLexerAdapter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/completion/full/line/python/supporters/PythonEnclosuresLexer;", "Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosuresLexerAdapter;", "enclosures", "Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosures;", "(Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosures;)V", "createBaseLexer", "Lcom/intellij/lexer/Lexer;", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosuresLexerAdapter$EnclosuresCollector;", "intellij.fullLine.python"})
@SourceDebugExtension(value={"SMAP\nPythonEnclosuresLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonEnclosuresLexer.kt\norg/jetbrains/completion/full/line/python/supporters/PythonEnclosuresLexer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,58:1\n151#2,6:59\n*S KotlinDebug\n*F\n+ 1 PythonEnclosuresLexer.kt\norg/jetbrains/completion/full/line/python/supporters/PythonEnclosuresLexer\n*L\n26#1:59,6\n*E\n"})
public final class PythonEnclosuresLexer
extends FullLineEnclosuresLexerAdapter {
    public PythonEnclosuresLexer(@NotNull FullLineEnclosures enclosures) {
        Intrinsics.checkNotNullParameter((Object)enclosures, (String)"enclosures");
        super(enclosures);
    }

    @Override
    @NotNull
    protected Lexer createBaseLexer() {
        return (Lexer)new PythonLexer(PythonLexerKind.CONSOLE);
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text, int offset, @NotNull FullLineEnclosuresLexerAdapter.EnclosuresCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        if (((CharSequence)text).length() == 0) {
            return;
        }
        if (PyTokenTypes.ALL_BRACES.contains(token)) {
            collector2.bracket(StringsKt.first((CharSequence)text), offset);
            return;
        }
        IElementType iElementType = token;
        if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.SINGLE_QUOTED_STRING)) {
            int quoteIndex;
            block17: {
                int n;
                CharSequence $this$indexOfFirst$iv = text;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    char it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!this.getEnclosures().isStringMarker(it)) continue;
                    n = index$iv;
                    break block17;
                }
                n = quoteIndex = -1;
            }
            if (quoteIndex != -1) {
                char quote = text.charAt(quoteIndex);
                String string = text.substring(0, quoteIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collector2.stringMarker(quote, offset + quoteIndex, string);
                if (quoteIndex + 1 != text.length() && quote == StringsKt.last((CharSequence)text)) {
                    FullLineEnclosuresLexerAdapter.EnclosuresCollector.stringMarker$default(collector2, quote, offset + text.length() - 1, null, 4, null);
                }
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_START)) {
            if (this.getEnclosures().isStringMarker(StringsKt.last((CharSequence)text))) {
                char c = StringsKt.last((CharSequence)text);
                int n = offset + text.length() - 1;
                String string = text.substring(0, 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collector2.stringMarker(c, n, string);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_END)) {
            if (this.getEnclosures().isStringMarker(StringsKt.first((CharSequence)text))) {
                FullLineEnclosuresLexerAdapter.EnclosuresCollector.stringMarker$default(collector2, StringsKt.first((CharSequence)text), offset, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_FRAGMENT_START)) {
            if (this.getEnclosures().isOpenBracket(StringsKt.first((CharSequence)text))) {
                FullLineEnclosuresLexerAdapter.EnclosuresCollector.stringTemplate$default(collector2, StringsKt.first((CharSequence)text), offset, null, 4, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.FSTRING_FRAGMENT_END) && this.getEnclosures().isCloseBracket(StringsKt.first((CharSequence)text))) {
            FullLineEnclosuresLexerAdapter.EnclosuresCollector.stringTemplate$default(collector2, StringsKt.first((CharSequence)text), offset, null, 4, null);
        }
    }
}

