/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.python.formatters;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingLexer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.python.formatters.PyIntendToScopeFormatter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u00132\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/completion/full/line/python/formatters/PyIntendToScopeFormatter;", "", "scopeIn", "", "scopeOut", "tempSuffix", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "curLineIndent", "", "lexer", "Lcom/jetbrains/python/lexer/PythonIndentingLexer;", "tokens", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "formatDocstring", "text", "formatIntents", "formatted", "handleLexerToken", "", "handleToken", "pair", "Lkotlin/Pair;", "Lcom/intellij/psi/tree/IElementType;", "removeIntents", "data", "tabSize", "", "intellij.fullLine.python"})
@SourceDebugExtension(value={"SMAP\nPyIntendToScopeFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyIntendToScopeFormatter.kt\norg/jetbrains/completion/full/line/python/formatters/PyIntendToScopeFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n777#2:114\n788#2:115\n1864#2,2:116\n789#2,2:118\n1866#2:120\n791#2:121\n1855#2,2:122\n*S KotlinDebug\n*F\n+ 1 PyIntendToScopeFormatter.kt\norg/jetbrains/completion/full/line/python/formatters/PyIntendToScopeFormatter\n*L\n69#1:114\n69#1:115\n69#1:116,2\n69#1:118,2\n69#1:120\n69#1:121\n80#1:122,2\n*E\n"})
public final class PyIntendToScopeFormatter {
    @NotNull
    private final String scopeIn;
    @NotNull
    private final String scopeOut;
    @NotNull
    private final String tempSuffix;
    @NotNull
    private final PythonIndentingLexer lexer;
    @NotNull
    private final StringBuilder tokens;
    private int curLineIndent;

    public PyIntendToScopeFormatter(@NotNull String scopeIn, @NotNull String scopeOut, @NotNull String tempSuffix) {
        Intrinsics.checkNotNullParameter((Object)scopeIn, (String)"scopeIn");
        Intrinsics.checkNotNullParameter((Object)scopeOut, (String)"scopeOut");
        Intrinsics.checkNotNullParameter((Object)tempSuffix, (String)"tempSuffix");
        this.scopeIn = scopeIn;
        this.scopeOut = scopeOut;
        this.tempSuffix = tempSuffix;
        this.lexer = new PythonIndentingLexer();
        this.tokens = new StringBuilder();
    }

    public /* synthetic */ PyIntendToScopeFormatter(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = "\u20b7";
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String formatIntents(@NotNull String formatted) {
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        this.lexer.start((CharSequence)(formatted + this.tempSuffix));
        while (this.lexer.getTokenType() != null) {
            IElementType tokenType = this.lexer.getTokenType();
            if (Intrinsics.areEqual((Object)tokenType, (Object)PyTokenTypes.LINE_BREAK)) {
                this.lexer.advance();
                if (Intrinsics.areEqual((Object)this.lexer.getTokenType(), (Object)PyTokenTypes.INDENT)) {
                    this.handleToken((Pair<String, ? extends IElementType>)TuplesKt.to((Object)this.scopeIn, (Object)PyTokenTypes.INDENT));
                } else if (this.lexer.getTokenType() != null) {
                    this.handleToken((Pair<String, ? extends IElementType>)TuplesKt.to((Object)"\n", (Object)tokenType));
                    this.handleLexerToken();
                }
            } else {
                this.handleLexerToken();
            }
            this.lexer.advance();
        }
        String string = this.tokens.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return StringsKt.removeSuffix((String)string, (CharSequence)this.tempSuffix);
    }

    private final void handleToken(Pair<String, ? extends IElementType> pair2) {
        String tokenText = (String)pair2.component1();
        IElementType tokenType = (IElementType)pair2.component2();
        IElementType iElementType = tokenType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.LINE_BREAK)) {
            this.tokens.append("\n");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.INDENT)) {
            int n = this.curLineIndent;
            this.curLineIndent = n + 1;
            this.tokens.append(this.scopeIn);
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.DOCSTRING) ? true : Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.TRIPLE_QUOTED_UNICODE)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.TRIPLE_QUOTED_STRING)) {
            String string = this.lexer.getTokenText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
            this.tokens.append(this.formatDocstring(string));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)PyTokenTypes.DEDENT)) {
            int n = this.curLineIndent;
            this.curLineIndent = n + -1;
            this.tokens.append(this.scopeOut);
            this.lexer.advance();
            if (!Intrinsics.areEqual((Object)this.lexer.getTokenType(), (Object)PyTokenTypes.LINE_BREAK)) {
                this.handleLexerToken();
            }
        } else {
            this.tokens.append(tokenText);
        }
    }

    private final void handleLexerToken() {
        this.handleToken((Pair<String, ? extends IElementType>)TuplesKt.to((Object)this.lexer.getTokenText(), (Object)this.lexer.getTokenType()));
    }

    private final String formatDocstring(String text) {
        return CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)text), (CharSequence)"\n", null, null, (int)0, null, (Function1)formatDocstring.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String removeIntents(String data, double tabSize) {
        void $this$filterIndexedTo$iv$iv;
        List it = StringsKt.lines((CharSequence)data);
        boolean $i$a$-let-PyIntendToScopeFormatter$removeIntents$contentLines$22 = false;
        Iterable $this$filterIndexed$iv = it;
        boolean $i$f$filterIndexed = false;
        Iterable iterable = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void s;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            String string = (String)element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if (!(!StringsKt.isBlank((CharSequence)((CharSequence)s)) || index == it.size() - 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List contentLines = (List)destination$iv$iv;
        if (contentLines.isEmpty()) {
            return "";
        }
        double prevIndentLevel = 0.0;
        if (!Intrinsics.areEqual((Object)((Object)StringsKt.trimStart((CharSequence)((String)CollectionsKt.first((List)contentLines)))).toString(), (Object)CollectionsKt.first((List)contentLines))) {
            return "";
        }
        Object[] $i$a$-let-PyIntendToScopeFormatter$removeIntents$contentLines$22 = new String[]{CollectionsKt.first((List)contentLines)};
        List lines = CollectionsKt.mutableListOf((Object[])$i$a$-let-PyIntendToScopeFormatter$removeIntents$contentLines$22);
        Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)contentLines, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line2 = (String)element$iv;
            boolean bl = false;
            String stripped_line = ((Object)StringsKt.trimStart((CharSequence)line2)).toString();
            double cur_indent_level = (double)(line2.length() - stripped_line.length()) / tabSize;
            double indent_change = cur_indent_level - prevIndentLevel;
            if (indent_change == 0.0) {
                lines.add("\n");
            } else if (indent_change == 1.0) {
                lines.add(this.scopeIn);
            } else if (indent_change < 0.0 && indent_change == (double)((int)indent_change)) {
                lines.add(StringsKt.repeat((CharSequence)this.scopeOut, (int)(-((int)indent_change))));
            } else if (indent_change > 0.0) {
                lines.add(this.scopeIn);
            } else if (indent_change < 0.0) {
                lines.add(this.scopeOut);
            } else {
                throw new IllegalArgumentException("Unexpected intent change `" + indent_change + "`.");
            }
            lines.add(stripped_line);
            prevIndentLevel = cur_indent_level;
        }
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }
}

