/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.request.analyzer;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ml.impl.correctness.checker.CorrectnessChecker;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.AnalyzedFullLineProposal;
import org.jetbrains.completion.full.line.RawFullLineProposal;
import org.jetbrains.completion.full.line.analyzer.CorrectnessAnalysisState;
import org.jetbrains.completion.full.line.analyzer.TextProposalsAnalyzer;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupportHolder;
import org.jetbrains.completion.full.line.platform.diagnostics.adapters.providers.ProvidersDiagnosticCallback;
import org.jetbrains.completion.full.line.settings.FullLineSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/analyzer/SingleLineSuggestionAnalyzer;", "Lorg/jetbrains/completion/full/line/analyzer/TextProposalsAnalyzer;", "holder", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "prefix", "", "diagnostic", "Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/providers/ProvidersDiagnosticCallback;", "(Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;Lcom/intellij/psi/PsiFile;ILjava/lang/String;Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/providers/ProvidersDiagnosticCallback;)V", "getSuffix", "proposal", "Lorg/jetbrains/completion/full/line/RawFullLineProposal;", "onAnalysisCompleted", "", "raw", "analyzed", "Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;", "runExpensiveAnalysis", "intellij.fullLine"})
public abstract class SingleLineSuggestionAnalyzer
implements TextProposalsAnalyzer {
    @NotNull
    private final FullLineLanguageSupportHolder holder;
    @NotNull
    private final PsiFile file;
    private final int offset;
    @NotNull
    private final String prefix;
    @NotNull
    private final ProvidersDiagnosticCallback diagnostic;

    public SingleLineSuggestionAnalyzer(@NotNull FullLineLanguageSupportHolder holder, @NotNull PsiFile file2, int offset, @NotNull String prefix2, @NotNull ProvidersDiagnosticCallback diagnostic) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        this.holder = holder;
        this.file = file2;
        this.offset = offset;
        this.prefix = prefix2;
        this.diagnostic = diagnostic;
    }

    @NotNull
    protected abstract String getSuffix(@NotNull RawFullLineProposal var1);

    @Override
    @NotNull
    public AnalyzedFullLineProposal runExpensiveAnalysis(@NotNull RawFullLineProposal proposal) {
        CorrectnessAnalysisState correctnessAnalysisState;
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        Project project = this.file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DumbService.Companion.isDumb(project) && FullLineSettings.Companion.getInstance().checkIncorrectCode(this.holder.getLanguage())) {
            CorrectnessChecker.CheckResult checkResult = this.holder.getSupporter().getCorrectnessChecker().checkSemantic(this.file, proposal.getSuggestion(), this.offset, this.prefix, proposal.getDetails().getMatchedEnclosuresIndices());
            correctnessAnalysisState = new CorrectnessAnalysisState.Analyzed(checkResult);
        } else {
            correctnessAnalysisState = CorrectnessAnalysisState.Unknown.INSTANCE;
        }
        CorrectnessAnalysisState correctnessAnalysisState2 = correctnessAnalysisState;
        return new AnalyzedFullLineProposal(proposal, this.getSuffix(proposal), correctnessAnalysisState2);
    }

    @Override
    public void onAnalysisCompleted(@NotNull RawFullLineProposal raw, @NotNull AnalyzedFullLineProposal analyzed2) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)analyzed2, (String)"analyzed");
        this.diagnostic.proposalAnalyzed(raw, analyzed2);
    }
}

