/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.request.analyzer;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.FullLineProposalsContext;
import org.jetbrains.completion.full.line.RawFullLineProposal;
import org.jetbrains.completion.full.line.language.enclosure.EnclosureLexeme;
import org.jetbrains.completion.full.line.language.enclosure.EnclosuresUtilsKt;
import org.jetbrains.completion.full.line.language.enclosure.FullLineEnclosuresLexerKt;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupportHolder;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.platform.diagnostics.adapters.providers.ProvidersDiagnosticCallback;
import org.jetbrains.completion.full.line.platform.request.analyzer.SingleLineSuggestionAnalyzer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/analyzer/InlineSuggestionAnalyzer;", "Lorg/jetbrains/completion/full/line/platform/request/analyzer/SingleLineSuggestionAnalyzer;", "holder", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "prefix", "", "diagnostic", "Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/providers/ProvidersDiagnosticCallback;", "(Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Document;ILjava/lang/String;Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/providers/ProvidersDiagnosticCallback;)V", "looseClosingBrackets", "", "", "getLooseClosingBrackets", "()Ljava/util/List;", "looseClosingBrackets$delegate", "Lkotlin/Lazy;", "proposalsContext", "Lorg/jetbrains/completion/full/line/FullLineProposalsContext;", "supporter", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupporter;", "getSuffix", "proposal", "Lorg/jetbrains/completion/full/line/RawFullLineProposal;", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nInlineSuggestionAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineSuggestionAnalyzer.kt\norg/jetbrains/completion/full/line/platform/request/analyzer/InlineSuggestionAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n959#2,7:64\n*S KotlinDebug\n*F\n+ 1 InlineSuggestionAnalyzer.kt\norg/jetbrains/completion/full/line/platform/request/analyzer/InlineSuggestionAnalyzer\n*L\n56#1:64,7\n*E\n"})
public final class InlineSuggestionAnalyzer
extends SingleLineSuggestionAnalyzer {
    private final int offset;
    @NotNull
    private final FullLineLanguageSupporter supporter;
    @NotNull
    private final FullLineProposalsContext proposalsContext;
    @NotNull
    private final Lazy looseClosingBrackets$delegate;

    public InlineSuggestionAnalyzer(@NotNull FullLineLanguageSupportHolder holder, @NotNull PsiFile file2, @NotNull Document document, int offset, @NotNull String prefix2, @NotNull ProvidersDiagnosticCallback diagnostic) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        super(holder, file2, offset, prefix2, diagnostic);
        this.offset = offset;
        this.supporter = holder.getSupporter();
        this.proposalsContext = FullLineProposalsContext.Companion.invoke(this.supporter, document, this.offset, file2, prefix2);
        this.looseClosingBrackets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<Character>>(this){
            final /* synthetic */ InlineSuggestionAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Character> invoke() {
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv = EnclosuresUtilsKt.findBalanceBreakAware(FullLineEnclosuresLexerKt.brackets(InlineSuggestionAnalyzer.access$getProposalsContext$p(this.this$0).getEnclosuresBeforeOffset()), InlineSuggestionAnalyzer.access$getSupporter$p(this.this$0).getEnclosures());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    EnclosureLexeme enclosureLexeme = (EnclosureLexeme)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Character.valueOf(it.getSym()));
                }
                List unbalancedBracketsBeforeOffset = (List)destination$iv$iv;
                Iterable $this$map$iv2 = EnclosuresUtilsKt.findUnbalancedClosed(FullLineEnclosuresLexerKt.brackets(InlineSuggestionAnalyzer.access$getProposalsContext$p(this.this$0).getEnclosuresAfterOffset()), InlineSuggestionAnalyzer.access$getSupporter$p(this.this$0).getEnclosures());
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    EnclosureLexeme bl = (EnclosureLexeme)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(Character.valueOf(it.getSym()));
                }
                List unbalancedBracketsAfterOffset = (List)destination$iv$iv2;
                List result = CollectionsKt.toMutableList((Collection)unbalancedBracketsAfterOffset);
                Iterator<E> iterator2 = unbalancedBracketsBeforeOffset.iterator();
                while (iterator2.hasNext()) {
                    char bracket;
                    Character c = InlineSuggestionAnalyzer.access$getSupporter$p(this.this$0).getEnclosures().getCloseToOpenBrackets().get(CollectionsKt.lastOrNull((List)result));
                    if (c == null || (bracket = ((Character)iterator2.next()).charValue()) != c.charValue()) continue;
                    CollectionsKt.removeLast((List)result);
                }
                return result;
            }
        }));
    }

    private final List<Character> getLooseClosingBrackets() {
        Lazy lazy = this.looseClosingBrackets$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    protected String getSuffix(@NotNull RawFullLineProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        List<Character> list2 = this.supporter.getMissingBraces(this.proposalsContext, proposal);
        if (list2 == null) {
            return "";
        }
        List<Character> missingBrackets = list2;
        Set<Integer> set = proposal.getDetails().getMatchedEnclosuresIndices();
        int matchedEnclosuresCnt = set != null ? set.size() : 0;
        List notOpenedBrackets = CollectionsKt.drop((Iterable)this.getLooseClosingBrackets(), (int)matchedEnclosuresCnt);
        Iterable $this$takeWhile$iv = CollectionsKt.zip((Iterable)CollectionsKt.reversed((Iterable)notOpenedBrackets), (Iterable)CollectionsKt.reversed((Iterable)missingBrackets));
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            char missing;
            Pair pair2 = (Pair)item$iv;
            boolean bl = false;
            char notOpened = ((Character)pair2.component1()).charValue();
            if (!(notOpened == (missing = ((Character)pair2.component2()).charValue()))) break;
            list$iv.add(item$iv);
        }
        List matchedWithLineAfter = list$iv;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast(missingBrackets, (int)matchedWithLineAfter.size()), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    public static final /* synthetic */ FullLineProposalsContext access$getProposalsContext$p(InlineSuggestionAnalyzer $this) {
        return $this.proposalsContext;
    }

    public static final /* synthetic */ FullLineLanguageSupporter access$getSupporter$p(InlineSuggestionAnalyzer $this) {
        return $this.supporter;
    }
}

