/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.request;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.AnalyzedFullLineProposal;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/RequestsCache;", "", "()V", "stateProvider", "Lorg/jetbrains/completion/full/line/platform/request/RequestsCache$CacheStateProvider;", "getOrInitializeCache", "", "Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "CacheKey", "CacheState", "CacheStateProvider", "intellij.fullLine"})
public final class RequestsCache {
    @NotNull
    private CacheStateProvider stateProvider = new CacheStateProvider();

    @NotNull
    public final List<AnalyzedFullLineProposal> getOrInitializeCache(@NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!Registry.is((String)"full.line.enable.caching")) {
            return new ArrayList();
        }
        CacheState state = this.stateProvider.forKey(new CacheKey(document, offset));
        return state.getProposals();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/RequestsCache$CacheKey;", "", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "(Lcom/intellij/openapi/editor/Document;I)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getOffset", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.fullLine"})
    private static final class CacheKey {
        @NotNull
        private final Document document;
        private final int offset;

        public CacheKey(@NotNull Document document, int offset) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            this.document = document;
            this.offset = offset;
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final Document component1() {
            return this.document;
        }

        public final int component2() {
            return this.offset;
        }

        @NotNull
        public final CacheKey copy(@NotNull Document document, int offset) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return new CacheKey(document, offset);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, Document document, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                document = cacheKey.document;
            }
            if ((n2 & 2) != 0) {
                n = cacheKey.offset;
            }
            return cacheKey.copy(document, n);
        }

        @NotNull
        public String toString() {
            return "CacheKey(document=" + this.document + ", offset=" + this.offset + ")";
        }

        public int hashCode() {
            int result = this.document.hashCode();
            result = result * 31 + Integer.hashCode(this.offset);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)other;
            if (!Intrinsics.areEqual((Object)this.document, (Object)cacheKey.document)) {
                return false;
            }
            return this.offset == cacheKey.offset;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/RequestsCache$CacheState;", "", "key", "Lorg/jetbrains/completion/full/line/platform/request/RequestsCache$CacheKey;", "(Lorg/jetbrains/completion/full/line/platform/request/RequestsCache$CacheKey;)V", "isValid", "", "()Z", "getKey", "()Lorg/jetbrains/completion/full/line/platform/request/RequestsCache$CacheKey;", "lastModificationStamp", "", "proposals", "", "Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;", "getProposals", "()Ljava/util/List;", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.fullLine"})
    private static final class CacheState {
        @NotNull
        private final CacheKey key;
        private final long lastModificationStamp;
        @NotNull
        private final List<AnalyzedFullLineProposal> proposals;

        public CacheState(@NotNull CacheKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.lastModificationStamp = this.key.getDocument().getModificationStamp();
            this.proposals = new ArrayList();
        }

        @NotNull
        public final CacheKey getKey() {
            return this.key;
        }

        @NotNull
        public final List<AnalyzedFullLineProposal> getProposals() {
            return this.proposals;
        }

        public final boolean isValid() {
            return this.key.getDocument().getModificationStamp() == this.lastModificationStamp;
        }

        @NotNull
        public final CacheKey component1() {
            return this.key;
        }

        @NotNull
        public final CacheState copy(@NotNull CacheKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new CacheState(key);
        }

        public static /* synthetic */ CacheState copy$default(CacheState cacheState, CacheKey cacheKey, int n, Object object) {
            if ((n & 1) != 0) {
                cacheKey = cacheState.key;
            }
            return cacheState.copy(cacheKey);
        }

        @NotNull
        public String toString() {
            return "CacheState(key=" + this.key + ")";
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheState)) {
                return false;
            }
            CacheState cacheState = (CacheState)other;
            return Intrinsics.areEqual((Object)this.key, (Object)cacheState.key);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/RequestsCache$CacheStateProvider;", "", "()V", "state", "Lorg/jetbrains/completion/full/line/platform/request/RequestsCache$CacheState;", "forKey", "key", "Lorg/jetbrains/completion/full/line/platform/request/RequestsCache$CacheKey;", "intellij.fullLine"})
    private static final class CacheStateProvider {
        @Nullable
        private CacheState state;

        @NotNull
        public final CacheState forKey(@NotNull CacheKey key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            CacheState currentState = this.state;
            if (currentState == null || !Intrinsics.areEqual((Object)currentState.getKey(), (Object)key) || !currentState.isValid()) {
                currentState = new CacheState(key);
            }
            this.state = currentState;
            return currentState;
        }
    }
}

