/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.request;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.inline.completion.InlineCompletionRequest;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.AnalyzedFullLineProposal;
import org.jetbrains.completion.full.line.FullLineCompletionQuery;
import org.jetbrains.completion.full.line.FullLineCompletionType;
import org.jetbrains.completion.full.line.FullLineParams;
import org.jetbrains.completion.full.line.FullLinePluginInfo;
import org.jetbrains.completion.full.line.PathUtilsKt;
import org.jetbrains.completion.full.line.language.FullLinePipelineConfiguration;
import org.jetbrains.completion.full.line.language.ModelSettings;
import org.jetbrains.completion.full.line.language.SkipLocationReason;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupportHolder;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.models.FullLineUXMode;
import org.jetbrains.completion.full.line.models.ModelType;
import org.jetbrains.completion.full.line.platform.CompletionId;
import org.jetbrains.completion.full.line.platform.CompletionIdFactory;
import org.jetbrains.completion.full.line.platform.FullLineProposedElement;
import org.jetbrains.completion.full.line.platform.logs.FullLineStatsStorage;
import org.jetbrains.completion.full.line.platform.logs.InvocationTracker;
import org.jetbrains.completion.full.line.providers.FullLineCompletionProvider;
import org.jetbrains.completion.full.line.relevance.RelevanceModelResponse;
import org.jetbrains.completion.full.line.relevance.RelevanceModelService;
import org.jetbrains.completion.full.line.settings.FullLineSettings;
import org.jetbrains.completion.full.line.thirdparty.FullLineThirdPartyConflictSupport;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00052\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest;", "", "()V", "Applicable", "Base", "Companion", "Inapplicable", "InapplicableReason", "Skipped", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Base;", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Inapplicable;", "intellij.fullLine"})
public abstract class FullLineRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FullLineRequest() {
    }

    public /* synthetic */ FullLineRequest(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Applicable;", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Base;", "parameters", "Lorg/jetbrains/completion/full/line/FullLineParams;", "holder", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;", "tracker", "Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;", "triggerModelResponse", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "(Lorg/jetbrains/completion/full/line/FullLineParams;Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;)V", "intellij.fullLine"})
    public static final class Applicable
    extends Base {
        public Applicable(@NotNull FullLineParams parameters, @NotNull FullLineLanguageSupportHolder holder, @NotNull InvocationTracker tracker, @NotNull RelevanceModelResponse triggerModelResponse) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)triggerModelResponse, (String)"triggerModelResponse");
            super(parameters, holder, tracker, triggerModelResponse, null);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u00012\u00020\u0002B'\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010%\u001a\u00020&H\u0096\u0001J\u0011\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\t\u0010+\u001a\u00020(H\u0096\u0001J\t\u0010,\u001a\u00020(H\u0096\u0001J\t\u0010-\u001a\u00020(H\u0096\u0001J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0007J\u0010\u00102\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0003J\u0011\u00103\u001a\u00020(2\u0006\u00104\u001a\u00020\tH\u0096\u0001J\u0018\u00105\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002J\u0011\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u00020<H\u0096\u0001J\u0017\u0010=\u001a\u00020(2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?H\u0096\u0001J\u0017\u0010A\u001a\u00020(2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C0?H\u0096\u0001J\u0011\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0096\u0001J\u0011\u0010H\u001a\u00020(2\u0006\u00104\u001a\u00020\tH\u0096\u0001J\u0016\u0010I\u001a\u000201*\u00020J2\b\u0010K\u001a\u0004\u0018\u000109H\u0002R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u0082\u0001\u0002LM\u00a8\u0006N"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Base;", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest;", "Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;", "parameters", "Lorg/jetbrains/completion/full/line/FullLineParams;", "holder", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;", "tracker", "triggerModelResponse", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "(Lorg/jetbrains/completion/full/line/FullLineParams;Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;)V", "completionId", "Lorg/jetbrains/completion/full/line/platform/CompletionId;", "getCompletionId", "()Lorg/jetbrains/completion/full/line/platform/CompletionId;", "config", "Lorg/jetbrains/completion/full/line/language/FullLinePipelineConfiguration;", "getConfig", "()Lorg/jetbrains/completion/full/line/language/FullLinePipelineConfiguration;", "file", "Lcom/intellij/psi/PsiFile;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getHolder", "()Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "modelMode", "Lorg/jetbrains/completion/full/line/models/ModelType;", "getModelMode", "()Lorg/jetbrains/completion/full/line/models/ModelType;", "getParameters", "()Lorg/jetbrains/completion/full/line/FullLineParams;", "getTriggerModelResponse", "()Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "areProposalsShown", "", "completionFinished", "", "time", "", "completionFinishedCancelled", "completionFinishedTimedOut", "completionStarted", "createQuery", "Lorg/jetbrains/completion/full/line/FullLineCompletionQuery;", "prefix", "", "createTextBasedCompletionQuery", "filterModelResponded", "response", "getPrefix", "editor", "Lcom/intellij/openapi/editor/Editor;", "el", "Lcom/intellij/codeInsight/lookup/LookupElement;", "inapplicable", "reason", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$InapplicableReason;", "itemsAnalyzed", "items", "", "Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;", "itemsProposed", "proposals", "Lorg/jetbrains/completion/full/line/platform/FullLineProposedElement;", "providerRequested", "Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker$ProviderTracker;", "provider", "Lorg/jetbrains/completion/full/line/providers/FullLineCompletionProvider;", "triggerModelResponded", "prefixFromLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "element", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Applicable;", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Skipped;", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nFullLineRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineRequest.kt\norg/jetbrains/completion/full/line/platform/request/FullLineRequest$Base\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
    public static abstract class Base
    extends FullLineRequest
    implements InvocationTracker {
        @NotNull
        private final FullLineParams parameters;
        @NotNull
        private final FullLineLanguageSupportHolder holder;
        @NotNull
        private final RelevanceModelResponse triggerModelResponse;
        private final /* synthetic */ InvocationTracker $$delegate_0;
        @NotNull
        private final PsiFile file;
        @NotNull
        private final Language language;
        @NotNull
        private final FullLinePipelineConfiguration config;
        @NotNull
        private final CompletionId completionId;
        @NotNull
        private final ModelType modelMode;

        private Base(FullLineParams parameters, FullLineLanguageSupportHolder holder, InvocationTracker tracker, RelevanceModelResponse triggerModelResponse) {
            super(null);
            this.parameters = parameters;
            this.holder = holder;
            this.triggerModelResponse = triggerModelResponse;
            this.$$delegate_0 = tracker;
            this.file = this.parameters.getOriginalFile();
            this.language = this.holder.getLanguage();
            this.config = this.holder.getSupporter().configurePipeline(this.parameters);
            this.completionId = CompletionIdFactory.INSTANCE.getNext();
            ModelSettings modelSettings = this.holder.getSupporter().getModelSettings();
            ModelType modelType = modelSettings != null ? modelSettings.getModelType() : null;
            if (modelType == null) {
                Base base = this;
                boolean bl = false;
                Base base2 = base;
                String string = "Model type for " + this.holder + " is null";
                throw new IllegalArgumentException(string.toString());
            }
            this.modelMode = modelType;
        }

        @NotNull
        public final FullLineParams getParameters() {
            return this.parameters;
        }

        @NotNull
        public final FullLineLanguageSupportHolder getHolder() {
            return this.holder;
        }

        @NotNull
        public final RelevanceModelResponse getTriggerModelResponse() {
            return this.triggerModelResponse;
        }

        @Override
        public boolean areProposalsShown() {
            return this.$$delegate_0.areProposalsShown();
        }

        @Override
        public void completionFinished(long time) {
            this.$$delegate_0.completionFinished(time);
        }

        @Override
        public void completionFinishedCancelled() {
            this.$$delegate_0.completionFinishedCancelled();
        }

        @Override
        public void completionFinishedTimedOut() {
            this.$$delegate_0.completionFinishedTimedOut();
        }

        @Override
        public void completionStarted() {
            this.$$delegate_0.completionStarted();
        }

        @Override
        public void filterModelResponded(@NotNull RelevanceModelResponse response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            this.$$delegate_0.filterModelResponded(response2);
        }

        @Override
        public void inapplicable(@NotNull InapplicableReason reason) {
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            this.$$delegate_0.inapplicable(reason);
        }

        @Override
        public void itemsAnalyzed(@NotNull List<AnalyzedFullLineProposal> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.$$delegate_0.itemsAnalyzed(items);
        }

        @Override
        public void itemsProposed(@NotNull List<? extends FullLineProposedElement> proposals) {
            Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
            this.$$delegate_0.itemsProposed(proposals);
        }

        @Override
        @NotNull
        public InvocationTracker.ProviderTracker providerRequested(@NotNull FullLineCompletionProvider provider2) {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            return this.$$delegate_0.providerRequested(provider2);
        }

        @Override
        public void triggerModelResponded(@NotNull RelevanceModelResponse response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            this.$$delegate_0.triggerModelResponded(response2);
        }

        @NotNull
        public final PsiFile getFile() {
            return this.file;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        @NotNull
        public final FullLinePipelineConfiguration getConfig() {
            return this.config;
        }

        @NotNull
        public final CompletionId getCompletionId() {
            return this.completionId;
        }

        @NotNull
        public final ModelType getModelMode() {
            return this.modelMode;
        }

        @RequiresReadLock
        @NotNull
        public final FullLineCompletionQuery createQuery(@NotNull String prefix2) {
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
            return this.createTextBasedCompletionQuery(prefix2);
        }

        @RequiresReadLock
        private final FullLineCompletionQuery createTextBasedCompletionQuery(String prefix2) {
            Object object;
            String filename;
            block3: {
                block2: {
                    filename = this.holder.getSupporter().customizeFilePath(PathUtilsKt.projectFilePath(this.file));
                    object = this.parameters.getLookupItemPrefix();
                    if (object == null) break block2;
                    LookupElement it = object;
                    boolean bl = false;
                    String string = this.getPrefix(this.parameters.getEditor(), it);
                    object = string;
                    if (string != null) break block3;
                }
                object = "";
            }
            Object additionalPrefix = object;
            return new FullLineCompletionQuery(this.config.getMode(), this.parameters.getOriginalFile(), this.parameters.getOffset(), filename, prefix2, this.language, (String)additionalPrefix);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String prefixFromLookup(Lookup $this$prefixFromLookup, LookupElement element) {
            LookupElement lookupElement = element;
            LookupElement lookupElement2 = lookupElement;
            if (lookupElement == null) return "";
            LookupElement it = lookupElement2;
            boolean bl = false;
            PrefixMatcher prefixMatcher = $this$prefixFromLookup.itemMatcher(it);
            lookupElement2 = prefixMatcher;
            if (prefixMatcher == null) return "";
            String string = lookupElement2.getPrefix();
            String string2 = string;
            if (string != null) return string2;
            return "";
        }

        private final String getPrefix(Editor editor, LookupElement el) {
            Object object;
            LookupEx lookupEx = LookupManager.getActiveLookup((Editor)editor);
            LookupImpl lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
            String string = el.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
            String fullElement = string;
            Object object2 = lookup;
            if (object2 == null || (object2 = this.prefixFromLookup((Lookup)object2, el)) == null) {
                object2 = "";
            }
            if ((object = lookup) == null || (object = object.getAdditionalPrefix()) == null) {
                object = "";
            }
            String typedPrefix = (String)object2 + (String)object;
            String string2 = el.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
            return StringsKt.startsWith$default((String)string2, (String)typedPrefix, (boolean)false, (int)2, null) ? StringsKt.drop((String)fullElement, (int)typedPrefix.length()) : "";
        }

        public /* synthetic */ Base(FullLineParams parameters, FullLineLanguageSupportHolder holder, InvocationTracker tracker, RelevanceModelResponse triggerModelResponse, DefaultConstructorMarker $constructor_marker) {
            this(parameters, holder, tracker, triggerModelResponse);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Companion;", "", "()V", "of", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "request", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionRequest;", "FullLineCompletionParameters", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nFullLineRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineRequest.kt\norg/jetbrains/completion/full/line/platform/request/FullLineRequest$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        @NotNull
        public final FullLineRequest of(@NotNull CompletionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Editor editor = parameters.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Language language2 = parameters.getOriginalFile().getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
            PsiFile psiFile2 = parameters.getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
            int n = parameters.getOffset();
            PsiElement psiElement = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
            return new FullLineCompletionParameters(new FullLineParams(editor, language2, psiFile2, FullLineCompletionType.LOOKUP, n, psiElement, parameters.getOriginalPosition(), parameters, null, null)).buildRequestWithStats();
        }

        @RequiresReadLock
        @NotNull
        public final FullLineRequest of(@NotNull InlineCompletionRequest request) {
            LookupElement lookupElement;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            PsiFile file2 = request.getFile();
            PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)request.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
            PsiElement position = psiElement;
            switch (WhenMappings.$EnumSwitchMapping$0[FullLineSettings.Companion.getInstance().getUXMode().ordinal()]) {
                case 1: {
                    lookupElement = request.getLookupElement();
                    if (lookupElement != null) break;
                    LookupEx lookupEx = LookupManager.getActiveLookup((Editor)request.getEditor());
                    if (lookupEx != null) {
                        lookupElement = lookupEx.getCurrentItem();
                        break;
                    }
                    lookupElement = null;
                    break;
                }
                case 2: {
                    LookupEx lookupEx = LookupManager.getActiveLookup((Editor)request.getEditor());
                    LookupImpl lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
                    Object object = lookup;
                    if (object != null) {
                        LookupImpl lookupImpl;
                        LookupImpl it = lookupImpl = object;
                        boolean bl = false;
                        object = it.getLookupFocusDegree() == LookupFocusDegree.FOCUSED ? lookupImpl : null;
                        if (object != null) {
                            lookupElement = object.getCurrentItem();
                            break;
                        }
                    }
                    lookupElement = null;
                    break;
                }
                default: {
                    lookupElement = null;
                }
            }
            LookupElement lookupPrefix = lookupElement;
            Editor editor = request.getEditor();
            Language language2 = file2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
            return new FullLineCompletionParameters(new FullLineParams(editor, language2, file2, FullLineCompletionType.INLINE, request.getEndOffset(), position, position, null, lookupPrefix, request)).buildRequestWithStats();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000b\u001a\u00020\bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0003H\u0002J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Companion$FullLineCompletionParameters;", "", "params", "Lorg/jetbrains/completion/full/line/FullLineParams;", "(Lorg/jetbrains/completion/full/line/FullLineParams;)V", "getParams", "()Lorg/jetbrains/completion/full/line/FullLineParams;", "buildRequest", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest;", "tracker", "Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;", "buildRequestWithStats", "isHeadless", "", "isInMainEditor", "whyInapplicable", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$InapplicableReason;", "language", "Lcom/intellij/lang/Language;", "requestTriggerModel", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupporter;", "intellij.fullLine"})
        private static final class FullLineCompletionParameters {
            @NotNull
            private final FullLineParams params;

            public FullLineCompletionParameters(@NotNull FullLineParams params2) {
                Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
                this.params = params2;
            }

            @NotNull
            public final FullLineParams getParams() {
                return this.params;
            }

            @NotNull
            public final FullLineRequest buildRequestWithStats() {
                FullLineStatsStorage storage = FullLineStatsStorage.Companion.obtain(this.params);
                return storage.trackedRequest((Function1<? super InvocationTracker, ? extends FullLineRequest>)((Function1)new Function1<InvocationTracker, FullLineRequest>(this){
                    final /* synthetic */ FullLineCompletionParameters this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final FullLineRequest invoke(@NotNull InvocationTracker it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return FullLineCompletionParameters.access$buildRequest(this.this$0, it);
                    }
                }));
            }

            private final FullLineRequest buildRequest(InvocationTracker tracker) {
                Language language2 = this.language(this.params);
                FullLineLanguageSupportHolder fullLineLanguageSupportHolder = FullLineLanguageSupporter.Companion.getHolder(language2);
                if (fullLineLanguageSupportHolder == null) {
                    return new Inapplicable(language2, InapplicableReason.LANGUAGE_IS_NOT_SUPPORTED, tracker);
                }
                FullLineLanguageSupportHolder holder = fullLineLanguageSupportHolder;
                FullLineLanguageSupporter supporter = holder.getSupporter();
                InapplicableReason inapplicableReason = this.whyInapplicable();
                if (inapplicableReason != null) {
                    return new Inapplicable(language2, inapplicableReason, tracker);
                }
                SkipLocationReason skipLocationReason = supporter.skipLocation(this.params);
                if (skipLocationReason != null) {
                    return new Skipped(skipLocationReason.getExplanation(), this.params, holder, tracker, RelevanceModelResponse.Companion.getDISABLED());
                }
                RelevanceModelResponse triggerModelResponse = this.requestTriggerModel(supporter, this.params, tracker);
                if (FullLineSettings.Companion.getInstance().isTriggerModelEnabled(this.language(this.params)) && triggerModelResponse.getDecision() == RelevanceModelResponse.Decision.SKIP) {
                    return new Skipped(SkipLocationReason.TRIGGER_MODEL.getExplanation(), this.params, holder, tracker, triggerModelResponse);
                }
                return new Applicable(this.params, holder, tracker, triggerModelResponse);
            }

            private final RelevanceModelResponse requestTriggerModel(FullLineLanguageSupporter $this$requestTriggerModel, FullLineParams params2, InvocationTracker tracker) {
                if (ApplicationKt.getApplication().isUnitTestMode()) {
                    return RelevanceModelResponse.Companion.getDISABLED();
                }
                RelevanceModelService triggerModelService = params2.isInline() ? $this$requestTriggerModel.getInlineTriggerModelService() : $this$requestTriggerModel.getLookupTriggerModelService();
                RelevanceModelResponse response2 = triggerModelService.requestModel(params2);
                tracker.triggerModelResponded(response2);
                return response2;
            }

            private final InapplicableReason whyInapplicable() {
                FullLineSettings settings = FullLineSettings.Companion.getInstance();
                Language language2 = this.language(this.params);
                if (this.params.isInline() && FullLineThirdPartyConflictSupport.Companion.getInstance().conflictExists()) {
                    return InapplicableReason.THIRD_PARTY_CONFLICT;
                }
                if (FullLinePluginInfo.INSTANCE.isGloballyDisabled()) {
                    return InapplicableReason.DISABLED_IN_RIDER;
                }
                if (!settings.isEnabled(language2)) {
                    return InapplicableReason.DISABLED_LANGUAGE;
                }
                if (!this.params.isSameCompletionType(settings.completionType())) {
                    return InapplicableReason.UNSUPPORTED_COMPLETION_MODE;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    if (!this.isHeadless() && !this.isInMainEditor()) {
                        return InapplicableReason.IS_NOT_MAIN_EDITOR;
                    }
                    if (this.params.getCompletion() != null && !this.params.isBasicCompletion()) {
                        return InapplicableReason.NOT_A_BASIC_COMPLETION;
                    }
                }
                if (PowerSaveMode.isEnabled()) {
                    return InapplicableReason.IN_POWER_SAFE_MODE;
                }
                return null;
            }

            private final boolean isHeadless() {
                return ApplicationManager.getApplication().isHeadlessEnvironment();
            }

            private final boolean isInMainEditor() {
                return this.params.getEditor().getEditorKind() == EditorKind.MAIN_EDITOR;
            }

            private final Language language(FullLineParams $this$language) {
                return $this$language.getLanguage();
            }

            public static final /* synthetic */ FullLineRequest access$buildRequest(FullLineCompletionParameters $this, InvocationTracker tracker) {
                return $this.buildRequest(tracker);
            }
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FullLineUXMode.values().length];
                try {
                    nArray[FullLineUXMode.InlineExtension.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FullLineUXMode.InlineSemiExtension.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Inapplicable;", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest;", "language", "Lcom/intellij/lang/Language;", "reason", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$InapplicableReason;", "tracker", "Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;", "(Lcom/intellij/lang/Language;Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$InapplicableReason;Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getReason", "()Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$InapplicableReason;", "getTracker", "()Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.fullLine"})
    public static final class Inapplicable
    extends FullLineRequest {
        @NotNull
        private final Language language;
        @NotNull
        private final InapplicableReason reason;
        @NotNull
        private final InvocationTracker tracker;

        public Inapplicable(@NotNull Language language2, @NotNull InapplicableReason reason, @NotNull InvocationTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            super(null);
            this.language = language2;
            this.reason = reason;
            this.tracker = tracker;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        @NotNull
        public final InapplicableReason getReason() {
            return this.reason;
        }

        @NotNull
        public final InvocationTracker getTracker() {
            return this.tracker;
        }

        @NotNull
        public final Language component1() {
            return this.language;
        }

        @NotNull
        public final InapplicableReason component2() {
            return this.reason;
        }

        @NotNull
        public final InvocationTracker component3() {
            return this.tracker;
        }

        @NotNull
        public final Inapplicable copy(@NotNull Language language2, @NotNull InapplicableReason reason, @NotNull InvocationTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            return new Inapplicable(language2, reason, tracker);
        }

        public static /* synthetic */ Inapplicable copy$default(Inapplicable inapplicable, Language language2, InapplicableReason inapplicableReason, InvocationTracker invocationTracker, int n, Object object) {
            if ((n & 1) != 0) {
                language2 = inapplicable.language;
            }
            if ((n & 2) != 0) {
                inapplicableReason = inapplicable.reason;
            }
            if ((n & 4) != 0) {
                invocationTracker = inapplicable.tracker;
            }
            return inapplicable.copy(language2, inapplicableReason, invocationTracker);
        }

        @NotNull
        public String toString() {
            return "Inapplicable(language=" + this.language + ", reason=" + this.reason + ", tracker=" + this.tracker + ")";
        }

        public int hashCode() {
            int result = this.language.hashCode();
            result = result * 31 + this.reason.hashCode();
            result = result * 31 + this.tracker.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Inapplicable)) {
                return false;
            }
            Inapplicable inapplicable = (Inapplicable)other;
            if (!Intrinsics.areEqual((Object)this.language, (Object)inapplicable.language)) {
                return false;
            }
            if (this.reason != inapplicable.reason) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tracker, (Object)inapplicable.tracker);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$InapplicableReason;", "", "(Ljava/lang/String;I)V", "LANGUAGE_IS_NOT_SUPPORTED", "DISABLED_IN_RIDER", "DISABLED_LANGUAGE", "UNSUPPORTED_COMPLETION_MODE", "IS_NOT_MAIN_EDITOR", "NOT_A_BASIC_COMPLETION", "UNSUPPORTED_PLATFORM", "THIRD_PARTY_CONFLICT", "IN_POWER_SAFE_MODE", "intellij.fullLine"})
    public static final class InapplicableReason
    extends Enum<InapplicableReason> {
        public static final /* enum */ InapplicableReason LANGUAGE_IS_NOT_SUPPORTED = new InapplicableReason();
        public static final /* enum */ InapplicableReason DISABLED_IN_RIDER = new InapplicableReason();
        public static final /* enum */ InapplicableReason DISABLED_LANGUAGE = new InapplicableReason();
        public static final /* enum */ InapplicableReason UNSUPPORTED_COMPLETION_MODE = new InapplicableReason();
        public static final /* enum */ InapplicableReason IS_NOT_MAIN_EDITOR = new InapplicableReason();
        public static final /* enum */ InapplicableReason NOT_A_BASIC_COMPLETION = new InapplicableReason();
        public static final /* enum */ InapplicableReason UNSUPPORTED_PLATFORM = new InapplicableReason();
        public static final /* enum */ InapplicableReason THIRD_PARTY_CONFLICT = new InapplicableReason();
        public static final /* enum */ InapplicableReason IN_POWER_SAFE_MODE = new InapplicableReason();
        private static final /* synthetic */ InapplicableReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static InapplicableReason[] values() {
            return (InapplicableReason[])$VALUES.clone();
        }

        public static InapplicableReason valueOf(String value) {
            return Enum.valueOf(InapplicableReason.class, value);
        }

        @NotNull
        public static EnumEntries<InapplicableReason> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = inapplicableReasonArray = new InapplicableReason[]{InapplicableReason.LANGUAGE_IS_NOT_SUPPORTED, InapplicableReason.DISABLED_IN_RIDER, InapplicableReason.DISABLED_LANGUAGE, InapplicableReason.UNSUPPORTED_COMPLETION_MODE, InapplicableReason.IS_NOT_MAIN_EDITOR, InapplicableReason.NOT_A_BASIC_COMPLETION, InapplicableReason.UNSUPPORTED_PLATFORM, InapplicableReason.THIRD_PARTY_CONFLICT, InapplicableReason.IN_POWER_SAFE_MODE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Skipped;", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$Base;", "reason", "", "parameters", "Lorg/jetbrains/completion/full/line/FullLineParams;", "holder", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;", "tracker", "Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;", "triggerModelResponse", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "(Ljava/lang/String;Lorg/jetbrains/completion/full/line/FullLineParams;Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;)V", "getReason", "()Ljava/lang/String;", "intellij.fullLine"})
    public static final class Skipped
    extends Base {
        @NotNull
        private final String reason;

        public Skipped(@NotNull String reason, @NotNull FullLineParams parameters, @NotNull FullLineLanguageSupportHolder holder, @NotNull InvocationTracker tracker, @NotNull RelevanceModelResponse triggerModelResponse) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)triggerModelResponse, (String)"triggerModelResponse");
            super(parameters, holder, tracker, triggerModelResponse, null);
            this.reason = reason;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }
    }
}

