/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.logs;

import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a8\u0006\u0007"}, d2={"captureImportsFeatures", "", "Lcom/intellij/codeInsight/completion/ml/CompletionEnvironment;", "result", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nImportsFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportsFeatures.kt\norg/jetbrains/completion/full/line/platform/logs/ImportsFeaturesKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,26:1\n125#2:27\n152#2,3:28\n1#3:31\n*S KotlinDebug\n*F\n+ 1 ImportsFeatures.kt\norg/jetbrains/completion/full/line/platform/logs/ImportsFeaturesKt\n*L\n16#1:27\n16#1:28,3\n*E\n"})
public final class ImportsFeaturesKt {
    /*
     * WARNING - void declaration
     */
    public static final void captureImportsFeatures(@NotNull CompletionEnvironment $this$captureImportsFeatures, @NotNull Map<String, MLFeatureValue> result) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$captureImportsFeatures, (String)"<this>");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiFile psiFile2 = $this$captureImportsFeatures.getParameters().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
        PsiFile file2 = psiFile2;
        Language language2 = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        Object object = FullLineLanguageSupporter.Companion.getInstance(language2);
        if (object == null || (object = object.getCodeAnalyzer()) == null) {
            return;
        }
        Object codeAnalyzer2 = object;
        Collection<PsiElement> allImports = codeAnalyzer2.getAllImports(file2);
        int allImportsCount = allImports.size();
        result.put("imports_count", MLFeatureValue.Companion.numerical(allImportsCount));
        if (allImportsCount == 0) {
            return;
        }
        Collection<String> qualifiedImportNames = codeAnalyzer2.getSourceNames(allImports);
        Map<String, Boolean> map = codeAnalyzer2.classifyByImportsToTopics(qualifiedImportNames);
        boolean $i$f$map = false;
        void var9_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)("has_" + it.getKey() + "_imports"), (Object)MLFeatureValue.Companion.binary(((Boolean)it.getValue()).booleanValue())));
        }
        Iterable p0 = (List)destination$iv$iv;
        boolean bl = false;
        MapsKt.putAll(result, (Iterable)p0);
        int popularLibraryImportsCount = codeAnalyzer2.countPopularLibraries(qualifiedImportNames);
        result.put("popular_library_imports_count", MLFeatureValue.Companion.numerical(popularLibraryImportsCount));
        result.put("popular_library_imports_ratio", MLFeatureValue.Companion.numerical((double)popularLibraryImportsCount / (double)allImportsCount));
        Project project = $this$captureImportsFeatures.getLookup().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Integer libraryImportsCount = codeAnalyzer2.countLibraries(project, allImports);
        if (libraryImportsCount == null) {
            return;
        }
        result.put("library_imports_count", MLFeatureValue.Companion.numerical(libraryImportsCount.intValue()));
        result.put("library_imports_ratio", MLFeatureValue.Companion.numerical((double)libraryImportsCount.intValue() / (double)allImportsCount));
    }
}

