/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.logs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.impl.LookupResultDescriptor;
import com.intellij.codeInsight.lookup.impl.LookupUsageDescriptor;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsageCollectorExtension;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.platform.FullLineLookupElement;
import org.jetbrains.completion.full.line.platform.logs.FUSLogsKt;
import org.jetbrains.completion.full.line.platform.logs.FullLineStatsStorage;
import org.jetbrains.completion.full.line.platform.logs.lookup.element.provider.FullLineLookupElementLogsProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineUsageDescriptor;", "Lcom/intellij/codeInsight/lookup/impl/LookupUsageDescriptor;", "()V", "buildUsageData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "lookupResultDescriptor", "Lcom/intellij/codeInsight/lookup/impl/LookupResultDescriptor;", "getAdditionalUsageData", "getExtensionKey", "", "unwrap", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Companion", "FullLineUsageCollectorExtension", "intellij.fullLine"})
public final class FullLineUsageDescriptor
implements LookupUsageDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String KEY = "full_line";

    @NotNull
    public String getExtensionKey() {
        return KEY;
    }

    @NotNull
    public List<EventPair<?>> getAdditionalUsageData(@NotNull LookupResultDescriptor lookupResultDescriptor) {
        Intrinsics.checkNotNullParameter((Object)lookupResultDescriptor, (String)"lookupResultDescriptor");
        List<EventPair<?>> usageData = this.buildUsageData(lookupResultDescriptor);
        Editor editor = lookupResultDescriptor.getLookup().getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        FullLineStatsStorage.Companion.clear(editor, FullLineStatsStorage.StorageType.LOOKUP);
        if (usageData.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)FUSLogsKt.getFL_VALUES().with((Object)new ObjectEventData(usageData)));
    }

    private final List<EventPair<?>> buildUsageData(LookupResultDescriptor lookupResultDescriptor) {
        Language language2;
        PsiFile psiFile2 = lookupResultDescriptor.getLookup().getPsiFile();
        Object object = language2 = psiFile2 != null ? psiFile2.getLanguage() : null;
        if (!lookupResultDescriptor.getLookup().isCompletion() || language2 == null) {
            return CollectionsKt.emptyList();
        }
        Editor editor = lookupResultDescriptor.getLookup().getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        FullLineStatsStorage storage = FullLineStatsStorage.Companion.get(editor, FullLineStatsStorage.StorageType.LOOKUP);
        List<EventPair<?>> result = FUSLogsKt.buildStatsData(storage, language2);
        LookupElement lookupElement = lookupResultDescriptor.getSelectedItem();
        LookupElement selected = lookupElement != null ? this.unwrap(lookupElement) : null;
        result.add(FUSLogsKt.access$getSELECTED$p().with((Object)(selected instanceof FullLineLookupElement)));
        if (selected instanceof FullLineLookupElement) {
            result.addAll((Collection)FullLineLookupElementLogsProvider.Companion.captureFus(((FullLineLookupElement)selected).getProposal()));
        }
        return result;
    }

    private final LookupElement unwrap(LookupElement $this$unwrap) {
        if (!($this$unwrap instanceof LookupElementDecorator)) {
            return $this$unwrap;
        }
        LookupElement item = $this$unwrap;
        while (item instanceof LookupElementDecorator) {
            Intrinsics.checkNotNullExpressionValue((Object)((LookupElementDecorator)item).getDelegate(), (String)"getDelegate(...)");
        }
        return item;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineUsageDescriptor$Companion;", "", "()V", "KEY", "", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineUsageDescriptor$FullLineUsageCollectorExtension;", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsageCollectorExtension;", "()V", "getEventId", "", "getExtensionFields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getGroupId", "intellij.fullLine"})
    public static final class FullLineUsageCollectorExtension
    implements FeatureUsageCollectorExtension {
        @NotNull
        public String getGroupId() {
            return "completion";
        }

        @NotNull
        public String getEventId() {
            return "finished";
        }

        @NotNull
        public List<EventField<?>> getExtensionFields() {
            return CollectionsKt.listOf((Object)FUSLogsKt.getFL_VALUES());
        }
    }
}

