/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.logs;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.AnalyzedFullLineProposal;
import org.jetbrains.completion.full.line.FullLineParams;
import org.jetbrains.completion.full.line.RawFullLineProposal;
import org.jetbrains.completion.full.line.analyzer.CorrectnessAnalysisState;
import org.jetbrains.completion.full.line.platform.FullLineProposedElement;
import org.jetbrains.completion.full.line.platform.logs.InvocationTracker;
import org.jetbrains.completion.full.line.platform.request.FullLineRequest;
import org.jetbrains.completion.full.line.providers.FullLineCompletionProvider;
import org.jetbrains.completion.full.line.relevance.RelevanceModelResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0005\u001c\u001d\u001e\u001f B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0006\u0010\r\u001a\u00020\tJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bJ\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\tJ\u001a\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00170\u0019J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage;", "", "()V", "requests", "", "Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$RequestInfo;", "filterModelResponse", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "finishedCancelledCompletions", "", "finishedCompletions", "", "", "finishedTimedOutCompletions", "inapplicable", "", "itemsGenerated", "itemsProposed", "itemsRedCodeInfo", "Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$RedCodeInfo;", "providersFinishedWithException", "startedCompletions", "trackedRequest", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest;", "builder", "Lkotlin/Function1;", "Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;", "triggerModelResponse", "Companion", "RedCodeInfo", "RequestInfo", "RequestTracker", "StorageType", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineStatsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineStatsStorage.kt\norg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1360#2:219\n1446#2,5:220\n1360#2:225\n1446#2,5:226\n1360#2:231\n1446#2,5:232\n1360#2:238\n1446#2,5:239\n1#3:237\n*S KotlinDebug\n*F\n+ 1 FullLineStatsStorage.kt\norg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage\n*L\n35#1:219\n35#1:220,5\n39#1:225\n39#1:226,5\n43#1:231\n43#1:232,5\n59#1:238\n59#1:239,5\n*E\n"})
public final class FullLineStatsStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RequestInfo> requests = new CopyOnWriteArrayList();

    private FullLineStatsStorage() {
    }

    @NotNull
    public final FullLineRequest trackedRequest(@NotNull Function1<? super InvocationTracker, ? extends FullLineRequest> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        RequestInfo info2 = new RequestInfo();
        this.requests.add(info2);
        RequestTracker tracker = new RequestTracker(info2);
        FullLineRequest request = (FullLineRequest)builder.invoke((Object)tracker);
        tracker.forRequest(request);
        return request;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final RelevanceModelResponse triggerModelResponse() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.requests;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RequestInfo it = (RequestInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTriggerModelResponses();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (RelevanceModelResponse)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final RelevanceModelResponse filterModelResponse() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.requests;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RequestInfo it = (RequestInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFilterModelResponses();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (RelevanceModelResponse)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> inapplicable() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.requests;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RequestInfo it = (RequestInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getInapplicable();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final int startedCompletions() {
        Iterable iterable = this.requests;
        int n = 0;
        for (Object t : iterable) {
            void it;
            RequestInfo requestInfo = (RequestInfo)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getStarted().get();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int finishedCancelledCompletions() {
        Iterable iterable = this.requests;
        int n = 0;
        for (Object t : iterable) {
            void it;
            RequestInfo requestInfo = (RequestInfo)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getFinishedCancelled().get();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int finishedTimedOutCompletions() {
        Iterable iterable = this.requests;
        int n = 0;
        for (Object t : iterable) {
            void it;
            RequestInfo requestInfo = (RequestInfo)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getFinishedTimedOut().get();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> finishedCompletions() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.requests;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            RequestInfo it = (RequestInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFinishedTime();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final int itemsGenerated() {
        Iterable iterable = this.requests;
        int n = 0;
        for (Object t : iterable) {
            void it;
            RequestInfo requestInfo = (RequestInfo)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getItemsGenerated().get();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int providersFinishedWithException() {
        Iterable iterable = this.requests;
        int n = 0;
        for (Object t : iterable) {
            void it;
            RequestInfo requestInfo = (RequestInfo)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getProvidersFinishedWithException().get();
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public final RedCodeInfo itemsRedCodeInfo() {
        int n;
        int n2;
        int n3;
        RequestInfo it;
        int n4;
        Iterable iterable = this.requests;
        int n5 = 0;
        for (Object t : iterable) {
            RequestInfo requestInfo = (RequestInfo)t;
            n4 = n5;
            boolean bl = false;
            n3 = it.getItemsAnalyzed().get();
            n5 = n4 + n3;
        }
        iterable = this.requests;
        n4 = n5;
        n5 = 0;
        for (Object t : iterable) {
            it = (RequestInfo)t;
            n3 = n5;
            boolean bl = false;
            n2 = it.getItemsInvalidTotal().get();
            n5 = n3 + n2;
        }
        n3 = n5;
        iterable = this.requests;
        n5 = 0;
        for (Object t : iterable) {
            it = (RequestInfo)t;
            n2 = n5;
            boolean bl = false;
            n = it.getItemsInvalidCritical().get();
            n5 = n2 + n;
        }
        n2 = n5;
        iterable = this.requests;
        n5 = 0;
        for (Object t : iterable) {
            it = (RequestInfo)t;
            n = n5;
            boolean bl = false;
            int n6 = it.getItemsNotAnalyzedUnknown().get();
            n5 = n + n6;
        }
        int n7 = n = n5;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        return new RedCodeInfo(n10, n9, n8, n7);
    }

    /*
     * WARNING - void declaration
     */
    public final int itemsProposed() {
        Iterable iterable = this.requests;
        int n = 0;
        for (Object t : iterable) {
            void it;
            RequestInfo requestInfo = (RequestInfo)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getItemsProposed().get();
            n = n2 + n3;
        }
        return n;
    }

    public /* synthetic */ FullLineStatsStorage(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$Companion;", "", "()V", "clear", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "storageType", "Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$StorageType;", "get", "Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage;", "obtain", "params", "Lorg/jetbrains/completion/full/line/FullLineParams;", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FullLineStatsStorage obtain(@NotNull FullLineParams params2) {
            Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
            StorageType storageType = params2.isInline() ? StorageType.INLINE : StorageType.LOOKUP;
            FullLineStatsStorage existing = this.get(params2.getEditor(), storageType);
            if (existing != null) {
                return existing;
            }
            FullLineStatsStorage storage = new FullLineStatsStorage(null);
            params2.getEditor().putUserData(storageType.getKey(), (Object)storage);
            return storage;
        }

        @Nullable
        public final FullLineStatsStorage get(@NotNull Editor editor, @NotNull StorageType storageType) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)((Object)storageType), (String)"storageType");
            return (FullLineStatsStorage)editor.getUserData(storageType.getKey());
        }

        public final void clear(@NotNull Editor editor, @NotNull StorageType storageType) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)((Object)storageType), (String)"storageType");
            editor.putUserData(storageType.getKey(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$RedCodeInfo;", "", "itemsAnalyzed", "", "itemsInvalidTotal", "itemsInvalidCritical", "itemsNotAnalyzedUnknown", "(IIII)V", "getItemsAnalyzed", "()I", "getItemsInvalidCritical", "getItemsInvalidTotal", "getItemsNotAnalyzedUnknown", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.fullLine"})
    public static final class RedCodeInfo {
        private final int itemsAnalyzed;
        private final int itemsInvalidTotal;
        private final int itemsInvalidCritical;
        private final int itemsNotAnalyzedUnknown;

        public RedCodeInfo(int itemsAnalyzed, int itemsInvalidTotal, int itemsInvalidCritical, int itemsNotAnalyzedUnknown) {
            this.itemsAnalyzed = itemsAnalyzed;
            this.itemsInvalidTotal = itemsInvalidTotal;
            this.itemsInvalidCritical = itemsInvalidCritical;
            this.itemsNotAnalyzedUnknown = itemsNotAnalyzedUnknown;
        }

        public final int getItemsAnalyzed() {
            return this.itemsAnalyzed;
        }

        public final int getItemsInvalidTotal() {
            return this.itemsInvalidTotal;
        }

        public final int getItemsInvalidCritical() {
            return this.itemsInvalidCritical;
        }

        public final int getItemsNotAnalyzedUnknown() {
            return this.itemsNotAnalyzedUnknown;
        }

        public final int component1() {
            return this.itemsAnalyzed;
        }

        public final int component2() {
            return this.itemsInvalidTotal;
        }

        public final int component3() {
            return this.itemsInvalidCritical;
        }

        public final int component4() {
            return this.itemsNotAnalyzedUnknown;
        }

        @NotNull
        public final RedCodeInfo copy(int itemsAnalyzed, int itemsInvalidTotal, int itemsInvalidCritical, int itemsNotAnalyzedUnknown) {
            return new RedCodeInfo(itemsAnalyzed, itemsInvalidTotal, itemsInvalidCritical, itemsNotAnalyzedUnknown);
        }

        public static /* synthetic */ RedCodeInfo copy$default(RedCodeInfo redCodeInfo, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = redCodeInfo.itemsAnalyzed;
            }
            if ((n5 & 2) != 0) {
                n2 = redCodeInfo.itemsInvalidTotal;
            }
            if ((n5 & 4) != 0) {
                n3 = redCodeInfo.itemsInvalidCritical;
            }
            if ((n5 & 8) != 0) {
                n4 = redCodeInfo.itemsNotAnalyzedUnknown;
            }
            return redCodeInfo.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "RedCodeInfo(itemsAnalyzed=" + this.itemsAnalyzed + ", itemsInvalidTotal=" + this.itemsInvalidTotal + ", itemsInvalidCritical=" + this.itemsInvalidCritical + ", itemsNotAnalyzedUnknown=" + this.itemsNotAnalyzedUnknown + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.itemsAnalyzed);
            result = result * 31 + Integer.hashCode(this.itemsInvalidTotal);
            result = result * 31 + Integer.hashCode(this.itemsInvalidCritical);
            result = result * 31 + Integer.hashCode(this.itemsNotAnalyzedUnknown);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RedCodeInfo)) {
                return false;
            }
            RedCodeInfo redCodeInfo = (RedCodeInfo)other;
            if (this.itemsAnalyzed != redCodeInfo.itemsAnalyzed) {
                return false;
            }
            if (this.itemsInvalidTotal != redCodeInfo.itemsInvalidTotal) {
                return false;
            }
            if (this.itemsInvalidCritical != redCodeInfo.itemsInvalidCritical) {
                return false;
            }
            return this.itemsNotAnalyzedUnknown == redCodeInfo.itemsNotAnalyzedUnknown;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0011\u0010\u0015\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u001e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010 \u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0011R\u0011\u0010\"\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0011R\u0011\u0010$\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0011R\u0011\u0010&\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0011R\u0011\u0010(\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0011R\u0011\u0010*\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0011R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\r\u00a8\u0006."}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$RequestInfo;", "", "()V", "applicable", "", "getApplicable", "()Z", "setApplicable", "(Z)V", "filterModelResponses", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "getFilterModelResponses", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "finishedCancelled", "Ljava/util/concurrent/atomic/AtomicInteger;", "getFinishedCancelled", "()Ljava/util/concurrent/atomic/AtomicInteger;", "finishedTime", "", "getFinishedTime", "finishedTimedOut", "getFinishedTimedOut", "inapplicable", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "getInapplicable", "()Ljava/util/concurrent/LinkedBlockingQueue;", "itemsAnalyzed", "getItemsAnalyzed", "itemsGenerated", "getItemsGenerated", "itemsInvalidCritical", "getItemsInvalidCritical", "itemsInvalidTotal", "getItemsInvalidTotal", "itemsNotAnalyzedUnknown", "getItemsNotAnalyzedUnknown", "itemsProposed", "getItemsProposed", "providersFinishedWithException", "getProvidersFinishedWithException", "started", "getStarted", "triggerModelResponses", "getTriggerModelResponses", "intellij.fullLine"})
    private static final class RequestInfo {
        private boolean applicable;
        @NotNull
        private final ConcurrentLinkedQueue<RelevanceModelResponse> triggerModelResponses = new ConcurrentLinkedQueue();
        @NotNull
        private final ConcurrentLinkedQueue<RelevanceModelResponse> filterModelResponses = new ConcurrentLinkedQueue();
        @NotNull
        private final LinkedBlockingQueue<String> inapplicable = new LinkedBlockingQueue();
        @NotNull
        private final AtomicInteger started = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger finishedCancelled = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger finishedTimedOut = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger providersFinishedWithException = new AtomicInteger(0);
        @NotNull
        private final ConcurrentLinkedQueue<Long> finishedTime = new ConcurrentLinkedQueue();
        @NotNull
        private final AtomicInteger itemsGenerated = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger itemsAnalyzed = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger itemsInvalidTotal = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger itemsInvalidCritical = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger itemsNotAnalyzedUnknown = new AtomicInteger(0);
        @NotNull
        private final AtomicInteger itemsProposed = new AtomicInteger(0);

        public final boolean getApplicable() {
            return this.applicable;
        }

        public final void setApplicable(boolean bl) {
            this.applicable = bl;
        }

        @NotNull
        public final ConcurrentLinkedQueue<RelevanceModelResponse> getTriggerModelResponses() {
            return this.triggerModelResponses;
        }

        @NotNull
        public final ConcurrentLinkedQueue<RelevanceModelResponse> getFilterModelResponses() {
            return this.filterModelResponses;
        }

        @NotNull
        public final LinkedBlockingQueue<String> getInapplicable() {
            return this.inapplicable;
        }

        @NotNull
        public final AtomicInteger getStarted() {
            return this.started;
        }

        @NotNull
        public final AtomicInteger getFinishedCancelled() {
            return this.finishedCancelled;
        }

        @NotNull
        public final AtomicInteger getFinishedTimedOut() {
            return this.finishedTimedOut;
        }

        @NotNull
        public final AtomicInteger getProvidersFinishedWithException() {
            return this.providersFinishedWithException;
        }

        @NotNull
        public final ConcurrentLinkedQueue<Long> getFinishedTime() {
            return this.finishedTime;
        }

        @NotNull
        public final AtomicInteger getItemsGenerated() {
            return this.itemsGenerated;
        }

        @NotNull
        public final AtomicInteger getItemsAnalyzed() {
            return this.itemsAnalyzed;
        }

        @NotNull
        public final AtomicInteger getItemsInvalidTotal() {
            return this.itemsInvalidTotal;
        }

        @NotNull
        public final AtomicInteger getItemsInvalidCritical() {
            return this.itemsInvalidCritical;
        }

        @NotNull
        public final AtomicInteger getItemsNotAnalyzedUnknown() {
            return this.itemsNotAnalyzedUnknown;
        }

        @NotNull
        public final AtomicInteger getItemsProposed() {
            return this.itemsProposed;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0016\u0010\u001b\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$RequestTracker;", "Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker;", "requestInfo", "Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$RequestInfo;", "(Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$RequestInfo;)V", "areProposalsShown", "", "completionFinished", "", "time", "", "completionFinishedCancelled", "completionFinishedTimedOut", "completionStarted", "filterModelResponded", "response", "Lorg/jetbrains/completion/full/line/relevance/RelevanceModelResponse;", "forRequest", "request", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest;", "inapplicable", "reason", "Lorg/jetbrains/completion/full/line/platform/request/FullLineRequest$InapplicableReason;", "itemsAnalyzed", "items", "", "Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;", "itemsProposed", "proposals", "Lorg/jetbrains/completion/full/line/platform/FullLineProposedElement;", "providerRequested", "Lorg/jetbrains/completion/full/line/platform/logs/InvocationTracker$ProviderTracker;", "provider", "Lorg/jetbrains/completion/full/line/providers/FullLineCompletionProvider;", "triggerModelResponded", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nFullLineStatsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineStatsStorage.kt\norg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$RequestTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1549#2:219\n1620#2,3:220\n1774#2,4:223\n1774#2,4:227\n1549#2:231\n1620#2,3:232\n800#2,11:235\n*S KotlinDebug\n*F\n+ 1 FullLineStatsStorage.kt\norg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$RequestTracker\n*L\n198#1:219\n198#1:220,3\n200#1:223,4\n203#1:227,4\n207#1:231\n207#1:232,3\n207#1:235,11\n*E\n"})
    private static final class RequestTracker
    implements InvocationTracker {
        @NotNull
        private final RequestInfo requestInfo;

        public RequestTracker(@NotNull RequestInfo requestInfo) {
            Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
            this.requestInfo = requestInfo;
        }

        public final void forRequest(@NotNull FullLineRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (request instanceof FullLineRequest.Applicable) {
                this.requestInfo.setApplicable(true);
            }
        }

        @Override
        public void triggerModelResponded(@NotNull RelevanceModelResponse response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            this.requestInfo.getTriggerModelResponses().add(response2);
        }

        @Override
        public void filterModelResponded(@NotNull RelevanceModelResponse response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            this.requestInfo.getFilterModelResponses().add(response2);
        }

        @Override
        public void inapplicable(@NotNull FullLineRequest.InapplicableReason reason) {
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            this.requestInfo.getInapplicable().add(reason.name());
        }

        @Override
        public void completionStarted() {
            this.requestInfo.getStarted().incrementAndGet();
        }

        @Override
        public void completionFinishedCancelled() {
            this.requestInfo.getFinishedCancelled().incrementAndGet();
        }

        @Override
        public void completionFinishedTimedOut() {
            this.requestInfo.getFinishedTimedOut().incrementAndGet();
        }

        @Override
        public void completionFinished(long time) {
            this.requestInfo.getFinishedTime().add(time);
        }

        @Override
        @NotNull
        public InvocationTracker.ProviderTracker providerRequested(@NotNull FullLineCompletionProvider provider2) {
            Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
            return new InvocationTracker.ProviderTracker(this){
                final /* synthetic */ RequestTracker this$0;
                {
                    this.this$0 = $receiver;
                }

                public void itemsContributed(@NotNull List<RawFullLineProposal> items) {
                    Intrinsics.checkNotNullParameter(items, (String)"items");
                    RequestTracker.access$getRequestInfo$p(this.this$0).getItemsGenerated().addAndGet(items.size());
                }

                public void finishedWithException() {
                    RequestTracker.access$getRequestInfo$p(this.this$0).getProvidersFinishedWithException().incrementAndGet();
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void itemsAnalyzed(@NotNull List<AnalyzedFullLineProposal> items) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            void $this$mapTo$iv$iv;
            int n;
            CorrectnessAnalysisState it;
            int n2;
            Iterable $this$count$iv;
            Object object;
            void $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(items, (String)"items");
            Iterable $this$map$iv = items;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                AnalyzedFullLineProposal analyzedFullLineProposal = (AnalyzedFullLineProposal)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it2.getCorrectnessState());
            }
            List correctnessStates = (List)destination$iv$iv;
            this.requestInfo.getItemsAnalyzed().addAndGet(correctnessStates.size());
            $this$map$iv = correctnessStates;
            object = this.requestInfo.getItemsInvalidTotal();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (CorrectnessAnalysisState)element$iv;
                    boolean bl = false;
                    boolean bl2 = it instanceof CorrectnessAnalysisState.Analyzed && !((Collection)((CorrectnessAnalysisState.Analyzed)it).getCheckResult().getErrors()).isEmpty();
                    if (!bl2 || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int n3 = n2;
            ((AtomicInteger)object).addAndGet(n3);
            $this$count$iv = correctnessStates;
            object = this.requestInfo.getItemsInvalidCritical();
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (CorrectnessAnalysisState)element$iv;
                    boolean bl = false;
                    if (!CorrectnessAnalysisState.Unknown.INSTANCE.hasCriticalErrors(it.errors()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            n3 = n;
            ((AtomicInteger)object).addAndGet(n3);
            Iterable $this$map$iv2 = correctnessStates;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                CorrectnessAnalysisState bl = (CorrectnessAnalysisState)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl3 = false;
                object.add(it3);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CorrectnessAnalysisState.Unknown)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List unknownStates = (List)destination$iv$iv2;
            this.requestInfo.getItemsNotAnalyzedUnknown().addAndGet(unknownStates.size());
        }

        @Override
        public void itemsProposed(@NotNull List<? extends FullLineProposedElement> proposals) {
            Intrinsics.checkNotNullParameter(proposals, (String)"proposals");
            this.requestInfo.getItemsProposed().addAndGet(proposals.size());
        }

        @Override
        public boolean areProposalsShown() {
            return this.requestInfo.getItemsProposed().get() > 0;
        }

        public static final /* synthetic */ RequestInfo access$getRequestInfo$p(RequestTracker $this) {
            return $this.requestInfo;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage$StorageType;", "", "key", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage;", "(Ljava/lang/String;ILcom/intellij/openapi/util/Key;)V", "getKey", "()Lcom/intellij/openapi/util/Key;", "LOOKUP", "INLINE", "intellij.fullLine"})
    public static final class StorageType
    extends Enum<StorageType> {
        @NotNull
        private final Key<FullLineStatsStorage> key;
        public static final /* enum */ StorageType LOOKUP;
        public static final /* enum */ StorageType INLINE;
        private static final /* synthetic */ StorageType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private StorageType(Key<FullLineStatsStorage> key) {
            this.key = key;
        }

        @NotNull
        public final Key<FullLineStatsStorage> getKey() {
            return this.key;
        }

        public static StorageType[] values() {
            return (StorageType[])$VALUES.clone();
        }

        public static StorageType valueOf(String value) {
            return Enum.valueOf(StorageType.class, value);
        }

        @NotNull
        public static EnumEntries<StorageType> getEntries() {
            return $ENTRIES;
        }

        static {
            Key key = Key.create((String)"full.line.lookup.storage");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            LOOKUP = new StorageType((Key<FullLineStatsStorage>)key);
            Key key2 = Key.create((String)"full.line.inline.storage");
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
            INLINE = new StorageType((Key<FullLineStatsStorage>)key2);
            $VALUES = storageTypeArray = new StorageType[]{StorageType.LOOKUP, StorageType.INLINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

