/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.logs;

import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.EditDistance;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.AnalyzedFullLineProposal;
import org.jetbrains.completion.full.line.FullLineProposal;
import org.jetbrains.completion.full.line.language.FullLineCodeAnalyzer;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.platform.logs.FUSLogsKt;
import org.jetbrains.completion.full.line.platform.logs.FullLineInlineElementFeatures;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J(\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00132\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J&\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u001cJ\"\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineInlineElementFeatures;", "", "()V", "calculateSimilarityTwoLines", "", "firstLine", "", "secondLine", "compute", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "proposal", "Lorg/jetbrains/completion/full/line/AnalyzedFullLineProposal;", "getLine", "", "Lcom/intellij/psi/PsiElement;", "seed", "nextFunction", "Lkotlin/Function1;", "getLineText", "lineElements", "getProposalPrevAndNextLineSimilarity", "Lkotlin/Pair;", "element", "Lorg/jetbrains/completion/full/line/FullLineProposal;", "getSuggestionReferenceFeatures", "codeAnalyzer", "Lorg/jetbrains/completion/full/line/language/FullLineCodeAnalyzer;", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineInlineElementFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineInlineElementFeatures.kt\norg/jetbrains/completion/full/line/platform/logs/FullLineInlineElementFeatures\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1#2:85\n1864#3,3:86\n*S KotlinDebug\n*F\n+ 1 FullLineInlineElementFeatures.kt\norg/jetbrains/completion/full/line/platform/logs/FullLineInlineElementFeatures\n*L\n37#1:86,3\n*E\n"})
public final class FullLineInlineElementFeatures {
    @NotNull
    public static final FullLineInlineElementFeatures INSTANCE = new FullLineInlineElementFeatures();

    private FullLineInlineElementFeatures() {
    }

    @NotNull
    public final List<EventPair<?>> compute(@NotNull PsiFile file2, int offset, @NotNull AnalyzedFullLineProposal proposal) {
        FullLineCodeAnalyzer codeAnalyzer2;
        List list2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        List $this$compute_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        PsiElement element = file2.findElementAt(offset - 1);
        if (element != null) {
            double it;
            Pair<Double, Double> pair2 = INSTANCE.getProposalPrevAndNextLineSimilarity(element, proposal);
            Double prevLineSimilarity = (Double)pair2.component1();
            Double nextLineSimilarity = (Double)pair2.component2();
            Double d = prevLineSimilarity;
            if (d != null) {
                it = ((Number)d).doubleValue();
                boolean bl2 = false;
                $this$compute_u24lambda_u242.add(FUSLogsKt.getPROPOSAL_PREV_LINE_SIMILARITY().with((Object)it));
            }
            Double d2 = nextLineSimilarity;
            if (d2 != null) {
                it = ((Number)d2).doubleValue();
                boolean bl3 = false;
                $this$compute_u24lambda_u242.add(FUSLogsKt.getPROPOSAL_NEXT_LINE_SIMILARITY().with((Object)it));
            }
        }
        Language language2 = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        FullLineLanguageSupporter fullLineLanguageSupporter = FullLineLanguageSupporter.Companion.getInstance(language2);
        FullLineCodeAnalyzer fullLineCodeAnalyzer = codeAnalyzer2 = fullLineLanguageSupporter != null ? fullLineLanguageSupporter.getCodeAnalyzer() : null;
        if (codeAnalyzer2 != null) {
            $this$compute_u24lambda_u242.addAll((Collection)INSTANCE.getSuggestionReferenceFeatures(codeAnalyzer2, proposal));
        }
        return CollectionsKt.build((List)list2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<EventPair<?>> getSuggestionReferenceFeatures(FullLineCodeAnalyzer codeAnalyzer2, AnalyzedFullLineProposal proposal) {
        void $this$forEachIndexed$iv;
        List list2;
        List<FullLineCodeAnalyzer.SuggestionReferenceFeatures> referenceFeatures = codeAnalyzer2.getSuggestionReferenceFeatures(proposal);
        List $this$getSuggestionReferenceFeatures_u24lambda_u244 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getSuggestionReferenceFeatures_u24lambda_u244.add(FUSLogsKt.getNUM_OF_SUGGESTION_REFERENCES().with((Object)referenceFeatures.size()));
        Iterable iterable = CollectionsKt.take((Iterable)referenceFeatures, (int)FUSLogsKt.getSUGGESTION_REFERENCE_FROM_LIB().length);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FullLineCodeAnalyzer.SuggestionReferenceFeatures suggestionReferenceFeatures = (FullLineCodeAnalyzer.SuggestionReferenceFeatures)item$iv;
            int i = n;
            boolean bl2 = false;
            if (element.getFromLibrary()) {
                $this$getSuggestionReferenceFeatures_u24lambda_u244.add(FUSLogsKt.getSUGGESTION_REFERENCE_FROM_LIB()[i].with((Object)true));
            }
            if (element.getInSameFile()) {
                $this$getSuggestionReferenceFeatures_u24lambda_u244.add(FUSLogsKt.getSUGGESTION_REFERENCE_IN_SAME_FILE()[i].with((Object)true));
            }
            if (element.getInFunction()) {
                $this$getSuggestionReferenceFeatures_u24lambda_u244.add(FUSLogsKt.getSUGGESTION_REFERENCE_IN_FUN()[i].with((Object)true));
            }
            if (element.getInClass()) {
                $this$getSuggestionReferenceFeatures_u24lambda_u244.add(FUSLogsKt.getSUGGESTION_REFERENCE_IN_CLASS()[i].with((Object)true));
            }
            if (element.getInSameFunction()) {
                $this$getSuggestionReferenceFeatures_u24lambda_u244.add(FUSLogsKt.getSUGGESTION_REFERENCE_IN_SAME_FUN()[i].with((Object)true));
            }
            if (element.getInSameClass()) {
                $this$getSuggestionReferenceFeatures_u24lambda_u244.add(FUSLogsKt.getSUGGESTION_REFERENCE_IN_SAME_CLASS()[i].with((Object)true));
            }
            if (element.isFunction()) {
                $this$getSuggestionReferenceFeatures_u24lambda_u244.add(FUSLogsKt.getSUGGESTION_REFERENCE_IS_FUN()[i].with((Object)true));
            }
            if (!element.isClass()) continue;
            $this$getSuggestionReferenceFeatures_u24lambda_u244.add(FUSLogsKt.getSUGGESTION_REFERENCE_IS_CLASS()[i].with((Object)true));
        }
        return CollectionsKt.build((List)list2);
    }

    private final Iterable<PsiElement> getLine(PsiElement seed, Function1<? super PsiElement, ? extends PsiElement> nextFunction) {
        return SequencesKt.asIterable((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)seed, nextFunction), (Function1)getLine.1.INSTANCE));
    }

    private final String getLineText(Iterable<? extends PsiElement> lineElements) {
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default(lineElements, (CharSequence)"", null, null, (int)0, null, (Function1)getLineText.1.INSTANCE, (int)30, null))).toString();
    }

    private final double calculateSimilarityTwoLines(String firstLine, String secondLine) {
        double editDistance = EditDistance.optimalAlignment((CharSequence)firstLine, (CharSequence)secondLine, (boolean)true);
        double editDistanceNormalized = editDistance / (double)Math.max(firstLine.length(), secondLine.length());
        return 1.0 - editDistanceNormalized;
    }

    @NotNull
    public final Pair<Double, Double> getProposalPrevAndNextLineSimilarity(@NotNull PsiElement element, @NotNull FullLineProposal proposal) {
        Double d;
        Double d2;
        String string;
        String string2;
        Iterable<PsiElement> iterable;
        List list2;
        PsiElement psiElement;
        PsiElement currentLineFirst2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        List currentLineBeforeElement2 = CollectionsKt.reversed(this.getLine(element, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)getProposalPrevAndNextLineSimilarity.currentLineBeforeElement.1.INSTANCE)));
        PsiElement psiElement2 = (PsiElement)CollectionsKt.lastOrNull(this.getLine(element, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)getProposalPrevAndNextLineSimilarity.currentLineFirst.1.INSTANCE)));
        if (psiElement2 == null) {
            psiElement2 = currentLineFirst2 = element;
        }
        if ((psiElement = (PsiElement)CollectionsKt.lastOrNull(this.getLine(element, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)getProposalPrevAndNextLineSimilarity.currentLineLast.1.INSTANCE)))) == null) {
            psiElement = element;
        }
        PsiElement currentLineLast2 = psiElement;
        PsiElement prevLineLastElement2 = PsiTreeUtil.skipMatching((PsiElement)currentLineFirst2, arg_0 -> FullLineInlineElementFeatures.getProposalPrevAndNextLineSimilarity$lambda$5(getProposalPrevAndNextLineSimilarity.prevLineLastElement.1.INSTANCE, arg_0), arg_0 -> FullLineInlineElementFeatures.getProposalPrevAndNextLineSimilarity$lambda$6(getProposalPrevAndNextLineSimilarity.prevLineLastElement.2.INSTANCE, arg_0));
        PsiElement nextLineFirstElement2 = PsiTreeUtil.skipMatching((PsiElement)currentLineLast2, arg_0 -> FullLineInlineElementFeatures.getProposalPrevAndNextLineSimilarity$lambda$7(getProposalPrevAndNextLineSimilarity.nextLineFirstElement.1.INSTANCE, arg_0), arg_0 -> FullLineInlineElementFeatures.getProposalPrevAndNextLineSimilarity$lambda$8(getProposalPrevAndNextLineSimilarity.nextLineFirstElement.2.INSTANCE, arg_0));
        PsiElement psiElement3 = prevLineLastElement2;
        if (psiElement3 != null) {
            PsiElement it = psiElement3;
            boolean bl = false;
            list2 = CollectionsKt.reversed(INSTANCE.getLine(prevLineLastElement2, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)getProposalPrevAndNextLineSimilarity.prevLine.1.1.INSTANCE)));
        } else {
            list2 = null;
        }
        List prevLine2 = list2;
        PsiElement psiElement4 = nextLineFirstElement2;
        if (psiElement4 != null) {
            PsiElement it = psiElement4;
            boolean bl = false;
            iterable = INSTANCE.getLine(nextLineFirstElement2, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)getProposalPrevAndNextLineSimilarity.nextLine.1.1.INSTANCE));
        } else {
            iterable = null;
        }
        Iterable<PsiElement> nextLine2 = iterable;
        String linePrefix = this.getLineText(currentLineBeforeElement2);
        List list3 = prevLine2;
        if (list3 != null) {
            List it = list3;
            boolean bl = false;
            string2 = INSTANCE.getLineText(it);
        } else {
            string2 = null;
        }
        String prevLineText = string2;
        Iterable<PsiElement> iterable2 = nextLine2;
        if (iterable2 != null) {
            Iterable<PsiElement> it = iterable2;
            boolean bl = false;
            string = INSTANCE.getLineText(it);
        } else {
            string = null;
        }
        String nextLineText = string;
        String string3 = prevLineText;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            d2 = INSTANCE.calculateSimilarityTwoLines(linePrefix + proposal.getSuggestion(), it);
        } else {
            d2 = null;
        }
        Double prevLineSimilarity = d2;
        String string4 = nextLineText;
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            d = INSTANCE.calculateSimilarityTwoLines(linePrefix + proposal.getSuggestion(), it);
        } else {
            d = null;
        }
        Double nextLineSimilarity = d;
        return TuplesKt.to((Object)prevLineSimilarity, nextLineSimilarity);
    }

    private static final PsiElement getProposalPrevAndNextLineSimilarity$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PsiElement)$tmp0.invoke(p0);
    }

    private static final boolean getProposalPrevAndNextLineSimilarity$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final PsiElement getProposalPrevAndNextLineSimilarity$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PsiElement)$tmp0.invoke(p0);
    }

    private static final boolean getProposalPrevAndNextLineSimilarity$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

