/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.logs;

import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.FullLineCodeAnalyzer;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.platform.logs.FUSLogsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0014H\u0002J&\u0010\u0015\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0014H\u0002J&\u0010\u0016\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0014H\u0002J&\u0010\u0017\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0014H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineInlineContextFeatures;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "compute", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "addArgumentsFeatures", "", "Lorg/jetbrains/completion/full/line/language/FullLineCodeAnalyzer;", "element", "Lcom/intellij/psi/PsiElement;", "result", "", "addBracketFeatures", "addImportFeatures", "addKeyWordFeatures", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineInlineContextFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineInlineContextFeatures.kt\norg/jetbrains/completion/full/line/platform/logs/FullLineInlineContextFeatures\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n1#2:90\n215#3,2:91\n9#4:93\n*S KotlinDebug\n*F\n+ 1 FullLineInlineContextFeatures.kt\norg/jetbrains/completion/full/line/platform/logs/FullLineInlineContextFeatures\n*L\n36#1:91,2\n11#1:93\n*E\n"})
public final class FullLineInlineContextFeatures {
    @NotNull
    public static final FullLineInlineContextFeatures INSTANCE;
    @NotNull
    private static final Logger LOG;

    private FullLineInlineContextFeatures() {
    }

    @NotNull
    public final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public final List<EventPair<?>> compute(@NotNull PsiFile file2, int offset) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List result = new ArrayList();
        Language language2 = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        Object object = FullLineLanguageSupporter.Companion.getInstance(language2);
        if (object == null || (object = object.getCodeAnalyzer()) == null) {
            return result;
        }
        Object codeAnalyzer2 = object;
        this.addImportFeatures((FullLineCodeAnalyzer)codeAnalyzer2, file2, result);
        PsiElement psiElement = file2.findElementAt(offset - 1);
        if (psiElement == null) {
            return result;
        }
        PsiElement element = psiElement;
        Integer n = codeAnalyzer2.getNumOfPrevQualifiers(element);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            result.add(FUSLogsKt.getNUMB_OF_PREV_QUALIFIERS().with((Object)it));
        }
        this.addKeyWordFeatures((FullLineCodeAnalyzer)codeAnalyzer2, element, result);
        this.addArgumentsFeatures((FullLineCodeAnalyzer)codeAnalyzer2, element, result);
        this.addBracketFeatures((FullLineCodeAnalyzer)codeAnalyzer2, element, result);
        result.add(FUSLogsKt.getIS_IN_CONDITIONAL_STATEMENT().with((Object)codeAnalyzer2.isInConditionalStatement(element)));
        result.add(FUSLogsKt.getIS_IN_FOR_STATEMENT().with((Object)codeAnalyzer2.isInForStatement(element)));
        result.add(FUSLogsKt.getELEMENT_PREFIX_LENGTH().with((Object)codeAnalyzer2.getElementPrefixLength(element, offset)));
        result.add(FUSLogsKt.getBLOCK_STATEMENT_LEVEL().with((Object)codeAnalyzer2.getBlockStatementLevel(element)));
        return result;
    }

    private final void addImportFeatures(FullLineCodeAnalyzer $this$addImportFeatures, PsiFile file2, List<EventPair<?>> result) {
        Collection<PsiElement> allImports = $this$addImportFeatures.getAllImports(file2);
        int allImportsCount = allImports.size();
        result.add(FUSLogsKt.getIMPORTS_COUNT().with((Object)allImportsCount));
        if (allImportsCount == 0) {
            return;
        }
        Collection<String> sourceNames = $this$addImportFeatures.getSourceNames(allImports);
        Map<String, Boolean> $this$forEach$iv = $this$addImportFeatures.classifyByImportsToTopics(sourceNames);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Boolean>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Boolean> element$iv;
            Map.Entry<String, Boolean> entry = element$iv = iterator2.next();
            boolean bl = false;
            String topic = entry.getKey();
            boolean value = entry.getValue();
            BooleanEventField field = FUSLogsKt.getTOPIC_TO_FIELD().get(topic);
            if (field != null) {
                result.add(field.with((Object)value));
                continue;
            }
            LOG.error("There is no event field for topic: " + topic);
        }
        int popularLibraryImportsCount = $this$addImportFeatures.countPopularLibraries(sourceNames);
        result.add(FUSLogsKt.getPOPULAR_LIBRARY_IMPORTS_COUNT().with((Object)popularLibraryImportsCount));
        result.add(FUSLogsKt.getPOPULAR_LIBRARY_IMPORTS_RATIO().with((Object)Float.valueOf((float)popularLibraryImportsCount / (float)allImportsCount)));
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Integer libraryImportsCount = $this$addImportFeatures.countLibraries(project, allImports);
        if (libraryImportsCount == null) {
            return;
        }
        result.add(FUSLogsKt.getLIBRARY_IMPORTS_COUNT().with((Object)libraryImportsCount));
        result.add(FUSLogsKt.getLIBRARY_IMPORTS_RATIO().with((Object)Float.valueOf((float)libraryImportsCount.intValue() / (float)allImportsCount)));
    }

    private final void addKeyWordFeatures(FullLineCodeAnalyzer $this$addKeyWordFeatures, PsiElement element, List<EventPair<?>> result) {
        List<Integer> sameColumnKws;
        List<Integer> sameLineKws;
        List<Integer> neighboursKws = $this$addKeyWordFeatures.getPrevNeighboursKeywordIds(element);
        if (neighboursKws.size() > 0) {
            result.add(FUSLogsKt.getPREV_NEIGHBOUR_KEYWORD_1().with((Object)neighboursKws.get(0)));
        }
        if (neighboursKws.size() > 1) {
            result.add(FUSLogsKt.getPREV_NEIGHBOUR_KEYWORD_2().with((Object)neighboursKws.get(1)));
        }
        if ((sameLineKws = $this$addKeyWordFeatures.getPrevKeywordsIdsInTheSameLine(element)).size() > 0) {
            result.add(FUSLogsKt.getPREV_SAME_LINE_KEYWORD_1().with((Object)sameLineKws.get(0)));
        }
        if (sameLineKws.size() > 1) {
            result.add(FUSLogsKt.getPREV_SAME_LINE_KEYWORD_2().with((Object)sameLineKws.get(1)));
        }
        if ((sameColumnKws = $this$addKeyWordFeatures.getPrevKeywordsIdsInTheSameColumn(element)).size() > 0) {
            result.add(FUSLogsKt.getPREV_SAME_COLUMN_KEYWORD_1().with((Object)sameColumnKws.get(0)));
        }
        if (sameColumnKws.size() > 1) {
            result.add(FUSLogsKt.getPREV_SAME_COLUMN_KEYWORD_2().with((Object)sameColumnKws.get(1)));
        }
    }

    private final void addArgumentsFeatures(FullLineCodeAnalyzer $this$addArgumentsFeatures, PsiElement element, List<EventPair<?>> result) {
        block3: {
            FullLineCodeAnalyzer.ArgumentFeatures $this$addArgumentsFeatures_u24lambda_u246 = $this$addArgumentsFeatures.getArgumentFeatures(element);
            boolean bl = false;
            result.add(FUSLogsKt.getIS_IN_ARGUMENTS().with((Object)$this$addArgumentsFeatures_u24lambda_u246.isInArguments()));
            result.add(FUSLogsKt.getIS_DIRECTLY_IN_ARGUMENTS_CONTEXT().with((Object)$this$addArgumentsFeatures_u24lambda_u246.isDirectlyInArgumentContext()));
            Integer n = $this$addArgumentsFeatures_u24lambda_u246.getArgumentIndex();
            if (n != null) {
                int n2 = ((Number)n).intValue();
                boolean bl2 = false;
                result.add(FUSLogsKt.getARGUMENT_INDEX().with((Object)n2));
            }
            Integer n3 = $this$addArgumentsFeatures_u24lambda_u246.getArgumentsSize();
            if (n3 != null) {
                int n4 = ((Number)n3).intValue();
                boolean bl3 = false;
                result.add(FUSLogsKt.getARGUMENTS_SIZE().with((Object)n4));
            }
            Boolean bl2 = $this$addArgumentsFeatures_u24lambda_u246.getHaveNamedArgLeft();
            if (bl2 != null) {
                boolean bl3 = bl2;
                boolean bl5 = false;
                result.add(FUSLogsKt.getHAVE_NAMED_ARG_LEFT().with((Object)bl3));
            }
            Boolean bl4 = $this$addArgumentsFeatures_u24lambda_u246.getHaveNamedArgRight();
            if (bl4 == null) break block3;
            boolean bl5 = bl4;
            boolean bl7 = false;
            result.add(FUSLogsKt.getHAVE_NAMED_ARG_RIGHT().with((Object)bl5));
        }
    }

    private final void addBracketFeatures(FullLineCodeAnalyzer $this$addBracketFeatures, PsiElement element, List<EventPair<?>> result) {
        FullLineCodeAnalyzer.BracketFeatures $this$addBracketFeatures_u24lambda_u247 = $this$addBracketFeatures.getBracketFeatures(element);
        boolean bl = false;
        result.add(FUSLogsKt.getHAVE_OPENING_PARENTHESIS_LEFT().with((Object)$this$addBracketFeatures_u24lambda_u247.getHaveOpeningParenthesisOnTheLeft()));
        result.add(FUSLogsKt.getHAVE_OPENING_BRACKET_LEFT().with((Object)$this$addBracketFeatures_u24lambda_u247.getHaveOpeningBracketOnTheLeft()));
        result.add(FUSLogsKt.getHAVE_OPENING_BRACE_LEFT().with((Object)$this$addBracketFeatures_u24lambda_u247.getHaveOpeningBraceOnTheLeft()));
        result.add(FUSLogsKt.getHAVE_OPENING_ANGLE_BRACKET_LEFT().with((Object)$this$addBracketFeatures_u24lambda_u247.getHaveOpeningAngleBracketOnTheLeft()));
    }

    static {
        FullLineInlineContextFeatures $this$thisLogger$iv = INSTANCE = new FullLineInlineContextFeatures();
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(FullLineInlineContextFeatures.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }
}

