/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.logs;

import com.intellij.codeInsight.inline.completion.logs.InlineCompletionProviderSpecificUsageData;
import com.intellij.codeInsight.inline.completion.logs.InlineCompletionUsageTracker;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsageCollectorExtension;
import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.CoreUtilsKt;
import org.jetbrains.completion.full.line.platform.logs.FUSLogsKt;
import org.jetbrains.completion.full.line.platform.logs.FullLineStatsStorage;
import org.jetbrains.completion.full.line.platform.logs.InlineFusLogs;
import org.jetbrains.completion.full.line.relevance.RelevanceModelResponse;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineInlineCompletionUsageData;", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionProviderSpecificUsageData;", "()V", "allowLogging", "", "storage", "Lorg/jetbrains/completion/full/line/platform/logs/FullLineStatsStorage;", "getAdditionalInvocationUsageData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "descriptor", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionProviderSpecificUsageData$InvocationDescriptor;", "getId", "", "FullLineUsageCollectorExtension", "intellij.fullLine"})
public final class FullLineInlineCompletionUsageData
implements InlineCompletionProviderSpecificUsageData {
    @NotNull
    public List<EventPair<?>> getAdditionalInvocationUsageData(@NotNull InlineCompletionProviderSpecificUsageData.InvocationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiFile psiFile2 = descriptor.getFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.getLanguage()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile language2 = psiFile2;
        FullLineStatsStorage storage = FullLineStatsStorage.Companion.get(descriptor.getEditor(), FullLineStatsStorage.StorageType.INLINE);
        boolean allowLogging = this.allowLogging(storage);
        if (!ApplicationKt.getApplication().isEAP() && !allowLogging) {
            return CollectionsKt.emptyList();
        }
        List<EventPair<?>> result = FUSLogsKt.buildStatsData(storage, (Language)language2);
        result.add(FUSLogsKt.getALLOW_LOGGING().with((Object)allowLogging));
        result.add(FUSLogsKt.getCONTEXT_FEATURES().with((Object)new ObjectEventData(InlineFusLogs.Companion.getInstance().takeContextFeatures())));
        result.addAll((Collection)InlineFusLogs.Companion.getInstance().takeElementFeatures());
        result.addAll((Collection)InlineFusLogs.Companion.getInstance().takePerformanceFeatures());
        FullLineStatsStorage.Companion.clear(descriptor.getEditor(), FullLineStatsStorage.StorageType.INLINE);
        InlineFusLogs.Companion.getInstance().clear();
        return CollectionsKt.listOf((Object)FUSLogsKt.getFL_VALUES().with((Object)new ObjectEventData(result)));
    }

    private final boolean allowLogging(FullLineStatsStorage storage) {
        RelevanceModelResponse.Decision filterModelDecision;
        Object object = storage;
        RelevanceModelResponse.Decision decision = object != null && (object = ((FullLineStatsStorage)object).filterModelResponse()) != null ? ((RelevanceModelResponse)object).getDecision() : (filterModelDecision = null);
        if (filterModelDecision == null || filterModelDecision == RelevanceModelResponse.Decision.UNAVAILABLE || filterModelDecision == RelevanceModelResponse.Decision.DISABLED) {
            return CoreUtilsKt.randomPass("full.line.send.logs.probability");
        }
        return filterModelDecision == RelevanceModelResponse.Decision.RANDOM_PASS;
    }

    @NotNull
    public String getId() {
        return FUSLogsKt.getFL_VALUES().getName();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineInlineCompletionUsageData$FullLineUsageCollectorExtension;", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsageCollectorExtension;", "()V", "getEventId", "", "getExtensionFields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getGroupId", "intellij.fullLine"})
    public static final class FullLineUsageCollectorExtension
    implements FeatureUsageCollectorExtension {
        @NotNull
        public String getGroupId() {
            return InlineCompletionUsageTracker.INSTANCE.getGroup().getId();
        }

        @NotNull
        public String getEventId() {
            return "invoked";
        }

        @NotNull
        public List<EventField<?>> getExtensionFields() {
            return CollectionsKt.listOf((Object)FUSLogsKt.getFL_VALUES());
        }
    }
}

