/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.logs;

import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.lang.Language;
import com.intellij.openapi.util.registry.Registry;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.LangState;
import org.jetbrains.completion.full.line.language.ModelSettings;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.models.ModelType;
import org.jetbrains.completion.full.line.platform.logs.CompletionLogsKt;
import org.jetbrains.completion.full.line.platform.logs.ImportsFeaturesKt;
import org.jetbrains.completion.full.line.settings.FullLineSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J \u0010\n\u001a\u00020\u000b*\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J(\u0010\n\u001a\u00020\u000b*\u00020\u000f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/completion/full/line/platform/logs/FullLineContextFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ContextFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "environment", "Lcom/intellij/codeInsight/completion/ml/CompletionEnvironment;", "getName", "capture", "", "Lorg/jetbrains/completion/full/line/language/LangState;", "result", "", "Lorg/jetbrains/completion/full/line/settings/FullLineSettings;", "language", "Lcom/intellij/lang/Language;", "intellij.fullLine"})
public final class FullLineContextFeatureProvider
implements ContextFeatureProvider {
    @NotNull
    public String getName() {
        return "full_line";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull CompletionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Language language2 = environment.getParameters().getOriginalFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        Language language3 = language2;
        FullLineSettings settings = FullLineSettings.Companion.getInstance();
        if (!settings.isLanguageSupported(language3)) {
            return MapsKt.emptyMap();
        }
        environment.putUserData(CompletionLogsKt.access$getFULL_LINE_AVAILABLE_KEY$p(), (Object)true);
        Map result = new LinkedHashMap();
        this.capture(settings, result, language3);
        CompletionLogsKt.access$captureModelSettings(environment, result);
        ImportsFeaturesKt.captureImportsFeatures(environment, result);
        CompletionLogsKt.access$captureReceiverType(environment, result);
        CompletionLogsKt.access$captureIsInAbstractMethodBody(environment, result);
        return result;
    }

    private final void capture(FullLineSettings $this$capture, Map<String, MLFeatureValue> result, Language language2) {
        result.put("installed", MLFeatureValue.Companion.binary(true));
        boolean isEnabled2 = $this$capture.isEnabled(language2);
        result.put("enabled", MLFeatureValue.Companion.binary(isEnabled2));
        if (!isEnabled2) {
            return;
        }
        result.put("ux_mode", MLFeatureValue.Companion.categorical((Enum)$this$capture.getUXMode()));
        ModelSettings modelSettings = FullLineLanguageSupporter.Companion.modelSettingsFor(language2);
        ModelType modelType = modelSettings != null ? modelSettings.getModelType() : null;
        Intrinsics.checkNotNull((Object)((Object)modelType));
        ModelType modelMode = modelType;
        result.put("model_type", MLFeatureValue.Companion.categorical((Enum)modelMode));
        if ($this$capture.getSettingsState().getStringsWalking()) {
            result.put("strings_walking", MLFeatureValue.Companion.binary(true));
        }
        this.capture($this$capture.getLangState(language2), result);
        if (Registry.is((String)"full.line.only.proposals")) {
            result.put("hide_standard_proposals", MLFeatureValue.Companion.binary(true));
        }
    }

    private final void capture(LangState $this$capture, Map<String, MLFeatureValue> result) {
        result.put("red_code_policy", MLFeatureValue.Companion.categorical((Enum)$this$capture.getIncorrectCodePolicy()));
        if ($this$capture.getOnlyFullLines()) {
            result.put("full_lines_enabled", MLFeatureValue.Companion.binary(true));
        }
        result.put("trigger_model", MLFeatureValue.Companion.binary($this$capture.isTriggerModelEnabled()));
    }
}

