/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.logs;

import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.CoreUtilsKt;
import org.jetbrains.completion.full.line.language.ModelSettings;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0007\u001a\u00020\b*\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a \u0010\r\u001a\u00020\b*\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a \u0010\u000e\u001a\u00020\b*\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0002*\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\f\u0010\u0012\u001a\u00020\u0002*\u00020\u0010H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"FULL_LINE_AVAILABLE_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "PROVIDERS_NAME", "", "captureIsInAbstractMethodBody", "", "Lcom/intellij/codeInsight/completion/ml/CompletionEnvironment;", "result", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "captureModelSettings", "captureReceiverType", "hasThirdPartyReceiver", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;", "isAfterDot", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nCompletionLogs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompletionLogs.kt\norg/jetbrains/completion/full/line/platform/logs/CompletionLogsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class CompletionLogsKt {
    @NotNull
    private static final String PROVIDERS_NAME = "full_line";
    @NotNull
    private static final Key<Boolean> FULL_LINE_AVAILABLE_KEY;

    private static final void captureReceiverType(CompletionEnvironment $this$captureReceiverType, Map<String, MLFeatureValue> result) {
        block2: {
            PsiElement psiElement = $this$captureReceiverType.getParameters().getOriginalPosition();
            if (psiElement == null) {
                return;
            }
            PsiElement position = psiElement;
            if (!CompletionLogsKt.isAfterDot(position)) break block2;
            Boolean bl = CompletionLogsKt.hasThirdPartyReceiver(position);
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                result.put("is_third_party_receiver", MLFeatureValue.Companion.binary(it));
            }
        }
    }

    private static final boolean isAfterDot(PsiElement $this$isAfterDot) {
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)$this$isAfterDot);
        return prev != null && Intrinsics.areEqual((Object)prev.getText(), (Object)".");
    }

    private static final Boolean hasThirdPartyReceiver(PsiElement $this$hasThirdPartyReceiver) {
        Boolean bl;
        PsiElement receiverClassElement;
        Language language2 = $this$hasThirdPartyReceiver.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        Object object = FullLineLanguageSupporter.Companion.getInstance(language2);
        PsiElement psiElement = receiverClassElement = object != null && (object = object.getCodeAnalyzer()) != null ? object.getReceiverClassElement($this$hasThirdPartyReceiver) : null;
        if (psiElement != null) {
            Project project = $this$hasThirdPartyReceiver.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            bl = CoreUtilsKt.isFromThirdPartyLibrary(psiElement, project);
        } else {
            bl = null;
        }
        return bl;
    }

    private static final void captureIsInAbstractMethodBody(CompletionEnvironment $this$captureIsInAbstractMethodBody, Map<String, MLFeatureValue> result) {
        block2: {
            PsiElement psiElement = $this$captureIsInAbstractMethodBody.getParameters().getOriginalPosition();
            if (psiElement == null) {
                return;
            }
            PsiElement element = psiElement;
            Language language2 = element.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
            Object object = FullLineLanguageSupporter.Companion.getInstance(language2);
            if (object == null || (object = object.getCodeAnalyzer()) == null) {
                return;
            }
            Object codeAnalyzer2 = object;
            Boolean bl = codeAnalyzer2.isInAbstractMethodBody(element);
            if (bl == null) break block2;
            boolean it = bl;
            boolean bl2 = false;
            result.put("is_in_abstract_method_body", MLFeatureValue.Companion.binary(it));
        }
    }

    private static final void captureModelSettings(CompletionEnvironment $this$captureModelSettings, Map<String, MLFeatureValue> result) {
        PsiElement psiElement = $this$captureModelSettings.getParameters().getOriginalPosition();
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        Language language2 = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        ModelSettings modelSettings = FullLineLanguageSupporter.Companion.modelSettingsFor(language2);
        if (modelSettings == null) {
            return;
        }
        ModelSettings modelSettings2 = modelSettings;
        result.put("num_iterations", MLFeatureValue.Companion.numerical(modelSettings2.getNumIterations()));
        result.put("beam_size", MLFeatureValue.Companion.numerical(modelSettings2.getBeamSize()));
    }

    public static final /* synthetic */ Key access$getFULL_LINE_AVAILABLE_KEY$p() {
        return FULL_LINE_AVAILABLE_KEY;
    }

    public static final /* synthetic */ void access$captureModelSettings(CompletionEnvironment $receiver, Map result) {
        CompletionLogsKt.captureModelSettings($receiver, result);
    }

    public static final /* synthetic */ void access$captureReceiverType(CompletionEnvironment $receiver, Map result) {
        CompletionLogsKt.captureReceiverType($receiver, result);
    }

    public static final /* synthetic */ void access$captureIsInAbstractMethodBody(CompletionEnvironment $receiver, Map result) {
        CompletionLogsKt.captureIsInAbstractMethodBody($receiver, result);
    }

    static {
        Key key = Key.create((String)"fl.available");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FULL_LINE_AVAILABLE_KEY = key;
    }
}

