/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.inline.shortcut;

import com.intellij.codeInsight.hints.presentation.InputHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.platform.inline.shortcut.HintState;
import org.jetbrains.completion.full.line.platform.inline.shortcut.InlineChooseShortcutElementKt;
import org.jetbrains.completion.full.line.platform.inline.shortcut.InlineShortcutRendererBase;
import org.jetbrains.completion.full.line.platform.inline.shortcut.ShortcutRenderer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u000e\u001a\u00020\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\u00192\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\rJ\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002J\f\u0010$\u001a\u00020\u0011*\u00020\u0011H\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/completion/full/line/platform/inline/shortcut/RendererBase;", "Lorg/jetbrains/completion/full/line/platform/inline/shortcut/InlineShortcutRendererBase;", "Lcom/intellij/codeInsight/hints/presentation/InputHandler;", "text", "", "hintState", "Lorg/jetbrains/completion/full/line/platform/inline/shortcut/HintState;", "lineNumber", "", "(Ljava/lang/String;Lorg/jetbrains/completion/full/line/platform/inline/shortcut/HintState;I)V", "getHintState", "()Lorg/jetbrains/completion/full/line/platform/inline/shortcut/HintState;", "myInlay", "Lcom/intellij/openapi/editor/Inlay;", "calcWidthInPixels", "inlay", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "editor", "Lcom/intellij/openapi/editor/Editor;", "guessPopupPoint", "Lcom/intellij/ui/awt/RelativePoint;", "event", "Ljava/awt/event/MouseEvent;", "initialize", "", "mouseExited", "mouseMoved", "translated", "Ljava/awt/Point;", "mousePressed", "mouseReleased", "updateCursor", "isHovered", "", "updateState", "updateIfHovering", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nInlineChooseShortcutElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineChooseShortcutElement.kt\norg/jetbrains/completion/full/line/platform/inline/shortcut/RendererBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n288#2,2:271\n1#3:273\n*S KotlinDebug\n*F\n+ 1 InlineChooseShortcutElement.kt\norg/jetbrains/completion/full/line/platform/inline/shortcut/RendererBase\n*L\n193#1:271,2\n*E\n"})
abstract class RendererBase
extends InlineShortcutRendererBase
implements InputHandler {
    @NotNull
    private final HintState hintState;
    private final int lineNumber;
    private Inlay<?> myInlay;

    public RendererBase(@Nullable String text, @NotNull HintState hintState, int lineNumber2) {
        Intrinsics.checkNotNullParameter((Object)hintState, (String)"hintState");
        super(text);
        this.hintState = hintState;
        this.lineNumber = lineNumber2;
    }

    @NotNull
    protected final HintState getHintState() {
        return this.hintState;
    }

    @Nullable
    protected TextAttributes getTextAttributes(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextAttributes textAttributes = super.getTextAttributes(editor);
        return textAttributes != null ? this.updateIfHovering(textAttributes) : null;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        return !InlineChooseShortcutElementKt.access$choiceShouldRender() ? 1 : super.calcWidthInPixels(inlay);
    }

    public final void initialize(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        if (!(this.myInlay == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.myInlay = inlay;
        DisposerUtilKt.whenDisposed((Disposable)((Disposable)inlay), (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RendererBase this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RendererBase.access$updateState(this.this$0, false);
            }
        }));
        this.hintState.whenUpdated((Function0<Unit>)((Function0)new Function0<Unit>(inlay){
            final /* synthetic */ Inlay<?> $inlay;
            {
                this.$inlay = $inlay;
                super(0);
            }

            public final void invoke() {
                this.$inlay.update();
            }
        }));
    }

    @NotNull
    protected final TextAttributes updateIfHovering(@NotNull TextAttributes $this$updateIfHovering) {
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)$this$updateIfHovering, (String)"<this>");
        if (this.hintState.isHovered()) {
            TextAttributes textAttributes2;
            TextAttributes $this$updateIfHovering_u24lambda_u240 = textAttributes2 = $this$updateIfHovering.clone();
            boolean bl = false;
            $this$updateIfHovering_u24lambda_u240.setForegroundColor(JBUI.CurrentTheme.Link.Foreground.ENABLED);
            TextAttributes textAttributes3 = textAttributes2;
            Intrinsics.checkNotNull((Object)textAttributes3);
            textAttributes = textAttributes3;
        } else {
            textAttributes = $this$updateIfHovering;
        }
        return textAttributes;
    }

    public void mousePressed(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (InlineChooseShortcutElementKt.access$choiceShouldRender()) {
            event.consume();
        }
    }

    public void mouseReleased(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (InlineChooseShortcutElementKt.access$choiceShouldRender()) {
            Inlay<?> inlay = this.myInlay;
            if (inlay == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
                inlay = null;
            }
            Editor editor = inlay.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            InlineChooseShortcutElementKt.access$showChooseShortcutPopup(editor, this.guessPopupPoint(event), this.lineNumber);
        }
    }

    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (InlineChooseShortcutElementKt.access$choiceShouldRender()) {
            this.updateState(true);
        }
    }

    public void mouseExited() {
        if (InlineChooseShortcutElementKt.access$choiceShouldRender()) {
            this.updateState(false);
        }
    }

    private final void updateState(boolean isHovered) {
        this.hintState.setHovered(isHovered);
        Inlay<?> inlay = this.myInlay;
        if (inlay == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
            inlay = null;
        }
        if (inlay.isValid()) {
            this.updateCursor(isHovered);
            this.hintState.update();
        }
    }

    private final void updateCursor(boolean isHovered) {
        Cursor cursor;
        boolean bl = isHovered;
        if (bl) {
            cursor = Cursor.getPredefinedCursor(12);
        } else if (!bl) {
            cursor = Cursor.getPredefinedCursor(0);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Cursor cursor2 = cursor;
        Inlay<?> inlay = this.myInlay;
        if (inlay == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
            inlay = null;
        }
        JComponent jComponent = inlay.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent contentComponent = jComponent;
        if (!Intrinsics.areEqual((Object)contentComponent.getCursor(), (Object)cursor2)) {
            UIUtil.setCursor((Component)contentComponent, (Cursor)cursor2);
        }
    }

    private final RelativePoint guessPopupPoint(MouseEvent event) {
        Point point;
        Inlay shortcutInlay;
        Object object;
        Object v2;
        Inlay it;
        block5: {
            Inlay<?> inlay = this.myInlay;
            if (inlay == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
                inlay = null;
            }
            List list2 = inlay.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(this.lineNumber);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAfterLineEndElementsForLogicalLine(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Inlay)element$iv;
                boolean bl = false;
                if (!(it.getRenderer() instanceof ShortcutRenderer)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        if ((object = (shortcutInlay = (Inlay)v2)) != null && (object = object.getBounds()) != null) {
            it = object;
            boolean bl = false;
            point = new Point(it.x, it.y);
        } else {
            point = event.getPoint();
        }
        Point point2 = point;
        Component component = event.getComponent();
        int n = point2.x;
        int n2 = point2.y;
        Inlay<?> inlay = this.myInlay;
        if (inlay == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myInlay");
            inlay = null;
        }
        return new RelativePoint(component, new Point(n, n2 + inlay.getEditor().getLineHeight()));
    }

    public static final /* synthetic */ void access$updateState(RendererBase $this, boolean isHovered) {
        $this.updateState(isHovered);
    }
}

