/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.inline.shortcut;

import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.platform.inline.shortcut.InlineCompletionShortcutChangeListener;
import org.jetbrains.completion.full.line.platform.inline.shortcut.InlineShortcutRendererBase;
import org.jetbrains.completion.full.line.platform.inline.shortcut.ShowInlineShortcutState;
import org.jetbrains.completion.full.line.settings.FullLineBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/completion/full/line/platform/inline/shortcut/InlineShortcutHintElement;", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "lineNumber", "", "(I)V", "text", "", "getText", "()Ljava/lang/String;", "toPresentable", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement$Presentable;", "Presentable", "intellij.fullLine"})
public final class InlineShortcutHintElement
implements InlineCompletionElement {
    private final int lineNumber;
    @NotNull
    private final String text;

    public InlineShortcutHintElement(int lineNumber2) {
        this.lineNumber = lineNumber2;
        this.text = "";
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public InlineCompletionElement.Presentable toPresentable() {
        return new Presentable(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010 \u001a\u00020\u0011H\u0002J\u000f\u0010!\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u0013J\f\u0010\"\u001a\u00020\u0006*\u00020#H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/completion/full/line/platform/inline/shortcut/InlineShortcutHintElement$Presentable;", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement$Presentable;", "element", "Lorg/jetbrains/completion/full/line/platform/inline/shortcut/InlineShortcutHintElement;", "(Lorg/jetbrains/completion/full/line/platform/inline/shortcut/InlineShortcutHintElement;)V", "currentShortcut", "", "getElement", "()Lorg/jetbrains/completion/full/line/platform/inline/shortcut/InlineShortcutHintElement;", "offset", "", "Ljava/lang/Integer;", "shortcutInlay", "Lcom/intellij/openapi/editor/Inlay;", "Lorg/jetbrains/completion/full/line/platform/inline/shortcut/InlineShortcutRendererBase;", "suffixInlay", "dispose", "", "endOffset", "()Ljava/lang/Integer;", "getBounds", "Ljava/awt/Rectangle;", "getShortcutRenderer", "getShortcutRepresentation", "getSuffixRenderer", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "hintShouldRender", "", "isVisible", "render", "Lcom/intellij/openapi/editor/Editor;", "rerender", "startOffset", "asString", "Lcom/intellij/openapi/actionSystem/Shortcut;", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nInlineShortcutHintElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineShortcutHintElement.kt\norg/jetbrains/completion/full/line/platform/inline/shortcut/InlineShortcutHintElement$Presentable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1#2:126\n9#3:127\n*S KotlinDebug\n*F\n+ 1 InlineShortcutHintElement.kt\norg/jetbrains/completion/full/line/platform/inline/shortcut/InlineShortcutHintElement$Presentable\n*L\n71#1:127\n*E\n"})
    public static final class Presentable
    implements InlineCompletionElement.Presentable {
        @NotNull
        private final InlineShortcutHintElement element;
        @Nullable
        private Inlay<InlineShortcutRendererBase> shortcutInlay;
        @Nullable
        private Inlay<InlineShortcutRendererBase> suffixInlay;
        @Nullable
        private Integer offset;
        @Nullable
        private String currentShortcut;

        public Presentable(@NotNull InlineShortcutHintElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.element = element;
            this.currentShortcut = this.getShortcutRepresentation();
            InlineCompletionShortcutChangeListener.Companion.whenInsertShortcutChanged((Disposable)this, (Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.rerender();
                }
            }));
        }

        @NotNull
        public InlineShortcutHintElement getElement() {
            return this.element;
        }

        public boolean isVisible() {
            return this.getBounds() != null;
        }

        @Nullable
        public Rectangle getBounds() {
            if (!this.hintShouldRender()) {
                return null;
            }
            Object object = this.shortcutInlay;
            if (object == null || (object = object.getBounds()) == null) {
                return null;
            }
            Object shortcutBounds = object;
            Object object2 = this.suffixInlay;
            if (object2 == null || (object2 = object2.getBounds()) == null) {
                return null;
            }
            Object suffixBounds = object2;
            return ((Rectangle)shortcutBounds).union((Rectangle)suffixBounds);
        }

        @Nullable
        public Integer startOffset() {
            return this.offset;
        }

        @Nullable
        public Integer endOffset() {
            return this.offset;
        }

        public void dispose() {
            Disposable p0;
            Inlay<InlineShortcutRendererBase> inlay = this.shortcutInlay;
            if (inlay != null) {
                p0 = (Disposable)inlay;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            Inlay<InlineShortcutRendererBase> inlay2 = this.suffixInlay;
            if (inlay2 != null) {
                p0 = (Disposable)inlay2;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
            this.shortcutInlay = null;
            this.suffixInlay = null;
            this.offset = null;
        }

        public void render(@NotNull Editor editor, int offset) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (!(editor instanceof EditorImpl) || this.currentShortcut == null || !InlineShortcutRendererBase.Companion.isAvailableForLine(editor, this.getElement().lineNumber)) {
                return;
            }
            try {
                this.shortcutInlay = ((EditorImpl)editor).getInlayModel().addAfterLineEndElement(offset, true, (EditorCustomElementRenderer)this.getShortcutRenderer());
                this.suffixInlay = ((EditorImpl)editor).getInlayModel().addAfterLineEndElement(offset, true, (EditorCustomElementRenderer)this.getSuffixRenderer((EditorImpl)editor));
                this.offset = offset;
            }
            catch (Exception e) {
                Presentable $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger2 = Logger.getInstance(Presentable.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                logger2.error("Could not render Full Line in-editor hint.", (Throwable)e);
            }
        }

        private final InlineShortcutRendererBase getSuffixRenderer(EditorImpl editor) {
            String string = FullLineBundle.Companion.message("full.line.inline.inplace.hint.suffix.text", new Object[0]);
            return new InlineShortcutRendererBase(this, editor, string){
                final /* synthetic */ Presentable this$0;
                final /* synthetic */ EditorImpl $editor;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    super($super_call_param$1);
                }

                public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                    if (!Presentable.access$hintShouldRender(this.this$0)) {
                        return;
                    }
                    InlineShortcutRendererBase.paintLabel$default(this, g, this.$editor, r, this.getText(), textAttributes, null, 32, null);
                }
            };
        }

        private final InlineShortcutRendererBase getShortcutRenderer() {
            String string = this.currentShortcut;
            return new InlineShortcutRendererBase(this, string){
                final /* synthetic */ Presentable this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
                    Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                    Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                    if (!Presentable.access$hintShouldRender(this.this$0)) {
                        return;
                    }
                    super.paint(inlay, g, r, textAttributes);
                }
            };
        }

        private final void rerender() {
            block2: {
                this.currentShortcut = this.getShortcutRepresentation();
                Inlay<InlineShortcutRendererBase> inlay = this.shortcutInlay;
                InlineShortcutRendererBase inlineShortcutRendererBase = inlay != null ? (InlineShortcutRendererBase)inlay.getRenderer() : null;
                if (inlineShortcutRendererBase != null) {
                    inlineShortcutRendererBase.setText(this.currentShortcut);
                }
                Inlay<InlineShortcutRendererBase> inlay2 = this.shortcutInlay;
                if (inlay2 != null) {
                    inlay2.update();
                }
                Inlay<InlineShortcutRendererBase> inlay3 = this.suffixInlay;
                if (inlay3 == null) break block2;
                inlay3.update();
            }
        }

        private final String getShortcutRepresentation() {
            Shortcut shortcut;
            Shortcut shortcut2 = shortcut = KeymapUtil.getPrimaryShortcut((String)"InsertInlineCompletionAction");
            return shortcut2 != null ? this.asString(shortcut2) : null;
        }

        private final String asString(Shortcut $this$asString) {
            String string;
            switch ($this$asString.toString()) {
                case "[pressed TAB]": {
                    string = "Tab";
                    break;
                }
                case "[pressed ENTER]": {
                    string = "Enter";
                    break;
                }
                case "[shift pressed RIGHT]": {
                    string = "Shift \u2192";
                    break;
                }
                default: {
                    String string2 = KeymapUtil.getShortcutText((Shortcut)$this$asString);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortcutText(...)");
                }
            }
            return string;
        }

        private final boolean hintShouldRender() {
            return this.currentShortcut != null && ShowInlineShortcutState.Companion.getState() == ShowInlineShortcutState.SHOW_HINT;
        }

        public static final /* synthetic */ boolean access$hintShouldRender(Presentable $this) {
            return $this.hintShouldRender();
        }
    }
}

