/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.inline;

import com.intellij.codeInsight.inline.completion.InlineCompletionProviderPresentation;
import com.intellij.codeInsight.inline.completion.tooltip.InlineCompletionTooltipFactory;
import com.intellij.fullLine.core.icons.FullLineIcons;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.FullLinePluginInfo;
import org.jetbrains.completion.full.line.settings.FullLineBundle;
import org.jetbrains.completion.full.line.settings.FullLineSettings;
import org.jetbrains.completion.full.line.settings.GeneralState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/completion/full/line/platform/inline/FullLineInlineCompletionProviderPresentation;", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionProviderPresentation;", "()V", "getInplaceEditorHintIcon", "Ljavax/swing/Icon;", "getTooltip", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "GoToPluginDescription", "GoToSettingsAction", "SwitchInplaceEditorHintAction", "intellij.fullLine"})
public final class FullLineInlineCompletionProviderPresentation
implements InlineCompletionProviderPresentation {
    @NotNull
    public JComponent getTooltip(@Nullable Project project) {
        String string = FullLineBundle.Companion.message("full.line.inline.provider.display.name", new Object[0]);
        String string2 = FullLineBundle.Companion.message("full.line.inline.provider.display.comment", new Object[0]);
        Icon icon = FullLineIcons.StatusBar.FullLine;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FullLine");
        AnAction[] anActionArray = new AnAction[]{new GoToSettingsAction(project), new GoToPluginDescription(project), new SwitchInplaceEditorHintAction((Function0<? extends Icon>)((Function0)new Function0<Icon>((Object)this){

            @Nullable
            public final Icon invoke() {
                return FullLineInlineCompletionProviderPresentation.access$getInplaceEditorHintIcon((FullLineInlineCompletionProviderPresentation)this.receiver);
            }
        }))};
        return InlineCompletionTooltipFactory.INSTANCE.defaultProviderTooltip(string, string2, icon, anActionArray);
    }

    private final Icon getInplaceEditorHintIcon() {
        return FullLineSettings.Companion.getInstance().getSettingsState().getInplaceEditorHintState().getShouldRender() ? PlatformIcons.CHECK_ICON : null;
    }

    public static final /* synthetic */ Icon access$getInplaceEditorHintIcon(FullLineInlineCompletionProviderPresentation $this) {
        return $this.getInplaceEditorHintIcon();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/platform/inline/FullLineInlineCompletionProviderPresentation$GoToPluginDescription;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.fullLine"})
    private static final class GoToPluginDescription
    extends AnAction {
        @Nullable
        private final Project project;

        public GoToPluginDescription(@Nullable Project project) {
            super(FullLineBundle.Companion.message("full.line.tooltip.action.open.more.info", new Object[0]), null, AllIcons.General.ShowInfos);
            this.project = project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            IdeaPluginDescriptor ideaPluginDescriptor = FullLinePluginInfo.INSTANCE.get();
            if (ideaPluginDescriptor == null || (ideaPluginDescriptor = ideaPluginDescriptor.getPluginId()) == null) {
                return;
            }
            IdeaPluginDescriptor pluginId = ideaPluginDescriptor;
            PluginManagerConfigurable.showPluginConfigurable((Project)this.project, (Collection)CollectionsKt.listOf((Object)pluginId));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/completion/full/line/platform/inline/FullLineInlineCompletionProviderPresentation$GoToSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.fullLine"})
    private static final class GoToSettingsAction
    extends AnAction {
        @Nullable
        private final Project project;

        public GoToSettingsAction(@Nullable Project project) {
            super(FullLineBundle.Companion.message("full.line.tooltip.action.settings", new Object[0]), null, AllIcons.General.GearPlain);
            this.project = project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ShowSettingsUtilImpl.Companion.showSettingsDialog(this.project, "editor.preferences.completion", FullLineBundle.Companion.message("full.line.settings.header", new Object[0]));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/completion/full/line/platform/inline/FullLineInlineCompletionProviderPresentation$SwitchInplaceEditorHintAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "getIcon", "Lkotlin/Function0;", "Ljavax/swing/Icon;", "(Lkotlin/jvm/functions/Function0;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.fullLine"})
    private static final class SwitchInplaceEditorHintAction
    extends AnAction {
        @NotNull
        private final Function0<Icon> getIcon;

        public SwitchInplaceEditorHintAction(@NotNull Function0<? extends Icon> getIcon) {
            Intrinsics.checkNotNullParameter(getIcon, (String)"getIcon");
            super(FullLineBundle.Companion.message("full.line.inline.inplace.hint.popup.text", new Object[0]), null, (Icon)getIcon.invoke());
            this.getIcon = getIcon;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            GeneralState.InplaceEditorHintState it = FullLineSettings.Companion.getInstance().getSettingsState().getInplaceEditorHintState();
            boolean bl = false;
            it.setShouldRender(!it.getShouldRender());
            this.getTemplatePresentation().setIcon((Icon)this.getIcon.invoke());
        }
    }
}

