/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.inline;

import com.intellij.codeInsight.inline.completion.DefaultInlineCompletionInsertHandler;
import com.intellij.codeInsight.inline.completion.InlineCompletionInsertEnvironment;
import com.intellij.codeInsight.inline.completion.elements.InlineCompletionElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.ml.impl.correctness.autoimport.ImportFixer;
import com.intellij.platform.ml.impl.correctness.autoimport.ImportFixerKt;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.services.FullLineServiceScope;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/completion/full/line/platform/inline/FullLineInlineCompletionInsertHandler;", "Lcom/intellij/codeInsight/inline/completion/DefaultInlineCompletionInsertHandler;", "()V", "afterInsertion", "", "environment", "Lcom/intellij/codeInsight/inline/completion/InlineCompletionInsertEnvironment;", "elements", "", "Lcom/intellij/codeInsight/inline/completion/elements/InlineCompletionElement;", "moveCaretBeforeSuffix", "performAutoImport", "Companion", "intellij.fullLine"})
public final class FullLineInlineCompletionInsertHandler
extends DefaultInlineCompletionInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Integer> CARET_SHIFT_AFTER_INSERTION_KEY;

    public void afterInsertion(@NotNull InlineCompletionInsertEnvironment environment, @NotNull List<? extends InlineCompletionElement> elements) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        super.afterInsertion(environment, elements);
        this.moveCaretBeforeSuffix(environment);
        this.performAutoImport(environment);
    }

    private final void moveCaretBeforeSuffix(InlineCompletionInsertEnvironment environment) {
        block0: {
            Integer n = (Integer)environment.getUserData(CARET_SHIFT_AFTER_INSERTION_KEY);
            if (n == null) break block0;
            Integer shift = n;
            boolean bl = false;
            Caret caret = environment.getEditor().getCaretModel().getCurrentCaret();
            boolean bl2 = false;
            caret.moveToOffset(caret.getOffset() + shift);
        }
    }

    private final void performAutoImport(InlineCompletionInsertEnvironment environment) {
        Language language2 = environment.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"getLanguage(...)");
        FullLineLanguageSupporter fullLineLanguageSupporter = FullLineLanguageSupporter.Companion.getInstance(language2);
        if (fullLineLanguageSupporter == null || (fullLineLanguageSupporter = fullLineLanguageSupporter.getImportFixer()) == null) {
            return;
        }
        FullLineLanguageSupporter importFixer2 = fullLineLanguageSupporter;
        Project project = environment.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ImportFixerKt.runAutoImportAsync((ImportFixer)importFixer2, (CoroutineScope)FullLineServiceScope.fullLineProjectScope(project), (PsiFile)environment.getFile(), (Editor)environment.getEditor(), (TextRange)environment.getInsertedRange());
    }

    static {
        Key key = Key.create((String)"full.line.inline.caret.shift");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CARET_SHIFT_AFTER_INSERTION_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/completion/full/line/platform/inline/FullLineInlineCompletionInsertHandler$Companion;", "", "()V", "CARET_SHIFT_AFTER_INSERTION_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCARET_SHIFT_AFTER_INSERTION_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Integer> getCARET_SHIFT_AFTER_INSERTION_KEY() {
            return CARET_SHIFT_AFTER_INSERTION_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

