/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.handlers;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.ml.impl.correctness.autoimport.ImportFixer;
import com.intellij.platform.ml.impl.correctness.autoimport.ImportFixerKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.FullLineStringLiteralSupporter;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupportHolder;
import org.jetbrains.completion.full.line.platform.FullLineLookupElement;
import org.jetbrains.completion.full.line.platform.diagnostics.DiagnosticsService;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLineLogger;
import org.jetbrains.completion.full.line.platform.diagnostics.FullLinePart;
import org.jetbrains.completion.full.line.platform.handlers.FullLineEnclosuresRepairer;
import org.jetbrains.completion.full.line.services.FullLineServiceScope;
import org.jetbrains.completion.full.line.settings.FullLineSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0003J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/completion/full/line/platform/handlers/FullLineSmartInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lorg/jetbrains/completion/full/line/platform/FullLineLookupElement;", "holder", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;", "(Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupportHolder;)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "removeMatchedPrefixAfterOffset", "removedMatchedEnclosures", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineSmartInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineSmartInsertHandler.kt\norg/jetbrains/completion/full/line/platform/handlers/FullLineSmartInsertHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 log.kt\norg/jetbrains/completion/full/line/platform/diagnostics/LogKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,82:1\n1#2:83\n1774#3,4:84\n59#4:88\n11#5:89\n*S KotlinDebug\n*F\n+ 1 FullLineSmartInsertHandler.kt\norg/jetbrains/completion/full/line/platform/handlers/FullLineSmartInsertHandler\n*L\n73#1:84,4\n79#1:88\n79#1:89\n*E\n"})
public final class FullLineSmartInsertHandler
implements InsertHandler<FullLineLookupElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FullLineLanguageSupportHolder holder;
    @NotNull
    private static final FullLineLogger LOG;

    public FullLineSmartInsertHandler(@NotNull FullLineLanguageSupportHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull FullLineLookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int offset = context2.getTailOffset();
        TextRange completionRange = new TextRange(context2.getStartOffset(), context2.getSelectionEndOffset());
        if (((CharSequence)item.getSuffix()).length() > 0) {
            context2.getDocument().insertString(context2.getSelectionEndOffset(), (CharSequence)item.getSuffix());
            context2.commitDocument();
            TextRange textRange = completionRange.grown(item.getSuffix().length());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
            completionRange = textRange;
        }
        int endLine = document2.getLineEndOffset(document2.getLineNumber(offset));
        if (LOG.isDebugEnabled()) {
            int starLine = document2.getLineStartOffset(document2.getLineNumber(offset));
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = context2.getStartOffset();
            String string3 = string2.substring(starLine, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String string4 = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            string2 = string4;
            n = context2.getStartOffset();
            int n2 = context2.getTailOffset();
            String string5 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String string6 = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
            string2 = string6;
            n = context2.getTailOffset();
            String string7 = string2.substring(n, endLine);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            LOG.debug("Full line with picked suggestion: `" + string3 + "|" + string5 + "|" + string7 + "`.");
        }
        this.removeMatchedPrefixAfterOffset(context2, item);
        this.removedMatchedEnclosures(context2, item);
        new FullLineEnclosuresRepairer(item, context2, this.holder.getSupporter()).repair();
        PsiElement psiElement = context2.getFile().findElementAt(completionRange.getStartOffset());
        if (psiElement == null) {
            return;
        }
        PsiElement elementAtStart = psiElement;
        FullLineStringLiteralSupporter stringLiteralSupporter2 = this.holder.getSupporter().getStringLiteralSupporter();
        if (FullLineSettings.Companion.getInstance().enableStringsWalking() && stringLiteralSupporter2.isStringWalkingEnabled(elementAtStart)) {
            PsiFile psiFile2 = context2.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getFile(...)");
            Template template = stringLiteralSupporter2.createStringTemplate((PsiElement)psiFile2, new TextRange(context2.getStartOffset(), completionRange.getEndOffset()));
            if (template != null) {
                LOG.debug("Create string-walking template `" + template.getString() + "`.");
                LiveTemplateLookupElementImpl.startTemplate((InsertionContext)context2, (Template)template);
            }
        }
        ImportFixer importFixer2 = this.holder.getSupporter().getImportFixer();
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CoroutineScope coroutineScope = FullLineServiceScope.fullLineProjectScope(project);
        PsiFile psiFile3 = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"getFile(...)");
        Editor editor = context2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        ImportFixerKt.runAutoImportAsync((ImportFixer)importFixer2, (CoroutineScope)coroutineScope, (PsiFile)psiFile3, (Editor)editor, (TextRange)completionRange);
    }

    @RequiresWriteLock
    private final void removeMatchedPrefixAfterOffset(InsertionContext context2, FullLineLookupElement item) {
        block1: {
            Object object = item.getProposal().getDetails().getMatchedAfterOffset();
            if (object == null) break block1;
            Integer n = ((String)object).length();
            int it = ((Number)n).intValue();
            boolean bl = false;
            object = it > 0 ? n : null;
            if (object != null) {
                int matchedLength = ((Number)object).intValue();
                boolean bl2 = false;
                TextRange textRange = TextRange.from((int)context2.getSelectionEndOffset(), (int)matchedLength);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
                TextRange range = textRange;
                context2.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
            }
        }
    }

    @RequiresWriteLock
    private final void removedMatchedEnclosures(InsertionContext context2, FullLineLookupElement item) {
        int n;
        Set<Integer> set = item.getProposal().getDetails().getMatchedEnclosuresIndices();
        if (set == null) {
            return;
        }
        Set<Integer> matchedEnclosures = set;
        Iterable $this$count$iv = matchedEnclosures;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(it < item.getProposal().getSuggestion().length()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int matchedLength = n;
        TextRange range = new TextRange(context2.getSelectionEndOffset(), context2.getSelectionEndOffset() + matchedLength);
        context2.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
    }

    static {
        FullLinePart part$iv = FullLinePart.POST_PROCESSING;
        boolean $i$f$logger = false;
        DiagnosticsService diagnosticsService = DiagnosticsService.Companion.getInstance();
        boolean $i$f$logger2 = false;
        Logger logger2 = Logger.getInstance(FullLineSmartInsertHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = diagnosticsService.logger(part$iv, logger2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/platform/handlers/FullLineSmartInsertHandler$Companion;", "", "()V", "LOG", "Lorg/jetbrains/completion/full/line/platform/diagnostics/FullLineLogger;", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

