/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.handlers;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.language.enclosure.EnclosureLexeme;
import org.jetbrains.completion.full.line.language.enclosure.FullLineEnclosures;
import org.jetbrains.completion.full.line.language.enclosure.FullLineEnclosuresLexer;
import org.jetbrains.completion.full.line.language.enclosure.FullLineEnclosuresLexerKt;
import org.jetbrains.completion.full.line.language.supporters.FullLineLanguageSupporter;
import org.jetbrains.completion.full.line.platform.FullLineLookupElement;
import org.jetbrains.completion.full.line.platform.handlers.FullLineEnclosuresRepairer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001-B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001bH\u0002J6\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001b2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0019H\u0007J\u0016\u0010)\u001a\u00020\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001bH\u0002J\u000f\u0010+\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u0010,R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/completion/full/line/platform/handlers/FullLineEnclosuresRepairer;", "", "item", "Lorg/jetbrains/completion/full/line/platform/FullLineLookupElement;", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "languageSupporter", "Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupporter;", "(Lorg/jetbrains/completion/full/line/platform/FullLineLookupElement;Lcom/intellij/codeInsight/completion/InsertionContext;Lorg/jetbrains/completion/full/line/language/supporters/FullLineLanguageSupporter;)V", "closeToOpenBrackets", "", "", "completionInfo", "Lorg/jetbrains/completion/full/line/platform/handlers/FullLineEnclosuresRepairer$CompletionInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "enclosures", "Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosures;", "enclosuresLexer", "Lorg/jetbrains/completion/full/line/language/enclosure/FullLineEnclosuresLexer;", "openToCloseBrackets", "deleteRedundantSuffix", "", "documentChanged", "", "findBalance", "Lcom/intellij/util/containers/Stack;", "brackets", "", "Lorg/jetbrains/completion/full/line/language/enclosure/EnclosureLexeme$Bracket;", "endOffset", "", "findInitialBalance", "findRedundantBracketsInSuffix", "Lcom/intellij/openapi/util/TextRange;", "balanceBeforeSuffix", "suffixRange", "suffix", "", "repair", "restoreInitialBalanceIfDecreased", "initialBalance", "simpleStringMarkersFix", "()Ljava/lang/Integer;", "CompletionInfo", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineEnclosuresRepairer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineEnclosuresRepairer.kt\norg/jetbrains/completion/full/line/platform/handlers/FullLineEnclosuresRepairer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n643#2,5:358\n643#2,5:363\n1549#3:368\n1620#3,3:369\n378#3,7:372\n1#4:379\n*S KotlinDebug\n*F\n+ 1 FullLineEnclosuresRepairer.kt\norg/jetbrains/completion/full/line/platform/handlers/FullLineEnclosuresRepairer\n*L\n61#1:358,5\n62#1:363,5\n223#1:368\n223#1:369,3\n299#1:372,7\n*E\n"})
public final class FullLineEnclosuresRepairer {
    @NotNull
    private final FullLineLookupElement item;
    @NotNull
    private final InsertionContext context;
    @NotNull
    private final Document document;
    @NotNull
    private CompletionInfo completionInfo;
    @NotNull
    private final FullLineEnclosures enclosures;
    @NotNull
    private final FullLineEnclosuresLexer enclosuresLexer;
    @NotNull
    private final Map<Character, Character> openToCloseBrackets;
    @NotNull
    private final Map<Character, Character> closeToOpenBrackets;

    public FullLineEnclosuresRepairer(@NotNull FullLineLookupElement item, @NotNull InsertionContext context2, @NotNull FullLineLanguageSupporter languageSupporter) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)languageSupporter, (String)"languageSupporter");
        this.item = item;
        this.context = context2;
        Document document = this.context.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.document = document;
        this.completionInfo = new CompletionInfo();
        this.enclosures = languageSupporter.getEnclosures();
        this.enclosuresLexer = languageSupporter.getEnclosuresLexer();
        this.openToCloseBrackets = this.enclosures.getOpenToCloseBrackets();
        this.closeToOpenBrackets = this.enclosures.getCloseToOpenBrackets();
    }

    @RequiresWriteLock
    public final void repair() {
        Integer markersAdded = this.simpleStringMarkersFix();
        if (markersAdded != null) {
            this.documentChanged();
        }
        Stack<Character> initialBalance = this.findInitialBalance();
        if (this.deleteRedundantSuffix()) {
            this.documentChanged();
        }
        if (initialBalance != null) {
            this.restoreInitialBalanceIfDecreased(initialBalance);
        }
        if (markersAdded != null && markersAdded != 0) {
            Caret it = this.context.getEditor().getCaretModel().getCurrentCaret();
            boolean bl = false;
            it.moveToOffset(it.getOffset() + markersAdded);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean deleteRedundantSuffix() {
        String string;
        int quotesAtSuffixEndCnt;
        Stack<Character> balanceBeforeSuffix;
        CompletionInfo $this$deleteRedundantSuffix_u24lambda_u243;
        block7: {
            String string2;
            block6: {
                void $this$takeWhile$iv;
                $this$deleteRedundantSuffix_u24lambda_u243 = this.completionInfo;
                boolean bl = false;
                if ($this$deleteRedundantSuffix_u24lambda_u243.getSuffixRange().isEmpty()) {
                    return false;
                }
                Stack<Character> stack = this.findBalance($this$deleteRedundantSuffix_u24lambda_u243.getBrackets(), $this$deleteRedundantSuffix_u24lambda_u243.getSuffixRange().getStartOffset());
                if (stack == null) {
                    return false;
                }
                balanceBeforeSuffix = stack;
                String string3 = $this$deleteRedundantSuffix_u24lambda_u243.getSuffix();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"<get-suffix>(...)");
                String string4 = ((Object)StringsKt.reversed((CharSequence)string3)).toString();
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    int n2 = 0;
                    if (this.enclosures.isStringMarker(it)) continue;
                    void var9_11 = $this$takeWhile$iv;
                    n2 = 0;
                    String string5 = var9_11.substring(n2, index$iv);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    break block6;
                }
                string2 = $this$takeWhile$iv;
            }
            quotesAtSuffixEndCnt = string2.length();
            String string6 = $this$deleteRedundantSuffix_u24lambda_u243.getSuffix();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"<get-suffix>(...)");
            String $this$takeWhile$iv = string6;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (this.enclosures.isStringMarker(it)) continue;
                String string7 = $this$takeWhile$iv;
                int n3 = 0;
                String string8 = string7.substring(n3, index$iv);
                string = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                break block7;
            }
            string = $this$takeWhile$iv;
        }
        int quotesAtSuffixStartCnt = string.length();
        if (quotesAtSuffixEndCnt + quotesAtSuffixStartCnt >= $this$deleteRedundantSuffix_u24lambda_u243.getSuffix().length()) {
            return false;
        }
        List<EnclosureLexeme.Bracket> list2 = $this$deleteRedundantSuffix_u24lambda_u243.getBrackets();
        TextRange textRange = new TextRange($this$deleteRedundantSuffix_u24lambda_u243.getSuffixRange().getStartOffset() + quotesAtSuffixStartCnt, $this$deleteRedundantSuffix_u24lambda_u243.getSuffixRange().getEndOffset() - quotesAtSuffixEndCnt);
        String string9 = $this$deleteRedundantSuffix_u24lambda_u243.getSuffix();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"<get-suffix>(...)");
        TextRange redundantBracketsInSuffix = this.findRedundantBracketsInSuffix(list2, balanceBeforeSuffix, textRange, StringsKt.dropLast((String)StringsKt.drop((String)string9, (int)quotesAtSuffixStartCnt), (int)quotesAtSuffixEndCnt));
        if (redundantBracketsInSuffix != null) {
            TextRange it = redundantBracketsInSuffix;
            boolean bl = false;
            this.document.deleteString(it.getStartOffset(), it.getEndOffset());
            return true;
        }
        return false;
    }

    private final boolean restoreInitialBalanceIfDecreased(Stack<Character> initialBalance) {
        boolean bl;
        StringBuilder stringBuilder;
        CompletionInfo $this$restoreInitialBalanceIfDecreased_u24lambda_u246 = this.completionInfo;
        boolean bl2 = false;
        Stack<Character> stack = this.findBalance($this$restoreInitialBalanceIfDecreased_u24lambda_u246.getBrackets(), $this$restoreInitialBalanceIfDecreased_u24lambda_u246.getSuffixRange().getEndOffset());
        if (stack == null) {
            return false;
        }
        Stack<Character> balanceAfterCompletion = stack;
        for (Pair pair2 : CollectionsKt.zip((Iterable)((Iterable)initialBalance), (Iterable)((Iterable)balanceAfterCompletion))) {
            Character after;
            Character before = (Character)pair2.component1();
            if (Intrinsics.areEqual((Object)before, (Object)(after = (Character)pair2.component2()))) continue;
            return false;
        }
        int afterSuffixOffset = 0;
        int fullBalance = 0;
        fullBalance = balanceAfterCompletion.size();
        StringBuilder $this$restoreInitialBalanceIfDecreased_u24lambda_u246_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl3 = false;
        while (initialBalance.size() < balanceAfterCompletion.size()) {
            Character currentOpen = (Character)balanceAfterCompletion.peek();
            if (afterSuffixOffset < $this$restoreInitialBalanceIfDecreased_u24lambda_u246.getLineAfterCompletion().length() && Intrinsics.areEqual((Object)this.closeToOpenBrackets.get(Character.valueOf($this$restoreInitialBalanceIfDecreased_u24lambda_u246.getLineAfterCompletion().charAt(afterSuffixOffset))), (Object)currentOpen)) {
                ++afterSuffixOffset;
            } else {
                Intrinsics.checkNotNull((Object)currentOpen);
                $this$restoreInitialBalanceIfDecreased_u24lambda_u246_u24lambda_u245.append(((Character)MapsKt.getValue(this.openToCloseBrackets, (Object)currentOpen)).charValue());
                balanceAfterCompletion.pop();
            }
            fullBalance += -1;
        }
        int n = $this$restoreInitialBalanceIfDecreased_u24lambda_u246.getLineAfterCompletion().length();
        for (int i = afterSuffixOffset; i < n; ++i) {
            if (this.enclosures.isOpenBracket($this$restoreInitialBalanceIfDecreased_u24lambda_u246.getLineAfterCompletion().charAt(i))) {
                ++fullBalance;
                continue;
            }
            if (!this.enclosures.isCloseBracket($this$restoreInitialBalanceIfDecreased_u24lambda_u246.getLineAfterCompletion().charAt(i))) continue;
            fullBalance += -1;
        }
        if (fullBalance < 0) {
            int length = $this$restoreInitialBalanceIfDecreased_u24lambda_u246_u24lambda_u245.length();
            fullBalance = Math.min(length, -fullBalance);
            Intrinsics.checkNotNullExpressionValue((Object)$this$restoreInitialBalanceIfDecreased_u24lambda_u246_u24lambda_u245.delete(length - fullBalance, length), (String)"delete(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String restored = string;
        if (((CharSequence)restored).length() > 0) {
            this.document.insertString($this$restoreInitialBalanceIfDecreased_u24lambda_u246.getCompletionRange().getEndOffset(), (CharSequence)restored);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final Stack<Character> findBalance(List<? extends EnclosureLexeme.Bracket> brackets2, int endOffset) {
        Stack result = new Stack();
        for (EnclosureLexeme.Bracket bracket : brackets2) {
            char bracket2 = bracket.component1();
            int offset = bracket.component2();
            if (offset >= endOffset) break;
            if (this.enclosures.isOpenBracket(bracket2)) {
                result.push((Object)Character.valueOf(bracket2));
                continue;
            }
            boolean bl = this.enclosures.isCloseBracket(bracket2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Character currentOpen = (Character)CollectionsKt.lastOrNull((List)((List)result));
            if (!Intrinsics.areEqual((Object)currentOpen, (Object)this.closeToOpenBrackets.get(Character.valueOf(bracket2)))) {
                return null;
            }
            result.pop();
        }
        return result;
    }

    private final Stack<Character> findInitialBalance() {
        CompletionInfo $this$findInitialBalance_u24lambda_u247 = this.completionInfo;
        boolean bl = false;
        Stack<Character> stack = this.findBalance($this$findInitialBalance_u24lambda_u247.getBrackets(), $this$findInitialBalance_u24lambda_u247.getCompletionRange().getStartOffset());
        if (stack == null) {
            return null;
        }
        Stack<Character> balance = stack;
        for (int afterSuffixOffset = 0; afterSuffixOffset < $this$findInitialBalance_u24lambda_u247.getLineAfterCompletion().length() && !((Collection)balance).isEmpty() && Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((List)((List)balance)), (Object)this.closeToOpenBrackets.get(Character.valueOf($this$findInitialBalance_u24lambda_u247.getLineAfterCompletion().charAt(afterSuffixOffset)))); ++afterSuffixOffset) {
            balance.pop();
        }
        return balance;
    }

    /*
     * WARNING - void declaration
     */
    private final TextRange findRedundantBracketsInSuffix(List<? extends EnclosureLexeme.Bracket> brackets2, Stack<Character> balanceBeforeSuffix, TextRange suffixRange2, String suffix2) {
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"org/jetbrains/completion/full/line/platform/handlers/FullLineEnclosuresRepairer$findRedundantBracketsInSuffix$Bracket", "", "symbol", "", "isBeforeSuffix", "", "(CZ)V", "()Z", "getSymbol", "()C", "component1", "component2", "copy", "(CZ)Lorg/jetbrains/completion/full/line/platform/handlers/FullLineEnclosuresRepairer$findRedundantBracketsInSuffix$Bracket;", "equals", "other", "hashCode", "", "toString", "", "intellij.fullLine"})
        public final class Bracket {
            private final char symbol;
            private final boolean isBeforeSuffix;

            public Bracket(char symbol, boolean isBeforeSuffix) {
                this.symbol = symbol;
                this.isBeforeSuffix = isBeforeSuffix;
            }

            public final char getSymbol() {
                return this.symbol;
            }

            public final boolean isBeforeSuffix() {
                return this.isBeforeSuffix;
            }

            public final char component1() {
                return this.symbol;
            }

            public final boolean component2() {
                return this.isBeforeSuffix;
            }

            @NotNull
            public final Bracket copy(char symbol, boolean isBeforeSuffix) {
                return new Bracket(symbol, isBeforeSuffix);
            }

            public static /* synthetic */ Bracket copy$default(Bracket bracket, char c, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    c = bracket.symbol;
                }
                if ((n & 2) != 0) {
                    bl = bracket.isBeforeSuffix;
                }
                return bracket.copy(c, bl);
            }

            @NotNull
            public String toString() {
                return "Bracket(symbol=" + this.symbol + ", isBeforeSuffix=" + this.isBeforeSuffix + ")";
            }

            public int hashCode() {
                int result = Character.hashCode(this.symbol);
                result = result * 31 + Boolean.hashCode(this.isBeforeSuffix);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Bracket)) {
                    return false;
                }
                Bracket bracket = (Bracket)other;
                if (this.symbol != bracket.symbol) {
                    return false;
                }
                return this.isBeforeSuffix == bracket.isBeforeSuffix;
            }
        }
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)balanceBeforeSuffix;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean bl = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Character c = (Character)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new Bracket(it.charValue(), true));
        }
        Collection collection = (List)destination$iv$iv;
        Stack balance = new Stack(collection);
        List redundantOffsets = new ArrayList();
        Ref.IntRef currentSuffixOffset = new Ref.IntRef();
        currentSuffixOffset.element = suffixRange2.getStartOffset();
        boolean jumpedThroughSuffix = false;
        for (EnclosureLexeme.Bracket bracket : brackets2) {
            int n;
            char bracket2 = bracket.component1();
            int offset = bracket.component2();
            if (!FullLineEnclosuresRepairer.findRedundantBracketsInSuffix$isSuffixLeft(currentSuffixOffset, suffixRange2)) break;
            if (offset < suffixRange2.getEndOffset()) continue;
            if (this.enclosures.isOpenBracket(bracket2)) {
                balance.push((Object)new Bracket(bracket2, false));
                continue;
            }
            boolean it = this.enclosures.isCloseBracket(bracket2);
            if (_Assertions.ENABLED && !it) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Bracket currentOpen = (Bracket)CollectionsKt.lastOrNull((List)((List)balance));
            if (!jumpedThroughSuffix) {
                while (true) {
                    Bracket bracket3 = currentOpen;
                    if (Intrinsics.areEqual((Object)(bracket3 != null ? Character.valueOf(bracket3.getSymbol()) : null), (Object)this.closeToOpenBrackets.get(Character.valueOf(bracket2))) || !FullLineEnclosuresRepairer.findRedundantBracketsInSuffix$isSuffixLeft(currentSuffixOffset, suffixRange2)) break;
                    Bracket bracket4 = currentOpen;
                    if (!Intrinsics.areEqual((Object)(bracket4 != null ? Character.valueOf(bracket4.getSymbol()) : null), (Object)this.closeToOpenBrackets.get(FullLineEnclosuresRepairer.findRedundantBracketsInSuffix$currentSuffixSymbol(suffix2, currentSuffixOffset, suffixRange2, this)))) break;
                    n = currentSuffixOffset.element;
                    currentSuffixOffset.element = n + 1;
                    balance.pop();
                    currentOpen = (Bracket)CollectionsKt.lastOrNull((List)((List)balance));
                }
            }
            if (!FullLineEnclosuresRepairer.findRedundantBracketsInSuffix$isSuffixLeft(currentSuffixOffset, suffixRange2)) break;
            Bracket bracket5 = currentOpen;
            boolean bl3 = bracket5 != null ? bracket5.getSymbol() == ((Character)MapsKt.getValue(this.closeToOpenBrackets, (Object)Character.valueOf(bracket2))).charValue() : false;
            if (!bl3) break;
            balance.pop();
            if (!currentOpen.isBeforeSuffix()) continue;
            Character c = FullLineEnclosuresRepairer.findRedundantBracketsInSuffix$currentSuffixSymbol(suffix2, currentSuffixOffset, suffixRange2, this);
            if (c == null || bracket2 != c.charValue()) break;
            ((Collection)redundantOffsets).add(currentSuffixOffset.element);
            n = currentSuffixOffset.element;
            currentSuffixOffset.element = n + 1;
            jumpedThroughSuffix = true;
        }
        return !((Collection)redundantOffsets).isEmpty() && ((Number)CollectionsKt.last((List)redundantOffsets)).intValue() + 1 == suffixRange2.getEndOffset() ? new TextRange(((Number)CollectionsKt.first((List)redundantOffsets)).intValue(), suffixRange2.getEndOffset()) : null;
    }

    private final Integer simpleStringMarkersFix() {
        Integer n;
        EnclosureLexeme.StringMarker markerBeforeSuffixEnd;
        EnclosureLexeme.StringMarker stringMarker;
        Object markerBeforeSuffixEndIndex;
        int n2;
        Object $this$indexOfLast$iv;
        EnclosureLexeme.StringMarker lastMarker;
        CompletionInfo $this$simpleStringMarkersFix_u24lambda_u2414;
        block9: {
            $this$simpleStringMarkersFix_u24lambda_u2414 = this.completionInfo;
            boolean bl = false;
            if ($this$simpleStringMarkersFix_u24lambda_u2414.getMarkers().isEmpty() || $this$simpleStringMarkersFix_u24lambda_u2414.getMarkers().size() % 2 == 0) {
                return null;
            }
            lastMarker = (EnclosureLexeme.StringMarker)CollectionsKt.last($this$simpleStringMarkersFix_u24lambda_u2414.getMarkers());
            $this$indexOfLast$iv = $this$simpleStringMarkersFix_u24lambda_u2414.getMarkers();
            boolean $i$f$indexOfLast = false;
            ListIterator<EnclosureLexeme.StringMarker> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                EnclosureLexeme.StringMarker it = iterator$iv.previous();
                boolean bl2 = false;
                if (!(it.getOffset() < $this$simpleStringMarkersFix_u24lambda_u2414.getSuffixRange().getEndOffset())) continue;
                n2 = iterator$iv.nextIndex();
                break block9;
            }
            n2 = -1;
        }
        $this$indexOfLast$iv = n2;
        int it = ((Number)$this$indexOfLast$iv).intValue();
        boolean bl = false;
        Object object = markerBeforeSuffixEndIndex = it >= 0 ? $this$indexOfLast$iv : null;
        if (object != null) {
            int it2 = ((Number)object).intValue();
            boolean bl3 = false;
            stringMarker = (EnclosureLexeme.StringMarker)CollectionsKt.getOrNull($this$simpleStringMarkersFix_u24lambda_u2414.getMarkers(), (int)(it2 + 1));
        } else {
            stringMarker = null;
        }
        EnclosureLexeme.StringMarker markerAfterSuffixEnd = stringMarker;
        Object object2 = markerBeforeSuffixEndIndex;
        if (object2 != null) {
            int it3 = ((Number)object2).intValue();
            boolean bl4 = false;
            v4 = (EnclosureLexeme.StringMarker)CollectionsKt.getOrNull($this$simpleStringMarkersFix_u24lambda_u2414.getMarkers(), (int)it3);
        } else {
            v4 = markerBeforeSuffixEnd = null;
        }
        if (markerBeforeSuffixEnd instanceof EnclosureLexeme.StringMarker.Close && markerAfterSuffixEnd != null) {
            this.document.deleteString(markerAfterSuffixEnd.getOffset(), markerAfterSuffixEnd.getOffset() + 1);
            n = 0;
        } else {
            int n3 = $this$simpleStringMarkersFix_u24lambda_u2414.getSuffixRange().getEndOffset();
            EnclosureLexeme.StringMarker stringMarker2 = markerBeforeSuffixEnd;
            if (stringMarker2 == null) {
                stringMarker2 = lastMarker;
            }
            this.document.insertString(n3, (CharSequence)String.valueOf(stringMarker2.getSym()));
            n = 1;
        }
        return n;
    }

    private final void documentChanged() {
        this.completionInfo = new CompletionInfo();
    }

    private static final Character findRedundantBracketsInSuffix$currentSuffixSymbol(String $suffix, Ref.IntRef currentSuffixOffset, TextRange $suffixRange, FullLineEnclosuresRepairer this$0) {
        Character c = Character.valueOf($suffix.charAt(currentSuffixOffset.element - $suffixRange.getStartOffset()));
        char it = c.charValue();
        boolean bl = false;
        return this$0.enclosures.isCloseBracket(it) ? c : null;
    }

    private static final boolean findRedundantBracketsInSuffix$isSuffixLeft(Ref.IntRef currentSuffixOffset, TextRange $suffixRange) {
        return currentSuffixOffset.element < $suffixRange.getEndOffset();
    }

    public static final /* synthetic */ FullLineEnclosuresLexer access$getEnclosuresLexer$p(FullLineEnclosuresRepairer $this) {
        return $this.enclosuresLexer;
    }

    public static final /* synthetic */ FullLineLookupElement access$getItem$p(FullLineEnclosuresRepairer $this) {
        return $this.item;
    }

    public static final /* synthetic */ FullLineEnclosures access$getEnclosures$p(FullLineEnclosuresRepairer $this) {
        return $this.enclosures;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R%\u0010\n\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\t\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R%\u0010\u0015\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\t\u001a\u0004\b\u0016\u0010\u000fR%\u0010\u0018\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\t\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001b\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R!\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\t\u001a\u0004\b\u001f\u0010\u0007R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0014R!\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\t\u001a\u0004\b)\u0010\u0007R%\u0010+\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\t\u001a\u0004\b,\u0010\u000fR\u001b\u0010.\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\t\u001a\u0004\b/\u0010\u0014\u00a8\u00061"}, d2={"Lorg/jetbrains/completion/full/line/platform/handlers/FullLineEnclosuresRepairer$CompletionInfo;", "", "(Lorg/jetbrains/completion/full/line/platform/handlers/FullLineEnclosuresRepairer;)V", "brackets", "", "Lorg/jetbrains/completion/full/line/language/enclosure/EnclosureLexeme$Bracket;", "getBrackets", "()Ljava/util/List;", "brackets$delegate", "Lkotlin/Lazy;", "completion", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getCompletion", "()Ljava/lang/String;", "completion$delegate", "completionRange", "Lcom/intellij/openapi/util/TextRange;", "getCompletionRange", "()Lcom/intellij/openapi/util/TextRange;", "line", "getLine", "line$delegate", "lineAfterCompletion", "getLineAfterCompletion", "lineAfterCompletion$delegate", "lineAfterCompletionRange", "getLineAfterCompletionRange", "lineEnclosures", "Lorg/jetbrains/completion/full/line/language/enclosure/EnclosureLexeme;", "getLineEnclosures", "lineEnclosures$delegate", "lineNumber", "", "getLineNumber", "()I", "lineRange", "getLineRange", "markers", "Lorg/jetbrains/completion/full/line/language/enclosure/EnclosureLexeme$StringMarker;", "getMarkers", "markers$delegate", "suffix", "getSuffix", "suffix$delegate", "suffixRange", "getSuffixRange", "suffixRange$delegate", "intellij.fullLine"})
    private final class CompletionInfo {
        @NotNull
        private final TextRange completionRange;
        private final int lineNumber;
        @NotNull
        private final TextRange lineRange;
        @NotNull
        private final TextRange lineAfterCompletionRange;
        @NotNull
        private final Lazy completion$delegate;
        @NotNull
        private final Lazy lineAfterCompletion$delegate;
        @NotNull
        private final Lazy line$delegate;
        @NotNull
        private final Lazy lineEnclosures$delegate;
        @NotNull
        private final Lazy brackets$delegate;
        @NotNull
        private final Lazy markers$delegate;
        @NotNull
        private final Lazy suffixRange$delegate;
        @NotNull
        private final Lazy suffix$delegate;

        public CompletionInfo() {
            this.completionRange = new TextRange(FullLineEnclosuresRepairer.this.context.getStartOffset(), FullLineEnclosuresRepairer.this.context.getSelectionEndOffset());
            this.lineNumber = FullLineEnclosuresRepairer.this.document.getLineNumber(this.completionRange.getStartOffset());
            this.lineRange = new TextRange(FullLineEnclosuresRepairer.this.document.getLineStartOffset(this.lineNumber), FullLineEnclosuresRepairer.this.document.getLineEndOffset(this.lineNumber));
            this.lineAfterCompletionRange = new TextRange(this.completionRange.getEndOffset(), this.lineRange.getEndOffset());
            this.completion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(FullLineEnclosuresRepairer.this, this){
                final /* synthetic */ FullLineEnclosuresRepairer this$0;
                final /* synthetic */ CompletionInfo this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return FullLineEnclosuresRepairer.access$getDocument$p(this.this$0).getText(this.this$1.getCompletionRange());
                }
            }));
            this.lineAfterCompletion$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(FullLineEnclosuresRepairer.this, this){
                final /* synthetic */ FullLineEnclosuresRepairer this$0;
                final /* synthetic */ CompletionInfo this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return FullLineEnclosuresRepairer.access$getDocument$p(this.this$0).getText(this.this$1.getLineAfterCompletionRange());
                }
            }));
            this.line$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(FullLineEnclosuresRepairer.this, this){
                final /* synthetic */ FullLineEnclosuresRepairer this$0;
                final /* synthetic */ CompletionInfo this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return FullLineEnclosuresRepairer.access$getDocument$p(this.this$0).getText(this.this$1.getLineRange());
                }
            }));
            this.lineEnclosures$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends EnclosureLexeme>>(FullLineEnclosuresRepairer.this, this){
                final /* synthetic */ FullLineEnclosuresRepairer this$0;
                final /* synthetic */ CompletionInfo this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final List<EnclosureLexeme> invoke() {
                    FullLineEnclosuresLexer fullLineEnclosuresLexer = FullLineEnclosuresRepairer.access$getEnclosuresLexer$p(this.this$0);
                    String string = this.this$1.getLine();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-line>(...)");
                    return FullLineEnclosuresLexer.accept-Q5X9qkY$default(fullLineEnclosuresLexer, string, null, this.this$1.getLineRange().getStartOffset(), 0, 0, 26, null).getLexemes();
                }
            }));
            this.brackets$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends EnclosureLexeme.Bracket>>(this){
                final /* synthetic */ CompletionInfo this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final List<EnclosureLexeme.Bracket> invoke() {
                    return FullLineEnclosuresLexerKt.brackets(this.this$0.getLineEnclosures());
                }
            }));
            this.markers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends EnclosureLexeme.StringMarker>>(this){
                final /* synthetic */ CompletionInfo this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final List<EnclosureLexeme.StringMarker> invoke() {
                    return FullLineEnclosuresLexerKt.stringMarkers(this.this$0.getLineEnclosures());
                }
            }));
            this.suffixRange$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TextRange>(this, FullLineEnclosuresRepairer.this){
                final /* synthetic */ CompletionInfo this$0;
                final /* synthetic */ FullLineEnclosuresRepairer this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final TextRange invoke() {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = this.this$0.getLineEnclosures();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        EnclosureLexeme enclosureLexeme = (EnclosureLexeme)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getOffset());
                    }
                    Set enclosuresOffsets = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    Ref.IntRef length = new Ref.IntRef();
                    while (length.element < this.this$0.getCompletionRange().getLength() - FullLineEnclosuresRepairer.access$getItem$p(this.this$1).getPrefix().length() && suffixRange.2.invoke$shouldLastSymbolBeInSuffix(this.this$1, this.this$0, length, enclosuresOffsets)) {
                        int n = length.element;
                        length.element = n + 1;
                    }
                    TextRange textRange = TextRange.from((int)(this.this$0.getCompletionRange().getEndOffset() - length.element), (int)length.element);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
                    return textRange;
                }

                private static final boolean invoke$shouldLastSymbolBeInSuffix(FullLineEnclosuresRepairer this$0, CompletionInfo this$1, Ref.IntRef length, Set<Integer> enclosuresOffsets) {
                    return FullLineEnclosuresRepairer.access$getEnclosures$p(this$0).isClose(this$1.getCompletion().charAt(this$1.getCompletion().length() - 1 - length.element)) && enclosuresOffsets.contains(this$1.getCompletionRange().getEndOffset() - length.element - 1);
                }
            }));
            this.suffix$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(FullLineEnclosuresRepairer.this, this){
                final /* synthetic */ FullLineEnclosuresRepairer this$0;
                final /* synthetic */ CompletionInfo this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return FullLineEnclosuresRepairer.access$getDocument$p(this.this$0).getText(this.this$1.getSuffixRange());
                }
            }));
        }

        @NotNull
        public final TextRange getCompletionRange() {
            return this.completionRange;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        @NotNull
        public final TextRange getLineRange() {
            return this.lineRange;
        }

        @NotNull
        public final TextRange getLineAfterCompletionRange() {
            return this.lineAfterCompletionRange;
        }

        @NotNull
        public final String getCompletion() {
            Lazy lazy = this.completion$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getLineAfterCompletion() {
            Lazy lazy = this.lineAfterCompletion$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getLine() {
            Lazy lazy = this.line$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final List<EnclosureLexeme> getLineEnclosures() {
            Lazy lazy = this.lineEnclosures$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<EnclosureLexeme.Bracket> getBrackets() {
            Lazy lazy = this.brackets$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final List<EnclosureLexeme.StringMarker> getMarkers() {
            Lazy lazy = this.markers$delegate;
            return (List)lazy.getValue();
        }

        @NotNull
        public final TextRange getSuffixRange() {
            Lazy lazy = this.suffixRange$delegate;
            return (TextRange)lazy.getValue();
        }

        @NotNull
        public final String getSuffix() {
            Lazy lazy = this.suffix$delegate;
            return (String)lazy.getValue();
        }
    }
}

