/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.diagnostics.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBTabsPaneImpl;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.platform.diagnostics.AddCachedProposals;
import org.jetbrains.completion.full.line.platform.diagnostics.Analyzed;
import org.jetbrains.completion.full.line.platform.diagnostics.ContextMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.FilterModelMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.FilteredAnalyzed;
import org.jetbrains.completion.full.line.platform.diagnostics.FilteredRaw;
import org.jetbrains.completion.full.line.platform.diagnostics.Grouped;
import org.jetbrains.completion.full.line.platform.diagnostics.Mapper;
import org.jetbrains.completion.full.line.platform.diagnostics.Mappings;
import org.jetbrains.completion.full.line.platform.diagnostics.PipelineStartsWith;
import org.jetbrains.completion.full.line.platform.diagnostics.ResultProposals;
import org.jetbrains.completion.full.line.platform.diagnostics.SessionMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.SilentCompletion;
import org.jetbrains.completion.full.line.platform.diagnostics.SkipReason;
import org.jetbrains.completion.full.line.platform.diagnostics.TriggerModelMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.ui.FullLineContextList;
import org.jetbrains.completion.full.line.platform.diagnostics.ui.FullLineGeneralInformationList;
import org.jetbrains.completion.full.line.platform.diagnostics.ui.FullLineMappersList;
import org.jetbrains.completion.full.line.platform.diagnostics.ui.FullLineProposalsList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineStructuredLogsTabs;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "analyzed", "Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineProposalsList;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "composedContext", "Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineContextList;", "filteredAnalyzed", "filteredRaw", "generalInformation", "Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineGeneralInformationList;", "grouping", "mappingStep", "Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineMappersList;", "receivedProposals", "resultProposals", "tabsPanel", "Lcom/intellij/ui/JBTabsPaneImpl;", "addMessage", "", "message", "Lorg/jetbrains/completion/full/line/platform/diagnostics/SessionMessage;", "dispose", "registerTab", "tab", "intellij.fullLine"})
public final class FullLineStructuredLogsTabs
implements Disposable {
    @NotNull
    private final JBTabsPaneImpl tabsPanel;
    @NotNull
    private final JComponent component;
    @NotNull
    private final FullLineGeneralInformationList generalInformation;
    @NotNull
    private final FullLineContextList composedContext;
    @NotNull
    private final FullLineProposalsList receivedProposals;
    @NotNull
    private final FullLineMappersList mappingStep;
    @NotNull
    private final FullLineProposalsList grouping;
    @NotNull
    private final FullLineProposalsList filteredRaw;
    @NotNull
    private final FullLineProposalsList analyzed;
    @NotNull
    private final FullLineProposalsList filteredAnalyzed;
    @NotNull
    private final FullLineProposalsList resultProposals;

    public FullLineStructuredLogsTabs(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.tabsPanel = new JBTabsPaneImpl(project, 2, (Disposable)this);
        JComponent jComponent = this.tabsPanel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        this.component = jComponent;
        this.generalInformation = new FullLineGeneralInformationList("General information");
        this.composedContext = new FullLineContextList("Composed context");
        this.receivedProposals = new FullLineProposalsList("Received proposals");
        this.mappingStep = new FullLineMappersList("Mappings");
        this.grouping = new FullLineProposalsList("Groups");
        this.filteredRaw = new FullLineProposalsList("Raw filters");
        this.analyzed = new FullLineProposalsList("Analyzed proposals");
        this.filteredAnalyzed = new FullLineProposalsList("Analyzed filters");
        this.resultProposals = new FullLineProposalsList("Result proposals");
        this.registerTab(this.generalInformation);
        this.registerTab(this.composedContext);
        this.registerTab(this.receivedProposals);
        this.registerTab(this.mappingStep);
        this.registerTab(this.grouping);
        this.registerTab(this.filteredRaw);
        this.registerTab(this.analyzed);
        this.registerTab(this.filteredAnalyzed);
        this.registerTab(this.resultProposals);
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    private final void registerTab(FullLineGeneralInformationList tab2) {
        this.tabsPanel.insertTab(tab2.getTitle(), null, (Component)tab2.getTab(), "", this.tabsPanel.getTabCount());
    }

    private final void registerTab(FullLineContextList tab2) {
        this.tabsPanel.insertTab(tab2.getTitle(), null, (Component)tab2.getTab(), "", this.tabsPanel.getTabCount());
    }

    private final void registerTab(FullLineProposalsList tab2) {
        this.tabsPanel.insertTab(tab2.getTitle(), null, (Component)tab2.getTab(), "", this.tabsPanel.getTabCount());
    }

    private final void registerTab(FullLineMappersList tab2) {
        this.tabsPanel.insertTab(tab2.getTitle(), null, (Component)tab2.getTab(), "", this.tabsPanel.getTabCount());
    }

    public final void addMessage(@NotNull SessionMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        SessionMessage sessionMessage = message;
        if (sessionMessage instanceof PipelineStartsWith) {
            this.receivedProposals.add(((PipelineStartsWith)message).getProposals());
            this.generalInformation.addStartProposalsCount(((PipelineStartsWith)message).getProposals().size());
        } else if (sessionMessage instanceof Mappings) {
            this.mappingStep.afterTransformations(((Mappings)message).getBefore(), ((Mappings)message).getAfter());
        } else if (sessionMessage instanceof Mapper) {
            this.mappingStep.addMapper(((Mapper)message).getMapperDiagnostics());
        } else if (sessionMessage instanceof Grouped) {
            this.grouping.addGroups(((Grouped)message).getGroups());
        } else if (sessionMessage instanceof FilteredRaw) {
            this.filteredRaw.addFiltered(((FilteredRaw)message).getItems());
        } else if (sessionMessage instanceof Analyzed) {
            this.analyzed.addAnalyzed(((Analyzed)message).getProposals());
        } else if (sessionMessage instanceof FilteredAnalyzed) {
            this.filteredAnalyzed.addFiltered(((FilteredAnalyzed)message).getItems());
        } else if (sessionMessage instanceof ResultProposals) {
            this.generalInformation.addFinishAddingProposal(((ResultProposals)message).getProposals().size());
            this.resultProposals.add(((ResultProposals)message).getProposals());
        } else if (sessionMessage instanceof AddCachedProposals) {
            this.generalInformation.addCachedProposalsCount(((AddCachedProposals)message).getProposals().size());
        } else if (sessionMessage instanceof TriggerModelMessage) {
            this.generalInformation.addTriggerModelResponse(((TriggerModelMessage)message).getResponse());
        } else if (sessionMessage instanceof FilterModelMessage) {
            this.generalInformation.addFilterModelResponse(((FilterModelMessage)message).getResponse());
        } else if (sessionMessage instanceof SkipReason) {
            this.generalInformation.addSkipReason(((SkipReason)message).getReason());
        } else if (sessionMessage instanceof SilentCompletion) {
            this.generalInformation.addSilentCompletionMessage();
        } else if (sessionMessage instanceof ContextMessage) {
            this.composedContext.addContext(((ContextMessage)message).getContext());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void dispose() {
    }
}

