/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.diagnostics.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.FullLineProposal;
import org.jetbrains.completion.full.line.platform.DiagnosableProposalTransformer;
import org.jetbrains.completion.full.line.platform.diagnostics.ui.FullLineMappersList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0014\u0010\u001a\u001a\u00020\u0010*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00070\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineMappersList;", "", "title", "", "(Ljava/lang/String;)V", "model", "Lcom/intellij/ui/CollectionListModel;", "Lcom/intellij/ui/SimpleColoredComponent;", "tab", "Lcom/intellij/ui/components/JBList;", "kotlin.jvm.PlatformType", "getTab", "()Lcom/intellij/ui/components/JBList;", "getTitle", "()Ljava/lang/String;", "addMapper", "", "mappings", "", "mapperDiagnostics", "Lorg/jetbrains/completion/full/line/platform/DiagnosableProposalTransformer$MapperDiagnostics;", "afterTransformations", "original", "Lorg/jetbrains/completion/full/line/FullLineProposal;", "transformed", "renderMapping", "appendHighlighted", "fragment", "Companion", "MapperTitleRenderer", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nFullLineMappersList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineMappersList.kt\norg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineMappersList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1549#2:112\n1620#2,3:113\n1549#2:116\n1620#2,3:117\n1855#2,2:120\n*S KotlinDebug\n*F\n+ 1 FullLineMappersList.kt\norg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineMappersList\n*L\n35#1:112\n35#1:113,3\n41#1:116\n41#1:117,3\n47#1:120,2\n*E\n"})
public final class FullLineMappersList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final CollectionListModel<SimpleColoredComponent> model;
    @NotNull
    private final JBList<SimpleColoredComponent> tab;
    @NotNull
    private static final SimpleTextAttributes highlightAttributes = new SimpleTextAttributes(1, (Color)JBColor.RED);
    @NotNull
    private static final SimpleTextAttributes originalSuggestionAttribute = new SimpleTextAttributes(1, (Color)JBColor.BLUE);

    /*
     * WARNING - void declaration
     */
    public FullLineMappersList(@NlsSafe @NotNull String title) {
        void $this$tab_u24lambda_u241;
        JBList jBList;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.title = title;
        this.model = new CollectionListModel((Object[])new SimpleColoredComponent[0]);
        JBList jBList2 = jBList = new JBList((ListModel)this.model);
        FullLineMappersList fullLineMappersList = this;
        boolean bl = false;
        $this$tab_u24lambda_u241.setCellRenderer((arg_0, arg_1, arg_2, arg_3, arg_4) -> FullLineMappersList.tab$lambda$1$lambda$0(tab.1.1.INSTANCE, arg_0, arg_1, arg_2, arg_3, arg_4));
        $this$tab_u24lambda_u241.setFocusable(false);
        fullLineMappersList.tab = jBList;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final JBList<SimpleColoredComponent> getTab() {
        return this.tab;
    }

    /*
     * WARNING - void declaration
     */
    public final void addMapper(@NotNull DiagnosableProposalTransformer.MapperDiagnostics mapperDiagnostics) {
        void $this$mapTo$iv$iv;
        MapperTitleRenderer mapperTitleRenderer;
        Intrinsics.checkNotNullParameter((Object)mapperDiagnostics, (String)"mapperDiagnostics");
        MapperTitleRenderer $this$addMapper_u24lambda_u242 = mapperTitleRenderer = new MapperTitleRenderer(mapperDiagnostics.getName());
        boolean bl = false;
        $this$addMapper_u24lambda_u242.withProperty((Function1<? super SimpleColoredComponent, Unit>)((Function1)new Function1<SimpleColoredComponent, Unit>(mapperDiagnostics){
            final /* synthetic */ DiagnosableProposalTransformer.MapperDiagnostics $mapperDiagnostics;
            {
                this.$mapperDiagnostics = $mapperDiagnostics;
                super(1);
            }

            public final void invoke(@NotNull SimpleColoredComponent $this$withProperty) {
                Intrinsics.checkNotNullParameter((Object)$this$withProperty, (String)"$this$withProperty");
                String string = "%.3f ms";
                Object[] objectArray = new Object[]{this.$mapperDiagnostics.getTotalTimeMs()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                $this$withProperty.append(string2, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                $this$withProperty.append(" in total", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }));
        $this$addMapper_u24lambda_u242.withProperty((Function1<? super SimpleColoredComponent, Unit>)((Function1)new Function1<SimpleColoredComponent, Unit>(mapperDiagnostics){
            final /* synthetic */ DiagnosableProposalTransformer.MapperDiagnostics $mapperDiagnostics;
            {
                this.$mapperDiagnostics = $mapperDiagnostics;
                super(1);
            }

            public final void invoke(@NotNull SimpleColoredComponent $this$withProperty) {
                Intrinsics.checkNotNullParameter((Object)$this$withProperty, (String)"$this$withProperty");
                int transformedNumber = this.$mapperDiagnostics.getMappings().size();
                int totalNumber = this.$mapperDiagnostics.getInvocations();
                $this$withProperty.append(transformedNumber + " out of " + totalNumber, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                $this$withProperty.append(" transformed", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }));
        MapperTitleRenderer titleRenderer2 = mapperTitleRenderer;
        Iterable $this$map$iv = mapperDiagnostics.getMappings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DiagnosableProposalTransformer.Mapping mapping = (DiagnosableProposalTransformer.Mapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.renderMapping(it.getOriginal(), it.getTransformed()));
        }
        List renderedMappings = (List)destination$iv$iv;
        this.addMapper(titleRenderer2.render(), renderedMappings);
    }

    /*
     * WARNING - void declaration
     */
    public final void afterTransformations(@NotNull List<? extends FullLineProposal> original, @NotNull List<? extends FullLineProposal> transformed) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter(transformed, (String)"transformed");
        MapperTitleRenderer titleRenderer2 = new MapperTitleRenderer("After all transformations");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)original, (Iterable)transformed);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair2 = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FullLineProposal orig = (FullLineProposal)pair2.component1();
            FullLineProposal trans = (FullLineProposal)pair2.component2();
            collection.add(this.renderMapping(orig, trans));
        }
        List renderedMappings = (List)destination$iv$iv;
        this.addMapper(titleRenderer2.render(), renderedMappings);
    }

    /*
     * WARNING - void declaration
     */
    private final void addMapper(SimpleColoredComponent title, List<? extends SimpleColoredComponent> mappings) {
        void $this$forEach$iv;
        this.model.add((Object)title);
        Iterable iterable = mappings;
        CollectionListModel<SimpleColoredComponent> collectionListModel = this.model;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SimpleColoredComponent p0 = (SimpleColoredComponent)element$iv;
            boolean bl = false;
            collectionListModel.add((Object)p0);
        }
    }

    private final SimpleColoredComponent renderMapping(FullLineProposal original, FullLineProposal transformed) {
        return this.renderMapping(original.getSuggestion(), transformed.getSuggestion());
    }

    private final SimpleColoredComponent renderMapping(String original, String transformed) {
        SimpleColoredComponent component = new SimpleColoredComponent();
        component.append("\t\t\t");
        if (Intrinsics.areEqual((Object)original, (Object)transformed)) {
            component.append(original);
        } else if (StringsKt.contains$default((CharSequence)original, (CharSequence)transformed, (boolean)false, (int)2, null)) {
            int afterTransformedIndex;
            int transformedIndex = StringsKt.indexOf$default((CharSequence)original, (String)transformed, (int)0, (boolean)false, (int)6, null);
            if (transformedIndex != 0) {
                String string = original.substring(0, transformedIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.appendHighlighted(component, string);
            }
            if (((CharSequence)transformed).length() > 0) {
                component.append(transformed);
            }
            if ((afterTransformedIndex = transformedIndex + transformed.length()) != original.length()) {
                String string = original.substring(afterTransformedIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.appendHighlighted(component, string);
            }
        } else {
            component.append(transformed);
            component.append("  \u27f5  " + original, originalSuggestionAttribute);
        }
        return component;
    }

    private final void appendHighlighted(SimpleColoredComponent $this$appendHighlighted, String fragment) {
        $this$appendHighlighted.append(StringsKt.replace$default((String)fragment, (char)' ', (char)'\u25ae', (boolean)false, (int)4, null), highlightAttributes);
    }

    private static final Component tab$lambda$1$lambda$0(Function5 $tmp0, JList p0, Object p1, int p2, boolean p3, boolean p4) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Component)$tmp0.invoke((Object)p0, p1, (Object)p2, (Object)p3, (Object)p4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineMappersList$Companion;", "", "()V", "highlightAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "originalSuggestionAttribute", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\bJ\u001f\u0010\f\u001a\u00020\u00002\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0005\u001a\u0019\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineMappersList$MapperTitleRenderer;", "", "mapperName", "", "(Ljava/lang/String;)V", "propertiesBuilders", "", "Lkotlin/Function1;", "Lcom/intellij/ui/SimpleColoredComponent;", "", "Lkotlin/ExtensionFunctionType;", "render", "withProperty", "builder", "intellij.fullLine"})
    @SourceDebugExtension(value={"SMAP\nFullLineMappersList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullLineMappersList.kt\norg/jetbrains/completion/full/line/platform/diagnostics/ui/FullLineMappersList$MapperTitleRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
    private static final class MapperTitleRenderer {
        @NotNull
        private final String mapperName;
        @NotNull
        private final List<Function1<SimpleColoredComponent, Unit>> propertiesBuilders;

        public MapperTitleRenderer(@NotNull String mapperName) {
            Intrinsics.checkNotNullParameter((Object)mapperName, (String)"mapperName");
            this.mapperName = mapperName;
            this.propertiesBuilders = new ArrayList();
        }

        @NotNull
        public final MapperTitleRenderer withProperty(@NotNull Function1<? super SimpleColoredComponent, Unit> builder) {
            MapperTitleRenderer mapperTitleRenderer;
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            MapperTitleRenderer $this$withProperty_u24lambda_u240 = mapperTitleRenderer = this;
            boolean bl = false;
            ((Collection)$this$withProperty_u24lambda_u240.propertiesBuilders).add(builder);
            return mapperTitleRenderer;
        }

        @NotNull
        public final SimpleColoredComponent render() {
            SimpleColoredComponent simpleColoredComponent;
            SimpleColoredComponent $this$render_u24lambda_u241 = simpleColoredComponent = new SimpleColoredComponent();
            boolean bl = false;
            $this$render_u24lambda_u241.append(this.mapperName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            if (!((Collection)this.propertiesBuilders).isEmpty()) {
                $this$render_u24lambda_u241.append(" [");
                Iterator<Function1<SimpleColoredComponent, Unit>> iterator2 = this.propertiesBuilders.iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    int i = n++;
                    Function1<SimpleColoredComponent, Unit> builder = iterator2.next();
                    builder.invoke((Object)$this$render_u24lambda_u241);
                    if (i >= this.propertiesBuilders.size() - 1) continue;
                    $this$render_u24lambda_u241.append(", ");
                }
                $this$render_u24lambda_u241.append("]");
            }
            return simpleColoredComponent;
        }
    }
}

