/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.diagnostics.ui;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.platform.NativeServerId;
import org.jetbrains.completion.full.line.platform.diagnostics.ConnectionAddress;
import org.jetbrains.completion.full.line.platform.diagnostics.GrpcChannelState;
import org.jetbrains.completion.full.line.platform.diagnostics.NativeServerMessage;
import org.jetbrains.completion.full.line.platform.diagnostics.ProcessStarted;
import org.jetbrains.completion.full.line.platform.diagnostics.ProcessTerminated;
import org.jetbrains.completion.full.line.settings.FullLineBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00070\u0006\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/DiagnosticUINativeServerState;", "", "nativeServerId", "Lorg/jetbrains/completion/full/line/platform/NativeServerId;", "(Lorg/jetbrains/completion/full/line/platform/NativeServerId;)V", "address", "Lcom/intellij/ui/SimpleColoredComponent;", "getAddress", "()Lcom/intellij/ui/SimpleColoredComponent;", "grpcChannelState", "getGrpcChannelState", "getNativeServerId", "()Lorg/jetbrains/completion/full/line/platform/NativeServerId;", "processState", "Lorg/jetbrains/annotations/NotNull;", "getProcessState", "title", "", "getTitle", "()Ljava/lang/String;", "onMessage", "", "message", "Lorg/jetbrains/completion/full/line/platform/diagnostics/NativeServerMessage;", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nDiagnosticUINativeServerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticUINativeServerState.kt\norg/jetbrains/completion/full/line/platform/diagnostics/ui/DiagnosticUINativeServerState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class DiagnosticUINativeServerState {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private final NativeServerId nativeServerId;
    @NotNull
    private final String title;
    @NotNull
    private final SimpleColoredComponent processState;
    @NotNull
    private final SimpleColoredComponent grpcChannelState;
    @NotNull
    private final SimpleColoredComponent address;
    @Deprecated
    @NlsSafe
    @NotNull
    public static final String processStateLabel = "Process state: ";
    @NotNull
    private static final SimpleTextAttributes goodAttributes;
    @NotNull
    private static final SimpleTextAttributes badAttributes;

    public DiagnosticUINativeServerState(@NotNull NativeServerId nativeServerId) {
        Intrinsics.checkNotNullParameter((Object)nativeServerId, (String)"nativeServerId");
        this.nativeServerId = nativeServerId;
        this.title = "Native Server " + this.nativeServerId.getValue();
        Object[] objectArray = new Object[]{processStateLabel};
        SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent().append(FullLineBundle.Companion.message("full.line.diagnostics.native.server.is.not.started", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"append(...)");
        this.processState = simpleColoredComponent;
        this.grpcChannelState = new SimpleColoredComponent();
        this.address = new SimpleColoredComponent();
    }

    @NotNull
    public final NativeServerId getNativeServerId() {
        return this.nativeServerId;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final SimpleColoredComponent getProcessState() {
        return this.processState;
    }

    @NotNull
    public final SimpleColoredComponent getGrpcChannelState() {
        return this.grpcChannelState;
    }

    @NotNull
    public final SimpleColoredComponent getAddress() {
        return this.address;
    }

    public final void onMessage(@NotNull NativeServerMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        NativeServerMessage nativeServerMessage = message;
        if (nativeServerMessage instanceof GrpcChannelState) {
            this.grpcChannelState.clear();
            Object[] objectArray = new Object[]{((GrpcChannelState)message).getState()};
            this.grpcChannelState.append(FullLineBundle.Companion.message("full.line.diagnostics.native.server.grpc.channel.state", objectArray));
        } else if (nativeServerMessage instanceof ProcessStarted) {
            this.processState.clear();
            this.processState.append(processStateLabel);
            this.processState.append(FullLineBundle.Companion.message("full.line.diagnostics.native.server.started", new Object[0]), goodAttributes);
        } else if (nativeServerMessage instanceof ProcessTerminated) {
            this.processState.clear();
            this.processState.append(processStateLabel);
            Object[] objectArray = new Object[]{((ProcessTerminated)message).getExitCode()};
            this.processState.append(FullLineBundle.Companion.message("full.line.diagnostics.native.server.terminated.with", objectArray), badAttributes);
        } else if (nativeServerMessage instanceof ConnectionAddress) {
            this.address.clear();
            Object[] objectArray = new Object[]{((ConnectionAddress)message).getHostname(), String.valueOf(((ConnectionAddress)message).getPort())};
            this.address.append(FullLineBundle.Companion.message("full.line.diagnostics.native.server.address", objectArray));
        }
    }

    static {
        TextAttributes textAttributes;
        Companion = new Companion(null);
        TextAttributes $this$goodAttributes_u24lambda_u240 = textAttributes = new TextAttributes();
        boolean bl = false;
        $this$goodAttributes_u24lambda_u240.setForegroundColor((Color)JBColor.GREEN);
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"fromTextAttributes(...)");
        goodAttributes = simpleTextAttributes;
        TextAttributes $this$badAttributes_u24lambda_u241 = textAttributes = new TextAttributes();
        boolean bl2 = false;
        $this$badAttributes_u24lambda_u241.setForegroundColor((Color)JBColor.RED);
        SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"fromTextAttributes(...)");
        badAttributes = simpleTextAttributes2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/ui/DiagnosticUINativeServerState$Companion;", "", "()V", "badAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "Lorg/jetbrains/annotations/NotNull;", "getBadAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "goodAttributes", "getGoodAttributes", "processStateLabel", "", "intellij.fullLine"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleTextAttributes getGoodAttributes() {
            return goodAttributes;
        }

        @NotNull
        public final SimpleTextAttributes getBadAttributes() {
            return badAttributes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

