/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.diagnostics.adapters.search;

import com.google.gson.Gson;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.local.generation.search.BeamSearchInfo;
import org.jetbrains.completion.full.line.local.generation.search.SearchDiagnosticCallback;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/search/JsonSearchDiagnostic;", "Lorg/jetbrains/completion/full/line/local/generation/search/SearchDiagnosticCallback;", "()V", "message", "", "text", "", "searchFinished", "result", "Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchInfo;", "searchStarted", "prefix", "Companion", "intellij.fullLine"})
@SourceDebugExtension(value={"SMAP\nJsonSearchDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSearchDiagnostic.kt\norg/jetbrains/completion/full/line/platform/diagnostics/adapters/search/JsonSearchDiagnostic\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,42:1\n11#2:43\n*S KotlinDebug\n*F\n+ 1 JsonSearchDiagnostic.kt\norg/jetbrains/completion/full/line/platform/diagnostics/adapters/search/JsonSearchDiagnostic\n*L\n36#1:43\n*E\n"})
public final class JsonSearchDiagnostic
implements SearchDiagnosticCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private static final Logger LOG;
    private static final Path DEFAULT_LOG_PATH;
    @NotNull
    private static final String SHOULD_LOG_PROPERTY = "flcc_search_logging_enabled";
    @NotNull
    private static final String LOG_PATH_PROPERTY = "flcc_search_log_path";

    private JsonSearchDiagnostic() {
    }

    @Override
    public void searchStarted(@NotNull String prefix2) {
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
    }

    @Override
    public void message(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
    }

    @Override
    public void searchFinished(@NotNull BeamSearchInfo result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Path path2 = Path.of(System.getProperty(LOG_PATH_PROPERTY), new String[0]);
        if (path2 == null) {
            path2 = DEFAULT_LOG_PATH;
        }
        Path logPath = path2;
        String json = GSON.toJson((Object)result);
        try {
            File file2 = logPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            FilesKt.appendText$default((File)file2, (String)(json + "\n"), null, (int)2, null);
        }
        catch (Throwable e) {
            LOG.warn("Error when adding an entry to the search log", e);
        }
    }

    public /* synthetic */ JsonSearchDiagnostic(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(JsonSearchDiagnostic.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        String[] stringArray = new String[]{"full-line", "search_log.jsonl"};
        DEFAULT_LOG_PATH = Paths.get(PathManager.getSystemPath(), stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/search/JsonSearchDiagnostic$Companion;", "", "()V", "DEFAULT_LOG_PATH", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "GSON", "Lcom/google/gson/Gson;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "LOG_PATH_PROPERTY", "", "SHOULD_LOG_PROPERTY", "tryCreate", "Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/search/JsonSearchDiagnostic;", "intellij.fullLine"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final JsonSearchDiagnostic tryCreate() {
            String string = System.getProperty(JsonSearchDiagnostic.SHOULD_LOG_PROPERTY);
            boolean bl = string != null ? Boolean.parseBoolean(string) : false;
            if (bl) {
                return new JsonSearchDiagnostic(null);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

